mol load pdb 2RLF.pdb
set protsel [atomselect top "protein and chain A"]
$protsel writepdb tempA.pdb
set protsel [atomselect top "protein and chain B"]
$protsel writepdb tempB.pdb
set protsel [atomselect top "protein and chain C"]
$protsel writepdb tempC.pdb
set protsel [atomselect top "protein and chain D"]
$protsel writepdb tempD.pdb

package require psfgen
resetpsf
pdbalias residue HIS HSD
pdbalias atom ILE CD1 CD

topology ../../04-cgc-top-par-files/martini-top/all27_prot_lipid_cmap.top

segment A {
  pdb tempA.pdb
  first nter
  last cter
}
coordpdb tempA.pdb A

segment B {
  pdb tempB.pdb
  first nter
  last cter
}
coordpdb tempB.pdb B

segment C {
  pdb tempC.pdb
  first nter
  last cter
}
coordpdb tempC.pdb C

segment D {
  pdb tempD.pdb
  first nter
  last cter
}
coordpdb tempD.pdb D

guesscoord
writepsf AA-M2channel.psf
writepdb AA-M2channel.pdb

file delete -force -- tempA.pdb
file delete -force -- tempB.pdb
file delete -force -- tempC.pdb
file delete -force -- tempD.pdb

source ../../05-scripts/la1.0/la.tcl
source ../../05-scripts/orient/orient.tcl
package require Orient
namespace import Orient::orient

mol load pdb AA-M2channel.pdb psf AA-M2channel.psf
set sel [atomselect top all]
set I [draw principalaxes $sel]
set A [orient $sel [lindex $I 2] {0 0 1}]
$sel move $A
set I [draw principalaxes $sel]
set A [orient $sel [lindex $I 1] {0 1 0}]
$sel move $A
set I [draw principalaxes $sel]
set sel [atomselect top all]
$sel writepdb AA-M2channel.pdb

exit
