#######################################
####                               ####
#### Code to create buttons        ####
#### DO NOT CHANGE                 ####
####                               ####
#######################################

destroy  .buttons
toplevel .buttons
wm title .buttons "ZLS Ribosome Demo"
set count 0
proc addframe {title row column rowspan colspan} {
  global frame count
  set frame .buttons.frame$count
  frame $frame -border 2 -relief groove
  label $frame.label -text $title -font {-family times -size 14} -foreground Blue
  pack  $frame -side left -padx 2 -pady 2 -anchor n -fill both
  pack  $frame.label -side top  -padx 2 -pady 2
  incr count

  grid $frame -row $row -column $column -rowspan $rowspan -columnspan $colspan -sticky nsew
}
proc addbutton {title command} {
  global frame count
  button $frame.$count -text $title -command $command
  pack   $frame.$count -side top -pady 1 -padx 1 -fill x
  incr count
}

#######################################
####                               ####
#### Code for representations      ####
#### DO NOT CHANGE                 ####
####                               ####
#######################################

# Delete all models
proc clear {} {
	mol delete all
	resetpsf
}

# Get the number of representations of the current model and
# return them in a an array
proc getreps {model} {
    
    # Get the new values of the representations
    set reps {}
    for {set i 0} {$i < [expr [molinfo $model get numreps]]} {incr i} {
	set temp [mol repname $model $i]
	lappend reps $temp
    }

    # Return list of all representations in this model
    return $reps
}

# Delete all representations in the passed array and model
proc delrepsarray {list model} {

    # For each representation in the list, get the index and delete it
    foreach rep $list {
	set index [mol repindex $model $rep]
	if {$index != -1} {
	    mol delrep $index $model
	}
    }
}

# Delete all reps in the current model
proc delrepsmodel {model} {

    set list [getreps $model]
    delrepsarray $list $model
}

# Add a representation to the current model and return the name
# of that representation
proc addrep {model repres col sel mat} {

    mol representation $repres
    mol color $col
    mol selection $sel
    mol material $mat
    mol addrep $model
    mol selupdate 0 $model 0
    mol colupdate 0 $model 0
    mol scaleminmax $model 0 0.000000 0.000000
    mol smoothrep $model 0 0
    mol drawframes $model 0 {now}   

    # Get the value of the last representation added to the array of 
    # representations for this model
    set numreps [expr [molinfo $model get numreps]]
    set lastrep [mol repname $model [expr { $numreps - 1 }]]
    return $lastrep
}

#######################################
####                               ####
#### Button and File Code          ####
#### Modify this part              ####
####                               ####
#######################################

# Load structures and set required variables.
# DEFINE ALL NEW STRUCTURES AND DISPLAY VARIABLES HERE.
proc load {} {

    # Global model ID variables
    global 2HGU_LSU
    global 2HGR_SSU
    global 1S72_LSU
    global 2HGQ_LSU
    global 2HGP_SSU
	
    # Load the three models and set the model ID variables
    mol new ./2HGR_SSU_Thermophilus.pdb type pdb first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all
    set 2HGR_SSU [[atomselect top all] molindex]
    mol delrep 0 top
    echo 2HGR_SSU loaded as structure $2HGR_SSU

    mol new ./2HGU_LSU_Thermophilus.pdb type pdb first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all
    set 2HGU_LSU [ [atomselect top all] molindex]
    mol delrep 0 top
    echo 2HGU_LSU loaded as structure $2HGU_LSU

    mol new ./1S72_LSU_Marismortui.pdb type pdb first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all
    set 1S72_LSU [ [atomselect top all] molindex]
    mol delrep 0 top
    echo 1S72_LSU loaded as structure $1S72_LSU

    mol new ./2HGQ_LSU_Thermophilus.pdb type pdb first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all
    set 2HGQ_LSU [ [atomselect top all] molindex]
    mol delrep 0 top
    echo 2HGQ_LSU loaded as structure $2HGQ_LSU

    mol new ./2HGP_SSU_Thermophilus.pdb type pdb first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all
    set 2HGP_SSU [ [atomselect top all] molindex]
    mol delrep 0 top
    echo 2HGP_SSU loaded as structure $2HGP_SSU

    # Set default visualization settings
    display eyesep       0.065000
    display focallength  2.000000
    display height       6.000000
    display distance     -2.000000
    display projection   Orthographic
    display nearclip set 0.500000
    display farclip  set 10.000000
    display depthcue   off
    display cuestart   0.500000
    display cueend     10.000000
    display cuedensity 0.400000
    display cuemode    Exp2
    axes location off
    color Display {Background} black
}

# Load all models now
load

addframe "Bacteria (T.th.)" 0 0 3 1

# Define button 1
addbutton {tRNA/mRNA} {

    # Global vars
    global trna_reps
    global tRNA_show
    global 2HGR_SSU

    if {![info exist tRNA_show]} {
	set tRNA_show 0
    }

    # If is already visible, render it invisible
    if {$tRNA_show} {
	
	# Delete all reps of this model
	delrepsarray $trna_reps $2HGR_SSU

	# Set the toggle variable to not_visible
	set tRNA_show 0
	
    } else {

	# Empty the trna
	set trna_reps {}

	# Display the three reps for this model
	lappend trna_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 7} {chain C} Opaque]
	lappend trna_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 11} {chain D} Opaque]
	lappend trna_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 4} {chain 1} Opaque]

	# Set the toggle variable to visible
	set tRNA_show 1
    }
    
}

addbutton {16S rRNA} {

    # Global vars
    global 2HGR_SSU
    global SSUrna_reps
    global SSUrna_show
 
    if {![info exist SSUrna_show]} {
	set SSUrna_show 0
    }

    # If is already visible, render it invisible
    if {$SSUrna_show} {

	# Delete all reps of this model
	delrepsarray $SSUrna_reps $2HGR_SSU

	# Set the toggle variable to not_visible
	set SSUrna_show 0

    } else {

	set SSUrna_reps {}

	# Display the two reps for this model
	lappend SSUrna_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Opaque]
	lappend SSUrna_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 1} {chain A and resid 1534 to 1542} Opaque]

	# Set the toggle variable to visible
	set SSUrna_show 1

    }
}

addbutton {16S Proteins} {

    # Global vars
    global 2HGR_SSU
    global SSUprot_reps
    global SSUprot_show

    if {![info exist SSUprot_show]} {
	set SSUprot_show 0
    }
    
    # If is already visible, render it invisible
    if {$SSUprot_show} {

        # Delete all reps of this model
	delrepsarray $SSUprot_reps $2HGR_SSU

	# Set the toggle variable to not_visible
	set SSUprot_show 0

    } else {

	set SSUprot_reps {}

	# Display the rep for this model
	lappend SSUprot_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 8} {protein} Opaque]

	# Set the toggle variable to visible
	set SSUprot_show 1

    }

}

addbutton {23S rRNA} {

    # Global vars
    global 2HGU_LSU
    global LSUrna_reps
    global LSUrna_show
 
    if {![info exist LSUrna_show]} {
	set LSUrna_show 0
    }
   
    # If is already visible, render it invisible
    if {$LSUrna_show} {

        # Delete all reps of this model
	delrepsarray $LSUrna_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set LSUrna_show 0

    } else {

	set LSUrna_reps {}

	# Display the rep for this model
	lappend LSUrna_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Opaque]
	lappend LSUrna_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 21} {chain B} Opaque]
	lappend LSUrna_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 9} {chain A and resid 2650 to 2670} Opaque]

	# Set the toggle variable to visible
	set LSUrna_show 1
    }
}


addbutton {23S Proteins} {

    # Global vars
    global 2HGU_LSU
    global LSUprot_reps
    global LSUprot_show
 
    if {![info exist LSUprot_show]} {
	set LSUprot_show 0
    }
   
    # If is already visible, render it invisible
    if {$LSUprot_show} {

        # Delete all reps of this model
	delrepsarray $LSUprot_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set LSUprot_show 0

    } else {

	set LSUrna_reps {}

	# Display the rep for this model
	lappend LSUprot_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 8} {protein} Opaque]

	# Set the toggle variable to visible
	set LSUprot_show 1

	#**************************************
	# ADDITIONAL VISUALIZATION SETTINGS
	set sel [atomselect $2HGU_LSU "chain C D E F G H K L M N O P Q R S T U V W X Y Z 1 2 3 4 5 6 7 8"];
	$sel set structure H;
	$sel delete;
	#**************************************

    }
}

addbutton {Exit Channel} {

    # Global vars
    global 2HGU_LSU
    global LSUexitchannel_reps
    global LSUexitchannel_show
 
    if {![info exist LSUexitchannel_show]} {
	set LSUexitchannel_show 0
    }
   
    # If is already visible, render it invisible
    if {$LSUexitchannel_show} {

        # Delete all reps of this model
	delrepsarray $LSUexitchannel_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set LSUexitchannel_show 0

    } else {

	set LSUexitchannel_reps {}

	# Display the rep for this model
	lappend LSUexitchannel_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 5} {chain A and (resid 85 to 101 or resid 20 to 30 or resid 60 to 70 or resid 450 to 510 or resid 670 to 680 or resid 745 to 755 or resid 785 to 800 or resid 1310 to 1340 or resid 1610 to 1620 or resid 1780 to 1785 or resid 1940 to 1970 or resid 2055 to 2065 or resid 2245 to 2255 or resid 2437 to 2590 or resid 2600 to 2615 or resid 1250 to 1270 or resid 2010 to 2020)} Opaque]

	# Set the toggle variable to visible
	set LSUexitchannel_show 1
    }
}

addbutton {Nascent Chain} {

    # Global vars
    global 2HGU_LSU
    global nascentchain_show
 
    if {![info exist nascentchain_show]} {
	set nascentchain_show 0
    }
   
    # If is already visible, render it invisible
    if {$nascentchain_show} {

        # Delete all reps of this model
	graphics $2HGU_LSU delete all

	# Set the toggle variable to not_visible
	set nascentchain_show 0

    } else {

	graphics $2HGU_LSU sphere {91.393002 -40.316002 -87.765999} radius 4
	graphics $2HGU_LSU sphere {83 -47 -90} radius 4
	graphics $2HGU_LSU sphere {75 -50 -98} radius 4
	graphics $2HGU_LSU sphere {63 -55 -105} radius 4
	graphics $2HGU_LSU sphere {53 -60 -115} radius 4
	graphics $2HGU_LSU sphere {43 -65 -120} radius 4
	graphics $2HGU_LSU sphere {33 -74 -126} radius 4
	graphics $2HGU_LSU sphere {20 -80 -128} radius 4
	graphics $2HGU_LSU color red
	graphics $2HGU_LSU cylinder {91.393002 -40.316002 -87.765999} {83 -47 -90} radius 0.5
	graphics $2HGU_LSU cylinder {75 -50 -98} {83 -47 -90} radius 0.5
	graphics $2HGU_LSU cylinder {75 -50 -98} {63 -55 -105} radius 0.5
	graphics $2HGU_LSU cylinder {53 -60 -115} {63 -55 -105} radius 0.5
	graphics $2HGU_LSU cylinder {53 -60 -115} {43 -65 -120} radius 0.5
	graphics $2HGU_LSU cylinder {33 -74 -126} {43 -65 -120} radius 0.5
	graphics $2HGU_LSU cylinder {33 -74 -126} {20 -80 -128} radius 0.5
	
	# Set the toggle variable to visible
	set nascentchain_show 1
    }
}

addbutton {Modified Bases} {

    # Global vars
    global 2HGR_SSU
    global 2HGU_LSU
    global modifiedbases_ssu_reps
    global modifiedbases_lsu_reps
    global modifiedbases_show

    if {![info exist modifiedbases_show]} {
	set modifiedbases_show 0
    } 
   
    # If is already visible, render it invisible
    if {$modifiedbases_show} {

        # Delete all reps of this model
	delrepsarray $modifiedbases_ssu_reps $2HGR_SSU
	delrepsarray $modifiedbases_lsu_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set modifiedbases_show 0

    } else {

	set modifiedbases_ssu_reps {}

	# Display the rep for this model
	lappend modifiedbases_ssu_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Transparent]
	lappend modifiedbases_ssu_reps [addrep $2HGR_SSU VDW {ColorID 8} {chain A and resid 516 527 966 967 1207 1402 1407 1498 1516 1518 1519} Opaque]
	lappend modifiedbases_lsu_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {nucleic} Transparent]
	lappend modifiedbases_lsu_reps [addrep $2HGU_LSU VDW {ColorID 8} {chain A and resid 745 746 747 955 1618 1835 1911 1915 1917 1939 1962 2030 2069 2251 2445 2449 2457 2498 2503 2504 2552 2580 2605} Opaque]

	# Set the toggle variable to visible
	set modifiedbases_show 1
    }
}

addbutton {16S Domains} {

    # Global vars
    global 2HGR_SSU
    global SSUdomains_reps
    global SSUdomains_show
    
    if {![info exist SSUdomains_show]} {
	set SSUdomains_show 0
    }

    # If is already visible, render it invisible
    if {$SSUdomains_show} {

        # Delete all reps of this model
	delrepsarray $SSUdomains_reps $2HGR_SSU

	# Set the toggle variable to not_visible
	set SSUdomains_show 0

    } else {

	set ssudomains_reps {}

	# Display the rep for this model
	lappend SSUdomains_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 0} {chain A and resid 1 to 556} Opaque]
	lappend SSUdomains_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 1} {chain A and resid 557 to 912} Opaque]
	lappend SSUdomains_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 31} {chain A and resid 913 to 1396} Opaque]
	lappend SSUdomains_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 6} {chain A and resid 1397 to 1534} Opaque]

	# Set the toggle variable to visible
	set SSUdomains_show 1
    }
}

addbutton {23S Domains} {

    # Global vars
    global 2HGU_LSU
    global LSUdomains_reps
    global LSUdomains_show

    if {![info exist LSUdomains_show]} {
	set LSUdomains_show 0
    }
    
    # If is already visible, render it invisible
    if {$LSUdomains_show} {

        # Delete all reps of this model
	delrepsarray $LSUdomains_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set LSUdomains_show 0

    } else {

	set ssudomains_reps {}

	# Display the rep for this model
	lappend LSUdomains_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 0} {chain A and resid 1 to 531} Opaque]
	lappend LSUdomains_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 1} {chain A and resid 532 to 1268} Opaque]
	lappend LSUdomains_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 31} {chain A and resid 1269 to 1646} Opaque]
	lappend LSUdomains_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 6} {chain A and resid 1647 to 2018} Opaque]
	lappend LSUdomains_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 12} {chain A and resid 2019 to 2627} Opaque]
	lappend LSUdomains_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 13} {chain A and resid 2628 to 2902} Opaque]

	# Set the toggle variable to visible
	set LSUdomains_show 1
    }
}

addbutton {Sequence Cons.} {

    # Global vars
    global 2HGU_LSU
    global 2HGR_SSU
    global bacterial_conservation_SSU_reps
    global bacterial_conservation_LSU_reps
    global bacterial_conservation_show

    if {![info exist bacterial_conservation_show]} {
	set bacterial_conservation_show 0
    }
    
    # For this button, three clicks determines what is displayed. Each
    # click displays a level of sequence conservation on both the small
    # and large subunits

    if {$bacterial_conservation_show == 0} {

 	#Create new reprentations of the conserved residues (level 1)
	set bacterial_conservation_SSU_reps {}
	set bacterial_conservation_LSU_reps {}

	lappend bacterial_conservation_SSU_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 8} {chain A} Transparent]
	lappend bacterial_conservation_SSU_reps [addrep $2HGR_SSU {Beads 0.600000 8.000000} {ColorID 0} {chain A and resid 865 1315 1319 1332 1338 1347} Opaque]     
	lappend bacterial_conservation_LSU_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 8} {chain A} Transparent]
	lappend bacterial_conservation_LSU_reps [addrep $2HGU_LSU {Beads 0.600000 8.000000} {ColorID 0} { chain A and resid  119	182	195	199	200	202	204	206	216	233	243	250	251	255	371	372	373	401	402	423	427	429	432	445	447	448	449	450	454	457	458	459	460	463	466	470	471	511	512	513	514
	  564	566	570	575	585	586	601	603	656	671	675	684	685	687	688	689	704	705	725	727	729	764	770	773	778	781	782	783	786	789	791	809	810	819	831	859	860	861	910	911	917	918	958	959	960	977	986	1028	1035	1048	1050	1060	1071	1077	1088	1091	1093	1094	1096	1103	1104	1111	1188	1189	1190	1237	1254	1255	1259	1266	1267	1268
	  1340	1345	1352	1378	1395	1570	1601	1602	1604	1611	1617	1620
	  1654	1664	1666	1667	1668	1669	1671	1674	1675	1676	1677	1687	1688	1689	1693	1695	1698	1700	1701	1773	1774	1775	1776	1777	1779	1780	1786	1788	1789	1791	1799	1829	1833	1834	1835	1837	1838	1841	1842	1851	1853	1889	1890	1891	1894	1900	1901	1903	1905	1907	1910	1911	1912	1913	1914	1917	1919	1927	1933	1934	1937	1939	1942	1943	1947	1953	1955	1968	1970	1973	1977	1991	1992	1993	1994	2012	2013
	  2036	2059	2060	2061	2064	2065	2071	2074	2075	2077	2078	2082	2114	2115	2119	2124	2126	2167	2168	2171	2173	2174	2199	2238	2239	2242	2243	2244	2249	2250	2251	2266	2268	2273	2275	2285	2287	2289	2308	2327	2328	2333	2335	2346	2376	2377	2383	2387	2391	2392	2394	2434	2435	2438	2439	2440	2448	2449	2450	2451	2452	2454	2457	2460	2467	2469	2470	2472	2475	2478	2480	2481	2483	2492	2494	2498	2502	2505	2506	2507	2508	2511	2518	2520	2529	2531	2541	2542	2545	2546	2552	2556	2558	2559	2573	2577	2580	2581	2582	2583	2585	2587	2589	2591	2592	2593	2594	2595	2597	2598	2599	2600	2601	2602	2603	2605	2608
	  2655	2656	2657	2658	2659	2660	2662	2663	2664	2665} Opaque]

	# Increment the display variable
	set bacterial_conservation_show 1

    } elseif {$bacterial_conservation_show == 1} {

      # Delete all reps of this model
	delrepsarray $bacterial_conservation_SSU_reps $2HGR_SSU
	delrepsarray $bacterial_conservation_LSU_reps $2HGU_LSU
	
 	#Create new reprentations of the conserved residues (level 1)
	set bacterial_conservation_SSU_reps {}
	set bacterial_conservation_LSU_reps {}

	lappend bacterial_conservation_SSU_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 8} {chain A} Transparent]
	lappend bacterial_conservation_SSU_reps [addrep $2HGR_SSU {Beads 0.600000 8.000000} {ColorID 0} {chain A and resid 51	56	244	246	282	323	327	368	499
	  565	566	571	574	584	791	795	796	801	804	810	813	815	820	865	892
	  1054	1055	1102	1191	1237	1240	1315	1316	1319	1332	1333	1337	1338	1339	1341	1347	1348	1349	1358	1376	1379	1380	1382	1391	1392	1394	1395
	  1397	1398} Opaque]	

	lappend bacterial_conservation_LSU_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 8} {chain A} Transparent]
	lappend bacterial_conservation_LSU_reps [addrep $2HGU_LSU {Beads 0.600000 8.000000} {ColorID 0} {chain A and resid 69	70	73	117	118	119	182	190	191	195	196	198	199	200	202	204	206	213	214	215	216	220	221	223	227	232	233	242	243	244	248	250	251	254	255	256	260	265	299	327	328	332	335	339	371	372	373	401	402	422	423	427	429	432	444	445	446	447	448	449	450	454	457	458	459	460	463	466	470	471	473	478	479	480	481	502	503	505	506	511	512	513	514
	  564	566	568	570	572	575	577	581	585	586	600	601	603	604	624	631	632	655	656	671	674	675	676	684	685	687	688	689	695	704	705	706	724	725	726	727	729	747	750	764	770	773	775	778	781	782	783	786	789	791	793	804	806	807	809	810	811	817	818	819	820	831	837	859	860	861	864	910	911	912	913	917	918	941	956	958	959	960	977	978	985	986	999	1000	1028	1029	1034	1035	1048	1049	1050	1055	1059	1060	1064	1071	1074	1077	1079	1084	1085	1088	1091	1093	1094	1095	1096	1098	1100	1103	1104	1111	1120	1121	1126	1129	1130	1143	1152	1155	1187	1188	1189	1190	1214	1223	1234	1237	1254	1255	1259	1265	1266	1267	1268
	  1308	1310	1312	1313	1329	1339	1340	1342	1345	1351	1352	1354	1378	1380	1389	1393	1395	1397	1569	1570	1571	1601	1602	1603	1604	1611	1617	1620	1621
	  1654	1664	1666	1667	1668	1669	1671	1674	1675	1676	1677	1687	1688	1689	1693	1695	1698	1700	1701	1773	1774	1775	1776	1777	1779	1780	1786	1787	1788	1789	1791	1799	1828	1829	1833	1834	1835	1837	1838	1841	1842	1851	1853	1889	1890	1891	1894	1898	1900	1901	1903	1905	1906	1907	1910	1911	1912	1913	1914	1915	1917	1919	1920	1923	1927	1928	1929	1930	1931	1932	1933	1934	1937	1939	1941	1942	1943	1945	1947	1953	1955	1959	1961	1964	1965	1966	1968	1969	1970	1972	1973	1977	1978	1990	1991	1992	1993	1994	1996	2010	2012	2013	2014
	  2027	2036	2059	2060	2061	2063	2064	2065	2071	2074	2075	2077	2078	2082	2093	2114	2115	2118	2119	2124	2126	2127	2167	2168	2171	2173	2174	2196	2197	2199	2225	2238	2239	2242	2243	2244	2248	2249	2250	2251	2252	2253	2254	2255	2256	2266	2268	2273	2275	2285	2287	2289	2296	2308	2322	2327	2328	2333	2335	2344	2346	2375	2376	2377	2378	2383	2387	2388	2391	2392	2394	2429	2430	2433	2434	2435	2436	2438	2439	2440	2445	2446	2448	2449	2450	2451	2452	2454	2457	2460	2467	2469	2470	2472	2475	2478	2480	2481	2482	2483	2492	2493	2494	2498	2500	2501	2502	2503	2504	2505	2506	2507	2508	2511	2512	2518	2520	2522	2529	2531	2541	2542	2543	2545	2546	2549	2552	2553	2556	2558	2559	2573	2576	2577	2578	2580	2581	2582	2583	2584	2585	2587	2589	2591	2592	2593	2594	2595	2597	2598	2599	2600	2601	2602	2603	2605	2608
	  2655	2656	2657	2658	2659	2660	2661	2662	2663	2664	2665	2686	2722	2746	2747	2751	2757	2758} Opaque]

	# Increment the display variable
	set bacterial_conservation_show 2

    } elseif {$bacterial_conservation_show == 2} {

       # Delete all reps of this model
	delrepsarray $bacterial_conservation_SSU_reps $2HGR_SSU
	delrepsarray $bacterial_conservation_LSU_reps $2HGU_LSU
	
	#Create new reprentations of the conserved residues (level 3)

	lappend bacterial_conservation_SSU_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 8} {chain A} Transparent]
	lappend bacterial_conservation_SSU_reps [addrep $2HGR_SSU {Beads 0.600000 8.000000} {ColorID 0} {chain A and resid 37	51	54	55	56	57	61	109	112	119	151	172	243	244	246	251	261	282	296	301	315	322	323	325	327	344	346	347	351	352	354	355	356	357	368	397	405	499	505	515	516	519	533	536
	  565	566	571	574	577	581	583	584	676	687	696	704	714	727	729	757	759	769	775	781	782	786	788	790	791	792	794	795	796	801	804	810	813	814	815	816	817	820	864	865	873	885	889	891	892	899	900	901	908	909	911
	  919	972	978	981	983	984	985	1052	1053	1054	1055	1056	1057	1058	1073	1085	1093	1095	1101	1102	1108	1191	1199	1200	1204	1209	1213	1227	1235	1237	1238	1240	1305	1315	1316	1318	1319	1332	1333	1337	1338	1339	1341	1347	1348	1349	1358	1359	1360	1363	1373	1374	1376	1379	1380	1382	1390	1391	1392	1394	1395	1396} Opaque]	

	lappend bacterial_conservation_LSU_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 8} {chain A} Transparent]
	lappend bacterial_conservation_LSU_reps [addrep $2HGU_LSU {Beads 0.600000 8.000000} {ColorID 0} { chain A and resid 26	28	29	35	48	51	52	53	57	58	69	70	73	117	118	119	178	182	183	189	190	191	195	196	198	199	200	202	204	206	213	214	215	216	220	221	223	227	232	233	241	242	243	244	247	248	249	250	251	254	255	256	260	265	266	299	322	327	328	332	335	338	339	371	372	373	401	402	422	423	426	427	428	429	431	432	443	444	445	446	447	448	449	450	454	457	458	459	460	463	465	466	470	471	473	476	478	479	480	481	498	502	503	505	506	511	512	513	514	515
	  564	566	568	570	572	575	577	581	585	586	588	600	601	603	604	624	627	631	632	655	656	669	671	674	675	676	684	685	687	688	689	692	695	699	701	704	705	706	707	715	716	724	725	726	727	729	733	747	750	751	764	770	773	775	778	781	782	783	786	789	791	793	803	804	806	807	809	810	811	817	818	819	820	831	837	858	859	860	861	863	864	869	910	911	912	913	917	918	941	942	956	958	959	960	977	978	983	985	986	999	1000	1003	1007	1010	1021	1028	1029	1034	1035	1048	1049	1050	1055	1059	1060	1064	1068	1071	1074	1077	1079	1084	1085	1088	1091	1093	1094	1095	1096	1098	1100	1101	1103	1104	1111	1120	1121	1126	1129	1130	1137	1142	1143	1152	1155	1187	1188	1189	1190	1213	1214	1215	1223	1226	1234	1237	1250	1254	1255	1259	1265	1266	1267	1268
	  1270	1297	1299	1308	1310	1312	1313	1315	1329	1337	1339	1340	1342	1345	1351	1352	1354	1378	1380	1384	1389	1393	1395	1396	1397	1398	1427	1569	1570	1571	1601	1602	1603	1604	1611	1613	1617	1619	1620	1621	1628	1635	1643
	  1654	1664	1666	1667	1668	1669	1671	1674	1675	1676	1677	1687	1688	1689	1692	1693	1695	1698	1700	1701	1702	1773	1774	1775	1776	1777	1779	1780	1784	1786	1787	1788	1789	1791	1792	1799	1819	1827	1828	1829	1833	1834	1835	1837	1838	1841	1842	1846	1851	1853	1854	1889	1890	1891	1894	1898	1900	1901	1903	1905	1906	1907	1910	1911	1912	1913	1914	1915	1917	1919	1920	1923	1924	1926	1927	1928	1929	1930	1931	1932	1933	1934	1937	1939	1941	1942	1943	1945	1947	1952	1953	1955	1959	1961	1964	1965	1966	1968	1969	1970	1972	1973	1977	1978	1990	1991	1992	1993	1994	1996	2010	2012	2013	2014
	  2027	2036	2053	2059	2060	2061	2062	2063	2064	2065	2071	2073	2074	2075	2077	2078	2082	2093	2110	2114	2115	2118	2119	2124	2126	2127	2161	2167	2168	2171	2173	2174	2196	2197	2199	2225	2226	2234	2238	2239	2242	2243	2244	2248	2249	2250	2251	2252	2253	2254	2255	2256	2266	2268	2273	2275	2280	2285	2287	2289	2295	2296	2303	2308	2313	2322	2327	2328	2331	2333	2335	2336	2337	2344	2346	2375	2376	2377	2378	2383	2387	2388	2391	2392	2394	2429	2430	2433	2434	2435	2436	2438	2439	2440	2445	2446	2447	2448	2449	2450	2451	2452	2454	2457	2460	2467	2469	2470	2472	2475	2478	2480	2481	2482	2483	2492	2493	2494	2498	2500	2501	2502	2503	2504	2505	2506	2507	2508	2511	2512	2515	2518	2520	2522	2529	2531	2541	2542	2543	2545	2546	2549	2552	2553	2556	2558	2559	2565	2569	2570	2573	2574	2576	2577	2578	2580	2581	2582	2583	2584	2585	2587	2589	2591	2592	2593	2594	2595	2597	2598	2599	2600	2601	2602	2603	2605	2608	2616
	  2639	2654	2655	2656	2657	2658	2659	2660	2661	2662	2663	2664	2665	2667	2684	2686	2687	2722	2723	2725	2737	2739	2741	2745	2746	2747	2748	2749	2751	2752	2754	2755	2756	2757	2758	2759	2765 } Opaque]

	# Increment the display variable
	set bacterial_conservation_show 3

    } elseif {$bacterial_conservation_show == 3} {

        # Delete all reps of this model
	delrepsarray $bacterial_conservation_SSU_reps $2HGR_SSU
	delrepsarray $bacterial_conservation_LSU_reps $2HGU_LSU
	
	# Set the toggle variable to not_visible
	set bacterial_conservation_show 0
    }

}

addbutton {Bacterial Specific Prot.} {

    # Global vars
    global 2HGU_LSU
    global bacterialspecificprot_reps
    global bacterialspecificprot_show

    if {![info exist bacterialspecificprot_show]} {
	set bacterialspecificprot_show 0
    }
    
    # If is already visible, render it invisible
    if {$bacterialspecificprot_show} {

        # Delete all reps of this model
	delrepsarray $bacterialspecificprot_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set bacterialspecificprot_show 0

    } else {

	set bacterialspecificprot_reps {}

	# Display the rep for this model
	lappend bacterialspecificprot_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 4} {chain K Q S T U Y Z 3 4 5 6 7 8} Opaque]

	# Set the toggle variable to visible
	set bacterialspecificprot_show 1
    }
}

addbutton {Antibiotics} {

    # Global vars
    global 2HGR_SSU
    global 2HGU_LSU
    global bacterialantibioticsSSU_reps
    global bacterialantibioticsLSU_reps
    global bacterialantibiotics_show

    if {![info exist bacterialantibiotics_show]} {
	set bacterialantibiotics_show 0
    }

    # If is already visible, render it invisible
    if {$bacterialantibiotics_show == 4} {

	# Delete all reps of this model
	delrepsarray $bacterialantibioticsSSU_reps $2HGR_SSU
	delrepsarray $bacterialantibioticsLSU_reps $2HGU_LSU	
	
	# Set the toggle variable to not_visible
	set bacterialantibiotics_show 0

    } elseif {$bacterialantibiotics_show == 0} {

	set bacterialantibioticsSSU_reps {}
	set bacterialantibioticsLSU_reps {}

	# Display the rep for this model
	lappend bacterialantibioticsSSU_reps [addrep $2HGR_SSU VDW {ResName} {resname SCM SRY PAR TAC PCY HYG EDE KSG NMY LLL} Opaque]
	
	# Set the toggle variable to visible
	set bacterialantibiotics_show 1

    } elseif {$bacterialantibiotics_show == 1} {

	# Delete all reps of this model
	delrepsarray $bacterialantibioticsSSU_reps $2HGR_SSU
	delrepsarray $bacterialantibioticsLSU_reps $2HGU_LSU
	set bacterialantibioticsSSU_reps {}
	set bacterialantibioticsLSU_reps {}
	
	# Display the rep for this model
	lappend bacterialantibioticsSSU_reps [addrep $2HGR_SSU VDW {ResName} {resname SCM SRY PAR TAC PCY HYG EDE KSG NMY LLL} Opaque]
	lappend bacterialantibioticsSSU_reps [addrep $2HGR_SSU Licorice {ColorID 8} {chain A and resid 716 756 912 962 973 1060 1110 1188 1194 1197 1211 1212 1229 1232 1381 1384 1386 1387 1393} Opaque]
	
	# Set the toggle variable to visible
	set bacterialantibiotics_show 2

    } elseif {$bacterialantibiotics_show == 2} {

	# Delete all reps of this model
	delrepsarray $bacterialantibioticsSSU_reps $2HGR_SSU
	delrepsarray $bacterialantibioticsLSU_reps $2HGU_LSU
	set bacterialantibioticsSSU_reps {}
	set bacterialantibioticsLSU_reps {}
	
	# Display the rep for this model
	lappend bacterialantibioticsLSU_reps [addrep $2HGU_LSU VDW {ResName} {resname CTY CLY ERY ROX CLM SPS 773 ZIT TAO TEL DOL SYB ERN G19 G34 LNZ} Opaque]
	
	# Set the toggle variable to visible
	set bacterialantibiotics_show 3

    } elseif {$bacterialantibiotics_show == 3} {

	# Delete all reps of this model
	delrepsarray $bacterialantibioticsSSU_reps $2HGR_SSU
	delrepsarray $bacterialantibioticsLSU_reps $2HGU_LSU
	set bacterialantibioticsSSU_reps {}
	set bacterialantibioticsLSU_reps {}
	
	# Display the rep for this model
	lappend bacterialantibioticsLSU_reps [addrep $2HGU_LSU VDW {ResName} {resname CTY CLY ERY ROX CLM SPS 773 ZIT TAO TEL DOL SYB ERN G19 G34 LNZ} Opaque]
	lappend bacterialantibioticsLSU_reps [addrep $2HGU_LSU Licorice {ColorID 8} {chain A and resid 13 15 17 31 44 124 391 413 415 474 523 529 534 555 559 565 576 584 637 693 714 718 745 746 760 769 813 827 830 844 900 919 922 1032 1054 1061 1105 1156 1194 1256 1263 1271 1305 1364 1379 1455 1456 1608 1623 1665 1770 1814 1815 1847 1852 1864 1925 1995 2034 2041 2046 2058 2090 2229 2262 2278 2352 2353 2354 2364 2366 2390 2393 2396 2397 2408 2410 2411 2412 2420 2423 2425 2428 2459 2466 2484 2496 2537 2590 2604 2611 2666 2675 2676 2703 2728 2731} Opaque]
	
	# Set the toggle variable to visible
	set bacterialantibiotics_show 4

	}
}

addbutton {16S Assembly Order} {

    # Global vars
    global 2HGR_SSU
    global bacterialassemblySSU_reps
    global bacterialassemblySSU_show

    if {![info exist bacterialassemblySSU_show]} {
	set bacterialassemblySSU_show 0
    }

    # If is already visible, render it invisible
    if {$bacterialassemblySSU_show == 4} {

	# Delete all reps of this model
	delrepsarray $bacterialassemblySSU_reps $2HGR_SSU
	
	# Set the toggle variable to not_visible
	set bacterialassemblySSU_show 0

    } elseif {$bacterialassemblySSU_show == 0} {

	set bacterialassemblySSU_reps {}

	# Display the rep for this model
	lappend bacterialassemblySSU_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 1} {chain T W G K N R J} Opaque]
	
	# Set the toggle variable to visible
	set bacterialassemblySSU_show 1

    } elseif {$bacterialassemblySSU_show == 1} {

	# Delete all reps of this model
	delrepsarray $bacterialassemblySSU_reps $2HGR_SSU
	set bacterialassemblySSU_reps {}

	# Display the rep for this model
	lappend bacterialassemblySSU_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 3} {chain S I U L P V} Opaque]
	
	# Set the toggle variable to visible
	set bacterialassemblySSU_show 2

    } elseif {$bacterialassemblySSU_show == 2} {

	# Delete all reps of this model
	delrepsarray $bacterialassemblySSU_reps $2HGR_SSU
	set bacterialassemblySSU_reps {}
	
	# Display the rep for this model
	lappend bacterialassemblySSU_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 5} {chain O H M Q} Opaque]
	
	# Set the toggle variable to visible
	set bacterialassemblySSU_show 3

    } elseif {$bacterialassemblySSU_show == 3} {

	# Delete all reps of this model
	delrepsarray $bacterialassemblySSU_reps $2HGR_SSU
	set bacterialassemblySSU_reps {}

	# Display the rep for this model
	lappend bacterialassemblySSU_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 8} {chain E F} Opaque]	
	
	# Set the toggle variable to visible
	set bacterialassemblySSU_show 4

	}
}

addbutton {23S Assembly Order} {

    # Global vars
    global 2HGU_LSU
    global bacterialassemblyLSU_reps
    global bacterialassemblyLSU_show

    if {![info exist bacterialassemblyLSU_show]} {
	set bacterialassemblyLSU_show 0
    }

    # If is already visible, render it invisible
    if {$bacterialassemblyLSU_show == 4} {

	# Delete all reps of this model
	delrepsarray $bacterialassemblyLSU_reps $2HGU_LSU
	
	# Set the toggle variable to not_visible
	set bacterialassemblyLSU_show 0

    } elseif {$bacterialassemblyLSU_show == 0} {

	set bacterialassemblyLSU_reps {}

	# Display the rep for this model
	lappend bacterialassemblyLSU_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 1} {chain X T F D W E C K} Opaque]
	
	# Set the toggle variable to visible
	set bacterialassemblyLSU_show 1

    } elseif {$bacterialassemblyLSU_show == 1} {

	# Delete all reps of this model
	delrepsarray $bacterialassemblyLSU_reps $2HGU_LSU
	set bacterialassemblyLSU_reps {}

	# Display the rep for this model
	lappend bacterialassemblyLSU_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 3} {chain U M 1 Q G O V 3} Opaque]
	
	# Set the toggle variable to visible
	set bacterialassemblyLSU_show 2

    } elseif {$bacterialassemblyLSU_show == 2} {

	# Delete all reps of this model
	delrepsarray $bacterialassemblyLSU_reps $2HGU_LSU
	set bacterialassemblyLSU_reps {}
	
	# Display the rep for this model
	lappend bacterialassemblyLSU_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 5} {chain 2 6 5 4 L N 5 R Y Z H} Opaque]
	
	# Set the toggle variable to visible
	set bacterialassemblyLSU_show 3

    } elseif {$bacterialassemblyLSU_show == 3} {

	# Delete all reps of this model
	delrepsarray $bacterialassemblyLSU_reps $2HGU_LSU
	set bacterialassemblyLSU_reps {}

	# Display the rep for this model
	lappend bacterialassemblyLSU_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 8} {chain P 5} Opaque]	
	
	# Set the toggle variable to visible
	set bacterialassemblyLSU_show 4

	}
}

#addframe "" 1 0 1 1
# Define Reload button
addbutton {Reload All} {
	clear
      load
}

#############BEGINNING OF ARCHY########################

addframe "Archaea (H.ma.)" 0 1 1 1

addbutton {23S rRNA} {

    # Global vars
    global 1S72_LSU
    global ArchySSUrna_reps
    global ArchySSUrna_show
 
    if {![info exist ArchySSUrna_show]} {
	set ArchySSUrna_show 0
    }
   
    # If is already visible, render it invisible
    if {$ArchySSUrna_show} {

        # Delete all reps of this model
	delrepsarray $ArchySSUrna_reps $1S72_LSU

	# Set the toggle variable to not_visible
	set ArchySSUrna_show 0

    } else {

	set ArchySSUrna_reps {}

	# Display the rep for this model
	lappend ArchySSUrna_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 0} {chain 0} Opaque]
	lappend ArchySSUrna_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 1} {chain 9} Opaque]

	# Set the toggle variable to visible
	set ArchySSUrna_show 1
    }
}

addbutton {23S Proteins} {

    # Global vars
    global 1S72_LSU
    global ArchySSUprot_reps
    global ArchySSUprot_show

    if {![info exist ArchySSUprot_show]} {
	set ArchySSUprot_show 0
    }
    
    # If is already visible, render it invisible
    if {$ArchySSUprot_show} {

        # Delete all reps of this model
	delrepsarray $ArchySSUprot_reps $1S72_LSU

	# Set the toggle variable to not_visible
	set ArchySSUprot_show 0

    } else {

	set ArchySSUrna_reps {}

	# Display the rep for this model
	lappend ArchySSUprot_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 8} {protein} Opaque]

	#**************************************
	# ADDITIONAL VISUALIZATION SETTINGS
	set sel [atomselect $1S72_LSU "chain A B C D E F G H I J K L M N O P Q R S T U V W X Y Z 1 2 3"];
	$sel set structure H;
	$sel delete;
	#**************************************

	# Set the toggle variable to visible
	set ArchySSUprot_show 1
    }
}

addbutton {Exit Channel} {

    # Global vars
    global 1S72_LSU
    global Archyexitchannel_reps
    global Archyexitchannel_show

    if {![info exist Archyexitchannel_show]} {
	set Archyexitchannel_show 0
    }
    
    # If is already visible, render it invisible
    if {$Archyexitchannel_show} {

        # Delete all reps of this model
	delrepsarray $Archyexitchannel_reps $1S72_LSU

	# Set the toggle variable to not_visible
	set Archyexitchannel_show 0

    } else {

	set Archyexitchannel_reps {}

	# Display the rep for this model
	lappend Archyexitchannel_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 10} {chain 0  and ((resid 55 to 62) or (resid 80 to 98) or (resid 454 to 515) or (resid 765 to 770) or (resid 835 to 847) or (resid 883 to 886) or (resid 1359 to 1374) or (resid 1386 to 1392) or (resid 1424 to 1434) or (resid 1439 to 1443) or (resid 1687 to 1694) or (resid 1835 to 1840) or (resid 1978 to 1999) or (resid 2100 to 2120) or (resid 2280 to 2290) or (resid 2472 to 2520) or (resid 2525 to 2545) or (resid 2583 to 2595) or (resid 2598 to 2626) or (resid 2635 to 2648) or (resid 2030 to 2100) or (resid 2640 to 2660))} Opaque]

	# Set the toggle variable to visible
	set Archyexitchannel_show 1
    }
}

addbutton {Exit Channel Prot.} {

    # Global vars
    global 1S72_LSU
    global Archyexitchannelprot_reps
    global Archyexitchannelprot_show

    if {![info exist Archyexitchannelprot_show]} {
	set Archyexitchannelprot_show 0
    }
    
    # If is already visible, render it invisible
    if {$Archyexitchannelprot_show} {

        # Delete all reps of this model
	delrepsarray $Archyexitchannelprot_reps $1S72_LSU

	# Set the toggle variable to not_visible
	set Archyexitchannelprot_show 0

    } else {

	set Archyexitchannelprot_reps {}

	# Display the rep for this model
	lappend Archyexitchannelprot_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 4} {chain B R S T V K C H 2} Opaque]

	# Set the toggle variable to visible
	set Archyexitchannelprot_show 1
    }
}

addbutton {Archaeal Specific Prot.} {

    # Global vars
    global 1S72_LSU
    global archaealspecificprot_reps
    global archaealspecificprot_show

    if {![info exist archaealspecificprot_show]} {
	set archaealspecificprot_show 0
    }
    
    # If is already visible, render it invisible
    if {$archaealspecificprot_show} {

        # Delete all reps of this model
	delrepsarray $archaealspecificprot_reps $1S72_LSU

	# Set the toggle variable to not_visible
	set archaealspecificprot_show 0

    } else {

	set archaealspecificprot_reps {}

	# Display the rep for this model
	lappend archaealspecificprot_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 7} {chain 3 2 1 Z X U Q M} Opaque]
	lappend archaealspecificprot_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 11} {chain Y P O} Opaque]

	# Set the toggle variable to visible
	set archaealspecificprot_show 1
    }
}

addbutton {Antibiotics} {

    # Global vars
    global 1S72_LSU
    global 2HGU_LSU
    global archaealantibiotics_reps
    global archaealnearbyprot_reps
    global archaealantibiotics_show

    if {![info exist archaealantibiotics_show]} {
	set archaealantibiotics_show 0
    }

    # If is already visible, render it invisible
    if {$archaealantibiotics_show == 4} {

	# Delete all reps of this model
	delrepsarray $archaealantibiotics_reps $1S72_LSU
	delrepsarray $archaealnearbyprot_reps $2HGU_LSU	
	
	# Set the toggle variable to not_visible
	set archaealantibiotics_show 0

    } elseif {$archaealantibiotics_show == 0} {

	set archaealantibiotics_reps {}
	set archaealnearbyprot_reps {}

	# Display the rep for this model
	lappend archaealantibiotics_reps [addrep $1S72_LSU VDW {ResName} {resname CAI TYK ANM BLS SPR ZIT PPU SPS ERY TEL VRS VIR SYB} Opaque]
	
	# Set the toggle variable to visible
	set archaealantibiotics_show 1

    } elseif {$archaealantibiotics_show == 1} {

	# Delete all reps of this model
	delrepsarray $archaealantibiotics_reps $1S72_LSU
	delrepsarray $archaealnearbyprot_reps $2HGU_LSU	
	set archaealantibiotics_reps {}
	set archaealnearbyprot_reps {}
	
	# Display the rep for this model
	lappend archaealantibiotics_reps [addrep $1S72_LSU VDW {ColorID 8} {resname ERY} Opaque]
	
	# Set the toggle variable to visible
	set archaealantibiotics_show 2

    } elseif {$archaealantibiotics_show == 2} {

	# Delete all reps of this model
	delrepsarray $archaealantibiotics_reps $1S72_LSU
	delrepsarray $archaealnearbyprot_reps $2HGU_LSU	
	set archaealantibiotics_reps {}
	set archaealnearbyprot_reps {}
	
	# Display the rep for this model
	lappend archaealantibiotics_reps [addrep $1S72_LSU VDW {ColorID 8} {resname ERY} Opaque]
	lappend archaealantibiotics_reps [addrep $1S72_LSU Licorice {ColorID 0} {chain 0 and resid 2099} Opaque]
	
	# Set the toggle variable to visible
	set archaealantibiotics_show 3

    } elseif {$archaealantibiotics_show == 3} {

	# Delete all reps of this model
	delrepsarray $archaealantibiotics_reps $1S72_LSU
	delrepsarray $archaealnearbyprot_reps $2HGU_LSU	
	set archaealantibiotics_reps {}
	set archaealnearbyprot_reps {}
	
	# Display the rep for this model
	lappend archaealantibiotics_reps [addrep $1S72_LSU VDW {ColorID 8} {resname ERY} Opaque]
	lappend archaealnearbyprot_reps [addrep $2HGU_LSU {SURF} {ColorID 1} {(same residue as  nucleic within 7 of chain A and resid 2058 746 2611) and not (chain A and resid  2058 746 2611)} Transparent]
	lappend archaealnearbyprot_reps [addrep $2HGU_LSU {Licorice 0.4} {ColorID 10} {chain A and resid 2058} Opaque]
	lappend archaealnearbyprot_reps [addrep $2HGU_LSU {Licorice 0.4} {ColorID 10} {chain A and resid 746 2611} Opaque]
	lappend archaealnearbyprot_reps [addrep $2HGU_LSU {SURF} {ColorID 15} {(same residue as protein within 7 of chain A and resid 2058 746 2611) and not (chain A and resid  2058 746 2611)} Transparent]
	
	# Set the toggle variable to visible
	set archaealantibiotics_show 4

	}
}


addframe "23S LSU (T.Th.)" 0 2 1 1

addbutton {23S SS A-Site (T.Th.)} {

    # Global vars
    global 2HGU_LSU
    global bacterial23SseqsigsAsite_reps
    global bacterial23SseqsigsAsite_show

    if {![info exist bacterial23SseqsigsAsite_show]} {
	set bacterial23SseqsigsAsite_show 0
    }
    
    # If is already visible, render it invisible
    if {$bacterial23SseqsigsAsite_show} {

        # Delete all reps of this model
	delrepsarray $bacterial23SseqsigsAsite_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set bacterial23SseqsigsAsite_show 0

    } else {

	set bacterial23SseqsigsAsite_reps {}

	# Display the rep for this model
	lappend bacterial23SseqsigsAsite_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Transparent]
	# THESE ARE CLOSE TO THE A-SITE AND EXIT CHANNEL
	lappend bacterial23SseqsigsAsite_reps [addrep $2HGU_LSU VDW {ColorID 1} {chain A and resid 2741 2687} Opaque]
	# THESE SIGNATURES ARE JUST CLOSE TO THE A-SITE
	lappend bacterial23SseqsigsAsite_reps [addrep $2HGU_LSU VDW {ColorID 2} {chain A and resid 2688} Opaque]

	# Set the toggle variable to visible
	set bacterial23SseqsigsAsite_show 1
    }
}

addbutton {23S SS P-Site (T.Th.)} {

    # Global vars
    global 2HGU_LSU
    global bacterial23SseqsigsPsite_reps
    global bacterial23SseqsigsPsite_show

    if {![info exist bacterial23SseqsigsPsite_show]} {
	set bacterial23SseqsigsPsite_show 0
    }
    
    # If is already visible, render it invisible
    if {$bacterial23SseqsigsPsite_show} {

        # Delete all reps of this model
	delrepsarray $bacterial23SseqsigsPsite_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set bacterial23SseqsigsPsite_show 0

    } else {

	set bacterial23SseqsigsPsite_reps {}

	# THESE SIGNATURES ARE CLOSE TO THE P-SITE
	lappend bacterial23SseqsigsPsite_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Transparent]
	# Display the rep for this model
	lappend bacterial23SseqsigsPsite_reps [addrep $2HGU_LSU VDW {ColorID 7} {chain A and resid 1947 2274 2290 2364 2365 2366 2376 2378} Opaque]

	# Set the toggle variable to visible
	set bacterial23SseqsigsPsite_show 1
    }
}

addbutton {23S SS E-Site (T.Th.)} {

    # Global vars
    global 2HGU_LSU
    global bacterial23SseqsigsEsite_reps
    global bacterial23SseqsigsEsite_show

    if {![info exist bacterial23SseqsigsEsite_show]} {
	set bacterial23SseqsigsEsite_show 0
    }
    
    # If is already visible, render it invisible
    if {$bacterial23SseqsigsEsite_show} {

        # Delete all reps of this model
	delrepsarray $bacterial23SseqsigsEsite_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set bacterial23SseqsigsEsite_show 0

    } else {

	set bacterial23SseqsigsEsite_reps {}

	# THESE SIGNATURES ARE CLOSE TO THE E-SITE
	lappend bacterial23SseqsigsEsite_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Transparent]
	# Display the rep for this model
	lappend bacterial23SseqsigsEsite_reps [addrep $2HGU_LSU VDW {ColorID 7} {chain A and resid 1883 2405 2408 2432 2435} Opaque]

	# Set the toggle variable to visible
	set bacterial23SseqsigsEsite_show 1
    }
}

addbutton {23S SS Exit Channel (T.Th.)} {

    # Global vars
    global 2HGU_LSU
    global bacterial23SseqsigsEC_reps
    global bacterial23SseqsigsEC_show

    if {![info exist bacterial23SseqsigsEC_show]} {
	set bacterial23SseqsigsEC_show 0
    }
    
    # If is already visible, render it invisible
    if {$bacterial23SseqsigsEC_show == 2} {

        # Delete all reps of this model
	delrepsarray $bacterial23SseqsigsEC_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set bacterial23SseqsigsEC_show 0

    } elseif {$bacterial23SseqsigsEC_show == 0} {

	set bacterial23SseqsigsEC_reps {}

	# THESE SIGNATURES MAKE UP PART OF THE EXIT CHANNEL
	lappend bacterial23SseqsigsEC_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Transparent]
	# Display the rep for this model
	lappend bacterial23SseqsigsEC_reps [addrep $2HGU_LSU VDW {ColorID 4} {chain A and resid 501 792 793 1302 1309 1317 2068 2080 2471 2478 2496 2508 2549 2602 2616 2623} Opaque]

	set bacterial23SseqsigsEC_show 1

	} elseif  {$bacterial23SseqsigsEC_show == 1} {

      # Delete all reps of this model
	delrepsarray $bacterial23SseqsigsEC_reps $2HGU_LSU

	# THESE SIGNATURES ARE PART OF AND NEAR TO THE EXIT CHANNEL
	lappend bacterial23SseqsigsEC_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Transparent]
	# Display the rep for this model
	lappend bacterial23SseqsigsEC_reps [addrep $2HGU_LSU VDW {ColorID 4} {chain A and resid 501 792 793 1302 1309 1317 2068 2080 2471 2478 2496 2508 2549 2602 2616 2623} Opaque]
	lappend bacterial23SseqsigsEC_reps [addrep $2HGU_LSU VDW {ColorID 6} {chain A and resid 15 17 31 440 599 607 874 877 1654 1801 2056 2687 2741 2744} Opaque]

	# Set the toggle variable to visible
	set bacterial23SseqsigsEC_show 2
    }
}

addbutton {23S SS Proteins (T.Th.)} {

    # Global vars
    global 2HGU_LSU
    global bacterial23Sseqsigsprot_reps
    global bacterial23Sseqsigsprot_show

    if {![info exist bacterial23Sseqsigsprot_show]} {
	set bacterial23Sseqsigsprot_show 0
    }
    
    # If is already visible, render it invisible
    if {$bacterial23Sseqsigsprot_show} {

        # Delete all reps of this model
	delrepsarray $bacterial23Sseqsigsprot_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set bacterial23Sseqsigsprot_show 0

    } else {

	set bacterial23Sseqsigsprot_reps {}

	# THESE SIGNATURES ARE CLOSE TO 23S PROTEINS
	lappend bacterial23Sseqsigsprot_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Transparent]
	# Display the rep for this model
	lappend bacterial23Sseqsigsprot_reps [addrep $2HGU_LSU VDW {ColorID 7} {chain A and resid 15 17 122 440 554 559 582 588 607 662 740 792 793 860 902 968 1203 1240 1302 1309 1410 1502 1712 1845 1846 2017 2063 2068 2112 2274 2290 2364 2365 2366 2376 2378 2402 2405 2408 2409 2424 2432 2435 2440 2471 2478 2496 2508 2602 2623 2678 2687 2688 2741 2744} Opaque]

	# Set the toggle variable to visible
	set bacterial23Sseqsigsprot_show 1
    }
}

addbutton {23S SS No Label (T.Th.)} {

    # Global vars
    global 2HGU_LSU
    global bacterial23SseqsigsEsite_reps
    global bacterial23SseqsigsEsite_show

    if {![info exist bacterial23SseqsigsEsite_show]} {
	set bacterial23SseqsigsEsite_show 0
    }
    
    # If is already visible, render it invisible
    if {$bacterial23SseqsigsEsite_show} {

        # Delete all reps of this model
	delrepsarray $bacterial23SseqsigsEsite_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set bacterial23SseqsigsEsite_show 0

    } else {

	set bacterial23SseqsigsEsite_reps {}

	# THESE SIGNATURES ARE NOT NEAR ANY KNOWN FUNCTIONAL SITE
	lappend bacterial23SseqsigsEsite_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Transparent]
	# Display the rep for this model
	lappend bacterial23SseqsigsEsite_reps [addrep $2HGU_LSU VDW {ColorID 7} {chain A and resid 13 43 418 442 548 578 761 765 807 816 946 965 1078 1351 1425 1503 1669 1878 2241 2420 2422 2423 2437 2715} Opaque]

	# Set the toggle variable to visible
	set bacterial23SseqsigsEsite_show 1
    }
}

addbutton {23S Struc Signatures (Old)} {

    # Global vars
    global 2HGU_LSU
    global bacterialstructuralsigs_reps
    global bacterialstructuralsigs_show

    if {![info exist bacterialstructuralsigs_show]} {
	set bacterialstructuralsigs_show 0
    }
    
    # If is already visible, render it invisible
    if {$bacterialstructuralsigs_show} {

        # Delete all reps of this model
	delrepsarray $bacterialstructuralsigs_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set bacterialstructuralsigs_show 0

    } else {

	set bacterialstructuralsigs_reps {}

	# Display the rep for this model
	lappend bacterialstructuralsigs_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 17} {chain A and ( resid 270 to 270 or resid 378 to 397 or resid 541 to 553 or resid 634 to 641 or resid 872 to 907 or resid 925 to 937 or resid 1021 to 1029 or resid 1473 to 1518 or resid 1854 to 1887 or resid 2206 to 2219 or resid 2348 to 2370 or resid 2855 to 2863 or resid 2421 to 2434)} Opaque]
	
	# Set the toggle variable to visible
	set bacterialstructuralsigs_show 1
    }
}

addbutton {23S Seq Signatures (Old)} {

    # Global vars
    global 2HGU_LSU
    global bacterialsequencesigs_reps
    global bacterialsequencesigs_show

    if {![info exist bacterialsequencesigs_show]} {
	set bacterialsequencesigs_show 0
    }
    
    # If is already visible, render it invisible
    if {$bacterialsequencesigs_show == 4} {

        # Delete all reps of this model
	delrepsarray $bacterialsequencesigs_reps $2HGU_LSU

	# Set the toggle variable to not_visible
	set bacterialsequencesigs_show 0

    } elseif {$bacterialsequencesigs_show == 0} {

	set bacterialsequencesigs_reps {}

	# Display the rep for this model
	lappend bacterialsequencesigs_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Transparent]
	lappend bacterialsequencesigs_reps [addrep $2HGU_LSU VDW {ColorID 7} {chain A and resid 13 15 17 31 44 124 391 413 415 474 523 529 534 555 559 565 576 584 637 693 714 718 745 746 760 769 813 827 830 844 900 919 922 1032 1054 1061 1105 1156 1194 1256 1263 1271 1305 1364 1379 1455 1456 1608 1623 1665 1770 1814 1815 1847 1852 1864 1925 1995 2034 2041 2046 2058 2090 2229 2262 2278 2352 2353 2354 2364 2366 2390 2393 2396 2397 2408 2410 2411 2412 2420 2423 2425 2428 2459 2466 2484 2496 2537 2590 2604 2611 2666 2675 2676 2703 2728 2731} Opaque]
	
	# Set the toggle variable to visible
	set bacterialsequencesigs_show 1

    } elseif {$bacterialsequencesigs_show == 1} {

        # Delete all reps of this model
	delrepsarray $bacterialsequencesigs_reps $2HGU_LSU

	set bacterialsequencesigs_reps {}

	# Display the rep for this model
	lappend bacterialsequencesigs_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Transparent]
	lappend bacterialsequencesigs_reps [addrep $2HGU_LSU VDW {ColorID 20} {chain A and resid 17 31 124 413 474 523 565 576 584 813 827 830 1054 1105 1194 1256 1271 1364 1379 1608 1665 1770 1847 1925 1995 2046 2058 2262 2278 2390 2393 2410 2411 2428 2459 2466 2484 2496 2590 2604 2666 2676 2728} Opaque]
	
	# Set the toggle variable to visible
	set bacterialsequencesigs_show 2

    } elseif {$bacterialsequencesigs_show == 2} {

        # Delete all reps of this model
	delrepsarray $bacterialsequencesigs_reps $2HGU_LSU

	set bacterialsequencesigs_reps {}

	# Display the rep for this model
	lappend bacterialsequencesigs_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Transparent]
	lappend bacterialsequencesigs_reps [addrep $2HGU_LSU VDW {ColorID 1} {chain A and resid 13 15 44 391 415 529 534 555 559 637 693 714 718 745 746 760 769 855 900 919 922 1032 1061 1156 1263 1305 1455 1456 1623 1814 1815 1852 1864 2034 2041 2090 2229 2352 2353 2354 2364 2366 2396 2397 2408 2412 2420 2423 2425 2537 2610 2675 2703 2731} Opaque]
	lappend bacterialsequencesigs_reps [addrep $2HGU_LSU VDW {ColorID 7} {chain A and resid 17 31 124 413 474 523 565 576 584 813 827 830 1054 1105 1194 1256 1271 1364 1379 1608 1665 1770 1847 1925 1995 2046 2058 2262 2278 2390 2393 2410 2411 2428 2459 2466 2484 2496 2590 2604 2666 2676 2728} Opaque]
	
	# Set the toggle variable to visible
	set bacterialsequencesigs_show 3

    } elseif {$bacterialsequencesigs_show == 3} {

        # Delete all reps of this model
	delrepsarray $bacterialsequencesigs_reps $2HGU_LSU

	set bacterialsequencesigs_reps {}

	# Display the rep for this model
	lappend bacterialsequencesigs_reps [addrep $2HGU_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Transparent]
	lappend bacterialsequencesigs_reps [addrep $2HGU_LSU VDW {ColorID 8} {chain A and resid 38 40 387 439 441 508 1567 1607 1627 1639 1880 1908 1922 1982 2265 2302 2314 2516 2530 2568 2622 2679} Opaque]
	lappend bacterialsequencesigs_reps [addrep $2HGU_LSU VDW {ColorID 1} {chain A and resid 13 15 44 391 415 529 534 555 559 637 693 714 718 745 746 760 769 855 900 919 922 1032 1061 1156 1263 1305 1455 1456 1623 1814 1815 1852 1864 2034 2041 2090 2229 2352 2353 2354 2364 2366 2396 2397 2408 2412 2420 2423 2425 2537 2611 2675 2703 2731} Opaque]
	lappend bacterialsequencesigs_reps [addrep $2HGU_LSU VDW {ColorID 7} {chain A and resid 17 31 124 413 474 523 565 576 584 813 827 830 1054 1105 1194 1256 1271 1364 1379 1608 1665 1770 1847 1925 1995 2046 2058 2262 2278 2390 2393 2410 2411 2428 2459 2466 2484 2496 2590 2604 2666 2676 2728} Opaque]
		
	# Set the toggle variable to visible
	set bacterialsequencesigs_show 4
    }
}


addbutton {16S Seq Signatures (Old)} {

    # Global vars
    global 2HGR_SSU
    global bacterial16Sseqsigs_reps
    global bacterial16Sseqsigs_show

    if {![info exist bacterial16Sseqsigs_show]} {
	set bacterial16Sseqsigs_show 0
    }
    
    # If is already visible, render it invisible
    if {$bacterial16Sseqsigs_show} {

        # Delete all reps of this model
	delrepsarray $bacterial16Sseqsigs_reps $2HGR_SSU

	# Set the toggle variable to not_visible
	set bacterial16Sseqsigs_show 0

    } else {

	set bacterial16Sseqsigs_reps {}

	# Display the rep for this model
	lappend bacterial16Sseqsigs_reps [addrep $2HGR_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Transparent]
	# Display the rep for this model
	lappend bacterial16Sseqsigs_reps [addrep $2HGR_SSU VDW {ColorID 7} {chain A and resid 716 756 912 962 973 1060 1110 1188 1194 1197 1211 1212 1229 1232 1381 1384 1386 1387 1393} Opaque]

	#This one was commented out:
	#lappend bacterial16Sseqsigs_reps [addrep $2HGR_SSU VDW {ColorID 7} {chain A and resid 33 349 350 367 377 393 447 487 551 558 559 684 1232} Transparent]
	
	# Set the toggle variable to visible
	set bacterial16Sseqsigs_show 1
    }
}


################BEGINNING OF ARCHY LSU SIGNATURES###########

addframe "23S LSU (H.ma.)" 1 2 1 1

addbutton {23S SS A-Site (H.ma.)} {

    # Global vars
    global 1S72_LSU
    global archaeal23SseqsigsAsite_reps
    global archaeal23SseqsigsAsite_show

    if {![info exist archaeal23SseqsigsAsite_show]} {
	set archaeal23SseqsigsAsite_show 0
    }
    
    # If is already visible, render it invisible
    if {$archaeal23SseqsigsAsite_show} {

        # Delete all reps of this model
	delrepsarray $archaeal23SseqsigsAsite_reps $1S72_LSU

	# Set the toggle variable to not_visible
	set archaeal23SseqsigsAsite_show 0

    } else {

	set archaeal23SseqsigsAsite_reps {}

	# Display the rep for this model
	lappend archaeal23SseqsigsAsite_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain 0} Transparent]
	# THESE ARE CLOSE TO THE A-SITE AND EXIT CHANNEL
	lappend archaeal23SseqsigsAsite_reps [addrep $1S72_LSU VDW {ColorID 1} {chain 0 and resid 2764} Opaque]
	# THESE SIGNATURES ARE JUST CLOSE TO THE A-SITE
	lappend archaeal23SseqsigsAsite_reps [addrep $1S72_LSU VDW {ColorID 2} {chain 0 and resid 2713} Opaque]

	# Set the toggle variable to visible
	set archaeal23SseqsigsAsite_show 1
    }
}

addbutton {23S SS P-Site (H.ma.)} {

    # Global vars
    global 1S72_LSU
    global archaeal23SseqsigsPsite_reps
    global archaeal23SseqsigsPsite_show

    if {![info exist archaeal23SseqsigsPsite_show]} {
	set archaeal23SseqsigsPsite_show 0
    }
    
    # If is already visible, render it invisible
    if {$archaeal23SseqsigsPsite_show} {

        # Delete all reps of this model
	delrepsarray $archaeal23SseqsigsPsite_reps $1S72_LSU

	# Set the toggle variable to not_visible
	set archaeal23SseqsigsPsite_show 0

    } else {

	set archaeal23SseqsigsPsite_reps {}

	# THESE SIGNATURES ARE CLOSE TO THE P-SITE
	lappend archaeal23SseqsigsPsite_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain 0} Transparent]
	# Display the rep for this model
	lappend archaeal23SseqsigsPsite_reps [addrep $1S72_LSU VDW {ColorID 7} {chain 0 and resid 2312 2296 1966} Opaque]

	# Set the toggle variable to visible
	set archaeal23SseqsigsPsite_show 1
    }
}

addbutton {23S SS E-Site (H.ma.)} {

    # Global vars
    global 1S72_LSU
    global archaeal23SseqsigsEsite_reps
    global archaeal23SseqsigsEsite_show

    if {![info exist archaeal23SseqsigsEsite_show]} {
	set archaeal23SseqsigsEsite_show 0
    }
    
    # If is already visible, render it invisible
    if {$archaeal23SseqsigsEsite_show} {

        # Delete all reps of this model
	delrepsarray $archaeal23SseqsigsEsite_reps $1S72_LSU

	# Set the toggle variable to not_visible
	set archaeal23SseqsigsEsite_show 0

    } else {

	set archaeal23SseqsigsEsite_reps {}

	# THESE SIGNATURES ARE CLOSE TO THE E-SITE
	lappend archaeal23SseqsigsEsite_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain 0} Transparent]
	# Display the rep for this model
	lappend archaeal23SseqsigsEsite_reps [addrep $1S72_LSU VDW {ColorID 7} {chain 0 and resid 2430} Opaque]

	# Set the toggle variable to visible
	set archaeal23SseqsigsEsite_show 1
    }
}

addbutton {23S SS Exit Channel (H.ma.)} {

    # Global vars
    global 1S72_LSU
    global archaeal23SseqsigsEC_reps
    global archaeal23SseqsigsEC_show

    if {![info exist archaeal23SseqsigsEC_show]} {
	set archaeal23SseqsigsEC_show 0
    }
    
    # If is already visible, render it invisible
    if {$archaeal23SseqsigsEC_show == 2} {

        # Delete all reps of this model
	delrepsarray $archaeal23SseqsigsEC_reps $1S72_LSU

	# Set the toggle variable to not_visible
	set archaeal23SseqsigsEC_show 0

    } elseif {$archaeal23SseqsigsEC_show == 0} {

	set archaeal23SseqsigsEC_reps {}

	# THESE SIGNATURES MAKE UP PART OF THE EXIT CHANNEL
	lappend archaeal23SseqsigsEC_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain 0} Transparent]
	# Display the rep for this model
	lappend archaeal23SseqsigsEC_reps [addrep $1S72_LSU VDW {ColorID 4} {chain 0 and resid 480 1360 1375 2099 2494 2501 2519 2531 2625 2639} Opaque]

	set archaeal23SseqsigsEC_show 1

	} elseif  {$archaeal23SseqsigsEC_show == 1} {

      # Delete all reps of this model
	delrepsarray $archaeal23SseqsigsEC_reps $1S72_LSU

	# THESE SIGNATURES ARE PART OF AND NEAR TO THE EXIT CHANNEL
	lappend archaeal23SseqsigsEC_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain 0} Transparent]
	# Display the rep for this model
	lappend archaeal23SseqsigsEC_reps [addrep $1S72_LSU VDW {ColorID 4} {chain 0 and resid 480 1360 1375 2099 2494 2501 2519 2531 2625 2639} Opaque]
	lappend archaeal23SseqsigsEC_reps [addrep $1S72_LSU VDW {ColorID 6} {chain 0 and resid 14 28 419 633 641 920 923 1683 1826 2087 2764} Opaque]

	# Set the toggle variable to visible
	set archaeal23SseqsigsEC_show 2
    }
}

addbutton {23S SS Proteins (H.ma.)} {

    # Global vars
    global 1S72_LSU
    global archaeal23Sseqsigsprot_reps
    global archaeal23Sseqsigsprot_show

    if {![info exist archaeal23Sseqsigsprot_show]} {
	set archaeal23Sseqsigsprot_show 0
    }
    
    # If is already visible, render it invisible
    if {$archaeal23Sseqsigsprot_show} {

        # Delete all reps of this model
	delrepsarray $archaeal23Sseqsigsprot_reps $1S72_LSU

	# Set the toggle variable to not_visible
	set archaeal23Sseqsigsprot_show 0

    } else {

	set archaeal23Sseqsigsprot_reps {}

	# THESE SIGNATURES ARE CLOSE TO 23S PROTEINS
	lappend archaeal23Sseqsigsprot_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain 0} Transparent]
	# Display the rep for this model
	lappend archaeal23Sseqsigsprot_reps [addrep $1S72_LSU VDW {ColorID 7} {chain 0 and resid 14 119 419 622 641 906 1299 1360 1470 1743 2075 2087 2296 2312 2427 2430 2465 2494 2501 2519 2531 2625 2703 2713 2764} Opaque]

	# Set the toggle variable to visible
	set archaeal23Sseqsigsprot_show 1
    }
}

addbutton {23S SS No Label (H.ma.)} {

    # Global vars
    global 1S72_LSU
    global archaeal23SseqsigsEsite_reps
    global archaeal23SseqsigsEsite_show

    if {![info exist archaeal23SseqsigsEsite_show]} {
	set archaeal23SseqsigsEsite_show 0
    }
    
    # If is already visible, render it invisible
    if {$archaeal23SseqsigsEsite_show} {

        # Delete all reps of this model
	delrepsarray $archaeal23SseqsigsEsite_reps $1S72_LSU

	# Set the toggle variable to not_visible
	set archaeal23SseqsigsEsite_show 0

    } else {

	set archaeal23SseqsigsEsite_reps {}

	# THESE SIGNATURES ARE NOT NEAR ANY KNOWN FUNCTIONAL SITE
	lappend archaeal23SseqsigsEsite_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain 0} Transparent]
	# Display the rep for this model
	lappend archaeal23SseqsigsEsite_reps [addrep $1S72_LSU VDW {ColorID 7} {chain 0 and resid 529 1486 1903 2448 2449} Opaque]

	# Set the toggle variable to visible
	set archaeal23SseqsigsEsite_show 1
    }
}

addbutton {23S Struc Signatures (Old)} {

    # Global vars
    global 1S72_LSU
    global archaealstructuralsigs_reps
    global archaealstructuralsigs_show

    if {![info exist archaealstructuralsigs_show]} {
	set archaealstructuralsigs_show 0
    }
    
    # If is already visible, render it invisible
    if {$archaealstructuralsigs_show} {

        # Delete all reps of this model
	delrepsarray $archaealstructuralsigs_reps $1S72_LSU

	# Set the toggle variable to not_visible
	set archaealstructuralsigs_show 0

    } else {

	set archaealstructuralsigs_reps {}

	# Display the rep for this model
	lappend archaealstructuralsigs_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 8} {chain 0 and (resid 241 to 270 or resid 387 to 403 or resid 546 to 611 or resid 695 to 733 or resid 967 to 1003 or resid 1021 to 1036 or resid 1118 to 1133 or resid 1576 to 1620  or resid 1910 to 1928 or resid 2246 to 2256 or resid 2382 to 2407 or resid 2871 to 2886 or resid 2459 to 2469)} Opaque]
	
	# Set the toggle variable to visible
	set archaealstructuralsigs_show 1
    }
}

addbutton {23S Seq Signatures (Old)} {

    # Global vars
    global 1S72_LSU
    global archaealsequencesigs_reps
    global archaealsequencesigs_show

    if {![info exist archaealsequencesigs_show]} {
	set archaealsequencesigs_show 0
    }
    
    # If is already visible, render it invisible
    if {$archaealsequencesigs_show == 4} {

        # Delete all reps of this model
	delrepsarray $archaealsequencesigs_reps $1S72_LSU

	# Set the toggle variable to not_visible
	set archaealsequencesigs_show 0

    } elseif {$archaealsequencesigs_show == 0} {

	set archaealsequencesigs_reps {}

	# Display the rep for this model
	lappend archaealsequencesigs_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 3} {chain 0} Transparent]
	lappend archaealsequencesigs_reps [addrep $1S72_LSU VDW 20 {chain 0 and resid 14 28 37 119 394 419 445 447 480 514 529 622 633 641 906 920 923 1158 1209 1299 1360 1367 1375 1470 1486 1654 1682 1683 1702 1716 1743 1826 1903 1925 1949 1963 1966 2023 2036 2087 2099 2296 2299 2312 2336 2348 2427 2430 2448 2449 2465 2494 2501 2519 2531 2551 2565 2603 2625 2639 2657 2703 2713 2716 2764} Opaque]
	
	# Set the toggle variable to visible
	set archaealsequencesigs_show 1

    } elseif {$archaealsequencesigs_show == 1} {

        # Delete all reps of this model
	delrepsarray $archaealsequencesigs_reps $1S72_LSU

	set archaealsequencesigs_reps {}

	# Display the rep for this model
	lappend archaealsequencesigs_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 3} {chain 0} Transparent]
	lappend archaealsequencesigs_reps [addrep $1S72_LSU VDW 20 {chain 0 and resid 14 28 119 419 480 529 622 633 641 906 920 923 1158 1209 1299 1360 1375 1470 1486 1683 1743 1826 1903 1966 2036 2087 2099 2296 2312 2427 2430 2448 2449 2465 2494 2501 2519 2531 2625 2639 2703 2713 2764} Opaque]
	
	# Set the toggle variable to visible
	set archaealsequencesigs_show 2

    } elseif {$archaealsequencesigs_show == 2} {

        # Delete all reps of this model
	delrepsarray $archaealsequencesigs_reps $1S72_LSU

	set archaealsequencesigs_reps {}

	# Display the rep for this model
	lappend archaealsequencesigs_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 3} {chain 0} Transparent]
	lappend archaealsequencesigs_reps [addrep $1S72_LSU VDW {ColorID 9} {chain 0 and resid 35 37 394 445 447 514 1654 1682 1702 1716 1925 1949 1963 2023 2299 2336 2348 2551 2565 2603 2657 2716} Opaque]
	lappend archaealsequencesigs_reps [addrep $1S72_LSU VDW {ColorID 20} {chain 0 and resid 14 28 119 419 480 529 622 633 641 906 920 923 1158 1209 1299 1360 1375 1470 1486 1683 1743 1826 1903 1966 2036 2087 2099 2296 2312 2427 2430 2448 2449 2465 2494 2501 2519 2531 2625 2639 2703 2713 2764} Opaque]
	
	# Set the toggle variable to visible
	set archaealsequencesigs_show 3

    } elseif {$archaealsequencesigs_show == 3} {

        # Delete all reps of this model
	delrepsarray $archaealsequencesigs_reps $1S72_LSU

	set archaealsequencesigs_reps {}

	# Display the rep for this model
	lappend archaealsequencesigs_reps [addrep $1S72_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 3} {chain 0} Transparent]
	lappend archaealsequencesigs_reps [addrep $1S72_LSU VDW {ColorID 6} {chain 0 and resid 10 12 40 398 421 535 540 612 616 729 784 805 809 838 839 853 862 949 996 1015 1018 1136 1165 1260 1367 1411 1561 1562 1698 1870 1871 1908 1916 2075 2082 2131 2262 2386 2387 2388 2401 2403 2433 2434 2446 2450 2458 2460 2462 2572 2646 2712 2739 2767} Opaque]
	lappend archaealsequencesigs_reps [addrep $1S72_LSU VDW {ColorID 9} {chain 0 and resid 35 37 394 445 447 514 1654 1682 1702 1716 1925 1949 1963 2023 2299 2336 2348 2551 2565 2603 2657 2716} Opaque]
	lappend archaealsequencesigs_reps [addrep $1S72_LSU VDW {ColorID 20} {chain 0 and resid 14 28 119 419 480 529 622 633 641 906 920 923 1158 1209 1299 1360 1375 1470 1486 1683 1743 1826 1903 1966 2036 2087 2099 2296 2312 2427 2430 2448 2449 2465 2494 2501 2519 2531 2625 2639 2703 2713 2764} Opaque]
		
	# Set the toggle variable to visible
	set archaealsequencesigs_show 4
	}
}

addframe "Low Res (T.th.)" 1 1 1 1
# Define button 1
addbutton {tRNA/mRNA} {

    # Global vars
    global trnalowres_reps
    global tRNAlowres_show
    global 2HGP_SSU

    if {![info exist tRNAlowres_show]} {
	set tRNAlowres_show 0
    }

    # If is already visible, render it invisible
    if {$tRNAlowres_show} {
	
	# Delete all reps of this model
	delrepsarray $trnalowres_reps $2HGP_SSU

	# Set the toggle variable to not_visible
	set tRNAlowres_show 0
	
    } else {

	# Empty the trna
	set trnalowres_reps {}

	# Display the three reps for this model
	lappend trnalowres_reps [addrep $2HGP_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 7} {chain C} Opaque]
	lappend trnalowres_reps [addrep $2HGP_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 11} {chain D} Opaque]
	lappend trnalowres_reps [addrep $2HGP_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 12} {chain B} Opaque]
	lappend trnalowres_reps [addrep $2HGP_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 4} {chain 1} Opaque]

	# Set the toggle variable to visible
	set tRNAlowres_show 1
    }
    
}

addbutton {16S rRNA} {

    # Global vars
    global 2HGP_SSU
    global SSUrnalowres_reps
    global SSUrnalowres_show
 
    if {![info exist SSUrnalowres_show]} {
	set SSUrnalowres_show 0
    }

    # If is already visible, render it invisible
    if {$SSUrnalowres_show} {

	# Delete all reps of this model
	delrepsarray $SSUrnalowres_reps $2HGP_SSU

	# Set the toggle variable to not_visible
	set SSUrnalowres_show 0

    } else {

	set SSUrnalowres_reps {}

	# Display the two reps for this model
	lappend SSUrnalowres_reps [addrep $2HGP_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Opaque]
	lappend SSUrnalowres_reps [addrep $2HGP_SSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 1} {chain A and resid 1534 to 1542} Opaque]

	# Set the toggle variable to visible
	set SSUrnalowres_show 1

    }
}

addbutton {23S rRNA} {

    # Global vars
    global 2HGQ_LSU
    global LSUrnalowres_reps
    global LSUrnalowres_show
 
    if {![info exist LSUrnalowres_show]} {
	set LSUrnalowres_show 0
    }
   
    # If is already visible, render it invisible
    if {$LSUrnalowres_show} {

        # Delete all reps of this model
	delrepsarray $LSUrnalowres_reps $2HGQ_LSU

	# Set the toggle variable to not_visible
	set LSUrnalowres_show 0

    } else {

	set LSUrnalowres_reps {}

	# Display the rep for this model
	lappend LSUrnalowres_reps [addrep $2HGQ_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 23} {chain A} Opaque]
	lappend LSUrnalowres_reps [addrep $2HGQ_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 21} {chain B} Opaque]
	lappend LSUrnalowres_reps [addrep $2HGQ_LSU {NewCartoon 0.300000 6.000000 4.100000 0} {ColorID 9} {chain A and resid 2650 to 2670} Opaque]

	# Set the toggle variable to visible
	set LSUrnalowres_show 1
    }
}





