(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3958,        106]*)
(*NotebookOutlinePosition[      4588,        128]*)
(*  CellTagsIndexPosition[      4544,        124]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\( (*\ 
      The\ gap\ function, \ Epsilon \((t)\), \ 
      is\ read\ from\ the\ output\ data\ file\ *) \)\(\[IndentingNewLine]\)\(\
\[IndentingNewLine]\)\(\(gapfuncfile\  = \ 
        ReadList["\<data.dat\>", \ {Number, \ Number}];\)\[IndentingNewLine]
    \(gapfunc\  = \ 
        Table[\(gapfuncfile[\([k]\)]\)[\([2]\)], {k, \ 
            Length[gapfuncfile]}];\)\)\)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[gapfunc, PlotJoined \[Rule] True, \ PlotRange \[Rule] All, \ 
        Axes \[Rule] False, \ Frame \[Rule] True, \ 
        PlotStyle \[Rule] {\ RGBColor[0, 0.2, 0.6]}];\)\)], "Input"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\
\( (*\ \[IndentingNewLine]Now\ read\ the\ sample\ output\ from\ a\ longer\ \
\((10  ps)\)\ simulation\ \[IndentingNewLine]You\ are\ given\ a\ larger\ data\
\ file\ to\ read\ for\ \(\(this\)\(.\)\)\[IndentingNewLine]*) \)\(\
\[IndentingNewLine]\)\(\[IndentingNewLine]\)\(\(EpsilonOfTfile\  = \ 
        ReadList["\<dataLONG.dat\>", \ {Number, \ 
            Number}];\)\[IndentingNewLine]
    \(EpsilonOfT = \ 
        Table[\(EpsilonOfTfile[\([k]\)]\)[\([2]\)], {k, \ 
            Length[EpsilonOfTfile]}];\)\[IndentingNewLine]
    \(noframes\  = \ Length[EpsilonOfTfile];\)\)\)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[EpsilonOfT, PlotJoined \[Rule] True, \ 
        PlotRange \[Rule] All, \ Axes \[Rule] False, \ Frame \[Rule] True, \ 
        PlotStyle \[Rule] {\ RGBColor[0.2, 0. , 0.5]}];\)\)], "Input"],

Cell[BoxData[
    \(<< Graphics`Graphics`\)], "Input"],

Cell[BoxData[
    \(<< Statistics`DescriptiveStatistics`\)], "Input"],

Cell[BoxData[
    \(\(Histogram[EpsilonOfT, \ Frame \[Rule] True];\)\)], "Input"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\( (*\ \ mean\ and\ \
variance\ of\ epsilon \((t)\)\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(meanEps\  = \ 
      Sum[EpsilonOfT[\([k]\)], {k, noframes}]/noframes\)], "Input"],

Cell[BoxData[
    \(varianceEps = \ 
      Sqrt[\ \((Sum[\ \((EpsilonOfT[\([k]\)] - meanEps)\)^2, {k, 
                noframes}])\)/noframes]\)], "Input"]
},
FrontEndVersion->"4.2 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{784, 896},
WindowMargins->{{Automatic, 135}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 454, 8, 107, "Input"],
Cell[2211, 61, 214, 3, 43, "Input"],
Cell[2428, 66, 684, 11, 187, "Input"],
Cell[3115, 79, 219, 3, 43, "Input"],
Cell[3337, 84, 54, 1, 27, "Input"],
Cell[3394, 87, 69, 1, 27, "Input"],
Cell[3466, 90, 81, 1, 27, "Input"],
Cell[3550, 93, 141, 2, 59, "Input"],
Cell[3694, 97, 102, 2, 27, "Input"],
Cell[3799, 101, 155, 3, 27, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

