(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7060,        213]*)
(*NotebookOutlinePosition[      7716,        236]*)
(*  CellTagsIndexPosition[      7672,        232]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Mathematica Noteook for Calculating Rate of Excitation Transfer between two \
BChls\
\>", "Title"],

Cell["\<\
NOTE: To execute a group of command lines, click anywhere within a cell \
covered by a blue bracket on the right which has a semi-arrow, press and hold \
the Shift key and then press Enter. \
\>", "Subtitle"],

Cell[CellGroupData[{

Cell["\<\
STEP 1: Define constants used in this calculation and Load a package called \
\"VectorAnalysis\".\
\>", "Section"],

Cell[BoxData[{
    \(\(const := \ 505644;\)\  (*\ 
      unit\ is\ angstrom\ cube\ per\ cm\ *) \), "\[IndentingNewLine]", 
    \(\(hbar := 6.582*10\^\(-16\)*8065.82*10\^12;\)\ \  (*\ 
      equal\ to\ 5.3089\ ps\ per\ cm\ *) \), "\[IndentingNewLine]", 
    \(\(J := 10.5*10\^\(-4\);\)\ \  (*\ 
      Unit\ in\ cm\ *) \), "\[IndentingNewLine]", 
    \(\(J1 := \ 2.785*10\^\(-4\);\)\), "\[IndentingNewLine]", 
    \(\(J2 := 6.295*10\^\(-10\);\)\), "\[IndentingNewLine]", 
    \(<< Calculus`VectorAnalysis`\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
STEP 2: Compute the directional vector d1 of the transition dipole moment  of \
the BChl B850a in segment BCA1.  \
\>", "Section"],

Cell[BoxData[{
    \(\(rNB1\  = \ {xNB1, \ yNB1, \ zNB1};\)\), "\[IndentingNewLine]", 
    \(\(rND1\  = \ {xND1, \ yND1, \ zND1};\)\), "\[IndentingNewLine]", 
    \(\(D1\  = \ rND1 - rNB1;\)\), "\[IndentingNewLine]", 
    \(\(D1sq = DotProduct[D1, D1];\)\), "\[IndentingNewLine]", 
    \(d1 = D1/Sqrt[D1sq]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
STEP 3: Compute the directional vector d3 of the transition dipole moment of \
the BChl B850a in segment BCA2. \
\>", "Section"],

Cell[BoxData[{
    \(\(rNB3 = {xNB3, \ yNB3, \ zNB3};\)\), "\[IndentingNewLine]", 
    \(\(rND3 = {XND3, \ yND3, \ zND3};\)\), "\[IndentingNewLine]", 
    \(\(D3\  = \ rND3 - rNB3;\)\), "\[IndentingNewLine]", 
    \(\(D3sq = DotProduct[D3, D3];\)\), "\[IndentingNewLine]", 
    \(d3 = D3/Sqrt[D3sq]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
STEP 4: Compute the separation distance L13 between the two central Mg2+ ions \
of the two BChls B850a in segments BCA1 and BCA2. \
\>", "Section"],

Cell[BoxData[{
    \(\(rMG1 = {xMG1, \ yMG1, \ zMG1};\)\), "\[IndentingNewLine]", 
    \(\(rMG3 = {xMG3, \ yMG3, \ zMG3};\)\), "\[IndentingNewLine]", 
    \(\(R13 = rMG1 - rMG3;\)\), "\[IndentingNewLine]", 
    \(\(R13sq = DotProduct[R13, R13];\)\), "\[IndentingNewLine]", 
    \(L13 = Sqrt[R13sq]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
STEP 5: Calculate the directional vector of the relative position vector r13 \
between the two Mg2+ ions\
\>", "Section"],

Cell[BoxData[
    \(r13 = R13/L13\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
STEP 6: Calculate the induced dipole-induced dipole interaction term U13 \
\>", "Section"],

Cell[BoxData[{
    \(\(d1d3 = DotProduct[d1, d3];\)\), "\[IndentingNewLine]", 
    \(\(d1r13 = DotProduct[d1, r13];\)\), "\[IndentingNewLine]", 
    \(\(d3r13 = DotProduct[d3, r13];\)\), "\[IndentingNewLine]", 
    \(U13 = 
      const*\(\(\((d1d3 - 3*d1r13*d3r13)\)/L13\^3\)\(\ \ \ \)\( (*\ 
          Unit\ in\ per\ cm\ *) \)\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
STEP 7: Calculate the excitation transfer rate k13 between two nearest BChls \
B850a \
\>", "Section"],

Cell[BoxData[
    \(k13 = \(\(\(2*
              Pi\)\/hbar\)\(*\)\(U13\^2\)\(*\)\(J\)\(\ \ \ \ \ \ \ \ \)\( (*\ 
          Unit\ is\ per\ ps\ *) \)\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
STEP 8: Calculate the forward rate kf of excitation transfer from BChl B800 \
(Segment BCA1)  to BChl B850a (segment BCA1)\
\>", "Section"],

Cell[BoxData[{
    \(\(sNB1\  = \ {27.736, \(-11.012\), \ 
          89.716};\)\), "\[IndentingNewLine]", 
    \(\(sND1\  = \ {24.434, \(-13.149\), \ 
          90.602};\)\), "\[IndentingNewLine]", 
    \(\(Ds1\  = \ sND1 - sNB1;\)\), "\[IndentingNewLine]", 
    \(\(Ds1sq = DotProduct[Ds1, Ds1];\)\), "\[IndentingNewLine]", 
    \(\(ds1 = Ds1/Sqrt[Ds1sq];\)\), "\[IndentingNewLine]", 
    \(\(\(sMG1 = {26.069, \(-12.126\), \ 90.141};\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(Rs11 = sMG1 - rMG1;\)\), "\[IndentingNewLine]", 
    \(\(Rs11sq = DotProduct[Rs11, Rs11];\)\), "\[IndentingNewLine]", 
    \(\(Ls11 = Sqrt[Rs11sq];\)\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(\(rs11 = Rs11/Ls11;\)\), "\[IndentingNewLine]", 
    \(\(ds1d1 = DotProduct[ds1, d1];\)\), "\[IndentingNewLine]", 
    \(\(ds1rs11 = DotProduct[ds1, rs11];\)\), "\[IndentingNewLine]", 
    \(\(d1rs11 = DotProduct[d1, rs11];\)\), "\[IndentingNewLine]", 
    \(\(Us11 = 
        const*\((ds1d1 - 3*ds1rs11*d1rs11)\)/
            Ls11\^3;\)\), "\[IndentingNewLine]", 
    \(kf = \(\(\(2*
              Pi\)\/hbar\)\(*\)\(Us11\^2\)\(*\)\(J1\)\(\ \ \ \ \ \)\( (*\ 
          Unit\ is\ per\ ps\ *) \)\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
STEP 9: Compute the backward rate kb of excitation transfer from BChl B850a \
(segment BCA1)  to B800 (segment BCA1)\
\>", "Section"],

Cell[BoxData[
    \(kb = \(\(\(2*
              Pi\)\/hbar\)\(*\)\(Us11\^2\)\(*\)\(J2\)\(\ \ \ \ \ \)\( (*\ 
          Unit\ is\ per\ ps\ *) \)\)\)], "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.2 for X",
ScreenRectangle->{{0, 2560}, {0, 1024}},
WindowToolbars->"EditBar",
WindowSize->{1268, 996},
WindowMargins->{{Automatic, 0}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 108, 3, 168, "Title"],
Cell[1887, 58, 218, 4, 93, "Subtitle"],

Cell[CellGroupData[{
Cell[2130, 66, 124, 3, 58, "Section"],
Cell[2257, 71, 517, 9, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2811, 85, 140, 3, 58, "Section"],
Cell[2954, 90, 320, 5, 91, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3311, 100, 138, 3, 58, "Section"],
Cell[3452, 105, 312, 5, 91, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3801, 115, 157, 3, 58, "Section"],
Cell[3961, 120, 311, 5, 91, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4309, 130, 131, 3, 58, "Section"],
Cell[4443, 135, 46, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4526, 141, 100, 2, 58, "Section"],
Cell[4629, 145, 343, 6, 80, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5009, 156, 112, 3, 58, "Section"],
Cell[5124, 161, 163, 3, 45, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5324, 169, 149, 3, 58, "Section"],
Cell[5476, 174, 1215, 22, 308, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6728, 201, 143, 3, 58, "Section"],
Cell[6874, 206, 158, 3, 45, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

