/**
***  Copyright (c) 1995, 1996, 1997, 1998, 1999, 2000 by
***  The Board of Trustees of the University of Illinois.
***  All rights reserved.
**/

/*
   Compute object which deals with a single patch.
*/

#include "charm++.h"
#include "WorkDistrib.decl.h"
#include "Node.h"
#include "ComputePatch.h"
#include "PatchMap.inl"
#include "Patch.h"

#define MIN_DEBUG_LEVEL 4
//#define DEBUGM
#include "Debug.h"

ComputePatch::ComputePatch(ComputeID c, PatchID p) : Compute(c) {
    setNumPatches(1);
    patchID = p;
    patch = NULL;
    positionBox = NULL;
    forceBox = NULL;
}

ComputePatch::~ComputePatch() {
  DebugM(4, "~ComputePatch("<<cid<<") numAtoms("<<patchID<<") = " 
    << numAtoms << "\n");
    if (positionBox != NULL) {
      PatchMap::Object()->patch(patchID)->unregisterPositionPickup(cid,
	 &positionBox);
    }
    if (forceBox != NULL) {
      PatchMap::Object()->patch(patchID)->unregisterForceDeposit(cid,
		&forceBox);
    }
}

void ComputePatch::initialize() {
    // How can we tell if BoxOwner has packed up and left?  Need a mechanism
    // to handle this or do we assume the Boxes have been dumped?

	if (positionBox == NULL) { // We have yet to get boxes
	    if (!(patch = PatchMap::Object()->patch(patchID))) {
	      NAMD_bug("ComputePatch used with unknown patch.");
	    }
	    DebugM(3, "initialize(" << cid <<")  patchid = "<<patch->getPatchID()<<"\n");
	    positionBox = patch->registerPositionPickup(cid);
	    forceBox = patch->registerForceDeposit(cid);
	}
	numAtoms = patch->getNumAtoms();

  DebugM(3, "initialize("<<cid<<") numAtoms("<<patchID<<") = " 
    << numAtoms  << " patchAddr=" << patch << "\n");
    Compute::initialize();

    int myNode = CkMyPe();
    if ( PatchMap::Object()->node(patchID) != myNode )
    {
      basePriority = 64 + patchID % 64;
    }
    else
    {
      basePriority = 2 * 64 + (patchID % 64);
    }
}

void ComputePatch::atomUpdate() {
    // How can we tell if BoxOwner has packed up and left?  Need a mechanism
    // to handle this or do we assume the Boxes have been dumped?
    numAtoms = patch->getNumAtoms();
}

void ComputePatch::doWork() {
  CompAtom* p;
  Results* r;
  int numData;

  DebugM(3,patchID << ": doWork() called.\n");

  // Open up positionBox, forceBox
  p = positionBox->open(&numData);
  if (numData != numAtoms) {
    NAMD_bug("doWork has opened a position box with wrong # atoms.");
  }
  r = forceBox->open();

  // Pass pointers to doForce
  doForce(p,r);

  // Close up boxes
  positionBox->close(&p);
  forceBox->close(&r);

  DebugM(2,patchID << ": doWork() completed.\n");
}

