/**
***  Copyright (c) 1995, 1996, 1997, 1998, 1999, 2000 by
***  The Board of Trustees of the University of Illinois.
***  All rights reserved.
**/

#include "ComputeEField.h"
#include "Node.h"
#include "SimParameters.h"
#include "HomePatch.h"


ComputeEField::ComputeEField(ComputeID c, PatchID pid)
  : ComputeHomePatch(c,pid)
{

	reduction = ReductionMgr::Object()->willSubmit(REDUCTIONS_BASIC);

}
/*			END OF FUNCTION ComputeEField		*/


ComputeEField::~ComputeEField()

{
	delete reduction;
}
/*			END OF FUNCTION ~ComputeEField		*/


void ComputeEField::doForce(FullAtom* p, Results* r) {

  SimParameters *simParams = Node::Object()->simParameters;
  Vector eField = simParams->eField;

  Force *forces = r->f[Results::normal];
  BigReal energy = 0;
  Force extForce = 0.;
  Tensor extVirial;

  //  Loop through and check each atom
  for (int i=0; i<numAtoms; i++) {
    Force force = p[i].charge * eField;
    forces[i] += force;
    extForce += force;
    Position vpos = homePatch->lattice.reverse_transform(
		p[i].position, p[i].transform );
    energy -= force * (vpos - homePatch->lattice.origin());
    extVirial += outer(force,vpos);
  }

  reduction->item(REDUCTION_MISC_ENERGY) += energy;
  ADD_VECTOR_OBJECT(reduction,REDUCTION_EXT_FORCE_NORMAL,extForce);
  ADD_TENSOR_OBJECT(reduction,REDUCTION_VIRIAL_NORMAL,extVirial);
  reduction->submit();

}
/*			END OF FUNCTION force				*/
