package projector.language;


import projector.core.*;
import projector.gui.*;
import java.util.Vector;
import java.awt.*;
import java.awt.event.*;
/*************
	Written by Sayantan Chakravorty
	October 2002
	This class is used to do language specific interpretations of EventObject Data and
	for Intervals etc
*********/


public class CharmInterpreter extends Interpreter{
	public boolean isBeginType(EventObject Obj){
		if(Obj.language == 2 && Obj.eventType == EventType._E_BEGIN_PROCESSING)
			return true;
		else
			return false;
	}
	public boolean isEndType(EventObject Obj){
		if(Obj.language == 2 && Obj.eventType == EventType._E_END_PROCESSING)
			return true;
		else
			return false;
	}

	public TimelineObject [] createTLO(Vector intervalVect,int pnum,TimelineData data){
		int numIntervals = intervalVect.size();
		Interval intervalElement;
		long btime, etime, rtime;
	  	int entry, pSrc, numMsgs, numpacks, msglen;
	  	int EventID;
          	ObjectId tid;
		CharmEventObject ceObjstart,ceObjend;

		TimelineObject [] tlo = new TimelineObject[numIntervals];
		for(int i=0;i<numIntervals;i++){
			intervalElement = (Interval )intervalVect.elementAt(i);
			btime = (long )(intervalElement.startTime*1000000.0);
			etime = (long )(intervalElement.endTime * 1000000.0);
			try{
			   if(intervalElement.beginObj != null){
				ceObjstart = new CharmEventObject (intervalElement.beginObj);
				ceObjstart.parseIData(ceObjstart.iData);
				ceObjend = new CharmEventObject (intervalElement.endObj);
				ceObjend.parseIData(ceObjend.iData);
				//System.out.println("Object EventID " + ceObjstart.eventID + " of type " + ceObjstart.entry);
				entry = ceObjstart.entry;
		 		pSrc  = ceObjstart.pe;
		 		msglen  = ceObjstart.msgLen;
				// all fields of TimelineObject are not traced at present by Projector
 		 		tid   =  new ObjectId();
		 		rtime = 0;
		 		EventID = ceObjstart.eventID;
				
				//The first traversal is used to count the number of messages and packs
				
			   }else{
			   	entry = 0;
				pSrc = pnum;
				msglen = -1;
				tid = new ObjectId();
				rtime = 0;
				EventID = -1;
			   }
				numMsgs = 0;
				numpacks = 0;
				for(int j=0;j<intervalElement.eventVector.size();j++){
					GeneralEventObject eventObj = (GeneralEventObject )intervalElement.eventVector.elementAt(j);
					if(eventObj.eventType == EventType._E_CREATION){
						numMsgs++;
					}
					if(eventObj.eventType == EventType._E_BEGIN_PACK){
						numpacks++;
					}
				}

				TimelineMessage[] msgs = new TimelineMessage[numMsgs];
				PackTime[] packs = new PackTime[numpacks];
				int countMsgs=0,countPacks=0;
	  			PackTime          PT          = null;
				TimelineMessage  TM = null;
				for(int j=0;j<intervalElement.eventVector.size();j++){
					GeneralEventObject eventObj = (GeneralEventObject )intervalElement.eventVector.elementAt(j);
					CharmEventObject charmEventObj = new CharmEventObject(eventObj);
					charmEventObj.parseIData(eventObj.iData);
					if(charmEventObj.eventType == EventType._E_CREATION){
						msgs[countMsgs] = (TM=new TimelineMessage((long )(charmEventObj.timestamp*1000000.0),charmEventObj.entry,charmEventObj.msgLen,charmEventObj.eventID));
						//System.out.println("TimelineMessage Time " + TM.Time+"Event time " + charmEventObj.timestamp);
						countMsgs++;
					}
					if(charmEventObj.eventType == EventType._E_BEGIN_PACK){
						PT = new PackTime((long )(charmEventObj.timestamp*1000000.0));
						packs[countPacks] = PT;
					}
					if(charmEventObj.eventType == EventType._E_END_PACK){
						if(PT != null){
							PT.EndTime =(long )(charmEventObj.timestamp*1000000.0);
							countPacks++;
						}
					}

				}

				tlo[i] = new TimelineObject(data, btime, etime, entry, msgs, packs, pnum, pSrc, msglen, rtime, tid,EventID,this);

			}catch(Exception e){
				System.out.println("Exception due to parseIData");
				e.printStackTrace();
			}
		}
		return tlo;
	}

	public String[] getBubbleText(TimelineObject t){
		String [] bubbletext;
		if(t.entry != -1)
	  	{
		 	bubbletext  = new String[10];
	  	        int ecount = Analysis.getUserEntryCount();
			if (t.entry >= ecount) {
			   System.out.println("Fatal error: invalid entry "+t.entry+"!");
			   System.exit(1) ;
			}
			bubbletext[0] = (Analysis.getUserEntryNames())[t.entry][1] + "::" + 
					  (Analysis.getUserEntryNames())[t.entry][0]; 
			bubbletext[1] = "Msg Len: " + t.msglen;
			bubbletext[2] = "Begin Time: " + t.format_.format(t.beginTime);
			bubbletext[3] = "End Time: " + t.format_.format(t.endTime);
			bubbletext[4] = "Total Time: " + U.t(t.endTime-t.beginTime);
			bubbletext[5] = "Packing: " + U.t(t.packtime);
		 	if (t.packtime>0)
				bubbletext[4]+=" (" + (100*(float)t.packtime/(t.endTime-t.beginTime+1)) + "%)";
			bubbletext[6] = "Msgs created: " + t.messages.length;
			bubbletext[7] = "Created by processor " + t.pCreation;
			bubbletext[8] = "Id: " + t.tid.id[0]+":"+ t.tid.id[1]+":"+t.tid.id[2];
			bubbletext[9] = "Recv Time: " + t.recvTime;
	  }
	  else
	  {
		 	bubbletext = new String[4];
		 	bubbletext[0] = "IDLE TIME";
		 	bubbletext[1] = "Begin Time: " + t.format_.format(t.beginTime);
		 	bubbletext[2] = "End Time: " + t.format_.format(t.endTime);
		 	bubbletext[3] = "Total Time: " + U.t(t.endTime-t.beginTime);
	  }
	  return bubbletext;
	}

	
	
	public void handleTimelineClick(TimelineObject t,MouseEvent evt){
		if(t.entry >= 0){
       		if(evt.getModifiers()==MouseEvent.BUTTON1_MASK){
			 t.OpenMessageWindow();
		}else{	
			
			if(t.creationLine<2){
			 	if(t.data.mesgVector[t.pCreation] == null || t.data.mesgVector[t.pCreation].isEmpty()){
			 	 }else{
				 	if(t.creationLine == 0)
					 	t.created_message= t.searchMesg(t.data.mesgVector[t.pCreation],t.EventID);
					if(t.created_message != null){
						t.data.drawConnectingLine(t.pCreation,t.created_message.Time,t.pCurrent,t.beginTime,t.h,t.startY,t.creationLine);			
						t.creationLine = 2;
					}
		 		}
				
			}else{
				t.data.drawConnectingLine(t.pCreation,t.created_message.Time,t.pCurrent,t.beginTime,t.h,t.startY,t.creationLine);
				t.creationLine = 1;
			}
			
		}	
		 
               }
       }
	
	
}
