package projector.language;


import projector.core.*;
import projector.gui.*;
import java.util.Vector;
import java.awt.*;
import java.awt.event.*;

/*************
	Written by Sayantan Chakravorty
	October 2002
	This class is used to do language specific interpretations of EventObject Data and
	for Intervals etc
*********/

public class AmpiInterpreter extends Interpreter{
	int count = 0;
	public boolean isBeginType(EventObject obj){
		count++;
		if(obj.language == 4 && obj.eventType == EventType._E_BEGIN_AMPI_PROCESSING && count != 1)
			return true;
		else
			return false;
	}
	
	public boolean isEndType(EventObject obj){
		if(obj.language == 4 && obj.eventType == EventType._E_END_AMPI_PROCESSING)
			return true;
		else
			return false;
	}
	
	public TimelineObject [] createTLO(Vector intervalVect,int pnum,TimelineData data){
		int numIntervals = intervalVect.size();
		Interval intervalElement;
		long btime, etime, rtime;
	  	int tag, pSrc, numMsgs, numpacks, msglen;
	  	int EventID;
          	ObjectId tid;
		AmpiEventObject aeObjstart,aeObjend;
		
		tid = new ObjectId(); // not used by ampi will have to be removed later  meaningless in ampi .. is preserved to avoid rewriting constructor for TimelineObject 
		
		TimelineObject [] tlo = new TimelineObject[numIntervals];
		for(int i=0;i<numIntervals;i++){
			intervalElement = (Interval )intervalVect.elementAt(i);
			btime = (long )(intervalElement.startTime*1000000.0);
			etime = (long )(intervalElement.endTime * 1000000.0);
			try{
			  if(intervalElement.beginObj != null){
				aeObjstart = new AmpiEventObject (intervalElement.beginObj);
				aeObjstart.parseIData(aeObjstart.iData);
				aeObjend = new AmpiEventObject (intervalElement.endObj);
				aeObjend.parseIData(aeObjend.iData);
				//System.out.println("Object EventID " + ceObjstart.eventID + " of type " + ceObjstart.entry);
				tag = aeObjstart.tag;
		 		pSrc  = aeObjstart.src;
		 		//msglen  = ceObjstart.msgLen;
				msglen = -1;
				// all fields of TimelineObject are not traced at present by Projector
 		 		
		 		rtime = 0;
		 		EventID = -1; // no sense for ampi 
			  }else{
			  	tag = 0;
				pSrc = pnum;
				msglen = -1;
				rtime = 0;
				EventID = -1;
			  }
				
				//The first traversal is used to count the number of messages
				
				numMsgs = 0;
				numpacks = 0;
				for(int j=0;j<intervalElement.eventVector.size();j++){
					GeneralEventObject eventObj = (GeneralEventObject )intervalElement.eventVector.elementAt(j);
					if(eventObj.eventType == EventType._E_AMPI_MSG_SEND){
						numMsgs++;
					}					
				}

				TimelineMessage[] msgs = new TimelineMessage[numMsgs];
				PackTime[] packs = new PackTime[numpacks];
				int countMsgs=0,countPacks=0;
	  			PackTime          PT          = null;
				TimelineMessage  TM = null;
				for(int j=0;j<intervalElement.eventVector.size();j++){
					GeneralEventObject eventObj = (GeneralEventObject )intervalElement.eventVector.elementAt(j);
					AmpiEventObject ampiEventObj = new AmpiEventObject(eventObj);
					ampiEventObj.parseIData(eventObj.iData);
					if(ampiEventObj.eventType == EventType._E_AMPI_MSG_SEND){
						msgs[countMsgs] = (TM=new TimelineMessage((long )(ampiEventObj.timestamp*1000000.0),ampiEventObj.tag,ampiEventObj.size,-1));
						//System.out.println("TimelineMessage Time " + TM.Time+"Event time " + charmEventObj.timestamp);
						countMsgs++;
					}
					

				}

				tlo[i] = new TimelineObject(data, btime, etime, tag, msgs, packs, pnum, pSrc, msglen, rtime, tid,EventID,this);

			}catch(Exception e){
				System.out.println("Exception due to parseIData");
				e.printStackTrace();
			}
		}
		return tlo;
	}
	
	public String[] getBubbleText(TimelineObject t){
		String [] bubbletext = new String [6];
		bubbletext[0] = "Tag :" + t.entry;
		bubbletext[1] = "Begin Time: " + t.format_.format(t.beginTime);
		bubbletext[2] = "End Time: " + t.format_.format(t.endTime);
		bubbletext[3] = "Total Time: " + U.t(t.endTime-t.beginTime);
		bubbletext[4] = "Msgs created: " + t.messages.length;
		bubbletext[5] = "Created by processor " + t.pCreation;
		return bubbletext;
	}
	
	public void handleTimelineClick(TimelineObject t,MouseEvent evt){
		if(t.entry >= 0){
       		if(evt.getModifiers()==MouseEvent.BUTTON1_MASK){
			 t.OpenMessageWindow();
		}
		}
	}	
}	
