package projector.core;


import projector.gui.*;
import projector.language.*;

import java.io.*;
import java.util.*;

public class IntervalGenerator {
	public int maxLang;
	public int pe;
	// for reading projector logs
	TraceReader tReader;
	// Object of any language .
	GeneralEventObject geObj1,geObj2;
	//Array for Interpreters;
	Interpreter [] interpreters;
	String fileName;
	String [] languageNames;
	Interval [] currentInterval;
	Vector[] intervals;

	public IntervalGenerator(String fileName,int pe){
		this.pe = pe;
		this.fileName = fileName;
		tReader = null;
		try{
			tReader = new TraceReader(fileName,"");


		}catch(Exception e){
			System.out.println("Problems with Opening Tracereader");
			System.exit(0);
		}
		maxLang = tReader.getMaxLangs();
		languageNames = tReader.getLanguageNames();
		interpreters = new Interpreter[tReader.getMaxLangs()+1];
		interpreters[1] = new ConverseInterpreter();
	  	interpreters[2] = new CharmInterpreter();
	  	interpreters[3] = new MachineInterpreter();
		interpreters[4] = new AmpiInterpreter();
		currentInterval = new Interval[tReader.getMaxLangs()];
	}

	public Vector [] getIntervals(double bt,double et){
		boolean teof;
		intervals=null;
	
		System.out.println("Beginning Time  " + bt+"EndTime " + et);
		try{
		intervals = new Vector[maxLang];
		
		for(int i=0;i<maxLang;i++){
			intervals[i] = new Vector();
			currentInterval[i] = null;
		}
		geObj1 = new GeneralEventObject();
	  	geObj2 = new GeneralEventObject();
		geObj1.proc = pe;
		geObj2.proc = pe;
		geObj1.language = 1;
		geObj2.language = 1;
		tReader = new TraceReader(fileName,"");
		teof = !tReader.nextGlobalEvent(geObj2,bt);

		Stack beginStack = new Stack();
		Stack beginTimeStack = new Stack();
		Stack intervalStack = new Stack();
		double nextBeginTime=-1,prevEndTime=0;
		Interval current_interval=null;
		Interval push_interval;
		while(!teof){
			//System.out.println("event "+geObj2.language+" " + geObj2.eventType+" " + geObj2.timestamp);
			teof = !tReader.nextGlobalEvent(geObj2);
			if(interpreters[geObj2.language].isBeginType(geObj2)){

				/*if(beginStack.empty()){
					prevEndTime = geObj2.timestamp;
				}else{
					double tempbeginTime = ((Double )beginTimeStack.pop()).doubleValue();
					tempbeginTime += geObj2.timestamp - prevEndTime;
					beginTimeStack.push(new Double(tempbeginTime));
					if(geObj2.timestamp > prevEndTime){
						prevEndTime = geObj2.timestamp;
					}
				}
				beginTimeStack.push(new Double(0));
				GeneralEventObject stackgeObj = geObj2.clone(1);*/
				
				current_interval = new Interval(pe,geObj2.timestamp,geObj2.language);
				current_interval.beginObj = geObj2.clone(1);

				//intervalStack.push(current_interval);
				//beginStack.push(stackgeObj);
				currentInterval[current_interval.language] = current_interval;
			}else{
				if(interpreters[geObj2.language].isEndType(geObj2)){
					/*if(!beginStack.empty()){
						geObj1 = (GeneralEventObject )beginStack.pop();
						push_interval = (Interval )intervalStack.pop();

						if(geObj1.language == geObj2.language){
							double execTime = ((Double )beginTimeStack.pop()).doubleValue();
							execTime += geObj2.timestamp - prevEndTime;
							prevEndTime = geObj2.timestamp;
							push_interval.endTime = geObj2.timestamp;
							push_interval.executionTime = execTime;
							push_interval.endObj = geObj2.clone(1);
							if(!intervalStack.empty())
								current_interval = (Interval )intervalStack.peek();
							else
								current_interval = null;
							intervals[push_interval.language].add(push_interval);
							currentInterval[push_interval.language] = null;
						}
						else{
							beginStack.push(geObj1);
							intervalStack.push(push_interval);
							System.out.println("Languages of END and BEGIN events don't match in proc "+pe);
							System.out.println("Begin Object " + geObj1.timestamp+" " + geObj1.language+" "+geObj1.eventType);
							System.out.println("End Object " + geObj2.timestamp+" " + geObj2.language+" "+geObj2.eventType);
						}

					}*/
					push_interval = (Interval )currentInterval[geObj2.language];
					if(push_interval != null){
						push_interval.endTime = geObj2.timestamp;
						push_interval.executionTime = geObj2.timestamp - push_interval.startTime;
						push_interval.endObj = geObj2.clone(1);
						intervals[push_interval.language].add(push_interval);
						currentInterval[push_interval.language] = null; 
					}
					
				}else{

					if(current_interval != null)
						if(current_interval.language == geObj2.language){
							current_interval.eventVector.add(geObj2.clone(1));
						}else{
							if(currentInterval[geObj2.language]!= null){
								currentInterval[geObj2.language].eventVector.add(geObj2.clone(1));
							}else{
								/**Events outside any interval .. create dummy interval and just add to correct language in intervals array**/
								Interval dummy_interval = new Interval(pe,geObj2.timestamp,geObj2.language);
								dummy_interval.beginObj = null;
								dummy_interval.endTime = geObj2.timestamp;
								dummy_interval.executionTime = 0.0;
								dummy_interval.endObj = null;
								dummy_interval.eventVector.add(geObj2.clone(1));
								intervals[geObj2.language].add(dummy_interval);
							}

						/*	System.out.println("Event appears to be out of scope in Language "+current_interval.language);
							System.out.println("Event Language " + geObj2.language+" Type "+geObj2.eventType);*/
						}
				}
			}
			if(teof || geObj2.timestamp > et){
				break;
			}	
		}
		tReader.close();
		}catch(Exception e){
			System.out.println("Exception in intervalgenerator \n"+e);
			e.printStackTrace();
		}

		return 	intervals;
		
	}
	

};
