/*****************************************************************************
 * $Source: /cvsroot/charm/src/xlat-i/sdag/CEntry.h,v $
 * $Author: louchios $
 * $Date: 2003/05/07 18:46:27 $
 * $Revision: 1.6 $
 *****************************************************************************/

#ifndef _CEntry_H_
#define _CEntry_H_

#include "xi-util.h"
#include "sdag-globals.h"
#include "CList.h"
#include "CStateVar.h"

class SdagConstruct;
class ParamList;

class CEntry{
  public:
    XStr *entry;
    //CParseNode *paramlist;
    ParamList *paramlist;
    int entryNum;
    int needsParamMarshalling;
    int refNumNeeded;
    TList<CStateVar*> *myParameters;
    //TList<CParseNode*> whenList;
    TList<SdagConstruct*> whenList;
    CEntry(XStr *e, ParamList *p, TList<CStateVar*>& list, int pm) : entry(e), paramlist(p), needsParamMarshalling(pm) {
       myParameters = new TList<CStateVar*>();
       CStateVar *sv;
       for(sv=list.begin(); !list.end(); sv=list.next()) {
	  myParameters->append(sv);
       }
       entryNum = numEntries++;
       refNumNeeded =0;
    }

    void print(int indent) {
      Indent(indent);
//      printf("entry %s (%s *)", entry->charstar(), msgType->charstar());
    } 

    void generateCode(XStr& op);
    void generateDeps(XStr& op);
};
#endif
