/* Declaration of the class that represents the results of the simulation process
 * $Source: /cvsroot/charm/src/ck-ldb/LBSimulation.h,v $
 * $Author: gzheng $
 * $Date: 2003/04/27 17:51:20 $
 * $Revision: 1.2 $
 */
#ifndef SIMRESULTS_H
#define SIMRESULTS_H

#include <charm++.h>
#include "CentralLB.h"

class CentralLB;

class LBSimulation
{
public:
  static int doSimulation;
  static char* dumpFile;
  static int dumpStep;
  static int simProcs;
public:
  LBSimulation(int numPes_);
  ~LBSimulation();
  void SetProcessorLoad(int pe, double load, double bgload);
  void PrintSimulationResults();
private:
  double* peLoads;
  double* bgLoads;
  double  minObjLoad, maxObjLoad;
  int numPes;
  friend class CentralLB;   // so that we don't have to provide little get/put functions
};

#endif /* SIMRESULTS_H */
