/*
** client.c -- client for the scheduler
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <netdb.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <signal.h>
#include <fcntl.h>
#include <pwd.h>
#include <sys/poll.h>

//#define USE_UNIX

#ifdef USE_UNIX
#include<sys/un.h>
#define UNIX_PATH_MAX 108
#else
#include <netinet/in.h>
#endif

#include <mysql/mysql.h>

#ifndef strnlen
#define strnlen(s, n) strlen(s)
#endif

int PORT;   /* the port client will be connecting to */

#define MAX_COMMAND_NAME_SIZE 8
#define MAXDATASIZE 1024 /* max number of bytes we can get at once */
#define MAXARGSIZE 256

extern int errno;

void handler(int);
void handler_int(int);
int jobid;

int uid;

char RESERVEDWORDS[9][MAXARGSIZE] = {"mpirun", "charmrun", "conv-host", "-p4pg", "-np", "-machinefile", "++nodelist", ""};


void usage(){
    printf("usage: client host_name port command_type command_name [<options>] [<args>]\n");
    printf("command_type: command/job\n");
    printf("command_type 'command'\nBasic Commands :\nListjobs, to list the jobs currently unfinished in the system, no arguments passed\n");
    printf("Kill, to kill a job running or queued, takes Job ID as argument\n\n");
    printf("command_type 'job'\nTakes <job name> <[options]> <[arguments]>\n");
    printf("Basic Options\n-stdout <filename>: The Std. Output file of the job\n");
    printf("-stderr <filename>: The Std. Error file of the job\n");
    printf("-stdin <filename>: The Std. Input file of the job\n");
    printf("-type [mpi/charm/mcharm/uni]: The type of the job\n");
    printf("-pwd <directory name>: Process Working Directory\n");
    printf("-minpe <value> : minimum number of processors used by the job\n");
    printf("-maxpe <value> : maximum number of processors used by the job\n");
    printf("#Processors allocated to the job varies between these bounds\n");
    printf("-time <hh:mm:ss> : time requested for the job\n");
    exit(1);
}

void reserved_word_check(char *arg){
    char *rword;
    int count = 0;

    rword =  RESERVEDWORDS[0];
    while(strcmp(rword, "")){
        if(strncmp(arg, rword, strlen(rword)) == 0){
            printf("Reserved Words (%s) cannot used in the name or arguments of the job submitted\n", rword);
            exit(0);
        }
        rword =  RESERVEDWORDS[++count];
    }
}

int main(int argc, char **argv)
{
    int sockfd, numbytes;
    char buf[MAXDATASIZE + 64];
    char tmpbuf[64];
    struct hostent *he;
    int maxlen = 0;
    struct passwd *cur_passwd;
    char str[MAXDATASIZE];
    int status, argcount;
    struct pollfd pfd[2];
    int nargs = 0;
    int nproc = 0;
    int nodes = 0;
    int ppn = 0;

    int return_job_id = 0;
    //    int jobid = 0;
    int exitCode = 0;
    char *jobidptr;
    FILE *fp;

    MYSQL mysql;
    char query[MAXDATASIZE];
    MYSQL_RES *res;
    MYSQL_ROW row;

#ifdef USE_UNIX
    struct sockaddr_un their_addr; /* connector's address information */
#else
    struct sockaddr_in their_addr; /* connector's address information */
#endif

    /* SIGPIPE is received if the socket stream connection is broken.*/
    signal(SIGPIPE,handler);
    signal(SIGINT,handler_int);

    if (argc < 5) {
        usage();
        exit(1);
    }
    
    if ((he=gethostbyname(argv[1])) == NULL) {  /* get the host info */
        perror("gethostbyname");
        exit(1);
    }

    /* Prepare and send the command line to the scheduler.*/
    //    str = (char*)malloc(MAXDATASIZE);
    
    /*argv[0] = client, argv[1] = scheduler_host, argv[2] = port/filename
      argv[3] = (command/job), argv[4].... command/job info */
    
    /*Client server protocol, 
      <command/job>:<username>:command/job name and arguments*/

    strcpy(buf, "");
    strcpy(str, "");

    maxlen = MAXDATASIZE - 24 - 2; /*24 for header, 2 for \n\0*/
    for(argcount = 4; argcount < argc; argcount++){

        if(strnlen(argv[argcount], MAXARGSIZE) >= MAXARGSIZE - 1){
            printf("Argument '%s' is too long, please try again\n", 
                   argv[argcount]);
            exit(0);
        }
        
        reserved_word_check(argv[argcount]);

        if(strncmp(argv[argcount], "+ppn", 4) == 0){
	    if(!ppn)
		ppn = atoi(argv[argcount] + 4);
            //printf("PPN = %d\n", ppn);
            continue;
        }

        if(strncmp(argv[argcount], "+p", 2) == 0){
	    if(!nproc)
		nproc = atoi(argv[argcount] + 2);
            //printf("NPROC = %d, %s\n", nproc, argv[argcount]);
            continue;
        }

        if(strncmp(argv[argcount], "+n", 2) == 0){
	    if(!nodes)
		nodes = atoi(argv[argcount] + 2);
            continue;
        }
        
        /*
          if((strcmp(argv[argcount], "++return-jobid") == 0) ||
          (strcmp(argv[argcount], "-return-jobid") == 0)){
          return_job_id = 1;
          continue;
          }
        */
        
        if(maxlen <= 2){
            printf("Too Many Arguments, Try Again\n");
	    exit(0);
	}
        
	strncat(buf, argv[argcount], maxlen);
	maxlen -= strlen(argv[argcount]);
	strncat(buf, " ", maxlen);
	maxlen --;
        
        nargs ++;
    }
    
    if(nproc > 0) {
        nargs += 4;
        sprintf(tmpbuf, "-maxpe %d -minpe %d ", nproc, nproc);
        strcat(buf, tmpbuf);
    }

    if(nodes > 0) {
        nargs += 4;
        sprintf(tmpbuf, "-maxnodes %d -minnodes %d ", nodes, nodes);
        strcat(buf, tmpbuf);
    }

    if(ppn > 0) {
        nargs += 2;
        sprintf(tmpbuf, "-ppn %d ", ppn);
        strcat(buf, tmpbuf);
    }

    cur_passwd = getpwuid(getuid());
    
    snprintf(str, MAXDATASIZE, "%s:%s:%d %s", argv[3], cur_passwd->pw_name, 
             nargs, buf);

    str[strnlen(str, MAXDATASIZE - 2)] = '\n';
    str[strnlen(str, MAXDATASIZE - 2) + 1] = '\0';
    
    //    printf("%s\n", str);

    /* Establish Socket Connection and send command */

    uid = getuid();
    setuid(geteuid());

    PORT = atoi(argv[2]);
#ifdef USE_UNIX
    if ((sockfd = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
	perror("socket");
	exit(1);
    }
    
    their_addr.sun_family = AF_UNIX;         /* host byte order */
    snprintf(their_addr.sun_path, UNIX_PATH_MAX, "/tmp/scheduler.%d", PORT);
    
    /*    printf("Connecting to %s\n", their_addr.sun_path);
	  printf("Connecting to Scheduler\n"); */

    if (connect(sockfd, (struct sockaddr *)&their_addr,
		strlen(their_addr.sun_path) + sizeof(short)) == -1) {
        perror("connect");
        exit(1);
    }
#else
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
        perror("socket");
        exit(1);
    }

    their_addr.sin_family = AF_INET;         /* host byte order */
    their_addr.sin_port = htons(PORT);     /* short, network byte order */
    their_addr.sin_addr = *((struct in_addr *)he->h_addr);
    bzero(&(their_addr.sin_zero), 8);        /* zero the rest of the struct */
    if (connect(sockfd, (struct sockaddr *)&their_addr,
		sizeof(struct sockaddr)) == -1) {
        perror("connect");
        exit(1);
    }
#endif

    write(sockfd, str, strnlen(str, MAXDATASIZE));
    errno = 0;
    
    if(strcmp(argv[3], "job") == 0){
        
        strcpy(buf, "");

        fp = fdopen(sockfd, "r");
        jobidptr = fgets(buf, 256, fp);
        
        if(jobidptr != NULL)
            jobid = atoi(jobidptr);
        
        if(jobid != 0)
            printf("Successfully Queuing Job, Job id is \n%d\n", jobid);
        else if(jobidptr != NULL)
            printf("%s\n", jobidptr);
        else printf("Error Submitting Job\n");
    }

    /* Print to STDOUT everything that we get from the other side.*/
    while(1){
	pfd[0].fd = 0;
	pfd[0].events = POLLIN;
	pfd[0].revents = 0;
	pfd[1].fd = sockfd;
	pfd[1].events = POLLIN;
	pfd[1].revents = 0;

	poll(pfd, 2, 1000);

	if(pfd[0].revents){
	    numbytes = read(0, buf, MAXDATASIZE);
	    /*	    printf("Poll Succeded, reading %d bytes\n", numbytes); */
	    if (numbytes <= 0)
		break;
	    numbytes = write(sockfd, buf, numbytes);
	    /* printf("Writing %d bytes\n", numbytes); */
	}
	
	if(pfd[1].revents){
	    numbytes = read(sockfd, buf, MAXDATASIZE);
	    if (numbytes <= 0)
		break;
	    write(1, buf, numbytes);
	}
    }
    
    close(sockfd);
    
    /*
    if((argc > 3) && (return_job_id) && (strcmp(argv[3], "job") == 0))
        return jobid;
    */

    if((argc > 3) && (strcmp(argv[3], "job") == 0) && (jobid > 0)){
        //        printf("Contacting database\n");
        mysql_init(&mysql);
        if(mysql_real_connect(&mysql, "cool2.cs.uiuc.edu", "skumar2", "test", "faucets", 0, NULL, 0) == NULL)
            return 0;
        
        //mysql_select_db(&mysql, "debug");
        
        snprintf(query, MAXDATASIZE, 
                 "select exitCode from jobInfo where id = %d", jobid);

        if(mysql_query(&mysql, query))
            exitCode = -1;
                
        if (!(res = mysql_store_result(&mysql)))
            exitCode = -1;
        
        if (!(row = mysql_fetch_row(res))){
            mysql_free_result(res);
            exitCode = -1;
        }
        
        if(row[0] != NULL)
            exitCode = atoi(row[0]);
        else exitCode = -1;
        
        mysql_free_result(res);        
        mysql_close(&mysql);

        //printf("Returning %d for %d\n", exitCode, jobid);

        if(exitCode == -1){
            //  printf("Failed to access Database\n");
        }

        return exitCode;
    }

    return 0;
}

void  handler(int id){
    printf("SIGPIPE Received\n");
    exit(0);
}

void handler_int(int id) {
    char command[256];
    fprintf(stderr, "Killing job %d\n", jobid);

    setuid(uid);
    if(jobid != 0) {
        sprintf(command, "fkill %d\n", jobid);
	//fprintf(stderr, command);
        system(command);
    }
    exit(0);
}
