#include "ComlibManager.h" //Call this before all other includes!
#include "StreamingStrategy.h"
#include <stdio.h>
#include "hello.decl.h"

/*readonly*/ CkGroupID dmid; 
/*readonly*/ CProxy_Main mainProxy;
/*readonly*/ int nElements;

/*mainchare*/
class Main : public Chare
{
  double startTime;
public:
  Main(CkArgMsg* m)
  {
    //Process command-line arguments
    nElements=5;
    if(m->argc >1 ) nElements=atoi(m->argv[1]);
    delete m;

    //Start the computation
    CkPrintf("Running Hello on %d processors for %d elements\n",
	     CkNumPes(),nElements);
    mainProxy = thishandle;

    Strategy *strat=new StreamingStrategy(10,10);
    dmid = CProxy_ComlibManager::ckNew(strat); 
    //Will be explained later
    CProxy_ComlibManager(dmid).ckLocalBranch()->createId();

    CProxy_Hello arr = CProxy_Hello::ckNew(nElements);
    
    startTime=CkWallTimer();
    CkPrintf("Starting ring...\n");
    arr[0].SayHi(17);
  };

  void done(void)
  {
    CkPrintf("All done: %d elements in %f seconds\n", nElements,
    	CkWallTimer()-startTime);
    CkExit();
  };
};

/*array [1D]*/
class Hello : public CBase_Hello 
{
public:
  Hello()
  {
    // CkPrintf("Hello %d created\n",thisIndex);

    //Registers the array element with the communications framework
    (CProxy_ComlibManager(dmid).ckLocalBranch())->localElement();
  }

  Hello(CkMigrateMessage *m) {}
  
  void SayHi(int hiNo)
  {
    // CkPrintf("Hi[%d] from element %d\n",hiNo,thisIndex);
    CProxy_Hello array_proxy=thisProxy;
    ComlibManager *cm=CProxy_ComlibManager(dmid).ckLocalBranch();
    array_proxy.ckDelegate(cm);
    
    cm->beginIteration();

    if (thisIndex < nElements-1)
      //Pass the hello on:
      array_proxy[thisIndex+1].SayHi(hiNo+1);
    else 
      //We've been around once-- we're done.
      mainProxy.done();
    
    cm->endIteration();
  }
};

#include "hello.def.h"
