#include <stdio.h>
#include "ampi.h"

extern "C"
int MPI_Main(int argc,char **argv)
{
	MPI_Init(&argc,&argv);
	double inval,outval;
	int rank,size;
	MPI_Print("Driver called");
	MPI_Comm_rank(MPI_COMM_WORLD, &rank);
	MPI_Comm_size(MPI_COMM_WORLD, &size);
	inval = rank+1;
	for (int i=0;i<argc;i++) printf("Argv[%d]='%s'\n",i,argv[i]);
	MPI_Reduce(&inval, &outval, 1, MPI_DOUBLE, MPI_SUM, 
                     0, MPI_COMM_WORLD);
	int expect = (size*(size+1))/2;
	if(rank == 0) {
	  if (outval == expect) 
  	    MPI_Print("reduce test passed");
  	  else {
  	    MPI_Print("reduce test failed");
	    return 1;
          }
	}
	MPI_Finalize();
	return 0;
}
