#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mpi.h>

int main(int argc, char* argv[]){
  int nStep,NSTEPS;
  int szData;
  double *data;
  double starttime,endtime,durtime;

  int thisIndex,worldSize;
  MPI_Status sts;

  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD,&thisIndex);
  MPI_Comm_size(MPI_COMM_WORLD,&worldSize);

  //initialization
  szData=16;
  if(argc>1) szData=atoi(argv[1]);
  data = new double [szData];
  NSTEPS=40;
  
  if(thisIndex==0) 
    starttime=MPI_Wtime();

  for(nStep=0; nStep<NSTEPS; nStep++){
    MPI_Send(data,16,MPI_DOUBLE,(thisIndex+1)%2,0,MPI_COMM_WORLD);
    MPI_Recv(data,16,MPI_DOUBLE,(thisIndex+1)%2,0,MPI_COMM_WORLD,&sts);
  }

  if(thisIndex == 0){
    endtime = MPI_Wtime();
    durtime = endtime - starttime;
    printf("DONE! Step = %d, time = %lf sec.\n", nStep, durtime/nStep);
  }
  
  MPI_Barrier(MPI_COMM_WORLD);
 
  delete [] data;
  MPI_Finalize();
  return 0;
}

