/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

import java.io.IOException;
import projections.analysis.GenericSummaryReader;
import projections.analysis.StsReader;
import projections.gui.Analysis;
import projections.misc.ProjectionsStatistics;

public class MultiRunData {
    private StsReader[] stsReaders;
    private GenericSummaryReader[][] sumReaders;
    private double[][][] dataTable;
    public static final int NUM_TYPES = 4;
    public static final int TYPE_TIME = 0;
    public static final int TYPE_TIMES_CALLED = 1;
    public static final int TYPE_NUM_MSG_SENT = 2;
    public static final int TYPE_SIZE_MSG = 3;
    private static final String[] typeNames = new String[]{"Execution Time", "Num Msgs Received", "Num Msgs Sent", "Msg Size"};
    private double[] runWallTimes;
    private int numRuns;
    private int numEPs;
    private String[] epNames;
    private String[] runNames;
    private ProjectionsStatistics timeStats = new ProjectionsStatistics();
    private ProjectionsStatistics numCallsStats = new ProjectionsStatistics();

    public MultiRunData(String[] stringArray) throws IOException {
        try {
            int n;
            int n2;
            this.numRuns = stringArray.length;
            if (this.numRuns == 0) {
                throw new IOException("MultiRunData cannot be initialized with zero runs!");
            }
            this.stsReaders = new StsReader[this.numRuns];
            this.sumReaders = new GenericSummaryReader[this.numRuns][];
            int n3 = 0;
            while (n3 < this.numRuns) {
                this.stsReaders[n3] = new StsReader(stringArray[n3]);
                n2 = this.stsReaders[n3].getProcessorCount();
                this.sumReaders[n3] = new GenericSummaryReader[n2];
                n = 0;
                while (n < n2) {
                    this.sumReaders[n3][n] = new GenericSummaryReader(this.getSumFilename(stringArray[n3], n), Analysis.getVersion());
                    ++n;
                }
                ++n3;
            }
            this.numEPs = this.stsReaders[0].getEntryCount();
            this.epNames = new String[this.numEPs];
            n2 = 0;
            while (n2 < this.numEPs) {
                this.epNames[n2] = this.stsReaders[0].getEntryNames()[n2][0];
                ++n2;
            }
            this.runNames = new String[this.numRuns];
            n = 0;
            while (n < this.numRuns) {
                this.runNames[n] = "(" + this.stsReaders[n].getProcessorCount() + ")" + "[" + this.stsReaders[n].getMachineName() + "]";
                ++n;
            }
            this.computeBaseInformation();
        }
        catch (IOException iOException) {
            throw new IOException("MultiRun data read failed: 13" + iOException);
        }
    }

    private String getSumFilename(String string, int n) {
        String string2 = string.substring(0, string.lastIndexOf(46));
        if (string2.substring(string2.lastIndexOf(46), string2.length()).equals(".sum")) {
            return string2.substring(0, string2.lastIndexOf(46)) + "." + n + ".sum";
        }
        return string2 + "." + n + ".sum";
    }

    private void computeBaseInformation() {
        int n;
        int n2;
        this.dataTable = new double[4][this.numRuns][this.numEPs];
        int n3 = 0;
        while (n3 < this.numRuns) {
            n2 = 0;
            while (n2 < this.numEPs) {
                this.timeStats.reset();
                this.numCallsStats.reset();
                n = 0;
                while (n < this.stsReaders[n3].getProcessorCount()) {
                    this.timeStats.accumulate(this.sumReaders[n3][n].epData[n2][0]);
                    this.numCallsStats.accumulate(this.sumReaders[n3][n].epData[n2][1]);
                    ++n;
                }
                this.dataTable[0][n3][n2] = this.timeStats.getSum();
                this.dataTable[1][n3][n2] = this.numCallsStats.getSum();
                ++n2;
            }
            ++n3;
        }
        this.runWallTimes = new double[this.numRuns];
        n2 = 0;
        while (n2 < this.numRuns) {
            this.timeStats.reset();
            n = 0;
            while (n < this.stsReaders[n2].getProcessorCount()) {
                this.timeStats.accumulate((double)this.sumReaders[n2][n].numIntervals * (this.sumReaders[n2][n].intervalSize * 1000000.0));
                ++n;
            }
            this.runWallTimes[n2] = this.timeStats.getSum();
            ++n2;
        }
    }

    public int getNumEPs() {
        return this.numEPs;
    }

    public int getNumRuns() {
        return this.numRuns;
    }

    public double[][] getData(int n) {
        return this.dataTable[n];
    }

    public double[][][] getData() {
        return this.dataTable;
    }

    public double[] getEPData(int n, int n2) {
        return this.dataTable[n][n2];
    }

    public double[] getRunData(int n, int n2) {
        double[] dArray = new double[this.numRuns];
        int n3 = 0;
        while (n3 < this.numRuns) {
            dArray[n3] = this.dataTable[n][n3][n2];
            ++n3;
        }
        return dArray;
    }

    public double[] getRunWallTimes() {
        return this.runWallTimes;
    }

    public String[] getEPNames() {
        return this.epNames;
    }

    public String[] getRunNames() {
        return this.runNames;
    }

    public static String getTypeName(int n) {
        return typeNames[n];
    }
}

