/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import projections.gui.Bubble;
import projections.gui.Util;
import projections.gui.graph.DataSource;
import projections.gui.graph.DataSource2D;
import projections.gui.graph.XAxis;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxis;
import projections.gui.graph.YAxisAuto;

public class Graph
extends JPanel
implements MouseMotionListener {
    public static final int STACKED = 0;
    public static final int UNSTACKED = 1;
    public static final int AREA = 2;
    public static final int SINGLE = 3;
    public static final int BAR = 4;
    public static final int LINE = 5;
    private int GraphType;
    private int BarGraphType;
    private DataSource dataSource;
    private XAxis xAxis;
    private YAxis yAxis;
    private int originX;
    private int originY;
    private double xscale;
    private static final int FONT_SIZE = 12;
    private static final Color BACKGROUND = Color.black;
    private static final Color FOREGROUND = Color.white;
    private static final double PI = 3.142;
    private Font font = null;
    private FontMetrics fm = null;
    private Color labelColor;
    private JLabel yLabel;
    private int w;
    private int h;
    private int tickincrementX;
    private int tickincrementY;
    double pixelincrementX;
    double pixelincrementY;
    private double[][] stackArray;
    private int maxSumY;
    private int barWidth;
    private int width;
    private int baseWidth;
    private boolean fitToScreen = false;
    private Bubble bubble;

    public Graph() {
        this.setPreferredSize(new Dimension(400, 300));
        this.baseWidth = this.getSize().width;
        this.GraphType = 4;
        this.BarGraphType = 0;
        this.labelColor = FOREGROUND;
        this.stackArray = null;
        this.dataSource = null;
        this.xscale = 1.0;
        this.addMouseMotionListener(this);
    }

    public Graph(DataSource dataSource, XAxis xAxis, YAxis yAxis) {
        this();
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.dataSource = dataSource;
        this.createStackArray();
    }

    public Dimension getMinimumSize() {
        return new Dimension(400, 300);
    }

    public void setGraphType(int n) {
        if (n == 5 || n == 4) {
            this.GraphType = n;
            this.repaint();
        } else if (n == 2) {
            this.GraphType = n;
            this.repaint();
        }
    }

    public int getGraphType() {
        return this.GraphType;
    }

    public void setBarGraphType(int n) {
        if (n == 0 || n == 1 || n == 3) {
            this.BarGraphType = n;
        }
        this.repaint();
    }

    private String getBarGraphType() {
        if (this.BarGraphType == 3) {
            return "avg";
        }
        if (this.BarGraphType == 1) {
            return "unstacked";
        }
        return "stacked";
    }

    public void setData(DataSource dataSource, XAxis xAxis, YAxis yAxis) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.dataSource = dataSource;
        this.createStackArray();
        this.repaint();
    }

    public void setData(DataSource dataSource) {
        this.dataSource = dataSource;
        this.createStackArray();
        this.repaint();
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
        this.repaint();
    }

    public void setScale(double d) {
        this.xscale = d;
        this.repaint();
    }

    private void createStackArray() {
        if (this.dataSource != null) {
            double d = 0.0;
            int n = this.dataSource.getValueCount();
            this.stackArray = new double[this.dataSource.getIndexCount()][];
            int n2 = 0;
            while (n2 < this.dataSource.getIndexCount()) {
                this.stackArray[n2] = new double[n];
                this.dataSource.getValues(n2, this.stackArray[n2]);
                int n3 = 1;
                while (n3 < n) {
                    double[] dArray = this.stackArray[n2];
                    int n4 = n3;
                    dArray[n4] = dArray[n4] + this.stackArray[n2][n3 - 1];
                    ++n3;
                }
                if (d < this.stackArray[n2][n - 1]) {
                    d = this.stackArray[n2][n - 1];
                }
                ++n2;
            }
            this.maxSumY = (int)Math.ceil(d);
        } else {
            this.stackArray = null;
        }
    }

    private int getXValue(int n) {
        if (n > this.originX && n < this.width + this.originX) {
            int n2 = this.dataSource.getIndexCount();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.originX + (int)((double)n3 * this.pixelincrementX) + (int)(this.pixelincrementX / 2.0);
                if (n > n4 - this.barWidth / 2 && n < n4 + this.barWidth / 2) {
                    return n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    private int getYValue(int n, int n2) {
        if (n >= 0 && n2 < this.originY && n2 > 30 && this.stackArray != null) {
            int n3 = this.dataSource.getValueCount();
            int n4 = 0;
            while (n4 < n3) {
                int n5 = (int)((double)this.originY - (double)((int)this.stackArray[n][n4]) * this.pixelincrementY);
                if (n2 > n5) {
                    return n4;
                }
                ++n4;
            }
        }
        return -1;
    }

    public void paint(Graphics graphics) {
        if (this.font == null) {
            this.font = new Font("Times New Roman", 1, 12);
            graphics.setFont(this.font);
            this.fm = graphics.getFontMetrics(this.font);
        }
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        this.drawDisplay(graphics);
    }

    public void print(Graphics graphics) {
        if (this.font == null) {
            this.font = new Font("Times New Roman", 1, 12);
            graphics.setFont(this.font);
            this.fm = graphics.getFontMetrics(this.font);
        }
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.drawDisplay(graphics);
        this.setBackground(BACKGROUND);
        this.setForeground(FOREGROUND);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.getXValue(n);
        int n4 = this.getYValue(n3, n2);
        if (n3 > -1 && n4 > -1) {
            this.showPopup(n3, n4, n, n2);
        } else if (this.bubble != null) {
            this.bubble.setVisible(false);
            this.bubble.dispose();
            this.bubble = null;
        }
    }

    public void showPopup(int n, int n2, int n3, int n4) {
        String[] stringArray = this.dataSource.getPopup(n, n2);
        if (stringArray == null) {
            return;
        }
        if (this.bubble == null) {
            if (this.BarGraphType == 0) {
                this.bubble = new Bubble(this, stringArray);
                ((Component)this.bubble).setLocation(n3 + 20, n4 + 20);
                this.bubble.setVisible(true);
                System.out.println(n3 + ", " + n4);
            } else {
                System.out.println("not Stacked");
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    private void drawDisplay(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setBackground(BACKGROUND);
        graphics2D.setColor(FOREGROUND);
        graphics2D.clearRect(0, 0, this.w, this.h);
        if (this.xAxis != null && this.yAxis != null) {
            this.drawAxes(graphics2D);
            if (this.GraphType == 4) {
                this.drawBarGraph(graphics2D);
            } else if (this.GraphType == 2) {
                this.drawAreaGraph(graphics2D);
            } else {
                this.drawLineGraph(graphics2D);
            }
        }
    }

    private void drawAxes(Graphics2D graphics2D) {
        String string;
        String string2 = this.yAxis.getTitle();
        String string3 = "";
        int n = 0;
        while (n < string2.length()) {
            string3 = string3 + string2.charAt(n) + "\n";
            ++n;
        }
        this.yLabel = new JLabel(string3);
        double d = this.GraphType == 4 && this.BarGraphType == 0 || this.GraphType == 2 ? (double)this.maxSumY : this.yAxis.getMax();
        this.originX = this.fm.getHeight() * 2 + this.fm.stringWidth(String.valueOf(d));
        this.originY = this.h - (30 + this.fm.getHeight() * 2);
        graphics2D.setColor(this.labelColor);
        String string4 = this.xAxis.getTitle();
        graphics2D.drawString(string4, (this.w - this.fm.stringWidth(string4)) / 2, this.h - 10);
        string4 = this.dataSource.getTitle();
        graphics2D.drawString(string4, (this.w - this.fm.stringWidth(string4)) / 2, 10 + this.fm.getHeight());
        string4 = this.yAxis.getTitle();
        graphics2D.rotate(-1.571);
        graphics2D.drawString(string4, -(this.h + this.fm.stringWidth(string4)) / 2, this.fm.getHeight());
        graphics2D.rotate(1.571);
        graphics2D.setColor(FOREGROUND);
        this.width = (int)((double)(this.baseWidth - 30 - this.originX) * this.xscale);
        int n2 = this.dataSource.getIndexCount();
        int n3 = this.fm.stringWidth("" + (double)n2 * this.xAxis.getMultiplier());
        if (this.fitToScreen) {
            this.tickincrementX = (int)Math.ceil(5.0 / ((double)this.width / (double)n2));
            this.tickincrementX = Util.getBestIncrement(this.tickincrementX);
        } else {
            this.tickincrementX = 1;
        }
        int n4 = (int)Math.ceil((double)n2 / (double)this.tickincrementX);
        this.pixelincrementX = (double)this.width / (double)n4;
        if (this.pixelincrementX < 4.0) {
            this.pixelincrementX = 4.0;
        }
        if (this.width < (int)(this.pixelincrementX * (double)n4)) {
            System.out.println("resize needed");
            this.width = (int)(this.pixelincrementX * (double)n4);
            this.baseWidth = (int)((double)this.width / this.xscale + 30.0 + (double)this.originX);
            this.w = this.width + 30 + this.originX;
            this.setPreferredSize(new Dimension(this.w, this.h));
        }
        int n5 = (int)Math.ceil((double)(n3 + 20) / this.pixelincrementX);
        n5 = Util.getBestIncrement(n5);
        graphics2D.drawLine(this.originX, this.originY, this.width + this.originX, this.originY);
        graphics2D.drawLine(this.originX, this.originY, this.originX, 30);
        int n6 = 0;
        int n7 = n2;
        if (n7 > n4) {
            n7 = n4;
        }
        int n8 = n6;
        while (n8 < n7) {
            int n9 = this.originX + (int)((double)n8 * this.pixelincrementX);
            n9 += (int)(this.pixelincrementX / 2.0);
            if (n8 % n5 == 0) {
                graphics2D.drawLine(n9, this.originY + 5, n9, this.originY - 5);
                string = "" + (int)this.xAxis.getIndex(n8);
                graphics2D.drawString(string, n9 - this.fm.stringWidth(string) / 2, this.originY + 10 + this.fm.getHeight());
            } else {
                graphics2D.drawLine(n9, this.originY + 2, n9, this.originY - 2);
            }
            ++n8;
        }
        d += 10.0 - d % 10.0;
        this.pixelincrementY = (double)(this.originY - 30) / d;
        n3 = this.fm.getHeight();
        int n10 = (int)Math.ceil((double)(n3 + 20) / this.pixelincrementY);
        int n11 = (n10 = Util.getBestIncrement(n10)) / 10;
        if (n11 < 1) {
            n11 = 1;
        }
        int n12 = 0;
        while ((double)n12 <= d) {
            int n13 = this.originY - (int)((double)n12 * this.pixelincrementY);
            if (n12 % n10 == 0) {
                graphics2D.drawLine(this.originX + 5, n13, this.originX - 5, n13);
                string = "" + n12;
                graphics2D.drawString(string, this.originX - this.fm.stringWidth(string) - 5, n13 + n3 / 2);
            } else {
                graphics2D.drawLine(this.originX + 2, n13, this.originX - 2, n13);
            }
            n12 += n11;
        }
    }

    private void drawBarGraph(Graphics2D graphics2D) {
        int n = this.dataSource.getIndexCount();
        int n2 = this.dataSource.getValueCount();
        double[] dArray = new double[n2];
        this.barWidth = this.pixelincrementX < 6.0 ? ((int)this.pixelincrementX % 2 == 0 ? (int)(this.pixelincrementX - 1.0) : (int)(this.pixelincrementX - 2.0)) : (int)(this.pixelincrementX * 0.75);
        int n3 = 0;
        while (n3 < n) {
            int n4;
            this.dataSource.getValues(n3, dArray);
            int n5 = this.originX + (int)((double)n3 * this.pixelincrementX) + (int)(this.pixelincrementX / 2.0);
            if (this.BarGraphType == 0) {
                int n6 = 0;
                n4 = 0;
                while (n4 < n2) {
                    n6 = this.originY - (int)(this.stackArray[n3][n4] * this.pixelincrementY);
                    graphics2D.setColor(this.dataSource.getColor(n4));
                    graphics2D.fillRect(n5 - this.barWidth / 2, n6, this.barWidth, (int)(dArray[n4] * this.pixelincrementY));
                    ++n4;
                }
            } else if (this.BarGraphType == 1) {
                int n7;
                int n8 = 0;
                n4 = 0;
                double d = 0.0;
                double[][] dArray2 = new double[n2][2];
                int n9 = 0;
                while (n9 < n2) {
                    dArray2[n9][0] = n9;
                    dArray2[n9][1] = dArray[n9];
                    ++n9;
                }
                int n10 = 0;
                while (n10 < n2) {
                    d = dArray2[n10][1];
                    n8 = n10;
                    n7 = n10;
                    while (n7 < n2) {
                        if (dArray2[n7][1] > d) {
                            n8 = n7;
                            d = dArray2[n7][1];
                        }
                        ++n7;
                    }
                    int n11 = (int)dArray2[n10][0];
                    double d2 = dArray2[n10][1];
                    dArray2[n10][0] = dArray2[n8][0];
                    dArray2[n10][1] = d;
                    dArray2[n8][0] = n11;
                    dArray2[n8][1] = d2;
                    ++n10;
                }
                n7 = 0;
                while (n7 < n2) {
                    graphics2D.setColor(this.dataSource.getColor((int)dArray2[n7][0]));
                    n4 = this.originY - (int)(dArray2[n7][1] * this.pixelincrementY);
                    graphics2D.fillRect(n5 - this.barWidth / 2, n4, this.barWidth, (int)(dArray2[n7][1] * this.pixelincrementY));
                    ++n7;
                }
            } else {
                double d = 0.0;
                int n12 = 0;
                int n13 = 0;
                while (n13 < n2) {
                    d += dArray[n13];
                    ++n13;
                }
                n12 = this.originY - (int)((d /= (double)n2) * this.pixelincrementY);
                graphics2D.fillRect(n5 - this.barWidth / 2, n12, this.barWidth, (int)(d * this.pixelincrementY));
            }
            ++n3;
        }
    }

    public void drawLineGraph(Graphics2D graphics2D) {
        int n = this.dataSource.getIndexCount();
        int n2 = this.dataSource.getValueCount();
        double[] dArray = new double[n2];
        int n3 = -1;
        int[] nArray = new int[n2];
        int n4 = 0;
        int[] nArray2 = new int[n2];
        int n5 = 0;
        while (n5 < n2) {
            nArray[n5] = -1;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n) {
            this.dataSource.getValues(n6, dArray);
            n4 = this.originX + (int)((double)n6 * this.pixelincrementX) + (int)(this.pixelincrementX / 2.0);
            int n7 = 0;
            while (n7 < n2) {
                graphics2D.setColor(this.dataSource.getColor(n7));
                nArray2[n7] = this.originY - (int)(dArray[n7] * this.pixelincrementY);
                if (n3 != -1) {
                    graphics2D.drawLine(n3, nArray[n7], n4, nArray2[n7]);
                }
                nArray[n7] = nArray2[n7];
                ++n7;
            }
            n3 = n4;
            ++n6;
        }
    }

    public void drawAreaGraph(Graphics2D graphics2D) {
        int n = this.dataSource.getIndexCount();
        int n2 = this.dataSource.getValueCount();
        double[] dArray = new double[n2];
        Polygon polygon = new Polygon();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            polygon = new Polygon();
            int n4 = 0;
            while (n4 < n) {
                this.dataSource.getValues(n4, dArray);
                int n5 = this.originX + (int)((double)n4 * this.pixelincrementX) + (int)(this.pixelincrementX / 2.0);
                this.prefixSum(dArray);
                int n6 = this.originY - (int)(dArray[n3] * this.pixelincrementY);
                if (n4 == 0) {
                    polygon.addPoint(n5, this.originY - 1);
                }
                polygon.addPoint(n5, n6);
                if (n4 == n - 1) {
                    polygon.addPoint(n5, this.originY - 1);
                }
                ++n4;
            }
            graphics2D.setColor(this.dataSource.getColor(n3));
            graphics2D.fill(polygon);
            graphics2D.setColor(Color.black);
            graphics2D.draw(polygon);
            --n3;
        }
    }

    private void prefixSum(double[] dArray) {
        int n = 0;
        while (n < dArray.length - 1) {
            dArray[n + 1] = dArray[n + 1] + dArray[n];
            ++n;
        }
    }

    private double findMaxOfSums() {
        double d = 0.0;
        int n = this.dataSource.getIndexCount();
        int n2 = this.dataSource.getValueCount();
        double[] dArray = new double[n2];
        int n3 = 0;
        while (n3 < n) {
            this.dataSource.getValues(n3, dArray);
            this.prefixSum(dArray);
            if (d < dArray[n2 - 1]) {
                d = dArray[n2 - 1];
            }
            ++n3;
        }
        return d;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        double[][] dArrayArray = new double[][]{{20.0, 21.0, 49.0, 3.0}, {25.0, 34.0, 8.0, 10.0}, {23.0, 20.0, 54.0, 3.0}, {20.0, 27.0, 4.0, 40.0}, {25.0, 21.0, 7.0, 4.0}, {20.0, 21.0, 8.0, 10.0}, {24.0, 26.0, 44.0, 4.0}, {22.0, 26.0, 20.0, 5.0}, {29.0, 29.0, 5.0, 20.0}, {20.0, 21.0, 8.0, 7.0}, {24.0, 20.0, 10.0, 3.0}, {21.0, 25.0, 6.0, 8.0}, {34.0, 23.0, 11.0, 11.0}, {20.0, 20.0, 20.0, 20.0}, {27.0, 25.0, 4.0, 5.0}, {21.0, 20.0, 5.0, 7.0}, {21.0, 24.0, 5.0, 8.0}, {26.0, 22.0, 5.0, 3.0}, {26.0, 29.0, 7.0, 10.0}, {29.0, 20.0, 8.0, 6.0}, {21.0, 24.0, 9.0, 4.0}};
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        DataSource2D dataSource2D = new DataSource2D("Histogram", dArrayArray);
        XAxisFixed xAxisFixed = new XAxisFixed("Entry Point Execution Time", "ms");
        YAxisAuto yAxisAuto = new YAxisAuto("Count", "", dataSource2D);
        Graph graph = new Graph();
        graph.setGraphType(2);
        graph.setData(dataSource2D, xAxisFixed, yAxisAuto);
        jPanel.add(graph);
        jFrame.getContentPane().add(jPanel);
        jFrame.pack();
        ((Component)jFrame).setSize(500, 400);
        jFrame.setTitle("Projections");
        ((Component)jFrame).setVisible(true);
    }
}

