/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import projections.gui.Analysis;
import projections.gui.GrayPanel;
import projections.gui.IntTextField;
import projections.gui.SelectField;
import projections.gui.TimeTextField;
import projections.gui.TimelineData;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.EntryNotFoundException;

public class TimelineRangeDialog
extends Dialog
implements ActionListener,
TextListener {
    private TimeTextField beginField;
    private TimeTextField endField;
    private TimeTextField lengthField;
    private SelectField processorField;
    private Checkbox colorbyObjectId;
    private long beginTime;
    private long endTime;
    private long totalTime;
    private long length;
    private IntTextField nField;
    private IntTextField pField;
    private TimelineData data;
    private List eList;
    private TextArea msgArea;
    private Button bOK;
    private Button bCancel;
    private Button bSearch;
    private Button bFullRange;

    public TimelineRangeDialog(Frame frame, TimelineData timelineData) {
        super(frame, "Select Timeline Ranges", true);
        this.data = timelineData;
        this.beginTime = timelineData.beginTime;
        this.endTime = timelineData.endTime;
        this.length = this.endTime - this.beginTime;
        this.totalTime = timelineData.totalTime;
        this.beginField = new TimeTextField(this.beginTime, 10);
        this.endField = new TimeTextField(this.endTime, 10);
        this.lengthField = new TimeTextField(this.length, 10);
        this.processorField = new SelectField(timelineData.processorString, 20);
        this.beginField.addActionListener(this);
        this.beginField.addTextListener(this);
        this.endField.addActionListener(this);
        this.endField.addTextListener(this);
        this.lengthField.addActionListener(this);
        this.lengthField.addTextListener(this);
        this.processorField.addActionListener(this);
        this.endField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getSource() instanceof TimeTextField && focusEvent.getSource() == TimelineRangeDialog.this.endField) {
                    TimelineRangeDialog.this.endTime = TimelineRangeDialog.this.endField.getValue();
                    if (TimelineRangeDialog.this.endTime <= TimelineRangeDialog.this.beginTime || TimelineRangeDialog.this.endTime > TimelineRangeDialog.this.totalTime) {
                        TimelineRangeDialog.this.endField.selectAll();
                        TimelineRangeDialog.this.endField.requestFocus();
                    }
                }
            }
        });
        this.bOK = new Button("OK");
        this.bOK.addActionListener(this);
        this.bCancel = new Button("Cancel");
        this.bCancel.addActionListener(this);
        this.bFullRange = new Button("Select Full Time Range");
        this.bFullRange.addActionListener(this);
        Label label = new Label("Processor(s): ");
        Label label2 = new Label("Begin Time: ");
        Label label3 = new Label("End Time: ");
        Label label4 = new Label("Length: ");
        Label label5 = new Label("-OR-", 1);
        Label label6 = new Label("-OR-", 1);
        Label label7 = new Label("Search for time (see below)");
        Label label8 = new Label("Valid times: 0 - " + U.t(this.totalTime), 1);
        Label label9 = new Label("Valid processors: 0 - " + (Analysis.getNumProcessors() - 1), 1);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GrayPanel grayPanel = new GrayPanel();
        grayPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        Util.gblAdd(grayPanel, label, gridBagConstraints, 0, 0, 1, 1, 1, 1, 8, 8, 4, 0);
        Util.gblAdd(grayPanel, this.processorField, gridBagConstraints, 1, 0, 4, 1, 1, 1, 8, 0, 4, 8);
        Util.gblAdd(grayPanel, label2, gridBagConstraints, 0, 1, 1, 1, 1, 1, 4, 8, 0, 0);
        Util.gblAdd(grayPanel, this.beginField, gridBagConstraints, 1, 1, 1, 1, 1, 1, 4, 0, 0, 4);
        Util.gblAdd(grayPanel, label5, gridBagConstraints, 2, 1, 1, 1, 1, 1, 4, 4, 0, 4);
        Util.gblAdd(grayPanel, label7, gridBagConstraints, 3, 1, 2, 1, 1, 1, 4, 4, 0, 8);
        Util.gblAdd(grayPanel, label3, gridBagConstraints, 0, 2, 1, 1, 1, 1, 0, 8, 4, 0);
        Util.gblAdd(grayPanel, this.endField, gridBagConstraints, 1, 2, 1, 1, 1, 1, 0, 0, 4, 4);
        Util.gblAdd(grayPanel, label6, gridBagConstraints, 2, 2, 1, 1, 1, 1, 0, 4, 4, 4);
        Util.gblAdd(grayPanel, label4, gridBagConstraints, 3, 2, 1, 1, 1, 1, 0, 4, 4, 0);
        Util.gblAdd(grayPanel, this.lengthField, gridBagConstraints, 4, 2, 1, 1, 1, 1, 0, 0, 4, 8);
        Util.gblAdd(grayPanel, label8, gridBagConstraints, 0, 3, 2, 1, 1, 1, 4, 8, 8, 4);
        Util.gblAdd(grayPanel, label9, gridBagConstraints, 2, 3, 3, 1, 1, 1, 4, 4, 8, 8);
        this.nField = new IntTextField(1, 5);
        this.pField = new IntTextField(0, 5);
        this.eList = new List(5, false);
        this.bSearch = new Button("Search for Begin Time");
        this.bSearch.addActionListener(this);
        this.nField.addActionListener(this);
        this.pField.addActionListener(this);
        this.eList.addActionListener(this);
        this.nField.addTextListener(this);
        this.pField.addTextListener(this);
        String[][] stringArray = Analysis.getEntryNames();
        int n = Analysis.getNumUserEntries();
        int n2 = 0;
        while (n2 < n) {
            this.eList.add(stringArray[n2][1] + " -- " + stringArray[n2][0]);
            ++n2;
        }
        this.eList.select(0);
        Label label10 = new Label("SEARCH FOR BEGIN TIME:");
        Label label11 = new Label("N: ", 2);
        Label label12 = new Label("Entry: ");
        Label label13 = new Label("Processor: ", 2);
        String string = "Search for begin time of Nth occurrence of entry E on processor P.";
        this.msgArea = new TextArea(string, 4, 40, 3);
        this.msgArea.setEditable(false);
        GrayPanel grayPanel2 = new GrayPanel();
        grayPanel2.setLayout(gridBagLayout);
        Util.gblAdd(grayPanel2, label10, gridBagConstraints, 0, 0, 4, 1, 1, 1, 8, 8, 2, 8);
        Util.gblAdd(grayPanel2, label11, gridBagConstraints, 0, 1, 1, 1, 0, 1, 2, 8, 2, 0);
        Util.gblAdd(grayPanel2, this.nField, gridBagConstraints, 1, 1, 1, 1, 1, 1, 2, 0, 2, 4);
        Util.gblAdd(grayPanel2, label13, gridBagConstraints, 2, 1, 1, 1, 0, 1, 2, 4, 2, 0);
        Util.gblAdd(grayPanel2, this.pField, gridBagConstraints, 3, 1, 1, 1, 1, 1, 2, 0, 2, 8);
        Util.gblAdd(grayPanel2, label12, gridBagConstraints, 0, 2, 4, 1, 1, 1, 2, 8, 0, 8);
        Util.gblAdd(grayPanel2, this.eList, gridBagConstraints, 0, 3, 4, 1, 1, 1, 0, 8, 2, 8);
        gridBagConstraints.fill = 0;
        Util.gblAdd(grayPanel2, this.bSearch, gridBagConstraints, 0, 4, 4, 1, 0, 1, 2, 8, 2, 8);
        gridBagConstraints.fill = 1;
        Util.gblAdd(grayPanel2, this.msgArea, gridBagConstraints, 0, 5, 4, 1, 1, 1, 2, 8, 8, 8);
        this.colorbyObjectId = new Checkbox("Color by Object Id ", false);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        panel.add(this.bFullRange);
        panel.add(this.bOK);
        panel.add(this.bCancel);
        panel.add(this.colorbyObjectId);
        Util.gblAdd(grayPanel, panel, gridBagConstraints, 0, 4, 5, 1, 1, 1, 0, 4, 4, 4);
        Panel panel2 = new Panel();
        panel2.setBackground(Color.gray);
        this.add("Center", panel2);
        panel2.setLayout(gridBagLayout);
        Util.gblAdd(panel2, grayPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1, 4, 4, 2, 4);
        Util.gblAdd(panel2, grayPanel2, gridBagConstraints, 0, 1, 1, 1, 1, 1, 2, 4, 4, 4);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button && (Button)object == this.bOK || object instanceof TimeTextField || object instanceof SelectField) {
            if (this.endTime > this.beginTime) {
                this.data.processorList = this.processorField.getValue(Analysis.getNumProcessors());
                this.data.processorString = this.data.processorList.listToString();
                this.data.numPs = this.data.processorList.size();
                this.data.beginTime = this.beginField.getValue();
                this.data.endTime = this.endField.getValue();
                this.data.timelineWindow.CloseRangeDialog();
                this.data.colorbyObjectId = this.colorbyObjectId.getState();
            } else {
                this.endField.selectAll();
                this.endField.requestFocus();
            }
        } else if (object instanceof Button && (Button)object == this.bCancel) {
            this.data.timelineWindow.CloseRangeDialog();
        } else if (object instanceof Button && (Button)object == this.bFullRange) {
            this.beginTime = 0L;
            this.endTime = this.totalTime;
            this.length = this.endTime - this.beginTime;
            this.beginField.setText("" + this.beginTime);
            this.endField.setText("" + this.endTime);
            this.lengthField.setText("" + this.length);
        } else if (object instanceof Button && (Button)object == this.bSearch) {
            int n = this.nField.getValue();
            int n2 = this.pField.getValue();
            int n3 = this.eList.getSelectedIndex();
            this.msgArea.setText("");
            if (n < 1) {
                this.msgArea.append("Invalid N value.  N > 0.\n");
            }
            if (n2 < 0 || n2 > Analysis.getNumProcessors() - 1) {
                this.msgArea.append("Invalid processor value.  0 <= P <= " + (Analysis.getNumProcessors() - 1) + "\n");
            }
            if (n3 < 0) {
                this.msgArea.append("Invalid entry selection. Select an entry.\n");
            }
            if (n >= 1 && n2 >= 0 && n2 < Analysis.getNumProcessors() && n3 >= 0) {
                long l;
                boolean bl = false;
                this.msgArea.setText("Searching...");
                try {
                    l = Analysis.searchTimeline(n, n2, n3);
                    bl = true;
                }
                catch (EntryNotFoundException entryNotFoundException) {
                    bl = false;
                    l = 0L;
                }
                this.msgArea.setText("");
                if (bl && l >= 0L) {
                    String string = "Begin Time = " + l + "\n";
                    this.msgArea.append(string);
                    string = " for Occurrence " + n + "\n";
                    this.msgArea.append(string);
                    string = " of Entry " + this.eList.getSelectedItem() + "\n";
                    this.msgArea.append(string);
                    string = " on Processor " + n2;
                    this.msgArea.append(string);
                    this.beginField.setText("" + l);
                } else {
                    String string = "Invalid N value.\n";
                    this.msgArea.append(string);
                    string = "Entry " + this.eList.getSelectedItem() + " occurs " + -l + " times on processor " + n2 + "\n";
                    this.msgArea.append(string);
                }
            }
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() instanceof TimeTextField) {
            TimeTextField timeTextField = (TimeTextField)textEvent.getSource();
            TimeTextField timeTextField2 = null;
            if (this.getFocusOwner() instanceof TimeTextField) {
                timeTextField2 = (TimeTextField)this.getFocusOwner();
            }
            if (timeTextField == this.beginField) {
                this.beginTime = this.beginField.getValue();
                if (this.beginTime > this.totalTime - 1L) {
                    int n = this.beginField.getCaretPosition();
                    this.beginTime = this.totalTime - 1L;
                    this.beginField.setText("" + this.beginTime);
                    this.beginField.setCaretPosition(n);
                }
                this.length = this.endTime - this.beginTime;
                if (this.length < 1L) {
                    this.length = 1L;
                    this.endTime = this.beginTime + this.length;
                }
                this.endField.setText("" + this.endTime);
                this.lengthField.setText("" + this.length);
            } else if (timeTextField == this.endField && timeTextField2 == this.endField) {
                this.endTime = this.endField.getValue();
                if (this.endTime > this.totalTime) {
                    int n = this.endField.getCaretPosition();
                    this.endTime = this.totalTime;
                    this.endField.setText("" + this.endTime);
                    this.endField.setCaretPosition(n);
                }
                this.length = this.endTime - this.beginTime;
                this.lengthField.setText("" + this.length);
            } else if (timeTextField == this.lengthField && timeTextField2 == this.lengthField) {
                this.length = this.lengthField.getValue();
                if (this.length < 1L) {
                    int n = this.lengthField.getCaretPosition();
                    this.length = 1L;
                    this.lengthField.setText("" + this.length);
                    this.lengthField.setCaretPosition(n);
                } else if (this.length > this.totalTime - this.beginTime) {
                    int n = this.lengthField.getCaretPosition();
                    this.length = this.totalTime - this.beginTime;
                    this.lengthField.setText("" + this.length);
                    this.lengthField.setCaretPosition(n);
                }
                this.endTime = this.beginTime + this.length;
                this.endField.setText("" + this.endTime);
            }
        } else if (textEvent.getSource() instanceof IntTextField) {
            IntTextField intTextField = (IntTextField)textEvent.getSource();
            if (intTextField == this.nField) {
                if (this.nField.getValue() < 1) {
                    int n = this.nField.getCaretPosition();
                    this.nField.setText("1");
                    this.nField.setCaretPosition(n);
                }
            } else if (intTextField == this.pField) {
                int n = this.pField.getValue();
                int n2 = Analysis.getNumProcessors() - 1;
                if (n < 0) {
                    int n3 = this.pField.getCaretPosition();
                    this.pField.setText("0");
                    this.pField.setCaretPosition(n3);
                } else if (n > n2) {
                    int n4 = this.pField.getCaretPosition();
                    this.pField.setText("" + n2);
                    this.pField.setCaretPosition(n4);
                }
            }
        }
    }
}

