/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import projections.gui.Analysis;
import projections.gui.ColorSelectable;
import projections.gui.EntrySelectionDialog;
import projections.gui.FloatTextField;
import projections.gui.MainWindow;
import projections.gui.PieChartWindow;
import projections.gui.ProfileAxisCanvas;
import projections.gui.ProfileColorWindow;
import projections.gui.ProfileData;
import projections.gui.ProfileDialog2;
import projections.gui.ProfileDisplayCanvas;
import projections.gui.ProfileLabelCanvas;
import projections.gui.ProfileObject;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.ProgressDialog;

public class ProfileWindow
extends Frame
implements ActionListener,
AdjustmentListener,
ColorSelectable {
    private static final int NUM_SYS_EPS = 3;
    private MainWindow mainWindow;
    private NoUpdatePanel mainPanel;
    private NoUpdatePanel displayPanel;
    private Panel labelCanvas2;
    private Panel titlePanel;
    private ProfileLabelCanvas labelCanvas;
    private ProfileAxisCanvas axisCanvas;
    private ProfileDisplayCanvas displayCanvas;
    private ProfileColorWindow colorWindow;
    private Label lTitle;
    private Label lTitle2;
    private Scrollbar HSB;
    private Scrollbar VSB;
    private ProfileData data;
    private FloatTextField xScaleField;
    private FloatTextField yScaleField;
    private Button bDecreaseX;
    private Button bIncreaseX;
    private Button bResetX;
    private Button bDecreaseY;
    private Button bIncreaseY;
    private Button bResetY;
    private Button bColors;
    private Button bPieChart;
    private boolean colorsSet = false;
    private Color[][] colors;
    private ProfileObject[][] poArray;
    private float xscale = 1.0f;
    private float yscale = 1.0f;
    private float[][] avg;
    private float thresh;
    private int avgSize;
    private ProfileDialog2 dialog;
    private PieChartWindow pieChartWindow;
    private EntrySelectionDialog entryDialog;

    public ProfileWindow(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProfileWindow.this.Close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (ProfileWindow.this.displayCanvas != null) {
                    ProfileWindow.this.setCursor(new Cursor(3));
                    ProfileWindow.this.setSizes();
                    ProfileWindow.this.setScales();
                    ProfileWindow.this.labelCanvas.makeNewImage();
                    ProfileWindow.this.axisCanvas.makeNewImage();
                    ProfileWindow.this.labelCanvas2.invalidate();
                    ProfileWindow.this.mainPanel.validate();
                    ProfileWindow.this.setCursor(new Cursor(0));
                }
            }
        });
        ((Component)this).setBackground(Color.lightGray);
        this.data = new ProfileData(this);
        this.setTitle("Projections Usage Profile");
        this.CreateMenus();
        this.CreateLayout();
        this.pack();
        ((Component)this).setVisible(true);
        this.ShowDialog();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Button) {
            this.setCursor(new Cursor(3));
            Button button = (Button)actionEvent.getSource();
            if (button == this.bDecreaseX || button == this.bIncreaseX || button == this.bResetX) {
                if (button == this.bDecreaseX) {
                    this.xscale = (float)((int)(this.xscale * 4.0f) - 1) / 4.0f;
                    if ((double)this.xscale < 1.0) {
                        this.xscale = 1.0f;
                    }
                } else if (button == this.bIncreaseX) {
                    this.xscale = (float)((int)(this.xscale * 4.0f) + 1) / 4.0f;
                } else if (button == this.bResetX) {
                    this.xscale = 1.0f;
                }
                this.xScaleField.setText("" + this.xscale);
                this.setScales();
                this.labelCanvas.makeNewImage();
            } else if (button == this.bDecreaseY || button == this.bIncreaseY || button == this.bResetY) {
                if (button == this.bDecreaseY) {
                    this.yscale = (float)((int)(this.yscale * 4.0f) - 1) / 4.0f;
                    if ((double)this.yscale < 1.0) {
                        this.yscale = 1.0f;
                    }
                } else if (button == this.bIncreaseY) {
                    this.yscale = (float)((int)(this.yscale * 4.0f) + 1) / 4.0f;
                } else if (button == this.bResetY) {
                    this.yscale = 1.0f;
                }
                this.yScaleField.setText("" + this.yscale);
                this.setScales();
                this.axisCanvas.makeNewImage();
            } else if (button == this.bPieChart) {
                this.pieChartWindow = new PieChartWindow(this.mainWindow, this.avg[0], this.avg[0].length, this.thresh, this.colors[0]);
            } else if (button == this.bColors) {
                int n = Analysis.getNumUserEntries();
                if (this.entryDialog == null) {
                    String[] stringArray = new String[]{"Entry Points"};
                    boolean[][] blArray = new boolean[1][n + 3];
                    int n2 = 0;
                    while (n2 < n + 3) {
                        blArray[0][n2] = true;
                        ++n2;
                    }
                    boolean[][] blArray2 = new boolean[1][n + 3];
                    int n3 = 0;
                    while (n3 < n + 3) {
                        blArray2[0][n3] = true;
                        ++n3;
                    }
                    String[] stringArray2 = new String[n + 3];
                    int n4 = 0;
                    while (n4 < n) {
                        stringArray2[n4] = Analysis.getEntryName(n4);
                        ++n4;
                    }
                    stringArray2[n] = "Pack Time";
                    stringArray2[n + 1] = "Unpack Time";
                    stringArray2[n + 2] = "Idle Time";
                    this.entryDialog = new EntrySelectionDialog(this, this, stringArray, blArray2, this.colors, blArray, stringArray2);
                }
                this.entryDialog.showDialog();
            }
            this.setCursor(new Cursor(0));
        } else if (actionEvent.getSource() instanceof MenuItem) {
            String string = ((MenuItem)actionEvent.getSource()).getLabel();
            if (string.equals("Close")) {
                this.Close();
            } else if (string.equals("Select Processors")) {
                this.ShowDialog();
            } else if (string.equals("Print Profile")) {
                this.PrintProfile();
            }
        } else if (actionEvent.getSource() instanceof FloatTextField) {
            this.setCursor(new Cursor(3));
            FloatTextField floatTextField = (FloatTextField)actionEvent.getSource();
            if (floatTextField == this.xScaleField) {
                this.xscale = this.xScaleField.getValue();
                this.setScales();
                this.labelCanvas.makeNewImage();
            } else if (floatTextField == this.yScaleField) {
                this.yscale = this.yScaleField.getValue();
                this.setScales();
                this.axisCanvas.makeNewImage();
            }
            this.setCursor(new Cursor(0));
        }
    }

    public void applyDialogColors() {
        this.MakePOArray(this.data.begintime, this.data.endtime);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Scrollbar scrollbar = (Scrollbar)adjustmentEvent.getSource();
        this.displayCanvas.setLocation(-this.HSB.getValue(), -this.VSB.getValue());
        if (scrollbar == this.HSB) {
            this.labelCanvas.repaint();
        } else if (scrollbar == this.VSB) {
            this.axisCanvas.repaint();
        }
    }

    public void CancelDialog() {
        ((Component)this.dialog).setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
    }

    private void Close() {
        ((Component)this).setVisible(false);
        this.mainWindow.closeChildWindow(this);
        this.dispose();
    }

    public void CloseDialog() {
        ((Component)this.dialog).setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
        new Thread(new Runnable(){

            public void run() {
                ProfileWindow.this.MakePOArray(((ProfileWindow)ProfileWindow.this).data.begintime, ((ProfileWindow)ProfileWindow.this).data.endtime);
            }
        }).start();
    }

    private void CreateLayout() {
        this.mainPanel = new NoUpdatePanel();
        this.displayPanel = new NoUpdatePanel();
        this.labelCanvas = new ProfileLabelCanvas(this.data);
        this.labelCanvas2 = new NoUpdatePanel();
        this.axisCanvas = new ProfileAxisCanvas(this.data);
        this.displayCanvas = new ProfileDisplayCanvas(this.data);
        this.HSB = new Scrollbar(0, 0, 1, 0, 1);
        this.VSB = new Scrollbar(1, 0, 1, 0, 1);
        this.mainPanel.setLayout(null);
        this.mainPanel.setBackground(Color.black);
        this.mainPanel.add(this.labelCanvas);
        this.mainPanel.add(this.labelCanvas2);
        this.mainPanel.add(this.axisCanvas);
        this.mainPanel.add(this.displayPanel);
        this.mainPanel.add(this.HSB);
        this.mainPanel.add(this.VSB);
        this.displayPanel.setLayout(null);
        this.displayPanel.add(this.displayCanvas);
        this.HSB.setBackground(Color.lightGray);
        this.HSB.addAdjustmentListener(this);
        this.VSB.setBackground(Color.lightGray);
        this.VSB.addAdjustmentListener(this);
        this.bColors = new Button("Change Colors");
        this.bDecreaseY = new Button("<<");
        this.bIncreaseY = new Button(">>");
        this.bResetY = new Button("Reset");
        this.bDecreaseX = new Button("<<");
        this.bIncreaseX = new Button(">>");
        this.bResetX = new Button("Reset");
        this.bPieChart = new Button("Pie Chart");
        this.bColors.addActionListener(this);
        this.bDecreaseY.addActionListener(this);
        this.bIncreaseY.addActionListener(this);
        this.bResetY.addActionListener(this);
        this.bDecreaseX.addActionListener(this);
        this.bIncreaseX.addActionListener(this);
        this.bResetX.addActionListener(this);
        this.bPieChart.addActionListener(this);
        Label label = new Label("X-SCALE: ", 1);
        this.xScaleField = new FloatTextField(this.xscale, 5);
        this.xScaleField.addActionListener(this);
        Label label2 = new Label("Y-SCALE: ", 1);
        this.yScaleField = new FloatTextField(this.yscale, 5);
        this.yScaleField.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        Util.gblAdd(panel, this.bDecreaseY, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, label2, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.yScaleField, gridBagConstraints, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bIncreaseY, gridBagConstraints, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bResetY, gridBagConstraints, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, new Label("  "), gridBagConstraints, 5, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bDecreaseX, gridBagConstraints, 6, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, label, gridBagConstraints, 7, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.xScaleField, gridBagConstraints, 8, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bIncreaseX, gridBagConstraints, 9, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bResetX, gridBagConstraints, 10, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bPieChart, gridBagConstraints, 11, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bColors, gridBagConstraints, 12, 0, 1, 1, 1, 1);
        Panel panel2 = new Panel();
        panel2.setBackground(Color.black);
        panel2.setForeground(Color.white);
        Label label3 = new Label("%", 1);
        panel2.setLayout(gridBagLayout);
        Util.gblAdd(panel2, label3, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        this.titlePanel = new Panel();
        this.titlePanel.setBackground(Color.black);
        this.titlePanel.setForeground(Color.white);
        this.lTitle = new Label("", 1);
        this.lTitle.setFont(new Font("SansSerif", 1, 16));
        this.lTitle2 = new Label("", 1);
        this.lTitle2.setFont(new Font("SansSerif", 1, 16));
        this.titlePanel.setLayout(gridBagLayout);
        Util.gblAdd(this.titlePanel, this.lTitle, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.titlePanel, this.lTitle2, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        this.setLayout(gridBagLayout);
        Util.gblAdd(this, panel2, gridBagConstraints, 0, 0, 1, 2, 0, 1);
        Util.gblAdd(this, this.titlePanel, gridBagConstraints, 1, 0, 1, 1, 1, 0);
        Util.gblAdd(this, this.mainPanel, gridBagConstraints, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this, panel, gridBagConstraints, 0, 2, 2, 1, 1, 0);
    }

    private void CreateMenus() {
        MenuBar menuBar = new MenuBar();
        menuBar.add(Util.makeMenu("File", new Object[]{"Select Processors", "Print Profile", null, "Close"}, this));
        Menu menu = new Menu("Help");
        menuBar.add(Util.makeMenu(menu, new Object[]{"Index", "About"}, this));
        menuBar.setHelpMenu(menu);
        this.setMenuBar(menuBar);
    }

    public int getHSBValue() {
        return this.HSB.getValue();
    }

    public int getVSBValue() {
        return this.VSB.getValue();
    }

    public void MakePOArray(long l, long l2) {
        Object object;
        int n;
        Object object2;
        int n2;
        int n3;
        int n4 = Analysis.getNumUserEntries();
        if (!this.colorsSet) {
            this.colors = new Color[1][n4 + 3];
            n3 = 0;
            while (n3 < n4) {
                this.colors[0][n3] = Analysis.getEntryColor(n3);
                ++n3;
            }
            this.colors[0][n4] = Color.black;
            this.colors[0][n4 + 1] = Color.orange;
            this.colors[0][n4 + 2] = Color.white;
        }
        this.displayCanvas.removeAll();
        this.data.numPs = this.data.plist.size() + 1;
        this.poArray = new ProfileObject[this.data.numPs][];
        n3 = Analysis.getNumUserEntries();
        this.avg = new float[2][n3 + 3];
        double d = 1.0 / (double)this.data.plist.size();
        int n5 = 1;
        ProgressDialog progressDialog = new ProgressDialog("Computing Average entry point usage");
        int n6 = this.data.plist.size();
        this.data.plist.reset();
        int n7 = 0;
        while (n7 < this.avg[0].length) {
            this.avg[0][n7] = 0.0f;
            this.avg[1][n7] = 0.0f;
            ++n7;
        }
        while (this.data.plist.hasMoreElements()) {
            n2 = this.data.plist.currentElement();
            if (!progressDialog.progress(n5++, n6, n2 + " of " + n6)) break;
            this.data.plist.nextElement();
            object2 = Analysis.GetUsageData(n2, l, l2, this.data.phaselist);
            n = 0;
            while (n < this.avg[0].length && n < ((Object)object2[0]).length) {
                float[] fArray = this.avg[0];
                int n8 = n;
                fArray[n8] = fArray[n8] + (float)((double)object2[0][n] * d);
                float[] fArray2 = this.avg[1];
                int n9 = n;
                fArray2[n9] = fArray2[n9] + (float)((double)object2[1][n] * d);
                ++n;
            }
        }
        progressDialog.done();
        object2 = new Vector<Integer>();
        n = 0;
        while (n < n4) {
            if ((double)(this.avg[0][n] + this.avg[1][n]) > 1.0) {
                ((Vector)object2).add(new Integer(n));
            }
            ++n;
        }
        int[] nArray = new int[((Vector)object2).size()];
        int n10 = 0;
        while (n10 < nArray.length) {
            nArray[n10] = (Integer)((Vector)object2).elementAt(n10);
            ++n10;
        }
        if (!this.colorsSet) {
            object = Analysis.createColorMap(n4, nArray);
            int n11 = 0;
            while (n11 < ((Color[])object).length) {
                this.colors[0][n11] = object[n11];
                ++n11;
            }
            this.colorsSet = true;
        }
        progressDialog = new ProgressDialog("Computing Entry Point Usage");
        n5 = 1;
        this.data.plist.reset();
        while (this.data.plist.hasMoreElements()) {
            n2 = this.data.plist.currentElement();
            if (!progressDialog.progress(n5, n6, n2 + " of " + n6)) break;
            this.data.plist.nextElement();
            object = Analysis.GetUsageData(n2, l, l2, this.data.phaselist);
            this.usage2po((float[][])object, n2, n5++, this.colors[0]);
        }
        this.usage2po(this.avg, -1, 0, this.colors[0]);
        progressDialog.done();
        object = "Profile of Usage for Processor";
        if (this.data.plist.size() > 1) {
            object = (String)object + "s";
        }
        object = (String)object + " " + this.data.plist.listToString();
        this.lTitle.setText((String)object);
        this.lTitle.invalidate();
        object = "(Time " + U.t(l) + " - " + U.t(l2) + ")";
        this.lTitle2.setText((String)object);
        this.lTitle2.invalidate();
        this.titlePanel.validate();
        this.setSizes();
        this.setScales();
        this.labelCanvas.makeNewImage();
        this.axisCanvas.makeNewImage();
        this.labelCanvas2.invalidate();
        this.mainPanel.validate();
    }

    private void PrintProfile() {
        String string;
        int n;
        int n2;
        int n3;
        int n4;
        PrintJob printJob = this.getToolkit().getPrintJob(this, "Print Profile", null);
        if (printJob == null) {
            return;
        }
        Dimension dimension = printJob.getPageDimension();
        if (dimension.width < dimension.height) {
            n4 = (int)(0.6 * (double)dimension.width / 8.5);
            n3 = (int)(0.6 * (double)dimension.height / 11.0);
        } else {
            n4 = (int)(0.6 * (double)dimension.width / 11.0);
            n3 = (int)(0.6 * (double)dimension.height / 8.5);
        }
        int n5 = dimension.width - 2 * n4;
        int n6 = dimension.height - 2 * n3;
        int n7 = this.HSB.getValue();
        float f = (float)(this.data.dcw - 2 * this.data.offset) / (float)this.data.numPs;
        int n8 = (int)Math.ceil(((double)(n7 - this.data.offset) - 0.5 * (double)f) / (double)f);
        if (n8 < 0) {
            n8 = 0;
        }
        if ((n2 = (int)Math.floor(((double)(n7 + this.data.vpw - this.data.offset) - 0.5 * (double)f) / (double)f)) > this.data.numPs - 1) {
            n2 = this.data.numPs - 1;
        }
        if (n8 > n2) {
            n8 = n2;
        }
        System.out.println("Want to print from Processor " + n8 + " to Processor " + n2);
        int n9 = this.VSB.getValue();
        float f2 = (float)((double)(this.data.dch - this.data.offset) / 100.0);
        int n10 = 100 - (int)Math.floor((float)(n9 - this.data.offset) / f2);
        if (n10 > 100) {
            n10 = 100;
        }
        if ((n = 100 - (int)Math.ceil((float)(n9 + this.data.vph - this.data.offset) / f2)) < 0) {
            n = 0;
        }
        System.out.println("Want to print from " + n + "% to " + n10 + "%");
        Graphics graphics = printJob.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Font font = new Font("SansSerif", 0, 10);
        graphics.setFont(font);
        graphics.translate(n4, n3);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n11 = fontMetrics.getHeight();
        int n12 = fontMetrics.stringWidth("100%") + 20;
        int n13 = 2 * n11 + 15;
        int n14 = 3 * n11 + 15;
        int n15 = n5 - n12;
        int n16 = n6 - n13 - n14;
        int n17 = 0;
        String string2 = "PROJECTIONS USAGE PROFILE FOR " + Analysis.getFilename();
        graphics.setColor(Color.black);
        graphics.drawString(string2, (n5 - fontMetrics.stringWidth(string2)) / 2, n17 += n11);
        string2 = "Profile of Usage for Processor";
        if (this.data.plist.size() > 1) {
            string2 = string2 + "s";
        }
        string2 = string2 + " " + this.data.plist.listToString();
        graphics.drawString(string2, (n5 - fontMetrics.stringWidth(string2)) / 2, n17 += 5 + n11);
        string2 = "(Time " + U.t(this.data.begintime) + " - " + U.t(this.data.endtime);
        graphics.drawString(string2, (n5 - fontMetrics.stringWidth(string2)) / 2, n17 += 5 + n11);
        n17 = n16 + n14;
        int n18 = n2 - n8 + 1;
        float f3 = (float)n15 / (float)n18;
        int n19 = fontMetrics.stringWidth("" + Analysis.getNumProcessors()) + 20;
        int n20 = (int)Math.ceil((double)n19 / (double)f3);
        n20 = Util.getBestIncrement(n20);
        int n21 = 10;
        int n22 = 5;
        this.data.plist.reset();
        int n23 = 0;
        while (n23 < n8) {
            this.data.plist.nextElement();
            ++n23;
        }
        int n24 = 0;
        while (n24 < n18) {
            string = "" + this.data.plist.nextElement();
            int n25 = n12 + (int)(((double)n24 + 0.5) * (double)f3);
            if (n24 % n20 == 0) {
                graphics.drawLine(n25, n17, n25, n17 + n21);
                graphics.drawString(string, n25 -= (int)(0.5 * (double)fontMetrics.stringWidth(string)), n17 + n21 + n11 + 5);
            } else {
                graphics.drawLine(n25, n17, n25, n17 + n22);
            }
            ++n24;
        }
        string = "Processor Number";
        graphics.drawString(string, (n15 - fontMetrics.stringWidth(string)) / 2 + n12, n17 += n21 + n11 * 2 + 10);
        graphics.drawLine(n12, n14, n12, n14 + n16);
        float f4 = (float)n16 / (float)(n10 - n);
        n20 = (int)Math.ceil((float)n11 / f4);
        n20 = Util.getBestIncrement(n20);
        int n26 = 0;
        while (n26 < n10 - n + 1) {
            n17 = n14 + n16 - (int)((float)n26 * f4);
            if ((n26 + n) % n20 == 0) {
                string = "" + (n26 + n);
                graphics.drawLine(n12 - 10, n17, n12, n17);
                graphics.drawString(string, n12 - 15 - fontMetrics.stringWidth(string), n17 += (int)(0.5 * (double)n11));
            } else {
                graphics.drawLine(n12 - 7, n17, n12, n17);
            }
            ++n26;
        }
        n17 = (n16 + n11) / 2 + n14;
        string = "%";
        graphics.drawString(string, 0, n17);
        int n27 = n8;
        while (n27 <= n2) {
            int n28 = n12 + (int)((float)n27 * f3) + (int)(0.125 * (double)f3);
            int n29 = n14 + n16;
            float f5 = 0.0f;
            int n30 = -1;
            while (f5 < (float)n) {
                f5 += this.poArray[n27][++n30].getUsage();
            }
            float f6 = 0.0f;
            if (n30 == -1) {
                n30 = 0;
                f6 = this.poArray[n27][n30].getUsage();
            } else {
                f6 = f5 - (float)n;
                f5 = n;
            }
            double d = 0.0;
            int n31 = (int)(0.75 * (double)f3);
            int n32 = n30;
            while (n32 < this.poArray[n27].length) {
                float f7;
                String string3 = this.poArray[n27][n32].getName();
                Color color = string3.equals("MESSAGE PACKING") ? Color.pink : (string3.equals("OVERHEAD") ? Color.black : (string3.equals("IDLE") ? Color.black : this.poArray[n27][n32].getForeground()));
                graphics.setColor(color);
                if (f6 >= 0.0f) {
                    f7 = f6;
                    f6 = -1.0f;
                } else {
                    f7 = this.poArray[n27][n32].getUsage();
                }
                f5 += f7;
                if (f5 > (float)n10) {
                    f7 = (float)n10 - f5 + f7;
                }
                double d2 = f4 * f7;
                int n33 = (d2 += d) - (double)((int)d2) >= 0.5 ? (int)d2 + 1 : (int)d2;
                d = d2 - (double)n33;
                Rectangle rectangle = graphics.getClipBounds();
                graphics.setClip(n28, n29 -= n33, n31, n33);
                graphics.fillRect(n28, n29, n31, n33);
                if (string3.equals("OVERHEAD")) {
                    graphics.setColor(Color.white);
                    int n34 = 0;
                    while (n34 < n33 + n31) {
                        graphics.drawLine(n28 + n34, n29, n28, n29 + n34);
                        graphics.drawLine(n28 + n34 + 1, n29, n28, n29 + n34 + 1);
                        n34 += 4;
                    }
                }
                graphics.setClip(rectangle);
                if (f5 > (float)n10) break;
                ++n32;
            }
            ++n27;
        }
        graphics.dispose();
        printJob.end();
    }

    private void setScales() {
        this.data.dcw = (int)(this.xscale * (float)this.data.vpw);
        this.data.dch = (int)(this.yscale * (float)this.data.vph);
        if (this.xscale > 1.0f) {
            this.HSB.setVisible(true);
        } else {
            this.HSB.setVisible(false);
        }
        if (this.yscale > 1.0f) {
            this.VSB.setVisible(true);
        } else {
            this.VSB.setVisible(false);
        }
        this.HSB.setMaximum(this.data.dcw);
        this.VSB.setMaximum(this.data.dch);
        this.HSB.setVisibleAmount(this.data.vpw);
        this.VSB.setVisibleAmount(this.data.vph);
        this.HSB.setBlockIncrement(this.data.vpw);
        this.VSB.setBlockIncrement(this.data.vph);
        this.displayCanvas.setBounds(0, 0, this.data.dcw, this.data.dch);
        double d = (double)(this.data.dch - this.data.offset) / 100.0;
        float f = (float)(this.data.dcw - 2 * this.data.offset) / (float)this.data.numPs;
        int n = (int)Math.ceil(0.75 * (double)f);
        int n2 = (int)((f - (float)n) / 2.0f);
        if (this.poArray != null) {
            int n3 = 0;
            while (n3 < this.data.numPs) {
                int n4 = this.data.dch;
                double d2 = 0.0;
                if (this.poArray[n3] != null) {
                    int n5 = 0;
                    while (n5 < this.poArray[n3].length) {
                        if (this.poArray[n3][n5] != null) {
                            double d3 = d * (double)this.poArray[n3][n5].getUsage();
                            int n6 = (d3 += d2) - (double)((int)d3) >= 0.5 ? (int)d3 + 1 : (int)d3;
                            d2 = d3 - (double)n6;
                            this.poArray[n3][n5].setBounds((int)(f * (float)n3 + (float)this.data.offset + (float)n2), n4 - n6, n, n6);
                            n4 -= n6;
                        } else {
                            System.out.println("POARRAY[" + n3 + "][" + n5 + "} IS NULL");
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
        }
        this.displayCanvas.makeNewImage();
    }

    private void setSizes() {
        int n = this.mainPanel.getSize().width;
        int n2 = this.mainPanel.getSize().height;
        int n3 = 50;
        int n4 = 30;
        int n5 = 30;
        int n6 = 20;
        int n7 = 20;
        this.data.vpw = n - n3 - n7;
        this.data.vph = n2 - n4 - n5 - n6;
        this.data.dcw = (int)(this.xscale * (float)this.data.vpw);
        this.data.dch = (int)(this.yscale * (float)this.data.vph);
        if (this.xscale > 1.0f) {
            this.HSB.setVisible(true);
        } else {
            this.HSB.setVisible(false);
        }
        if (this.yscale > 1.0f) {
            this.VSB.setVisible(true);
        } else {
            this.VSB.setVisible(false);
        }
        this.HSB.setMaximum(this.data.dcw);
        this.VSB.setMaximum(this.data.dch);
        this.HSB.setBlockIncrement(this.data.vpw);
        this.VSB.setBlockIncrement(this.data.vph);
        this.axisCanvas.setBounds(0, 0, n3, this.data.vph);
        this.displayPanel.setBounds(n3, 0, this.data.vpw, this.data.vph);
        this.displayCanvas.setBounds(0, 0, this.data.dcw, this.data.dch);
        this.labelCanvas.setBounds(n3, this.data.vph, this.data.vpw, n4);
        this.labelCanvas2.setBounds(n3, this.data.vph + n4, this.data.vpw, n5);
        this.VSB.setBounds(n - n7, 0, n7, this.data.vph);
        this.HSB.setBounds(n3, n2 - n6, this.data.vpw, n6);
    }

    private void ShowDialog() {
        if (this.dialog == null) {
            this.dialog = new ProfileDialog2((Frame)this, this.data);
        }
        ((Component)this.dialog).setVisible(true);
    }

    private void usage2po(float[][] fArray, int n, int n2, Color[] colorArray) {
        String string;
        int n3;
        float f;
        int n4 = Analysis.getNumUserEntries();
        String[][] stringArray = Analysis.getEntryNames();
        int n5 = 0;
        int n6 = 0;
        float f2 = 0.01f;
        int n7 = 0;
        while (n7 < fArray[0].length) {
            if (fArray[0][n7] > f2) {
                ++n6;
            }
            if (fArray[1][n7] > f2) {
                ++n6;
            }
            ++n7;
        }
        this.poArray[n2] = new ProfileObject[n6];
        n7 = 0;
        while (n7 < fArray[0].length) {
            f = fArray[0][n7];
            if (!(f <= f2)) {
                n3 = n7;
                if (n3 < n4) {
                    string = stringArray[n3][1] + "::" + stringArray[n3][0];
                } else if (n3 == n4 + 2) {
                    string = "IDLE";
                } else if (n3 == n4) {
                    string = "PACKING";
                } else {
                    if (n3 != n4 + 1) break;
                    string = "UNPACKING";
                }
                this.poArray[n2][n5] = new ProfileObject(f, string, n);
                this.displayCanvas.add(this.poArray[n2][n5]);
                this.poArray[n2][n5].setForeground(colorArray[n3]);
                ++n5;
            }
            ++n7;
        }
        if (Analysis.getVersion() > 4.9) {
            n7 = 0;
            while (n7 < fArray[1].length) {
                f = fArray[1][n7];
                if (!(f <= f2)) {
                    n3 = n7;
                    if (n3 < n4) {
                        string = "Message Send Time: " + stringArray[n3][1] + "::" + stringArray[n3][0];
                    } else if (n3 == n4 + 2) {
                        string = "Message Send Time: IDLE";
                    } else if (n3 == n4) {
                        string = "Message Send Time: PACKING";
                    } else {
                        if (n3 != n4 + 1) break;
                        string = "Message Send Time: UNPACKING";
                    }
                    this.poArray[n2][n5] = new ProfileObject(f, string, n);
                    this.displayCanvas.add(this.poArray[n2][n5]);
                    this.poArray[n2][n5].setForeground(colorArray[n3]);
                    ++n5;
                }
                ++n7;
            }
        }
    }

    class NoUpdatePanel
    extends Panel {
        NoUpdatePanel() {
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }
}

