/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.TextField;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import projections.gui.MultiRunWindow;
import projections.gui.Util;
import projections.misc.MultiRunData;

public class MultiRunControlPanel
extends JPanel {
    private ButtonGroup displayModes;
    private JPanel modePanel;
    private JRadioButton textMode;
    private JRadioButton graphMode;
    private ButtonGroup dataTypeModes;
    private JPanel dataTypePanel;
    private JRadioButton[] dataTypeButtons;
    private JButton done;
    private Label cmdLineLabel;
    private TextField cmdLine;
    private MultiRunWindow mainWindow;

    public MultiRunControlPanel(MultiRunWindow multiRunWindow, int n) {
        this.mainWindow = multiRunWindow;
        this.setBackground(Color.lightGray);
        this.displayModes = new ButtonGroup();
        this.modePanel = new JPanel();
        this.textMode = new JRadioButton("Table", false);
        this.textMode.addItemListener(multiRunWindow);
        this.graphMode = new JRadioButton("Graph", true);
        this.graphMode.addItemListener(multiRunWindow);
        this.displayModes.add(this.textMode);
        this.displayModes.add(this.graphMode);
        this.modePanel.add(this.textMode);
        this.modePanel.add(this.graphMode);
        this.modePanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.dataTypeModes = new ButtonGroup();
        this.dataTypePanel = new JPanel();
        this.dataTypeButtons = new JRadioButton[4];
        int n2 = 0;
        while (n2 < 4) {
            this.dataTypeButtons[n2] = new JRadioButton(MultiRunData.getTypeName(n2), n2 == n);
            this.dataTypeButtons[n2].addItemListener(multiRunWindow);
            this.dataTypeModes.add(this.dataTypeButtons[n2]);
            this.dataTypePanel.add(this.dataTypeButtons[n2]);
            ++n2;
        }
        this.dataTypePanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.done = new JButton("Close Window");
        this.done.addActionListener(multiRunWindow);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        Util.gblAdd(this, this.modePanel, gridBagConstraints, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this, this.dataTypePanel, gridBagConstraints, 0, 1, 2, 1, 1, 0, 1, 1, 1, 1);
        gridBagConstraints.fill = 1;
        Util.gblAdd(this, this.done, gridBagConstraints, 2, 1, 1, 1, 1, 0, 1, 1, 1, 1);
    }

    public int getSelectedIdx(ItemSelectable itemSelectable) {
        JRadioButton jRadioButton = (JRadioButton)itemSelectable;
        int n = 0;
        while (n < 4) {
            if (jRadioButton == this.dataTypeButtons[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

