/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import projections.gui.FloatTextField;
import projections.gui.Util;
import projections.gui.graph.DataSource;
import projections.gui.graph.DataSource2D;
import projections.gui.graph.Graph;
import projections.gui.graph.XAxis;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxis;
import projections.gui.graph.YAxisAuto;

public class AreaGraphPanel
extends JPanel
implements ActionListener,
AdjustmentListener {
    private static final Color BACKGROUND = Color.black;
    private static final Color FOREGROUND = Color.white;
    private JPanel mainPanel;
    private JScrollPane displayPanel;
    private Graph displayCanvas;
    private Button bIncreaseX;
    private Button bDecreaseX;
    private Button bResetX;
    private Button bIncreaseY;
    private Button bDecreaseY;
    private Button bResetY;
    private Label xScaleLabel;
    private Label yScaleLabel;
    private FloatTextField xScaleField;
    private FloatTextField yScaleField;

    public AreaGraphPanel(Graph graph) {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (AreaGraphPanel.this.mainPanel != null) {
                    AreaGraphPanel.this.displayCanvas.repaint();
                }
            }
        });
        this.setBackground(BACKGROUND);
        this.displayCanvas = graph;
        this.displayCanvas.setGraphType(2);
        this.createLayout();
    }

    private void createLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.xScaleLabel = new Label("X-Axis Scale: ", 1);
        this.xScaleField = new FloatTextField(1.0f, 5);
        this.xScaleField.addActionListener(this);
        this.xScaleField.setText("1.0");
        this.bDecreaseX = new Button("<<");
        this.bIncreaseX = new Button(">>");
        this.bResetX = new Button("Reset");
        this.bIncreaseX.addActionListener(this);
        this.bDecreaseX.addActionListener(this);
        this.bResetX.addActionListener(this);
        Util.gblAdd(jPanel, this.bDecreaseX, gridBagConstraints, 0, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.xScaleLabel, gridBagConstraints, 1, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.xScaleField, gridBagConstraints, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.bIncreaseX, gridBagConstraints, 3, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.bResetX, gridBagConstraints, 4, 0, 1, 1, 1, 0);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        this.yScaleLabel = new Label("Y-Axis Scale: ", 1);
        this.yScaleField = new FloatTextField(1.0f, 5);
        this.yScaleField.addActionListener(this);
        this.yScaleField.setText("1.0");
        this.bDecreaseY = new Button("<<");
        this.bIncreaseY = new Button(">>");
        this.bResetY = new Button("Reset");
        this.bIncreaseY.addActionListener(this);
        this.bDecreaseY.addActionListener(this);
        this.bResetY.addActionListener(this);
        Util.gblAdd(jPanel2, this.bDecreaseY, gridBagConstraints, 0, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel2, this.yScaleLabel, gridBagConstraints, 1, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel2, this.yScaleField, gridBagConstraints, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel2, this.bIncreaseY, gridBagConstraints, 3, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel2, this.bResetY, gridBagConstraints, 4, 0, 1, 1, 1, 0);
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(gridBagLayout);
        this.displayPanel = new JScrollPane(this.displayCanvas);
        Util.gblAdd(this.mainPanel, this.displayPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this, this.mainPanel, gridBagConstraints, 0, 0, 2, 1, 1, 1, 5, 5, 5, 5);
        Util.gblAdd(this, jPanel, gridBagConstraints, 0, 1, 1, 1, 1, 0, 2, 2, 2, 2);
        Util.gblAdd(this, jPanel2, gridBagConstraints, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2);
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(450, 350);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        float f = this.xScaleField.getValue();
        float f2 = this.yScaleField.getValue();
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bDecreaseX) {
                if ((double)(f = (float)((int)(f * 4.0f) - 1) / 4.0f) < 1.0) {
                    f = 1.0f;
                }
            } else if (button == this.bIncreaseX) {
                f = (float)((int)(f * 4.0f) + 1) / 4.0f;
            } else if (button == this.bResetX) {
                f = 1.0f;
            } else if (button == this.bDecreaseY) {
                if ((double)(f2 = (float)((int)(f2 * 4.0f) - 1) / 4.0f) < 1.0) {
                    f2 = 1.0f;
                }
            } else if (button == this.bIncreaseY) {
                f2 = (float)((int)(f2 * 4.0f) + 1) / 4.0f;
            } else if (button == this.bResetY) {
                f2 = 1.0f;
            }
            this.xScaleField.setText("" + f);
            this.yScaleField.setText("" + f2);
        }
        this.displayCanvas.setScale(f);
        this.displayCanvas.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.displayCanvas.repaint();
    }

    public void setData(DataSource dataSource, XAxis xAxis, YAxis yAxis) {
        this.displayCanvas.setData(dataSource, xAxis, yAxis);
        this.displayCanvas.setGraphType(2);
        this.repaint();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        double[][] dArrayArray = new double[][]{{20.0, 2100.0, 49.0, 3.0}, {25.0, 34.0, 8.0, 10.0}, {23.0, 20.0, 54.0, 3.0}, {2000.0, 27.0, 4.0, 40.0}, {25.0, 21.0, 7.0, 4.0}, {20.0, 21.0, 8.0, 10.0}, {24.0, 26.0, 44.0, 4.0}, {22.0, 26.0, 20.0, 5.0}, {29.0, 29.0, 5.0, 20.0}, {20.0, 21.0, 8.0, 7.0}, {24.0, 20.0, 10.0, 3.0}, {21.0, 25.0, 6.0, 8.0}, {34.0, 23.0, 11.0, 11.0}, {20.0, 20.0, 20.0, 20.0}, {27.0, 25.0, 4.0, 5.0}, {21.0, 20.0, 5.0, 7.0}, {21.0, 24.0, 5.0, 8.0}, {26.0, 22.0, 5.0, 3.0}, {26.0, 29.0, 7.0, 10.0}, {29.0, 20.0, 8.0, 6.0}, {21.0, 24.0, 9.0, 4.0}};
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        DataSource2D dataSource2D = new DataSource2D("Histogram", dArrayArray);
        XAxisFixed xAxisFixed = new XAxisFixed("Entry Point Execution Time", "ms");
        YAxisAuto yAxisAuto = new YAxisAuto("Count", "", dataSource2D);
        Graph graph = new Graph();
        graph.setGraphType(2);
        graph.setData(dataSource2D, xAxisFixed, yAxisAuto);
        AreaGraphPanel areaGraphPanel = new AreaGraphPanel(graph);
        JMenuBar jMenuBar = new JMenuBar();
        jFrame.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Trial Item");
        jMenu.add(jMenuItem);
        jFrame.setContentPane(areaGraphPanel);
        jFrame.pack();
        ((Component)jFrame).setSize(800, 600);
        jFrame.setTitle("Projections");
        ((Component)jFrame).setVisible(true);
    }
}

