/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import projections.analysis.Chare;
import projections.analysis.ProjDefs;
import projections.gui.OrderedIntList;
import projections.misc.LogLoadException;

public class StsReader
extends ProjDefs {
    private String baseName;
    private String logDirectory;
    private boolean hasSum;
    private boolean hasSumDetail;
    private boolean hasLog;
    private boolean hasBGSum;
    public static final int NUM_TYPES = 4;
    public static final int LOG = 0;
    public static final int SUMMARY = 1;
    public static final int COUNTER = 2;
    public static final int SUMDETAIL = 3;
    private OrderedIntList[] validPEs;
    private StringBuffer[] validPEStringBuffers;
    private int[] lastPE;
    private boolean[] inRange;
    private double version;
    private String Machine;
    private int NumPe;
    private int TotalChares;
    private int EntryCount;
    private int TotalMsgs;
    private String[] ClassNames;
    private Chare[] ChareList;
    private long[] MsgTable;
    private String[][] EntryNames;
    private int userEventIndex = 0;
    private Hashtable userEventIndices = new Hashtable();
    private Hashtable userEvents = new Hashtable();
    private String[] userEventNames;

    public StsReader(String string) throws LogLoadException {
        this.validPEs = new OrderedIntList[4];
        this.lastPE = new int[4];
        this.inRange = new boolean[4];
        int n = 0;
        while (n < 4) {
            this.validPEs[n] = new OrderedIntList();
            ++n;
        }
        this.baseName = this.getBaseName(string);
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                Comparable<StringBuffer> comparable;
                int n2;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("VERSION")) {
                    this.version = Double.parseDouble(stringTokenizer.nextToken());
                    continue;
                }
                if (string4.equals("MACHINE")) {
                    this.Machine = stringTokenizer.nextToken();
                    continue;
                }
                if (string4.equals("PROCESSORS")) {
                    this.NumPe = Integer.parseInt(stringTokenizer.nextToken());
                    continue;
                }
                if (string4.equals("TOTAL_CHARES")) {
                    this.TotalChares = Integer.parseInt(stringTokenizer.nextToken());
                    this.ChareList = new Chare[this.TotalChares];
                    this.ClassNames = new String[this.TotalChares];
                    continue;
                }
                if (string4.equals("TOTAL_EPS")) {
                    this.EntryCount = Integer.parseInt(stringTokenizer.nextToken());
                    this.EntryNames = new String[this.EntryCount][2];
                    continue;
                }
                if (string4.equals("TOTAL_MSGS")) {
                    this.TotalMsgs = Integer.parseInt(stringTokenizer.nextToken());
                    this.MsgTable = new long[this.TotalMsgs];
                    continue;
                }
                if (string4.equals("CHARE") || string2.equals("BOC")) {
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                    this.ChareList[n2] = new Chare();
                    this.ChareList[n2].ChareID = n2;
                    this.ChareList[n2].NumEntries = 0;
                    this.ChareList[n2].Name = stringTokenizer.nextToken();
                    this.ChareList[n2].Type = new String(string4);
                    this.ClassNames[n2] = this.ChareList[n2].Name;
                    continue;
                }
                if (string4.equals("ENTRY")) {
                    String string5 = stringTokenizer.nextToken();
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                    comparable = new StringBuffer(stringTokenizer.nextToken());
                    String string6 = ((StringBuffer)comparable).toString();
                    if (-1 != string6.indexOf(40) && -1 == string6.indexOf(41)) {
                        do {
                            string3 = stringTokenizer.nextToken();
                            ((StringBuffer)comparable).append(" ");
                            ((StringBuffer)comparable).append(string3);
                        } while (!string3.endsWith(")"));
                    }
                    string6 = ((StringBuffer)comparable).toString();
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    this.EntryNames[n2][0] = string6;
                    this.EntryNames[n2][1] = this.ClassNames[n3];
                    continue;
                }
                if (string4.equals("MESSAGE")) {
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                    int n5 = Integer.parseInt(stringTokenizer.nextToken());
                    this.MsgTable[n2] = n5;
                    continue;
                }
                if (string4.equals("EVENT")) {
                    comparable = new Integer(stringTokenizer.nextToken());
                    if (this.userEvents.containsKey(comparable)) continue;
                    string3 = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = string3 + stringTokenizer.nextToken() + " ";
                    }
                    this.userEvents.put(comparable, string3);
                    this.userEventNames[this.userEventIndex] = string3;
                    this.userEventIndices.put(comparable, new Integer(this.userEventIndex++));
                    continue;
                }
                if (string4.equals("TOTAL_EVENTS")) {
                    this.userEventNames = new String[Integer.parseInt(stringTokenizer.nextToken())];
                    continue;
                }
                if (string4.equals("END")) break;
            }
            this.hasLog = false;
            this.hasSum = false;
            this.hasSumDetail = false;
            int n6 = 0;
            while (n6 < this.NumPe) {
                if (new File(this.getSumName(n6)).isFile()) {
                    this.hasSum = true;
                    this.validPEs[1].insert(n6);
                }
                if (new File(this.getSumDetailName(n6)).isFile()) {
                    this.hasSumDetail = true;
                    this.validPEs[3].insert(n6);
                }
                if (new File(this.getLogName(n6)).isFile()) {
                    this.hasLog = true;
                    this.validPEs[0].insert(n6);
                }
                ++n6;
            }
            this.hasBGSum = this.getBGSumName() != null;
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new LogLoadException(string, 0);
        }
        catch (IOException iOException) {
            throw new LogLoadException(string, 1);
        }
    }

    private String getBaseName(String string) {
        String string2 = null;
        if (string.endsWith(".sum.sts")) {
            string2 = string.substring(0, string.length() - 8);
        } else if (string.endsWith(".sts")) {
            string2 = string.substring(0, string.length() - 4);
        } else {
            System.err.println("Invalid sts filename. Catastrophic error. Exiting.");
            System.exit(-1);
        }
        return string2;
    }

    private String dirFromFile(String string) {
        int n = string.lastIndexOf(File.separator);
        if (n != -1) {
            return string.substring(0, n);
        }
        return ".";
    }

    public double getVersion() {
        return this.version;
    }

    public int getEntryCount() {
        return this.EntryCount;
    }

    public int getProcessorCount() {
        return this.NumPe;
    }

    public String getMachineName() {
        return this.Machine;
    }

    public String[][] getEntryNames() {
        return this.EntryNames;
    }

    public int getNumUserDefinedEvents() {
        return this.userEvents.size();
    }

    public int getUserEventIndex(int n) {
        Integer n2 = new Integer(n);
        return (Integer)this.userEventIndices.get(n2);
    }

    public String getUserEventName(int n) {
        Integer n2 = new Integer(n);
        return (String)this.userEvents.get(n2);
    }

    public String[] getUserEventNames() {
        return this.userEventNames;
    }

    public String getValidProcessorString(int n) {
        switch (n) {
            case 0: {
                if (this.hasLog) break;
                System.err.println("Warning: No log files.");
                break;
            }
            case 1: {
                if (this.hasSum) break;
                System.err.println("Warning: No summary files.");
                break;
            }
            case 3: {
                if (this.hasSumDetail) break;
                System.err.println("Warning: No summary detail files.");
            }
        }
        return this.validPEs[n].listToString();
    }

    public OrderedIntList getValidProcessorList(int n) {
        switch (n) {
            case 0: {
                if (this.hasLog) break;
                System.err.println("Warning: No log files.");
                break;
            }
            case 1: {
                if (this.hasSum) break;
                System.err.println("Warning: No summary files.");
                break;
            }
            case 3: {
                if (this.hasSumDetail) break;
                System.err.println("Warning: No summary detail files.");
            }
        }
        return this.validPEs[n];
    }

    public boolean hasLogFiles() {
        return this.hasLog;
    }

    public boolean hasSumFiles() {
        return this.hasSum;
    }

    public boolean hasSumDetailFiles() {
        return this.hasSumDetail;
    }

    public boolean hasBGSumFile() {
        return this.hasBGSum;
    }

    public String getLogPathname() {
        return this.logDirectory;
    }

    public String getFilename() {
        return this.baseName;
    }

    public String getLogName(int n) {
        return this.baseName + "." + n + ".log";
    }

    public String getSumName(int n) {
        return this.baseName + "." + n + ".sum";
    }

    public String getSumDetailName(int n) {
        return this.baseName + "." + n + ".sumd";
    }

    public String getBGSumName() {
        if (new File(this.baseName + ".sum").isFile()) {
            return this.baseName + ".sum";
        }
        return null;
    }
}

