/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.IOException;

public abstract class ProjectionsReader {
    protected static final int UNAVAILABLE = 0;
    protected static final int UNREAD = 1;
    protected static final int READ = 2;
    protected int status = this.isAvailable() ? 1 : 0;
    protected long bytesRead = 0L;

    protected abstract boolean isAvailable();

    public void readData() throws IOException {
        switch (this.status) {
            case 2: {
                throw new IOException("Warning: Data already read into memory!");
            }
            case 0: {
                throw new IOException("Data unavailable, cannot be read!");
            }
            case 1: {
                try {
                    this.bytesRead = this.read();
                    this.status = 2;
                    break;
                }
                catch (IOException iOException) {
                    this.bytesRead = -1L;
                    this.status = 0;
                    throw new IOException(iOException.toString());
                }
            }
            default: {
                System.err.println("Unrecognized status flag. Catastrophic error. Exiting.");
                System.exit(-1);
            }
        }
    }

    protected abstract long read() throws IOException;

    public void evictData() throws IOException {
        this.nullifyData();
        if (this.status != 2) {
            throw new IOException("Warning: Evicting non-existent data!");
        }
        this.status = 1;
    }

    protected abstract void nullifyData();
}

