function y=myecho(t,tau0,tau,T0,T1,T2)
% the thermal myecho expression in Harmonic approximation
% y=myecho(t,tau0,tau,T0,T1,T2)
% t: time
% tau0: the decay time of temperature auto_correlation fun.
% tau: the time between t(T1) and t(T2)
% T0: initial temperature
% T1: temperature of first velocity assignment
% T2: temperature of the second velocity assignment

% define parameters
lambda1=sqrt(T1/T0);
lambda2=sqrt(T2/T0);

% difine different contributions in the experssion
y1=(1+lambda1^2+2*lambda2^2)/4; % new temperature
y2=(1+lambda1^2-2*lambda2^2)/4*myfun(tau0,(t-tau)); % temperature recovery
y3=lambda1*lambda2/2*myfun(tau0,abs(t-3*tau/2)); % 3/2 tau pulse
y4=(1-lambda1^2)/8*myfun(tau0,abs(t-2*tau)); % 2 tau pulse
y=T0*(y1-y2-y3-y4);
