function cmp_echo(tau,temp)
% function cmp_echo(tau,temp)

tau0=2.4; % temperature auto_correlation fun decay time
T0=300; % initial temp
T1=0; % first temp of veloctiy reassignment
T2=0; % second temp of velocity reassignment

% plot the simulated data
tini=503+tau;
tfin=tini+3*tau;
t0=tini:tfin;
tsim=temp(tini:tfin,1);
ysim=temp(tini:tfin,2);
tsim=tsim-tsim(1)+tau;
figure
plot(t0,ysim,'k-')
hold on

% plot the expression according to the harmonic approximation
t=tau:4*tau;
y=myecho(t,tau0,tau,T0,T1,T2);
plot(t0,y,'r--','LineWidth',2);
grid on

xlabel('t / fs');
ylabel('temperature');
title('thermal echoes for T0=300K, T1=0K, T2=0K, and tau=200fs');
%legend('simulation','harmonic approximation');

hold  off
