% This script will generate the temperature
% autocorrelation function as auto_tmp.dat
% and fix it to the exponentail function
% Ct=exp(-t/tau0) to get the decay time tau0

clear all
close all
load temp1.dat
n=25; % the limit of auto-correlation fun.
c=auto(temp1(:,2),n)'; % auto-correlation fun
t=[0:n]';
auto_tmp=[t,c];

% save it to a data file
save auto_tmp.dat  auto_tmp -ascii 

clear all

% load the data file
load auto_tmp.dat

% fit it to the exponential function
% the definition of this function is give in myfun.m
tau0=nlinfit(auto_tmp(:,1),auto_tmp(:,2),@myfun,5)
save tau0.dat tau0 -ascii

%plot the results
t=auto_tmp(:,1);
y=auto_tmp(:,2);
plot(t,y,'*-k')
hold on
plot(t,myfun(tau0,t),'r-')
grid on
xlabel('t / fs')
ylabel('Ct')
title('temperature auto-correlation funtion')
%legend('simulation','fitting')

