mol load psf ../common/ubq_ws.psf dcd ubq-nvt.dcd

set nf [molinfo top get numframes]

for {set i 0 } {$i < $nf } {incr i } {
  set sel [atomselect top protein frame $i]
  $sel writepdb $i.pdb
}

mol load psf ../common/ubq.psf

for {set i 0 } {$i < $nf } {incr i } {
  animate read pdb $i.pdb }

animate write dcd {ubq-nvt-prot.dcd} waitfor all top

for {set i 0 } {$i < $nf } {incr i } {
puts "Removing file $i.pdb"
rm $i.pdb}

exit
