#
# This script reads the header of a X-ray pdb structure,
# creates a new directory,  save in that directory 
# copies of the PDB according to the tranlation matrix
# and draw an crystallographic unit cell
#
# For the moment, this script can only draw orthogonal unit cell
#

proc DrawCUC { inputPDB Wrap } {

    

    ###############################################
    
    ################## MAIN PART #################
    
    ###############################################

    
    # CREATE WORKING DIRECTORY
    
    set filename [string trimright $inputPDB .pdb]

    file mkdir $filename
        
    set readPDB [open $inputPDB r]
    
    set stuff [pwd]
    puts $stuff
        
        
    # READ DATA FROM PDB
    # It reads only orthogonal cell

    set matrix {}
    
    foreach line [ split [read $readPDB] \n ] {  
	foreach { 1String 2Str 3Str 4Str 5Str 6Str 7Str 8Str } $line {
	    
	    # Read Matrix Values
	    if { $1String == "REMARK"  } {
		
		if { $2Str == "290" } { 
		    
		    if { $3Str == "SMTRY1" || $3Str == "SMTRY2" || $3Str == "SMTRY3"  } { 			

 			lappend matrix "$4Str $5Str $6Str $7Str $8Str"						
		    }
		} 
	    }	
	    
	    
	    #Read Origin of the cell
	    
	    if { $1String == "ORIGX1" } {		
		set minx $5Str
	    }
	    
	    if { $1String == "ORIGX2" } {	       
		set miny $5Str		
	    }
	    
	    if { $1String == "ORIGX3" } {		
		set minz $5Str
	    }
	    
	    	    
	    #Read End of the cell
	    
	    if { $1String == "CRYST1" } {

		set maxx $2Str
		set maxy $3Str
		set maxz $4Str
		
	    }	    	    	    
	}
    }
    
    close $readPDB
    

    
    # ORGANIZE DATA IN A MATRIX
    # this woks, but it is not so clear, polish is needed
    
    set i 0
    set dummy "Start"
    
    foreach lineMatrix $matrix { 
	
	
	set indexMatrix [lindex  [lindex $matrix $i] 0]
	
	
	if { $dummy != $indexMatrix && $dummy != "Start" } {
	    
	    #Close Vector
	    lappend $VectorName " 0 0 0 1 "
	    
	    #Start a New Vector
	    
	    #incr i
	    
	    set a [lindex  [lindex $matrix $i] 1]
	    set b [lindex  [lindex $matrix $i] 2]
	    set c [lindex  [lindex $matrix $i] 3]
	    set d [lindex  [lindex $matrix $i] 4]
		
	    set VectorName Vector($indexMatrix)
	    lappend $VectorName "$a $b $c $d" 
	    
	    set dummy $indexMatrix
	    
	    
	} elseif { $dummy == $indexMatrix || $dummy == "Start"} {
	    
	    # Append Data to the vector
	    set a [lindex  [lindex $matrix $i] 1]
	    set b [lindex  [lindex $matrix $i] 2]
	    set c [lindex  [lindex $matrix $i] 3]
	    set d [lindex  [lindex $matrix $i] 4]
	    
	    set VectorName Vector($indexMatrix)
	    lappend $VectorName " $a $b $c $d " 
	    
	    set dummy $indexMatrix
	    
	} 
	
	
	
	incr i
    }
    
    lappend $VectorName " 0 0 0 1 "
    
    
    
    # WRITE PDBs FOR EACH IMAGE


    set ChainName "A A B C D E F G H I J K L M N O P Q R S T U V W X Y Z"

    set j 1
    
    while { $j <= $indexMatrix } {
	
	mol new $inputPDB	
	set all [atomselect top all]
	$all move $Vector($j)
	$all set segname [lindex $ChainName $j]		
	$all writepdb ./$filename/$filename$j.pdb
	$all delete	
	mol delete top	
	incr j	
    }
    

    # CREATE ONE PDB FILE
 
    set outWrap [open ./$filename/$filename.NoWrap.pdb w]
    
    set l 1
    
    while { $l < $j } {
	
	set pdbFileRead [open ./$filename/$filename$l.pdb r]
	
	foreach line [ split [read $pdbFileRead] \n ] {
	    
	    set stringATOM [ string range $line 0 3 ]
	    
	    if { [string match $stringATOM "ATOM"] } {
		
		puts $outWrap $line
		
	    } else {
		
	    }
	    
	}
	
	close $pdbFileRead
       
       set stuff $filename$l.pdb
       puts $stuff
	file delete ./$filename/$stuff
    
	incr l
                                                                
    }
    close $outWrap

    

    # TO WRAP THE CELL


    if { $Wrap == "wrap" || $Wrap == "Wrap" || $Wrap == "WRAP"  } {

	
	set 00 0
	file rename ./$filename/$filename.NoWrap.pdb ./$filename/$filename$00.pdb
	

	
	#Define new vectors
	lappend mover(1)  " 1 0 0 $maxx "
	lappend mover(1)  " 0 1 0 0 "
	lappend mover(1)  " 0 0 1 0 "
	lappend mover(1)  " 0 0 0 1 "
	
	
	lappend mover(2)  " 1 0 0 $maxx "
	lappend mover(2)  " 0 1 0 0 "
	lappend mover(2)  " 0 0 1 $maxz "
	lappend mover(2)  " 0 0 0 1 "
	
	
	lappend mover(3)  " 1 0 0 $maxx "
	lappend mover(3)  " 0 1 0 0 "
	lappend mover(3)  " 0 0 1 -$maxz "
	lappend mover(3)  " 0 0 0 1 "
	
	
	lappend mover(4)  " 1 0 0 $maxx "
	lappend mover(4)  " 0 1 0 $maxy "
	lappend mover(4)  " 0 0 1 0 "
	lappend mover(4)  " 0 0 0 1 "
	
	
	lappend mover(5)  " 1 0 0 $maxx "
	lappend mover(5)  " 0 1 0 -$maxy "
	lappend mover(5)  " 0 0 1 0 "
	lappend mover(5)  " 0 0 0 1 "
	
	
	lappend mover(6)  " 1 0 0 $maxx "
	lappend mover(6)  " 0 1 0 $maxy "
	lappend mover(6)  " 0 0 1 $maxz "
	lappend mover(6)  " 0 0 0 1 "
	
	
	lappend mover(7)  " 1 0 0 $maxx "
	lappend mover(7)  " 0 1 0 $maxy "
	lappend mover(7)  " 0 0 1 -$maxz "
	lappend mover(7)  " 0 0 0 1 "
	
	
	
	lappend mover(8)  " 1 0 0 $maxx "
	lappend mover(8)  " 0 1 0 -$maxy "
	lappend mover(8)  " 0 0 1 $maxz "
	lappend mover(8)  " 0 0 0 1 "
	
	
	lappend mover(9)  " 1 0 0 $maxx "
	lappend mover(9)  " 0 1 0 -$maxy "
	lappend mover(9)  " 0 0 1 -$maxz "
	lappend mover(9)  " 0 0 0 1 "
	
	
	lappend mover(10)  " 1 0 0 -$maxx "
	lappend mover(10)  " 0 1 0 0 "
	lappend mover(10)  " 0 0 1 0 "
	lappend mover(10)  " 0 0 0 1 "
	
	
	lappend mover(11)  " 1 0 0 -$maxx "
	lappend mover(11)  " 0 1 0 0 "
	lappend mover(11)  " 0 0 1 $maxz "
	lappend mover(11)  " 0 0 0 1 "
	
	
	lappend mover(12)  " 1 0 0 -$maxx "
	lappend mover(12)  " 0 1 0 0 "
	lappend mover(12)  " 0 0 1 -$maxz "
	lappend mover(12)  " 0 0 0 1 "
	
	
	lappend mover(13)  " 1 0 0 -$maxx "
	lappend mover(13)  " 0 1 0 $maxy "
	lappend mover(13)  " 0 0 1 0 "
	lappend mover(13)  " 0 0 0 1 "
	
	
	lappend mover(14)  " 1 0 0 -$maxx "
	lappend mover(14)  " 0 1 0 -$maxy "
	lappend mover(14)  " 0 0 1 0 "
	lappend mover(14)  " 0 0 0 1 "
	
	
	lappend mover(15)  " 1 0 0 -$maxx "
	lappend mover(15)  " 0 1 0 $maxy "
	lappend mover(15)  " 0 0 1 $maxz "
	lappend mover(15)  " 0 0 0 1 "
	
	
	lappend mover(16)  " 1 0 0 -$maxx "
	lappend mover(16)  " 0 1 0 $maxy "
	lappend mover(16)  " 0 0 1 -$maxz "
	lappend mover(16)  " 0 0 0 1 "
	
	
	
	lappend mover(17)  " 1 0 0 -$maxx "
	lappend mover(17)  " 0 1 0 -$maxy "
	lappend mover(17)  " 0 0 1 $maxz "
	lappend mover(17)  " 0 0 0 1 "
	
	
	lappend mover(18)  " 1 0 0 -$maxx "
	lappend mover(18)  " 0 1 0 -$maxy "
	lappend mover(18)  " 0 0 1 -$maxz "
	lappend mover(18)  " 0 0 0 1 "

	
	lappend mover(19)  "1 0 0 0"
	lappend mover(19)  "0 1 0 $maxy"
	lappend mover(19)  "0 0 1 0"
	lappend mover(19)  "0 0 0 1"

	
	lappend mover(20)  "1 0 0 0"
	lappend mover(20)  "0 1 0 $maxy"
	lappend mover(20)  "0 0 1 $maxz"
	lappend mover(20)  "0 0 0 1"
	
	lappend mover(21)  "1 0 0 0"
	lappend mover(21)  "0 1 0 $maxy"
	lappend mover(21)  "0 0 1 -$maxz"
	lappend mover(21)  "0 0 0 1"
	
	
	lappend mover(22)  "1 0 0 0"
	lappend mover(22)  "0 1 0 -$maxy"
	lappend mover(22)  "0 0 1 0"
	lappend mover(22)  "0 0 0 1"
	
	
	lappend mover(23)  "1 0 0 0"
	lappend mover(23)  "0 1 0 -$maxy"
	lappend mover(23)  "0 0 1 $maxz"
	lappend mover(23)  "0 0 0 1"
	
	lappend mover(24)  "1 0 0 0"
	lappend mover(24)  "0 1 0 -$maxy"
	lappend mover(24)  "0 0 1 -$maxz"
	lappend mover(24)  "0 0 0 1"
	
	
	lappend mover(25)  "1 0 0 0"
	lappend mover(25)  "0 1 0 0"
	lappend mover(25)  "0 0 1 $maxz"
	lappend mover(25)  " 0 0 0 1 "
	
	lappend mover(26)  "1 0 0 0"
	lappend mover(26)  "0 1 0 0"
	lappend mover(26)   "0 0 1 -$maxz"
	lappend mover(26)  "0 0 0 1 "
	
	
	#Write new PDBs to fill the cell
	set ss 1
	
	while { $ss <= 26 } {
		
	    mol new ./$filename/$filename$00.pdb
	    set all [atomselect top all]
	    $all move $mover($ss)
	    $all writepdb ./$filename/$filename$ss.pdb
	    
	    $all delete
	    mol delete top
	    
	    incr ss
	    
	}


	
	# Create one PDB
	
	set outWrap [open ./$filename/$filename.Borders.pdb w]
	
	set l 0
	
	while { $l <= 26 } {
	    
	    set pdbFileRead [open ./$filename/$filename$l.pdb r]
	    
	    foreach line [ split [read $pdbFileRead] \n ] {
		
		set stringATOM [ string range $line 0 3 ]
		
		if { [string match $stringATOM "ATOM"] } {
		    
		    puts $outWrap $line
		    
		} else {
		    
		}
		
	    }
	    
	    close $pdbFileRead
	    file delete ./$filename/$filename$l.pdb
	    incr l
	    
	}
	
	close $outWrap	
	


	# Cut borders

	mol new ./$filename/$filename.Borders.pdb
	set all [atomselect top "x< $maxx and x > $minx and y < $maxy and y > $miny and z < $maxz and z > $minz  "]
	$all writepdb  ./$filename/$filename.Wrap.pdb
	$all delete
	mol delete top
	file delete ./$filename/$filename.Borders.pdb
    }
    




    # LOAD MOLECULES

    if { $Wrap == "wrap" || $Wrap == "Wrap" || $Wrap == "WRAP"  } {
       #This file already exists sometimes
       file delete ?force ./$filename.Wrap.pdb
	file copy ./$filename/$filename.Wrap.pdb  .

	file delete -force ./$filename

	mol new ./$filename.Wrap.pdb

    } else {

       #This file already exists sometimes
       file delete ?force ./$filename.NoWrap.pdb
	file copy  ./$filename/$filename.NoWrap.pdb  ./$filename.NoWrap.pdb

	file delete -force ./$filename

	mol new ./$filename.NoWrap.pdb


    }

    
    # DRAW UNIT CELL
    # from box_molecule.tcl (www.ks.uiuc.edu)
            
    draw materials off
    draw color green
    # draw color red
    # 

    draw line "$minx $miny $minz" "$maxx $miny $minz" width 5 
    draw line "$minx $miny $minz" "$minx $maxy $minz" width 5 
    draw line "$minx $miny $minz" "$minx $miny $maxz" width 5 
    
    draw line "$maxx $miny $minz" "$maxx $maxy $minz" width 5 
    draw line "$maxx $miny $minz" "$maxx $miny $maxz" width 5 
    
    draw line "$minx $maxy $minz" "$maxx $maxy $minz" width 5 
    draw line "$minx $maxy $minz" "$minx $maxy $maxz" width 5 
    
    draw line "$minx $miny $maxz" "$maxx $miny $maxz" width 5 
    draw line "$minx $miny $maxz" "$minx $maxy $maxz" width 5 
    
    draw line "$maxx $maxy $maxz" "$maxx $maxy $minz" width 5 
    draw line "$maxx $maxy $maxz" "$minx $maxy $maxz" width 5 
    draw line "$maxx $maxy $maxz" "$maxx $miny $maxz" width 5 
    

    # Cell parameters

    molinfo top set a $maxx 
    molinfo top set b $maxy
    molinfo top set c $maxz
}
    
 


