#################################################
# Calculate the radius of gyration for all atoms in a trajectory  #
#################################################

# get the number of frames
set nf [molinfo top get numframes]

#make a selection with all the atoms
set all [atomselect top all]

#initialize average
set avrgyr 0.

# loop over all frames
for {set f 0 } {$f < $nf} {incr f} {
    # go to frame f
    $all frame $f
    # get the radius of gyration
    set rgyr [measure rgyr $all]
    # add to the average
    set avrgyr [expr $avrgyr + $rgyr]
} 

#divide the average over the number of frames
set avrgyr [expr $avrgyr / $nf]
# Delete the selection
$all delete

puts "Average radius or gyration for $nf frames is: $avrgyr"


