package provide neuroread 1.0

namespace eval ::neuro {}

proc ::neuro::cortex_color_map {thePopName} {
  set matchList {
    AIv 1.000 1.000 0.878
    GU 1.000 1.000 0.600
    AIp 1.000 0.890 0.008
    AId 1.000 0.918 0.090
    VISC 1.000 1.000 0.078
    VISam 0.196 0.090 0.302
    VISpm 0.788 0.627 0.863
    VISa 0.392 0.325 0.580
    RSPagl 0.624 0.000 1.000
    RSPd 0.933 0.510 0.933
    RSPv 0.498 0.000 1.000
    ILA 0.000 0.000 0.804
    ORBm 0.275 0.510 0.706
    FRP 0.000 0.749 1.000
    ACAv 0.098 0.098 0.439
    ORBvl 0.000 0.000 0.502
    ORBl 0.941 0.973 1.000
    ACAd 0.529 0.808 0.980
    PL 0.118 0.565 1.000
    MOs 0.000 0.000 1.000
    SSp-un 0.886 0.239 0.157
    SSp-tr 0.400 0.000 0.000
    SSp-ll 1.000 0.627 0.478
    SSp-n 0.804 0.361 0.361
    SSp-ul 1.000 0.388 0.278
    SSp-m 0.863 0.078 0.235
    SSp-bfd 1.000 0.271 0.000
    MOp 0.698 0.133 0.133
    SSs 1.000 0.000 0.000
    PERI 0.769 0.384 0.063
    AUDpo 1.000 0.549 0.000
    AUDd 0.929 0.569 0.129
    ECT 1.000 0.459 0.220
    AUDv 1.000 0.510 0.000
    AUDp 1.000 0.624 0.000
    TEa 1.000 0.498 0.000
    VISli 0.000 0.651 0.576
    VISal 0.000 0.416 0.306
    VISrl 0.400 1.000 0.000
    VISpl 0.000 0.800 0.600
    VISpor 0.675 0.882 0.686
    VISl 0.090 0.447 0.271
    VISp 0.000 1.000 0.000
  }
  
  foreach {matchString r g b} $matchList {
    #puts "matchString= $matchString   r g b = $r $g $b"
    if {[string match $matchString $thePopName]} {
      return [list $r $g $b]
    }
  }
  puts "default color set"
     #set to tan
  return [list .500 .500 .200]
}

proc ::neuro::v1_color_map {theName} {
  #   desired colors
  # Pvalb Blue
  # Sst Deep Gre
  # Htr3a Cyan
  # e23 Deep Pink
  # e4 Red
  # e5 Firebrick
  # e6 Deep Orange

  set matchList {
    Pvalb 0
    Sst 7
    Htr3a 10
    e23 27 
    e4 1
    e5 30
    e6 31
  }
  #default color
  set theColor 5

  
  foreach {matchString c} $matchList {
    #puts "matchString= $matchString c= $c"
    if {[string match -nocase "*${matchString}*" $theName]} {
      set theColor $c
      puts "for $theName set color $c"
      return $theColor
    }
  }
  puts "default color: $theName, color $c"
  return $theColor
}


proc ::neuro::initVars {} {
  # XX really should catch/unset all Hashes and Arrays first
  catch {unset ::neuro::morphoHash}
  variable morphoHash
  set morphoHash(-1) ""
  catch {unset ::neuro::node}
  variable node
  set node(-1) ""
  variable nodeIdList ""
  variable spikeList ""
  variable typeList ""
  variable typeHash
  set typeHash(-1) ""
  variable nrepCount 0
  variable nrepList ""
  variable debugMode 0
}

proc ::neuro::proto_retrieve_morphology {the_nodeType} {
  variable morphoHash
  return $morphoHash($the_nodeType)
}

proc ::neuro::read_store_types_no_morphos {filename rot_zaxis_col pop_col null_radius} {
  # set rot_zaxis_col to -1 if not neeeded
  # XX fix to read out node_id and morphology column from header line
  variable typeHash
  variable typeList
  variable morphoHash 
  set fp [open $filename r]
  #set linenum 0
  set header [gets $fp myline]
  puts "header for $filename: $myline]"
  set typeList ""
  set rot_zaxis 0
  while { [gets $fp myline] >=0} {
    set lineList [split $myline]
    set thisType [lindex $lineList 0]
    set popName [lindex $lineList $pop_col]
    if {$rot_zaxis_col != -1 } {
      set rot_zaxis [lindex $lineList $rot_zaxis_col]
      if {($rot_zaxis eq "NULL")} {
        set rot_zaxis 0
      }
    } 
    
    lappend typeList $thisType
    set typeHash(popName,$thisType) $popName
    set typeHash(rot_zaxis,$thisType) $rot_zaxis
    # X could check for uniques as add, in case badly-formed input file
    #incr linenum
  }
  close $fp 
  puts "Completed reading [llength $typeList] file types"
}
proc ::neuro::proto_read_store_types_and_morphos {filename morph_col rot_zaxis_col pop_col swc_dir  null_radius} {
  # use prototype file reader plugin smilation and file accessors
  # set rot_zaxis_col to -1 if not neeeded
  # XX fix to read out node_id and morphology column from header line
  # leftmost column in .cvs file is column 0
  variable typeHash
  variable typeList
  variable morphoHash 
  set fp [open $filename r]
  #set linenum 0
  set header [gets $fp myline]
  puts "header for $filename: $myline]"
  set typeList ""
  set rot_zaxis 0
  while { [gets $fp myline] >=0} {
    set lineList [split $myline]
    set thisType [lindex $lineList 0]
    set morphoName [lindex $lineList $morph_col]
    set popName [lindex $lineList $pop_col]
    if {$rot_zaxis_col != -1 } {
      set rot_zaxis [lindex $lineList $rot_zaxis_col]
      if {($rot_zaxis eq "NULL")} {
        set rot_zaxis 0
      }
    } 
    if {!($morphoName eq "NULL")} { 
      # append .swc file suffix if not present
      if  {!([string range $morphoName end-3 end] eq ".swc")} {
        set morphoName "${morphoName}.swc"
      }
    }
    lappend typeList $thisType
    set typeHash(popName,$thisType) $popName
    set typeHash(morphoName,$thisType) $morphoName
    set typeHash(rot_zaxis,$thisType) $rot_zaxis
    # X could check for uniques as add, in case badly-formed input file
    #incr linenum
  }
  #now read in 
  foreach e $typeList {
    set thefilename [file join $swc_dir $typeHash(morphoName,$e)]
    puts "Now to read in morphology $e $thefilename"
    proto_store_swc [proto_read_swc  $thefilename $null_radius] $e 
  }
  puts "Completed reading [llength $typeList] file types"
  close $fp
}

proc ::neuro::read_store_types_and_morphos {filename morph_col rot_zaxis_col pop_col swc_dir  null_radius} {
  # set rot_zaxis_col to -1 if not neeeded
  # XX fix to read out node_id and morphology column from header line
  variable typeHash
  variable typeList
  variable morphoHash 
  set fp [open $filename r]
  #set linenum 0
  set header [gets $fp myline]
  puts "header for $filename: $myline]"
  set typeList ""
  set rot_zaxis 0
  while { [gets $fp myline] >=0} {
    set lineList [split $myline]
    set thisType [lindex $lineList 0]
    set morphoName [lindex $lineList $morph_col]
    set popName [lindex $lineList $pop_col]
    if {$rot_zaxis_col != -1 } {
      set rot_zaxis [lindex $lineList $rot_zaxis_col]
      if {($rot_zaxis eq "NULL")} {
        set rot_zaxis 0
      }
    } 
    if {!($morphoName eq "NULL")} { 
      # append .swc file suffix if not present
      if  {!([string range $morphoName end-3 end] eq ".swc")} {
        set morphoName "${morphoName}.swc"
      }
    }
    lappend typeList $thisType
    set typeHash(popName,$thisType) $popName
    set typeHash(morphoName,$thisType) $morphoName
    set typeHash(rot_zaxis,$thisType) $rot_zaxis
    # X could check for uniques as add, in case badly-formed input file
    #incr linenum
  }
  #now read in 
  foreach e $typeList {
    set thefilename [file join $swc_dir $typeHash(morphoName,$e)]
    puts "Now to read in morphology $e $thefilename"
    read_store_swc  $thefilename $e $null_radius
  }
  close $fp
  puts "Completed reading [llength $typeList] file types"
}


proc ::neuro::proto_read_swc {filename null_radius} {
 # this work will be done by a VMD plugin
 # return a memory represenation of the file, maybe with some processing before returning it
 # vector use: for this Tcl data accessor prototype version, all vectors x y z embedded in list of other values will be a sub-list {x y z}
  set pointList ""
  set movedPointList ""
  # make list each meber is list, from SWC format columns, {n type x y z radius parent} 
  # if NULL file, set as a single point
  # clean this up so works with file dirs or boolean on proc call 
  if {[string range $filename end-3 end] eq "NULL"} {
    #set a single point at 0 0 0 
    #set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] - $somax]  [expr [lindex $e 3] - $somay] [expr [lindex $e 4] - $somaz] [lindex $e 5]  [lindex $e 6]] 
    # we set a single point, with type soma and radius $null_radius
    # XX change to VND_NULL_RADIUS so null_radius can be changed without re-loading data
    set l [list 0 1 0 0 0 $null_radius 0] 
    lappend movedPointList $l
} else {
    set fp [open $filename r]
    set linenum 0
    while { [gets $fp myline] >=0} {
      #puts "linenum= $linenum; DATA: >$myline<"
      #skip comments
      if {[string first \# $myline] != 0} {
        set lineList [split $myline]
        if {[lindex $lineList 1] == 1} then {
          #this is the soma
          set somaList $lineList
        }
        lappend pointList $lineList
      }
      incr linenum
    }
    #reset position to 0,0,0
    # XX consider moving this position reset out of read and into proto_store_swc
    set somax [lindex $somaList 2]
    set somay [lindex $somaList 3]
    set somaz [lindex $somaList 4]
    foreach e $pointList {
      # XX make x y z into a sub-list (vector), and change all that use this data to handle the vector list
      set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] - $somax]  [expr [lindex $e 3] - $somay] [expr [lindex $e 4] - $somaz]  [lindex $e 5]  [lindex $e 6]] 
      lappend movedPointList $l
     }
     close $fp
   }
   #set morphoHash($node_type) $movedPointList
   return $movedPointList

}

proc ::neuro::proto_store_swc {swc_data_list node_type} {
 # this work will by done by internal (non-plugin) VMD code
 # takes in memory representation of what is in the file and stores it in data structures that other functions will call
 # for now, we prototype 
  #XX soon, provide scan for null_radius token, replace with null_radius
  #XX since we want to do all (most) operations after getting data from plugin
  variable morphoHash
  set morphoHash($node_type) $swc_data_list
  set datlength [llength $swc_data_list]
  set mlength [llength $morphoHash($node_type)]
  puts "stored morpho for $node_type,  swc_data_list list length = $datlength mlength= $mlength" 
}

proc ::neuro::read_store_swc {filename node_type null_radius} {
  variable morphoHash
  set pointList ""
  set movedPointList ""
  # make list each meber is list, from SWC format columns, {n type x y z radius parent} 
  # if NULL file, set as a single point
  # clean this up so works with file dirs or boolean on proc call 
  if {[string range $filename end-3 end] eq "NULL"} {
    #set a single point at 0 0 0 
      #set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] - $somax]  [expr [lindex $e 3] - $somay] [expr [lindex $e 4] - $somaz] [lindex $e 5]  [lindex $e 6]] 
      # we set a single point, with type soma and radius $null_radius
      # XX change so null_radius can be changed without re-loading data
      set l [list 0 1 0 0 0 $null_radius 0] 
     lappend movedPointList $l
} else {
    set fp [open $filename r]
    set linenum 0
    while { [gets $fp myline] >=0} {
      #puts "linenum= $linenum; DATA: >$myline<"
      #skip comments
      if {[string first \# $myline] != 0} {
        set lineList [split $myline]
        if {[lindex $lineList 1] == 1} then {
          #this is the soma
          set somaList $lineList
        }
        lappend pointList $lineList
      }
      incr linenum
    }
    #reset position to 0,0,0
    set somax [lindex $somaList 2]
    set somay [lindex $somaList 3]
    set somaz [lindex $somaList 4]
    foreach e $pointList {
      set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] - $somax]  [expr [lindex $e 3] - $somay] [expr [lindex $e 4] - $somaz] [lindex $e 5]  [lindex $e 6]] 
      lappend movedPointList $l
     }
   }
   set morphoHash($node_type) $movedPointList
   return
}

proc ::neuro::show_morph_moved_soma_only_old {node_type x y z xrot yrot zrot radius_scale} {
  variable morphoHash
  variable typeHash
  set pointList $morphoHash($node_type)
  set rotPointList ""
  puts "yrot = $yrot"
  # do rotation here
  set c [expr $node_type % 32]
  draw color $c
  puts "in show_morph_moved, color set to $c"
  set type_zrot $typeHash(rot_zaxis,$node_type)
  puts "node_type= $node_type  type_zrot= $type_zrot"
  foreach e $pointList {
    
    # need sequential type_zrot, zrot, yrot, xrot
    # XX later, add type_xrot and type_yrot if these are ever used
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad]]
    # negative type_zrot:
    set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z $type_zrot rad]]
    #set m [transaxis z $type_zrot rad]
    #set m [transaxis z 0 rad]
    set v [list [lindex $e 2] [lindex $e 3] [lindex $e 4]]
    set vr [coordtrans $m $v]
    #puts "vr = $vr, v 0 = [lindex $vr 0]"
    set l [list [lindex $e 0] [lindex $e 1] [lindex $vr 0]  [lindex $vr 1]   [lindex $vr 2]   [lindex $e 5]  [lindex $e 6]]
    #puts "rot show_morph_moved l= $l"
    lappend rotPointList $l
  } 
  set movedPointList ""
  foreach e $rotPointList {
    set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] + $x]  [expr [lindex $e 3] + $y] [expr [lindex $e 4] + $z] [lindex $e 5]  [lindex $e 6]] 
    #puts "moved show_morph_moved l= $l"
    lappend movedPointList $l
   } 
  set sphereList ""
  set radiusList ""
  set linenum 0
  foreach lineList $movedPointList {
    #puts "lineList=$lineList"
    #set enum 0
    #foreach e $lineList {
    #   if {$e < 0.0} {set e 0.0}
    #   set mat($linenum,$enum) [expr $e + 0.0]
    #   incr enum
    #} 
    #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 
    #puts "draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}  radius [lindex $lineList 5] resolution 6" 

    # XX sets color per sphere, so per component of neuron - make this a param setting 
    ## draw color [lindex $lineList 1] 

    #don't scale soma, increase res for soma 
    if {[lindex $lineList 1] == 1} then {
      set draw_radius_scale 1.0
      set sphereRes 12
      lappend sphereList "[list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]"
      lappend radiusList  [expr $draw_radius_scale * [lindex $lineList 5] ] 
    } else {
      set draw_radius_scale $radius_scale
      set sphereRes 4 
    } 
       
    
    #draw sphere [list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]  radius [expr $draw_radius_scale * [lindex $lineList 5] ] resolution  $sphereRes 
    ##lappend sphereList "[list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]"
    ##lappend radiusList  [expr $draw_radius_scale * [lindex $lineList 5] ] 
    #puts "$linenum: [lrange $radiusList 0 4], "
    #puts "[lrange $sphereList 0 4], "
    #draw sphere "{[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}"  radius [lindex $lineList 5] resolution 8
    #draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]} radius  [lindex $lineList 5] resolution 8" 
    incr linenum
  }
  draw spheretube "$sphereList" radii $radiusList drawtubes 0
  #draw spheretube "$sphereList" radii $radiusList drawtubes 1
} 

proc ::neuro::show_morph_moved_soma_only_color_old {node_type x y z xrot yrot zrot radius_scale theColor} {
  variable morphoHash
  variable typeHash
  set pointList $morphoHash($node_type)
  set rotPointList ""
  puts "yrot = $yrot"
  # do rotation here
  ##et c [expr $node_type % 32]
  draw color $theColor
  set type_zrot $typeHash(rot_zaxis,$node_type)
  puts "theColor= $theColor node_type= $node_type  type_zrot= $type_zrot"
  foreach e $pointList {
    
    # need sequential type_zrot, zrot, yrot, xrot
    # XX later, add type_xrot and type_yrot if these are ever used
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad]]
    # negative type_zrot:
    set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z $type_zrot rad]]
    #set m [transaxis z $type_zrot rad]
    #set m [transaxis z 0 rad]
    set v [list [lindex $e 2] [lindex $e 3] [lindex $e 4]]
    set vr [coordtrans $m $v]
    #puts "vr = $vr, v 0 = [lindex $vr 0]"
    set l [list [lindex $e 0] [lindex $e 1] [lindex $vr 0]  [lindex $vr 1]   [lindex $vr 2]   [lindex $e 5]  [lindex $e 6]]
    #puts "rot show_morph_moved l= $l"
    lappend rotPointList $l
  } 
  set movedPointList ""
  foreach e $rotPointList {
    set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] + $x]  [expr [lindex $e 3] + $y] [expr [lindex $e 4] + $z] [lindex $e 5]  [lindex $e 6]] 
    #puts "moved show_morph_moved l= $l"
    lappend movedPointList $l
   } 
  set sphereList ""
  set radiusList ""
  set linenum 0
  foreach lineList $movedPointList {
    #puts "lineList=$lineList"
    #set enum 0
    #foreach e $lineList {
    #   if {$e < 0.0} {set e 0.0}
    #   set mat($linenum,$enum) [expr $e + 0.0]
    #   incr enum
    #} 
    #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 
    #puts "draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}  radius [lindex $lineList 5] resolution 6" 

    # XX sets color per sphere, so per component of neuron - make this a param setting 
    ## draw color [lindex $lineList 1] 

    #don't scale soma, increase res for soma 
    if {[lindex $lineList 1] == 1} then {
      set draw_radius_scale 1.0
      set sphereRes 12
      lappend sphereList "[list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]"
      lappend radiusList  [expr $draw_radius_scale * [lindex $lineList 5] ] 
    } else {
      set draw_radius_scale $radius_scale
      set sphereRes 4 
    } 
       
    
    #draw sphere [list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]  radius [expr $draw_radius_scale * [lindex $lineList 5] ] resolution  $sphereRes 
    ##lappend sphereList "[list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]"
    ##lappend radiusList  [expr $draw_radius_scale * [lindex $lineList 5] ] 
    #puts "$linenum: [lrange $radiusList 0 4], "
    #puts "[lrange $sphereList 0 4], "
    #draw sphere "{[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}"  radius [lindex $lineList 5] resolution 8
    #draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]} radius  [lindex $lineList 5] resolution 8" 
    incr linenum
  }
  draw spheretube "$sphereList" radii $radiusList drawtubes 0
  #draw spheretube "$sphereList" radii $radiusList drawtubes 1
} 

proc check { a } {return}

proc ::neuro::show_morph_moved_oldspheres {node_type x y z xrot yrot zrot radius_scale} {
  variable morphoHash
  variable typeHash
  set pointList $morphoHash($node_type)
  set rotPointList ""
  puts "yrot = $yrot"
  # do rotation here
  set c [expr $node_type % 32]
  draw color $c
  #draw color $theColor
  puts "in show_morph_moved_color, color set to $c"
  set type_zrot $typeHash(rot_zaxis,$node_type)
  puts "node_type= $node_type  type_zrot= $type_zrot"
  foreach e $pointList {
    
    # need sequential type_zrot, zrot, yrot, xrot
    # XX later, add type_xrot and type_yrot if these are ever used
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad]]
    # negative type_zrot:
    set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z $type_zrot rad]]
    #set m [transaxis z $type_zrot rad]
    #set m [transaxis z 0 rad]
    set v [list [lindex $e 2] [lindex $e 3] [lindex $e 4]]
    set vr [coordtrans $m $v]
    #puts "vr = $vr, v 0 = [lindex $vr 0]"
    set l [list [lindex $e 0] [lindex $e 1] [lindex $vr 0]  [lindex $vr 1]   [lindex $vr 2]   [lindex $e 5]  [lindex $e 6]]
    #puts "rot show_morph_moved l= $l"
    lappend rotPointList $l
  } 
  set movedPointList ""
  foreach e $rotPointList {
    set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] + $x]  [expr [lindex $e 3] + $y] [expr [lindex $e 4] + $z] [lindex $e 5]  [lindex $e 6]] 
    #puts "moved show_morph_moved l= $l"
    lappend movedPointList $l
   } 
  set sphereList ""
  set radiusList ""
  set linenum 0
  foreach lineList $movedPointList {
    #puts "lineList=$lineList"
    #set enum 0
    #foreach e $lineList {
    #   if {$e < 0.0} {set e 0.0}
    #   set mat($linenum,$enum) [expr $e + 0.0]
    #   incr enum
    #} 
    #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 
    #puts "draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}  radius [lindex $lineList 5] resolution 6" 

    # XX sets color per sphere, so per component of neuron - make this a param setting 
    ## draw color [lindex $lineList 1] 

    #don't scale soma, increase res for soma 
    if {[lindex $lineList 1] == 1} then {
      set draw_radius_scale 1.0
      set sphereRes 12
    } else {
      set draw_radius_scale $radius_scale
      set sphereRes 4 
    } 
       
    
    draw sphere [list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]  radius [expr $draw_radius_scale * [lindex $lineList 5] ] resolution  $sphereRes 
    #lappend sphereList "[list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]"
    #lappend radiusList  [expr $draw_radius_scale * [lindex $lineList 5] ] 
    #puts "$linenum: [lrange $radiusList 0 4], "
    #puts "[lrange $sphereList 0 4], "
    #draw sphere "{[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}"  radius [lindex $lineList 5] resolution 8
    #draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]} radius  [lindex $lineList 5] resolution 8" 
    incr linenum
  }
  #draw spheretube "$sphereList" radii $radiusList drawtubes 0
  #draw spheretube "$sphereList" radii $radiusList drawtubes 1
}

proc ::neuro::show_morph_moved_color_oldspheres {node_type x y z xrot yrot zrot radius_scale theColor} {
  variable morphoHash
  variable typeHash
  set pointList $morphoHash($node_type)
  set rotPointList ""
  puts "yrot = $yrot"
  # do rotation here
  #set c [expr $node_type % 32]
  draw color $theColor
  puts "in show_morph_moved_color, color set to $theColor"
  set type_zrot $typeHash(rot_zaxis,$node_type)
  puts "node_type= $node_type  type_zrot= $type_zrot"
  foreach e $pointList {
    
    # need sequential type_zrot, zrot, yrot, xrot
    # XX later, add type_xrot and type_yrot if these are ever used
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad]]
    # negative type_zrot:
    set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z $type_zrot rad]]
    #set m [transaxis z $type_zrot rad]
    #set m [transaxis z 0 rad]
    set v [list [lindex $e 2] [lindex $e 3] [lindex $e 4]]
    set vr [coordtrans $m $v]
    #puts "vr = $vr, v 0 = [lindex $vr 0]"
    set l [list [lindex $e 0] [lindex $e 1] [lindex $vr 0]  [lindex $vr 1]   [lindex $vr 2]   [lindex $e 5]  [lindex $e 6]]
    #puts "rot show_morph_moved l= $l"
    lappend rotPointList $l
  } 
  set movedPointList ""
  foreach e $rotPointList {
    set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] + $x]  [expr [lindex $e 3] + $y] [expr [lindex $e 4] + $z] [lindex $e 5]  [lindex $e 6]] 
    #puts "moved show_morph_moved l= $l"
    lappend movedPointList $l
   } 
  set sphereList ""
  set radiusList ""
  set linenum 0
  foreach lineList $movedPointList {
    #puts "lineList=$lineList"
    #set enum 0
    #foreach e $lineList {
    #   if {$e < 0.0} {set e 0.0}
    #   set mat($linenum,$enum) [expr $e + 0.0]
    #   incr enum
    #} 
    #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 
    #puts "draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}  radius [lindex $lineList 5] resolution 6" 

    # XX sets color per sphere, so per component of neuron - make this a param setting 
    ## draw color [lindex $lineList 1] 

    #don't scale soma, increase res for soma 
    if {[lindex $lineList 1] == 1} then {
      set draw_radius_scale 1.0
      set sphereRes 12
    } else {
      set draw_radius_scale $radius_scale
      set sphereRes 4 
    } 
       
    
    draw sphere [list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]  radius [expr $draw_radius_scale * [lindex $lineList 5] ] resolution  $sphereRes 
    #lappend sphereList "[list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]"
    #lappend radiusList  [expr $draw_radius_scale * [lindex $lineList 5] ] 
    #puts "$linenum: [lrange $radiusList 0 4], "
    #puts "[lrange $sphereList 0 4], "
    #draw sphere "{[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}"  radius [lindex $lineList 5] resolution 8
    #draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]} radius  [lindex $lineList 5] resolution 8" 
    incr linenum
  }
  #draw spheretube "$sphereList" radii $radiusList drawtubes 0
  #draw spheretube "$sphereList" radii $radiusList drawtubes 1
}

proc ::neuro::show_morph_moved_color {node_type x y z xrot yrot zrot radius_scale theColor} {
  variable morphoHash
  variable typeHash
  set pointList $morphoHash($node_type)
  set rotPointList ""
  puts "yrot = $yrot"
  # do rotation here
  #set c [expr $node_type % 32]
  draw color $theColor
  puts "in show_morph_moved_color, color set to $theColor"
  set type_zrot $typeHash(rot_zaxis,$node_type)
  puts "node_type= $node_type  type_zrot= $type_zrot"
  foreach e $pointList {
    
    # need sequential type_zrot, zrot, yrot, xrot
    # XX later, add type_xrot and type_yrot if these are ever used
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad]]
    # negative type_zrot:
    set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z $type_zrot rad]]
    #set m [transaxis z $type_zrot rad]
    #set m [transaxis z 0 rad]
    set v [list [lindex $e 2] [lindex $e 3] [lindex $e 4]]
    set vr [coordtrans $m $v]
    #puts "vr = $vr, v 0 = [lindex $vr 0]"
    set l [list [lindex $e 0] [lindex $e 1] [lindex $vr 0]  [lindex $vr 1]   [lindex $vr 2]   [lindex $e 5]  [lindex $e 6]]
    #puts "rot show_morph_moved l= $l"
    lappend rotPointList $l
  } 
  set movedPointList ""
  foreach e $rotPointList {
    set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] + $x]  [expr [lindex $e 3] + $y] [expr [lindex $e 4] + $z] [lindex $e 5]  [lindex $e 6]] 
    #puts "moved show_morph_moved l= $l"
    lappend movedPointList $l
   } 
  set sphereList ""
  set radiusList ""
  set linenum 0
  foreach lineList $movedPointList {
    #puts "lineList=$lineList"
    #set enum 0
    #foreach e $lineList {
    #   if {$e < 0.0} {set e 0.0}
    #   set mat($linenum,$enum) [expr $e + 0.0]
    #   incr enum
    #} 
    #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 
    #puts "draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}  radius [lindex $lineList 5] resolution 6" 

    # XX sets color per sphere, so per component of neuron - make this a param setting 
    ## draw color [lindex $lineList 1] 

    #don't scale soma, increase res for soma 
    if {[lindex $lineList 1] == 1} then {
      set draw_radius_scale 1.0
      set sphereRes 12
    } else {
      set draw_radius_scale $radius_scale
      set sphereRes 4 
    } 
       
    
    #draw sphere [list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]  radius [expr $draw_radius_scale * [lindex $lineList 5] ] resolution  $sphereRes 
    lappend sphereList "[list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]"
    lappend radiusList  [expr $draw_radius_scale * [lindex $lineList 5] ] 
    #puts "$linenum: [lrange $radiusList 0 4], "
    #puts "[lrange $sphereList 0 4], "
    #draw sphere "{[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}"  radius [lindex $lineList 5] resolution 8
    #draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]} radius  [lindex $lineList 5] resolution 8" 
    incr linenum
  }
  draw spheretube "$sphereList" radii $radiusList drawtubes 0
  #draw spheretube "$sphereList" radii $radiusList drawtubes 1
}

proc ::neuro::sphereList_morph_moved {node_type x y z xrot yrot zrot } {
  variable morphoHash
  variable typeHash
  set pointList $morphoHash($node_type)
  set rotPointList ""
  puts "yrot = $yrot"
  # do rotation here
  #don't set color
  #set c [expr $node_type % 32]
  #draw color $c
  #puts "in show_morph_moved, color set to $c"
  set type_zrot $typeHash(rot_zaxis,$node_type)
  puts "node_type= $node_type  type_zrot= $type_zrot"
  #note the corrective -type_zrot, not true for all data sets
  puts "transoffset $x $y $z =  [transoffset [list $x $y $z]]"
  set m [transmult  [transoffset [list $x $y $z]] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
  foreach e $pointList {
    
    # need sequential type_zrot, zrot, yrot, xrot
    # XX later, add type_xrot and type_yrot if these are ever used
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad]]
    # negative type_zrot:
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transoffset $x $y $z] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z $type_zrot rad]]
    #set m [transaxis z $type_zrot rad]
    #set m [transaxis z 0 rad]
    set v [list [lindex $e 2] [lindex $e 3] [lindex $e 4]]
    set vr [coordtrans $m $v]
    #puts "vr = $vr, v 0 = [lindex $vr 0]"
    set l [list [lindex $e 0] [lindex $e 1] [lindex $vr 0]  [lindex $vr 1]   [lindex $vr 2]   [lindex $e 5]  [lindex $e 6]]
    #puts "rot show_morph_moved l= $l"
    lappend rotPointList $l
  } 
  #set movedPointList ""
  #foreach e $rotPointList {
  #  set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] + $x]  [expr [lindex $e 3] + $y] [expr [lindex $e 4] + $z] [lindex $e 5]  [lindex $e 6]] 
  #  #puts "moved show_morph_moved l= $l"
  #  lappend movedPointList $l
  # } 
  set sphereList ""
  set radiusList ""
  set linenum 0
 
  #count spheres for XYZ file
  set sphereCount 0 
  foreach lineList $rotPointList {
    #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 

    # XX next line sets color per sphere, so per component of neuron - make this a param setting 
    ## draw color [lindex $lineList 1] 

    #don't scale soma, increase res for soma 
    #if {[lindex $lineList 1] == 1} then {
    #  set draw_radius_scale 1.0
    #  set sphereRes 12
    #} else {
    #  set draw_radius_scale $radius_scale
    #  set sphereRes 4 
    #} 
       
    
    #draw sphere [list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]  radius [expr $draw_radius_scale * [lindex $lineList 5] ] resolution  $sphereRes 
    lappend sphereList "[list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]"
    #lappend radiusList  [expr $draw_radius_scale * [lindex $lineList 5] ] 
    #puts "$linenum: [lrange $radiusList 0 4], "
    #puts "[lrange $sphereList 0 4], "
    #draw sphere "{[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}"  radius [lindex $lineList 5] resolution 8
    #draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]} radius  [lindex $lineList 5] resolution 8" 
    incr linenum
  }
  ##draw spheretube "$sphereList" radii $radiusList drawtubes 0
  #set sphereCount [llength $sphereList]
  #set fp [open $theFilename w]
  ##puts $theFile $sphereCount
  ##puts $theFile "Halo spheres - node type $node_type"
  #foreach e $sphereList {
  #  puts $theFile "CA [lindex $e 0] [lindex $e 1] [lindex $e 2]" 
  #} 
  ##close $fp
  #set haloMol [mol new $theFilename]
  #mol rename $haloMol "type_$node_type"
  #puts "added haloMol $haloMol"
  #set haloSel [atomselect $haloMol "all"]
  #$haloSel set radius $halo_radius 
  #mol modstyle 0 $haloMol QuickSurf 1.200000 1.700000 1.200000 1.000000 
  #mol modmaterial 0 $haloMol GlassBubble
  #mol modcolor 0 $haloMol ColorID $halo_color
  return $sphereList
}

proc ::neuro::halo_morph_moved {node_type x y z xrot yrot zrot radius_scale theFilename halo_radius halo_color halo_label} {
  variable morphoHash
  variable typeHash
  set pointList $morphoHash($node_type)
  set rotPointList ""
  puts "yrot = $yrot"
  # do rotation here
  #don't set color
  #set c [expr $node_type % 32]
  #draw color $c
  #puts "in show_morph_moved, color set to $c"
  set type_zrot $typeHash(rot_zaxis,$node_type)
  puts "node_type= $node_type  type_zrot= $type_zrot"
  #note the corrective -type_zrot, not true for all data sets
  puts "transoffset $x $y $z =  [transoffset [list $x $y $z]]"
  set m [transmult  [transoffset [list $x $y $z]] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
  foreach e $pointList {
    
    # need sequential type_zrot, zrot, yrot, xrot
    # XX later, add type_xrot and type_yrot if these are ever used
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad]]
    # negative type_zrot:
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transoffset $x $y $z] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z $type_zrot rad]]
    #set m [transaxis z $type_zrot rad]
    #set m [transaxis z 0 rad]
    set v [list [lindex $e 2] [lindex $e 3] [lindex $e 4]]
    set vr [coordtrans $m $v]
    #puts "vr = $vr, v 0 = [lindex $vr 0]"
    set l [list [lindex $e 0] [lindex $e 1] [lindex $vr 0]  [lindex $vr 1]   [lindex $vr 2]   [lindex $e 5]  [lindex $e 6]]
    #puts "rot show_morph_moved l= $l"
    lappend rotPointList $l
  } 
  #set movedPointList ""
  #foreach e $rotPointList {
  #  set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] + $x]  [expr [lindex $e 3] + $y] [expr [lindex $e 4] + $z] [lindex $e 5]  [lindex $e 6]] 
  #  #puts "moved show_morph_moved l= $l"
  #  lappend movedPointList $l
  # } 
  set sphereList ""
  set radiusList ""
  set linenum 0
 
  #count spheres for XYZ file
  set sphereCount 0 
  foreach lineList $rotPointList {
    #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 

    # XX next line sets color per sphere, so per component of neuron - make this a param setting 
    ## draw color [lindex $lineList 1] 

    #don't scale soma, increase res for soma 
    if {[lindex $lineList 1] == 1} then {
      set draw_radius_scale 1.0
      set sphereRes 12
    } else {
      set draw_radius_scale $radius_scale
      set sphereRes 4 
    } 
       
    
    #draw sphere [list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]  radius [expr $draw_radius_scale * [lindex $lineList 5] ] resolution  $sphereRes 
    lappend sphereList "[list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]"
    lappend radiusList  [expr $draw_radius_scale * [lindex $lineList 5] ] 
    #puts "$linenum: [lrange $radiusList 0 4], "
    #puts "[lrange $sphereList 0 4], "
    #draw sphere "{[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}"  radius [lindex $lineList 5] resolution 8
    #draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]} radius  [lindex $lineList 5] resolution 8" 
    incr linenum
  }
  ##draw spheretube "$sphereList" radii $radiusList drawtubes 0
  set sphereCount [llength $sphereList]
  set fp [open $theFilename w]
  puts $fp $sphereCount
  puts $fp "Halo spheres - node type $node_type"
  foreach e $sphereList {
    puts $fp "CA [lindex $e 0] [lindex $e 1] [lindex $e 2]" 
  }
  close $fp
  set haloMol [mol new $theFilename]
  mol rename $haloMol "$halo_label"
  puts "added haloMol $haloMol"
  set haloSel [atomselect $haloMol "all"]
  $haloSel set radius $halo_radius 
  mol modstyle 0 $haloMol QuickSurf 1.200000 1.700000 1.200000 1.000000 
  mol modmaterial 0 $haloMol GlassBubble
  mol modcolor 0 $haloMol ColorID $halo_color

}

proc ::neuro::sphereList_morph_moved_soma_only {node_type x y z xrot yrot zrot soma_radius_scale} {
  variable morphoHash
  variable typeHash
  #set pointList $morphoHash($node_type)
  #set rotPointList ""
  #puts "yrot = $yrot"
  # do rotation here
  #don't set color
  #set c [expr $node_type % 32]
  #draw color $c
  #puts "in show_morph_moved, color set to $c"
  #set type_zrot $typeHash(rot_zaxis,$node_type)
  #puts "node_type= $node_type  type_zrot= $type_zrot"
  #note the corrective -type_zrot, not true for all data sets
  #puts "transoffset $x $y $z =  [transoffset [list $x $y $z]]"
  #set m [transmult  [transoffset [list $x $y $z]] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
   
  #foreach e $pointList {
    
    # need sequential type_zrot, zrot, yrot, xrot
    # XX later, add type_xrot and type_yrot if these are ever used
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad]]
    # negative type_zrot:
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transoffset $x $y $z] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z $type_zrot rad]]
    #set m [transaxis z $type_zrot rad]
    #set m [transaxis z 0 rad]
    #set v [list [lindex $e 2] [lindex $e 3] [lindex $e 4]]
    #.set vr [coordtrans $m $v]
    #puts "vr = $vr, v 0 = [lindex $vr 0]"
    #set l [list [lindex $e 0] [lindex $e 1] [lindex $vr 0]  [lindex $vr 1]   [lindex $vr 2]   [lindex $e 5]  [lindex $e 6]]
    #puts "rot show_morph_moved l= $l"
    #lappend rotPointList $l
  #} 
  #set movedPointList ""
  #foreach e $rotPointList {
  #  set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] + $x]  [expr [lindex $e 3] + $y] [expr [lindex $e 4] + $z] [lindex $e 5]  [lindex $e 6]] 
  #  #puts "moved show_morph_moved l= $l"
  #  lappend movedPointList $l
  # } 
  set sphereList ""
  set radiusList ""
  set linenum 0
  #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 

  # XX next line sets color per sphere, so per component of neuron - make this a param setting 
  ## draw color [lindex $lineList 1] 

  #don't scale soma, increase res for soma 
  set draw_radius_scale $soma_radius_scale
  draw spheretube "{ $x $y $z }" radii "{ $soma_radius_scale }" drawtubes 0
  #draw spheretube "$sphereList" radii $radiusList drawtubes 1
}

proc ::neuro::show_morph_moved_soma_only_color_rgb {node_type x y z r g b soma_radius} {
  draw spheretube "{ $x $y $z }" radii "{ $soma_radius }" color "{ $r $g $b}" drawtubes 0
  #draw spheretube "$sphereList" radii $radiusList drawtubes 1
}


proc ::neuro::proto_show_morph_moved_soma_only {node_type x y z xrot yrot zrot soma_radius_scale givenRes} {
  #variable morphoHash
  variable typeHash
  #set pointList $morphoHash($node_type)
  #set rotPointList ""
  #puts "yrot = $yrot"
  # do rotation here
  #don't set color
  #set c [expr $node_type % 32]
  #draw color $c
  #puts "in show_morph_moved, color set to $c"
  #set type_zrot $typeHash(rot_zaxis,$node_type)
  #puts "node_type= $node_type  type_zrot= $type_zrot"
  #note the corrective -type_zrot, not true for all data sets
  #puts "transoffset $x $y $z =  [transoffset [list $x $y $z]]"
  #set m [transmult  [transoffset [list $x $y $z]] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
   
  #foreach e $pointList {
    
    # need sequential type_zrot, zrot, yrot, xrot
    # XX later, add type_xrot and type_yrot if these are ever used
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad]]
    # negative type_zrot:
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transoffset $x $y $z] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z $type_zrot rad]]
    #set m [transaxis z $type_zrot rad]
    #set m [transaxis z 0 rad]
    #set v [list [lindex $e 2] [lindex $e 3] [lindex $e 4]]
    #.set vr [coordtrans $m $v]
    #puts "vr = $vr, v 0 = [lindex $vr 0]"
    #set l [list [lindex $e 0] [lindex $e 1] [lindex $vr 0]  [lindex $vr 1]   [lindex $vr 2]   [lindex $e 5]  [lindex $e 6]]
    #puts "rot show_morph_moved l= $l"
    #lappend rotPointList $l
  #} 
  #set movedPointList ""
  #foreach e $rotPointList {
  #  set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] + $x]  [expr [lindex $e 3] + $y] [expr [lindex $e 4] + $z] [lindex $e 5]  [lindex $e 6]] 
  #  #puts "moved show_morph_moved l= $l"
  #  lappend movedPointList $l
  # } 
  set sphereList ""
  set radiusList ""
  set linenum 0
  #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 

  # XX next line sets color per sphere, so per component of neuron - make this a param setting 
  ## draw color [lindex $lineList 1] 

  #don't scale soma, increase res for soma 
  set draw_radius_scale $soma_radius_scale
  draw spheretube "{ $x $y $z }" radii "{ $soma_radius_scale }" drawtubes 0 resolution $givenRes
  #draw spheretube "$sphereList" radii $radiusList drawtubes 1
}

proc ::neuro::proto_show_morph_moved_swc_segment {node_type x y z xrot yrot zrot radius_scale swc_segment} {
  #variable morphoHash
  variable typeHash
  set pointList [proto_retrieve_morphology $node_type ]
  set rotPointList ""
  puts "yrot = $yrot"
  # do rotation here
  #don't set color
  #set c [expr $node_type % 32]
  #draw color $c
  #puts "in show_morph_moved, color set to $c"
  set type_zrot $typeHash(rot_zaxis,$node_type)
  puts "node_type= $node_type  type_zrot= $type_zrot"
  #note the corrective -type_zrot, not true for all data sets
  puts "transoffset $x $y $z =  [transoffset [list $x $y $z]]"
  set m [transmult  [transoffset [list $x $y $z]] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
  #set pointcount 0

  foreach e $pointList {
    # need sequential type_zrot, zrot, yrot, xrot
    # XX later, add type_xrot and type_yrot if these are ever used
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad]]
    # negative type_zrot:
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transoffset $x $y $z] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z $type_zrot rad]]
    #set m [transaxis z $type_zrot rad]
    #set m [transaxis z 0 rad]
    set id [lindex $e 0]
    set v [list [lindex $e 2] [lindex $e 3] [lindex $e 4]]
    set vr [coordtrans $m $v]
    #puts "vr = $vr, v 0 = [lindex $vr 0]"
    set l [list [lindex $e 0] [lindex $e 1] [lindex $vr 0]  [lindex $vr 1]   [lindex $vr 2]   [lindex $e 5]  [lindex $e 6]]
    #puts "rot show_morph_moved l= $l"
    if {$swc_segment == $id} {lappend rotPointList $l}
    #incr pointcount
  } 
  #set movedPointList ""
  #foreach e $rotPointList {
  #  set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] + $x]  [expr [lindex $e 3] + $y] [expr [lindex $e 4] + $z] [lindex $e 5]  [lindex $e 6]] 
  #  #puts "moved show_morph_moved l= $l"
  #  lappend movedPointList $l
  # } 
  set sphereList ""
  set radiusList ""
  set linenum 0
  foreach lineList $rotPointList {
    #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 

    # XX next line sets color per sphere, so per component of neuron - make this a param setting 
    ## draw color [lindex $lineList 1] 

    #don't scale soma, increase res for soma 
    if {[lindex $lineList 1] == 1} then {
      set draw_radius_scale 1.0
      set sphereRes 12
      set theRad [expr $radius_scale * $draw_radius_scale  ] 
    } else {
      set draw_radius_scale $radius_scale
      set sphereRes 4 
      #set theRad [expr $draw_radius_scale * [lindex $lineList 5] ] 
      set theRad 10
    } 
      if {$theRad>$radius_scale} {puts "$theRad";set $theRad $radius_scale}   
      lappend radiusList $theRad 
    
    #draw sphere [list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]  radius [expr $draw_radius_scale * [lindex $lineList 5] ] resolution  $sphereRes 
    lappend sphereList "[list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]"
    ##lappend radiusList  [expr $draw_radius_scale * [lindex $lineList 5] ] 
    #puts "$linenum: [lrange $radiusList 0 4], "
    #puts "[lrange $sphereList 0 4], "
    #draw sphere "{[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}"  radius [lindex $lineList 5] resolution 8
    #draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]} radius  [lindex $lineList 5] resolution 8" 
    incr linenum
  }
  draw spheretube "$sphereList" radii $radiusList drawtubes 0
  #draw spheretube "$sphereList" radii $radiusList drawtubes 1
}
proc ::neuro::proto_show_morph_moved {node_type x y z xrot yrot zrot radius_scale} {
  #variable morphoHash
  variable typeHash
  variable debugMode
  set pointList [proto_retrieve_morphology $node_type ]
  set rotPointList ""

  # do rotation here
  #don't set color
  #set c [expr $node_type % 32]
  #draw color $c
  #puts "in show_morph_moved, color set to $c"
  set type_zrot $typeHash(rot_zaxis,$node_type)
  if {$debugMode} {  
    puts "yrot = $yrot"
    puts "node_type= $node_type  type_zrot= $type_zrot"
  #note the corrective -type_zrot, not true for all data sets
    puts "transoffset $x $y $z =  [transoffset [list $x $y $z]]"
  }
  set m [transmult  [transoffset [list $x $y $z]] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
  foreach e $pointList {
    
    # need sequential type_zrot, zrot, yrot, xrot
    # XX later, add type_xrot and type_yrot if these are ever used
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad]]
    # negative type_zrot:
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transoffset $x $y $z] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z $type_zrot rad]]
    #set m [transaxis z $type_zrot rad]
    #set m [transaxis z 0 rad]
    set v [list [lindex $e 2] [lindex $e 3] [lindex $e 4]]
    set vr [coordtrans $m $v]
    #puts "vr = $vr, v 0 = [lindex $vr 0]"
    set l [list [lindex $e 0] [lindex $e 1] [lindex $vr 0]  [lindex $vr 1]   [lindex $vr 2]   [lindex $e 5]  [lindex $e 6]]
    #puts "rot show_morph_moved l= $l"
    lappend rotPointList $l
  } 
  #set movedPointList ""
  #foreach e $rotPointList {
  #  set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] + $x]  [expr [lindex $e 3] + $y] [expr [lindex $e 4] + $z] [lindex $e 5]  [lindex $e 6]] 
  #  #puts "moved show_morph_moved l= $l"
  #  lappend movedPointList $l
  # } 
  set sphereList ""
  set radiusList ""
  set linenum 0
  foreach lineList $rotPointList {
    #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 

    # XX next line sets color per sphere, so per component of neuron - make this a param setting 
    ## draw color [lindex $lineList 1] 

    #don't scale soma, increase res for soma 
    if {[lindex $lineList 1] == 1} then {
      set draw_radius_scale 1.0
      set sphereRes 12
      set theRad [expr $radius_scale * $draw_radius_scale  ] 
    } else {
      set draw_radius_scale $radius_scale
      set sphereRes 4 
      set theRad [expr $draw_radius_scale * [lindex $lineList 5] ] 
    } 
      if {$theRad>$radius_scale} {
        if {$debugMode} {puts "$theRad"}
        set $theRad $radius_scale
      }   
      lappend radiusList $theRad 
    
    #draw sphere [list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]  radius [expr $draw_radius_scale * [lindex $lineList 5] ] resolution  $sphereRes 
    lappend sphereList "[list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]"
    ##lappend radiusList  [expr $draw_radius_scale * [lindex $lineList 5] ] 
    #puts "$linenum: [lrange $radiusList 0 4], "
    #puts "[lrange $sphereList 0 4], "
    #draw sphere "{[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}"  radius [lindex $lineList 5] resolution 8
    #draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]} radius  [lindex $lineList 5] resolution 8" 
    incr linenum
  }
  draw spheretube "$sphereList" radii $radiusList drawtubes 0
  #draw spheretube "$sphereList" radii $radiusList drawtubes 1
}

proc ::neuro::show_morph_moved {node_type x y z xrot yrot zrot radius_scale} {
  variable morphoHash
  variable typeHash
  set pointList $morphoHash($node_type)
  set rotPointList ""
  puts "yrot = $yrot"
  # do rotation here
  #don't set color
  #set c [expr $node_type % 32]
  #draw color $c
  #puts "in show_morph_moved, color set to $c"
  set type_zrot $typeHash(rot_zaxis,$node_type)
  puts "node_type= $node_type  type_zrot= $type_zrot"
  #note the corrective -type_zrot, not true for all data sets
  puts "transoffset $x $y $z =  [transoffset [list $x $y $z]]"
  set m [transmult  [transoffset [list $x $y $z]] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
  foreach e $pointList {
    
    # need sequential type_zrot, zrot, yrot, xrot
    # XX later, add type_xrot and type_yrot if these are ever used
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad]]
    # negative type_zrot:
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transoffset $x $y $z] [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    #set m [transmult  [transaxis x $xrot rad ] [transaxis y $yrot rad] [transaxis z $zrot rad] [transaxis z $type_zrot rad]]
    #set m [transaxis z $type_zrot rad]
    #set m [transaxis z 0 rad]
    set v [list [lindex $e 2] [lindex $e 3] [lindex $e 4]]
    set vr [coordtrans $m $v]
    #puts "vr = $vr, v 0 = [lindex $vr 0]"
    set l [list [lindex $e 0] [lindex $e 1] [lindex $vr 0]  [lindex $vr 1]   [lindex $vr 2]   [lindex $e 5]  [lindex $e 6]]
    #puts "rot show_morph_moved l= $l"
    lappend rotPointList $l
  } 
  #set movedPointList ""
  #foreach e $rotPointList {
  #  set l [list [lindex $e 0] [lindex $e 1] [expr [lindex $e 2] + $x]  [expr [lindex $e 3] + $y] [expr [lindex $e 4] + $z] [lindex $e 5]  [lindex $e 6]] 
  #  #puts "moved show_morph_moved l= $l"
  #  lappend movedPointList $l
  # } 
  set sphereList ""
  set radiusList ""
  set linenum 0
  foreach lineList $rotPointList {
    #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 

    # XX next line sets color per sphere, so per component of neuron - make this a param setting 
    ## draw color [lindex $lineList 1] 

    #don't scale soma, increase res for soma 
    if {[lindex $lineList 1] == 1} then {
      set draw_radius_scale 1.0
      set sphereRes 12
      set theRad [expr $radius_scale * $draw_radius_scale  ] 
    } else {
      set draw_radius_scale $radius_scale
      set sphereRes 4 
      set theRad [expr $draw_radius_scale * [lindex $lineList 5] ] 
    } 
      if {$theRad>$radius_scale} {puts "$theRad";set $theRad $radius_scale}   
      lappend radiusList $theRad 
    
    #draw sphere [list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]  radius [expr $draw_radius_scale * [lindex $lineList 5] ] resolution  $sphereRes 
    lappend sphereList "[list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]"
    ##lappend radiusList  [expr $draw_radius_scale * [lindex $lineList 5] ] 
    #puts "$linenum: [lrange $radiusList 0 4], "
    #puts "[lrange $sphereList 0 4], "
    #draw sphere "{[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}"  radius [lindex $lineList 5] resolution 8
    #draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]} radius  [lindex $lineList 5] resolution 8" 
    incr linenum
  }
  draw spheretube "$sphereList" radii $radiusList drawtubes 0
  #draw spheretube "$sphereList" radii $radiusList drawtubes 1
}


proc ::neuro::show_morph {node_type radius_scale} {
  variable morphoHash
  foreach lineList $morphoHash($node_type) {
    #puts "lineList=$lineList"
    #set enum 0
    #foreach e $lineList {
    #   if {$e < 0.0} {set e 0.0}
    #   set mat($linenum,$enum) [expr $e + 0.0]
    #   incr enum
    #} 
    #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 
    #puts "draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}  radius [lindex $lineList 5] resolution 6" 
     
    draw color [lindex $lineList 1] 
    #don't scale soma 
    if {[lindex $lineList 1] == 1} then {
      set draw_radius_scale 1.0
    } else {
      set draw_radius_scale $radius_scale
    } 
       
    
    draw sphere [list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]  radius [expr $draw_radius_scale * [lindex $lineList 5] ] resolution 12 

    #draw sphere "{[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}"  radius [lindex $lineList 5] resolution 8
    #draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]} radius  [lindex $lineList 5] resolution 8" 
    incr linenum
  }
}




proc ::neuro::read_swc {filename radius_scale} {
  set fp [open $filename r]
  set linenum 0
  while { [gets $fp myline] >=0} {
  #puts "linenum= $linenum; DATA: >$myline<"
      #skip comments
      if {[string first \# $myline] != 0} {
        set lineList [split $myline]
        #set enum 0
        #foreach e $lineList {
        #   if {$e < 0.0} {set e 0.0}
        #   set mat($linenum,$enum) [expr $e + 0.0]
        #   incr enum
        #} 
        #puts "1:[lindex $lineList 2] 2:[lindex $lineList 3] 3:[lindex $lineList 4]  4:[lindex $lineList 5]" 
        #puts "draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}  radius [lindex $lineList 5] resolution 6" 
         
        draw color [lindex $lineList 1] 
        #don't scale soma 
        if {[lindex $lineList 1] == 1} then {
          set draw_radius_scale 1.0
        } else {
          set draw_radius_scale $radius_scale
        } 
           

        draw sphere [list [lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4] ]  radius [expr $draw_radius_scale * [lindex $lineList 5] ] resolution 12 

        #draw sphere "{[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]}"  radius [lindex $lineList 5] resolution 8
        #draw sphere {[lindex $lineList 2] [lindex $lineList 3] [lindex $lineList 4]} radius  [lindex $lineList 5] resolution 8" 
        incr linenum
    }
  }
  #set matSize $linenum
  #puts "mat(0,0)=$mat(0,0), matSize= $matSize"
  close $fp
}

proc ::neuro::read_store_spike_csv {filenamestart filenameend} {
  variable spikeList
  set spikecsvfilename "${filenamestart}${filenameend}"
  set spikeList ""
  #add zero-fill vectors at length of idv above for any empty file names
  set thefile [open $spikecsvfilename r]
  while { [gets $thefile myline] >=0} {
    set vec [split $myline]
    #store as: node_id spiketime (gid can work for node_id sometimes, but makes assimptions, depdnds how used, see SONATA gid discussion on web)
    set e [list [lindex $vec 1] [lindex $vec 0]] 
    lappend spikeList $e
  }
  close $thefile
   
  set spikeList [lsort -real -index 1 $spikeList] 
  puts "spikeList has [llength $spikeList] elements"
  return
}

proc ::neuro::read_store_spike {filenamestart filenameend} {
  variable spikeList
  set spikefilename "${filenamestart}timestamps${filenameend}"
  set idfilename "${filenamestart}node_ids${filenameend}"
  #add zero-fill vectors at length of idv above for any empty file names
  foreach vec {idv spiketimev} fn {idfilename spikefilename} {
    set thefilename [set $fn]
    puts "vec= $vec thefilename= $thefilename"
    if {$thefilename != ""} {
      #XX exit with error if idfilename
      #XX count idv size when it is made, then make idv-long zero-fill here
      puts "opened $thefilename"
      set thefile [open $thefilename r]
      # XXX change so works for something that is not last line in file
      while { [gets $thefile myline] >=0} {
        set $vec [split $myline]
      }
      close $thefile
   }
  }

  #XX only show yrot so far, add zero-fill compensators at length of idv above for any empty
  set spikeList ""
  foreach eid $idv espiketime $spiketimev {
    #XX FIX with zero filling so can handle absent rots
    set e [list $eid $espiketime]
    
    lappend spikeList $e
  }
  set spikeList [lsort -real -index 1 $spikeList] 
  puts "spikeList has [llength $spikeList] elements"
  return
} 

proc ::neuro::show_spike_timing_morph_from_list_render {start end filenamestart filenameend rotinc subsetNodeIdList stride windowSize molidForGraphics waitTime {rad_scale 4} } {
  set theFrame 0
  mol top $molidForGraphics
  variable spikeList
  variable node
  puts "length spikeList is [llength $spikeList]"
  set invWinSizeIncr [expr 1.0 / ($windowSize + 1)]               
  for {set t $start} {$t<=$end} {set t [expr $t + $stride]} {
    set rangeEnd [expr $t + $windowSize]
    #puts "$t rangeEnd = $rangeEnd" 
    set showList ""
    set fadeList ""
    foreach e $spikeList {
      set val [lindex $e 1]
      set spikeNodeId [lindex $e 0]
      if {($val>=$t) && ($val<=$rangeEnd)} {
        #puts "t=$t, val=$val  rangeEnd= $rangeEnd"
        foreach theId $subsetNodeIdList {
          if {$spikeNodeId == $theId} {
            lappend showList $e 
            lappend fadeList [expr  1 - (($start - $t) * $invWinSizeIncr) ]
            # linear scale for alpha, 1.0 at time t, scaled so smoothly to 0 at $windowsize +1] 
          }
        }
      }
    } 
    display update off
    draw delete all
    puts "Range $t to $rangeEnd  length showList= [llength $showList]" 
    foreach e $showList {
      set n [lindex $e 0]
      set p $node($n)
      #puts "p= $p"
      set c [expr [lindex $p 6] % 32 ] 
      #draw color $c
      #force to white
      draw color 8 

      #puts "show_morph_moved [lindex $p 6] [lindex $p 0] [lindex $p 1] [lindex $p 2]  [lindex $p 3] [lindex $p 4] [lindex $p 5]  3"
      show_morph_moved [lindex $p 6] [lindex $p 0] [lindex $p 1] [lindex $p 2]  [lindex $p 3] [lindex $p 4] [lindex $p 5] $rad_scale 
      #draw sphere [list [lindex $p 0] [lindex $p 1] [lindex $p 2]] radius 8 resolution 12
    }
    display update on
    display update
    set fname "$filenamestart[format %05d $theFrame]$filenameend"
    render TachyonLOptiXInternal $fname  
    incr theFrame
    rotate y by $rotinc
    after $waitTime
  }
}

proc ::neuro::show_spike_timing_morph_from_list {start end subsetNodeIdList stride windowSize molidForGraphics waitTime {rad_scale 4}} {
  mol top $molidForGraphics
  variable spikeList
  variable node
  puts "length spikeList is [llength $spikeList]"
  set invWinSizeIncr [expr 1.0 / ($windowSize + 1)]               
  for {set t $start} {$t<=$end} {set t [expr $t + $stride]} {
    set rangeEnd [expr $t + $windowSize]
    #puts "$t rangeEnd = $rangeEnd" 
    set showList ""
    set fadeList ""
    foreach e $spikeList {
      set val [lindex $e 1]
      set spikeNodeId [lindex $e 0]
      if {($val>=$t) && ($val<=$rangeEnd)} {
        #puts "t=$t, val=$val  rangeEnd= $rangeEnd"
        foreach theId $subsetNodeIdList {
          if {$spikeNodeId == $theId} {
            lappend showList $e 
            lappend fadeList [expr  1 - (($start - $t) * $invWinSizeIncr) ]
            # linear scale for alpha, 1.0 at time t, scaled so smoothly to 0 at $windowsize +1] 
          }
        }
      }
    } 
    display update off
    draw delete all
    puts "Range $t to $rangeEnd  length showList= [llength $showList]" 
    foreach e $showList {
      set n [lindex $e 0]
      set p $node($n)
      #puts "p= $p"
      set c [expr [lindex $p 6] % 32 ] 
      #draw color $c
      #force to white
      draw color 8 

      #puts "show_morph_moved [lindex $p 6] [lindex $p 0] [lindex $p 1] [lindex $p 2]  [lindex $p 3] [lindex $p 4] [lindex $p 5]  3"
      show_morph_moved [lindex $p 6] [lindex $p 0] [lindex $p 1] [lindex $p 2]  [lindex $p 3] [lindex $p 4] [lindex $p 5] $rad_scale
      #draw sphere [list [lindex $p 0] [lindex $p 1] [lindex $p 2]] radius 8 resolution 12
    }
    display update on
    display update
    after $waitTime
  }
}

proc ::neuro::halo_spike_timing_morph_from_list {start end subsetNodeIdList stride windowSize molidForGraphics waitTime halo_radius halo_color halo_label} {
  mol top $molidForGraphics
  variable spikeList
  variable node
  puts "length spikeList is [llength $spikeList]"
  set invWinSizeIncr [expr 1.0 / ($windowSize + 1)]               
  for {set t $start} {$t<=$end} {set t [expr $t + $stride]} {
    set rangeEnd [expr $t + $windowSize]
    #puts "$t rangeEnd = $rangeEnd" 
    set showList ""
    set fadeList ""
    foreach e $spikeList {
      set val [lindex $e 1]
      set spikeNodeId [lindex $e 0]
      if {($val>=$t) && ($val<=$rangeEnd)} {
        #puts "t=$t, val=$val  rangeEnd= $rangeEnd"
        foreach theId $subsetNodeIdList {
          if {$spikeNodeId == $theId} {
            lappend showList $e 
            lappend fadeList [expr  1 - (($start - $t) * $invWinSizeIncr) ]
            # linear scale for alpha, 1.0 at time t, scaled so smoothly to 0 at $windowsize +1] 
          }
        }
      }
    } 
    display update off
    draw delete all
    puts "Range $t to $rangeEnd  length showList= [llength $showList]" 
    foreach e $showList {
      set n [lindex $e 0]
      set p $node($n)
      #puts "p= $p"
      set c [expr [lindex $p 6] % 32 ] 
      #draw color $c
      #force to white
      draw color 8 

      #puts "show_morph_moved [lindex $p 6] [lindex $p 0] [lindex $p 1] [lindex $p 2]  [lindex $p 3] [lindex $p 4] [lindex $p 5]  3"
      halo_morph_moved [lindex $p 6] [lindex $p 0] [lindex $p 1] [lindex $p 2]  [lindex $p 3] [lindex $p 4] [lindex $p 5] 3   "/tmp/out.xyz" $halo_radius $halo_color $halo_label
      #draw sphere [list [lindex $p 0] [lindex $p 1] [lindex $p 2]] radius 8 resolution 12
    }
    display update on
    display update
    after $waitTime
  }
}

proc ::neuro::show_spike_timing_from_list {start end subsetNodeIdList stride windowSize molidForGraphics waitTime} {
  mol top $molidForGraphics
  variable spikeList
  variable node
  puts "length spikeList is [llength $spikeList]"
  set invWinSizeIncr [expr 1.0 / ($windowSize + 1)]               
  for {set t $start} {$t<=$end} {set t [expr $t + $stride]} {
    set rangeEnd [expr $t + $windowSize]
    #puts "$t rangeEnd = $rangeEnd" 
    set showList ""
    set fadeList ""
    foreach e $spikeList {
      set val [lindex $e 1]
      set spikeNodeId [lindex $e 0]
      if {($val>=$t) && ($val<=$rangeEnd)} {
        #puts "t=$t, val=$val  rangeEnd= $rangeEnd"
        foreach theId $subsetNodeIdList {
          if {$spikeNodeId == $theId} {
            lappend showList $e 
            lappend fadeList [expr  1 - (($start - $t) * $invWinSizeIncr) ]
            # linear scale for alpha, 1.0 at time t, scaled so smoothly to 0 at $windowsize +1] 
          }
        }
      }
    } 
    display update off
    draw delete all
    puts "Range $t to $rangeEnd  length showList= [llength $showList]" 
    foreach e $showList {
      set n [lindex $e 0]
      set p $node($n)
      #puts "p= $p"
      set c [expr [lindex $p 6] % 32 ] 
      #draw color $c
      #force to white
      draw color 8 
      draw sphere [list [lindex $p 0] [lindex $p 1] [lindex $p 2]] radius 8 resolution 12
    }
    display update on
    display update
    after $waitTime
  }
}


proc ::neuro::show_spike_timing {start end stride windowSize molidForGraphics waitTime} {
  mol top $molidForGraphics
  variable spikeList
  variable node
  puts "length spikeList is [llength $spikeList]"
  set invWinSizeIncr [expr 1.0 / ($windowSize + 1)]               
  for {set t $start} {$t<=$end} {set t [expr $t + $stride]} {
    set rangeEnd [expr $t + $windowSize]
    #puts "$t rangeEnd = $rangeEnd" 
    set showList ""
    set fadeList ""
    foreach e $spikeList {
      set val [lindex $e 1]
      if {($val>=$t) && ($val<=$rangeEnd)} {
        #puts "t=$t, val=$val  rangeEnd= $rangeEnd"
        lappend showList $e
        # linear scale for alpha, 1.0 at time t, scaled so smoothly to 0 at $windowsize +1] 
        lappend fadeList [expr  1 - (($start - $t) * $invWinSizeIncr) ]
      }
    } 
    display update off
    draw delete all
    puts "Range $t to $rangeEnd  length showList= [llength $showList]" 
    foreach e $showList {
      set n [lindex $e 0]
      set p $node($n)
      #puts "p= $p"
      set c [expr [lindex $p 6] % 32 ] 
      draw color $c
      draw sphere [list [lindex $p 0] [lindex $p 1] [lindex $p 2]] radius 8 resolution 12
    }
    display update on
    display update
    after $waitTime
  }
}

proc ::neuro::read_store_nodes_singlecol {filenamestart filenameend y_rot_only} {
   # needs output from h5dump with "-w 1" for isngle column mode
  variable node
  variable morphoHash 
  variable nodeIdList
  set xfilename "${filenamestart}x${filenameend}"
  set yfilename "${filenamestart}y${filenameend}"
  set zfilename "${filenamestart}z${filenameend}"
  set typefilename "${filenamestart}node_type${filenameend}"
  set idfilename "${filenamestart}node_id${filenameend}"
  set xaxisfilename "${filenamestart}rotation_angle_xaxis${filenameend}"
  set yaxisfilename "${filenamestart}rotation_angle_yaxis${filenameend}"
  set zaxisfilename "${filenamestart}rotation_angle_zaxis${filenameend}"

  
  if {$y_rot_only} {
    set xaxisfilename ""
    set zaxisfilename ""
   
  } else {
    set xaxisfilename "${filenamestart}rotation_angle_xaxis${filenameend}"
    set zaxisfilename "${filenamestart}rotation_angle_zaxis${filenameend}"
  }
  #override for soma-only (make a param?) 
  #set yfilename "" 
  #set zfilename "" 
  set xaxisfilename "" 
  set yaxisfilename "" 
  set zaxisfilename "" 
 
  foreach vec {idv xv yv zv xrotv yrotv zrotv typev} fn {idfilename xfilename yfilename zfilename xaxisfilename yaxisfilename zaxisfilename typefilename} {
    set thefilename [set $fn]
    puts "vec= $vec thefilename= $thefilename"
    if {$thefilename != ""} {
      #count idfilename vector size, this file is read before all others
      set thefile [open $thefilename r]
      #discard first five lines
      for {set i 0} {$i<5} {incr i} {
        gets $thefile myline
      }
      set inputList ""
      while { [gets $thefile myline] >=0} {
        #set $vec [split $myline]
        set e [lindex [split $myline { ,}] 4]
        #assumes can never have empty entry
        if {$e != ""} {
         lappend inputList $e 
        } else {
          break
        }
      }

      set $vec $inputList
      puts "set $vec,  length= [llength [set $vec]]"
      if {$vec == "idv"} {
        set vecLength [llength $idv]
        puts "read_store_nodes_singlecol vec is $vec   vecLength = $vecLength"
      }
      close $thefile
    } else {
      #XX add better error check for idv
      #exit with error if no idv, thus no idfilename 
      if {$vec == "idv"} {
        puts "ERROR: read_store_nodes needs id file name"
        return
      }
      # populate with zeroes if corresponding file not preset
      for {set i 0} {$i<$vecLength} {incr i} {
        lappend $vec 0
      }
      puts "set $vec to 0 vector with length [llength [set $vec]]"
    }
  } 
 # now assign to nodes 
  set nodeIdList ""
  foreach eid $idv ex $xv ey $yv ez $zv exrot $xrotv eyrot $yrotv  ezrot $zrotv etype $typev {
    ##XX FIX with zero filling so can handle absent rots
    ##set exrot 0
    ##set ezrot 0
    set node($eid) [list $ex $ey $ez $exrot $eyrot $ezrot $etype]
    
    lappend nodeIdList $eid
  }
  
} 


proc ::neuro::read_store_nodes {filenamestart filenameend y_rot_only} {
  variable node
  variable morphoHash 
  variable nodeIdList
  set xfilename "${filenamestart}x${filenameend}"
  set yfilename "${filenamestart}y${filenameend}"
  set zfilename "${filenamestart}z${filenameend}"
  set typefilename "${filenamestart}node_type${filenameend}"
  set idfilename "${filenamestart}node_id${filenameend}"
  set xaxisfilename "${filenamestart}rotation_angle_xaxis${filenameend}"
  set yaxisfilename "${filenamestart}rotation_angle_yaxis${filenameend}"
  set zaxisfilename "${filenamestart}rotation_angle_zaxis${filenameend}"
  if {$y_rot_only} {
    set xaxisfilename ""
    set zaxisfilename ""
   
  } else {
    set xaxisfilename "${filenamestart}rotation_angle_xaxis${filenameend}"
    set zaxisfilename "${filenamestart}rotation_angle_zaxis${filenameend}"
  }
  #XX only show yrot so far, add zero-fill compensators at length of idv above for any empty file names
  foreach vec {idv xv yv zv xrotv yrotv zrotv typev} fn {idfilename xfilename yfilename zfilename xaxisfilename yaxisfilename zaxisfilename typefilename} {
    set thefilename [set $fn]
    puts "vec= $vec thefilename= $thefilename"
    if {$thefilename != ""} {
      #count idfilename vector size, this file is read before all others
      set thefile [open $thefilename r]
      # XXX change so works for entries that are not last line in file
      while { [gets $thefile myline] >=0} {
        set $vec [split $myline]
      }
      if {$vec == "idv"} {
        set vecLength [llength $idv]
        puts "read_store_nodes vecLength = $vecLength"
      }
      close $thefile
    } else {
      #XX add better error check for idv
      #exit with error if no idv, thus no idfilename 
      if {$vec == "idv"} {
        puts "ERROR: read_store_nodes needs id file name"
        return
      }
      for {set i 0} {$i<$vecLength} {incr i} {
        lappend $vec 0
      }
      puts "set $vec to 0 vector with length [llength [set $vec]]"
    }
  } 
 # now assign to nodes 
  set nodeIdList ""
  foreach eid $idv ex $xv ey $yv ez $zv exrot $xrotv eyrot $yrotv  ezrot $zrotv etype $typev {
    ##XX FIX with zero filling so can handle absent rots
    ##set exrot 0
    ##set ezrot 0
    set node($eid) [list $ex $ey $ez $exrot $eyrot $ezrot $etype]
    
    lappend nodeIdList $eid
  }
  
} 

proc ::neuro::show_nodes_from_list_soma_only_color {theColor subsetNodeIdList} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node

  set node_radius 1 
  set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  theId: $theId line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    set c [expr $etype % 32 ] 
    draw color $c
    puts "set color to $c" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    show_morph_moved_soma_only_color $etype $ex $ey $ez $exrot $eyrot $ezrot 3 $theColor
    incr n
  }
}

proc ::neuro::show_nodes_from_list_radprescale_oldspheres {radprescale subsetNodeIdList} {

  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node

  set node_radius 1 
  set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  theId: $theId line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    #set c [expr $etype % 32 ] 
    #draw color $theColor
    #puts "set color to $theColor" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    show_morph_moved_oldspheres $etype $ex $ey $ez $exrot $eyrot $ezrot [expr 3 * $radprescale] 
    incr n
  }
}



proc ::neuro::show_nodes_from_list_color_radprescale_oldspheres {theColor radprescale subsetNodeIdList} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node

  set node_radius 1 
  set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  theId: $theId line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    #set c [expr $etype % 32 ] 
    draw color $theColor
    puts "set color to $theColor" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    show_morph_moved_color_oldspheres $etype $ex $ey $ez $exrot $eyrot $ezrot [expr 3 * $radprescale] $theColor
    incr n
  }
}


proc ::neuro::show_nodes_from_list_color_radprescale {theColor radprescale subsetNodeIdList} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node

  set node_radius 1 
  set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  theId: $theId line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    #set c [expr $etype % 32 ] 
    draw color $theColor
    puts "set color to $theColor" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    show_morph_moved_color $etype $ex $ey $ez $exrot $eyrot $ezrot [expr 3 * $radprescale] $theColor
    incr n
  }
}


proc ::neuro::show_nodes_from_list_soma_only_single_color {subsetNodeIdList theColor radPreScale} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node
  variable typeHash
  set node_radius 1 
  set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  theId: $theId line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    #set c [v1_color_map $typeHash(popName,$etype)]
    #set c [expr $etype % 32 ] 
    draw color $theColor
    puts "set color to $theColor" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    show_morph_moved_soma_only $etype $ex $ey $ez $exrot $eyrot $ezrot $radPreScale
    incr n
  }
}

proc ::neuro::show_nodes_from_list_single_color {subsetNodeIdList theColor} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node
  variable typeHash
  set node_radius 1 
  set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  theId: $theId line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    #set c [v1_color_map $typeHash(popName,$etype)]
    #set c [expr $etype % 32 ] 
    draw color $theColor
    puts "set color to $theColor" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    show_morph_moved $etype $ex $ey $ez $exrot $eyrot $ezrot 3
    incr n
  }
}

proc ::neuro::show_nodes_from_list_soma_v1_color {subsetNodeIdList {radius_scale 3}} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node
  variable typeHash
  set node_radius 1 
  set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  theId: $theId line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    set c [v1_color_map $typeHash(popName,$etype)]
    #set c [expr $etype % 32 ] 
    draw color $c
    puts "set color to $c" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    show_morph_moved_soma_only  $etype $ex $ey $ez $exrot $eyrot $ezrot $radius_scale
    incr n
  }
}

proc ::neuro::show_nodes_from_list_v1_color {subsetNodeIdList} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node
  variable typeHash
  set node_radius 1 
  set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  theId: $theId line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    set c [v1_color_map $typeHash(popName,$etype)]
    #set c [expr $etype % 32 ] 
    draw color $c
    puts "set color to $c" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    show_morph_moved $etype $ex $ey $ez $exrot $eyrot $ezrot 3
    incr n
  }
}

proc ::neuro::halo_nodes_soma_only_bygroup_from_list {subsetNodeIdList halo_color halo_radius {group_label ""} } {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc

  set tempFilename "/tmp/out.xyz" 
  #variable nodeIdList
  variable node

  set node_radius 1 
  set node_scale 1
  set n 0
  set combSphereList ""
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  theId: $theId line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    #set c [expr $etype % 32 ] 
    #draw color $c
    #puts "set color to $c" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    #set sphereList [sphereList_morph_moved $etype $ex $ey $ez $exrot $eyrot $ezrot] 
    #puts $sphereList
    puts "pre-append length of combSphereList is [llength $combSphereList]"
    #puts "length of sphereList is [llength $sphereList]"
    lappend combSphereList [list $ex $ey $ez]
    puts "length of combSphereList is [llength $combSphereList]"
    incr n
  }
  #count spheres for XYZ file
  set sphereCount [llength $combSphereList]
  #puts $combSphereList
  puts "sphereCount = $sphereCount"
  set fp [open $tempFilename w]
  puts $fp $sphereCount
  puts $fp "Halo - $group_label"
  foreach e $combSphereList {
    puts $fp "CA [lindex $e 0] [lindex $e 1] [lindex $e 2]" 
  }
  close $fp
  set haloMol [mol new $tempFilename]
  mol rename $haloMol "halo $group_label"
  puts "added haloMol $haloMol"
  set haloSel [atomselect $haloMol "all"]
  $haloSel set radius $halo_radius 
  mol modstyle 0 $haloMol QuickSurf 1.200000 1.700000 1.200000 1.000000 
  mol modmaterial 0 $haloMol GlassBubble
  mol modcolor 0 $haloMol ColorID $halo_color
  return $sphereCount
}

proc ::neuro::halo_nodes_bygroup_from_list {subsetNodeIdList halo_radius halo_color {group_label ""} } {
  # XXX creates merged, blobby results
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc

  set tempFilename "/tmp/out.xyz" 
  #variable nodeIdList
  variable node

  set node_radius 1 
  set node_scale 1
  set n 0
  set combSphereList ""
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  theId: $theId line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    #set c [expr $etype % 32 ] 
    #draw color $c
    #puts "set color to $c" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    set sphereList [sphereList_morph_moved $etype $ex $ey $ez $exrot $eyrot $ezrot] 
    #puts $sphereList
    puts "pre-append length of combSphereList is [llength $combSphereList]"
    puts "length of sphereList is [llength $sphereList]"
    foreach e $sphereList {
      lappend combSphereList $e 
    }
    puts "length of combSphereList is [llength $combSphereList]"
    incr n
  }
  #count spheres for XYZ file
  set sphereCount [llength $combSphereList]
  #puts $combSphereList
  puts "sphereCount = $sphereCount"
  set fp [open $tempFilename w]
  puts $fp $sphereCount
  puts $fp "Halo - $group_label"
  foreach e $combSphereList {
    puts $fp "CA [lindex $e 0] [lindex $e 1] [lindex $e 2]" 
  }
  close $fp
  set haloMol [mol new $tempFilename]
  mol rename $haloMol "halo $group_label"
  puts "added haloMol $haloMol"
  set haloSel [atomselect $haloMol "all"]
  $haloSel set radius $halo_radius 
  mol modstyle 0 $haloMol QuickSurf 1.200000 1.700000 1.200000 1.000000 
  mol modmaterial 0 $haloMol GlassBubble
  mol modcolor 0 $haloMol ColorID $halo_color
  return $sphereCount
}


proc ::neuro::halo_nodes_from_list {subsetNodeIdList halo_radius halo_color} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node

  set node_radius 1 
  set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  theId: $theId line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    set c [expr $etype % 32 ] 
    draw color $c
    puts "set color to $c" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    set halo_label "id $theId"
    halo_morph_moved $etype $ex $ey $ez $exrot $eyrot $ezrot 3 "/tmp/out.xyz" $halo_radius $halo_color $halo_label
    incr n
  }
}

proc ::neuro::proto_show_nodes_from_list_single_swc_segment {subsetNodeIdList swc_segment theColor} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
  puts "proto_show_nodes   swc_segment = $swc_segment"
 
  #variable nodeIdList
  variable node

  set node_radius 1 
  set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  theId: $theId line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    #set c [expr $etype % 32 ] 
    set c $theColor
    draw color $c
    puts "set color to $c" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    proto_show_morph_moved_swc_segment $etype $ex $ey $ez $exrot $eyrot $ezrot 3 $swc_segment
    incr n
  }
}
proc ::neuro::proto_show_nodes_from_list {subsetNodeIdList colorUsed} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node
  variable debugMode

  set node_radius 1 
  set node_scale 1
  
  set n 0
  switch $colorUsed {
    "type" {
      foreach theId $subsetNodeIdList {
        foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
        set c [expr $etype % 32 ] 
        draw color $c
        if {$debugMode} {
          puts "list elem: $n  line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
          puts "set color to $c" 
        }
        #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
        ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
        #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
        proto_show_morph_moved $etype $ex $ey $ez $exrot $eyrot $ezrot 3
        incr n
      }
    }
    "default" {
      set c $colorUsed
      draw color $c
      foreach theId $subsetNodeIdList {
        foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
        if {$debugMode} {
          puts "list elem: $n  line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
          puts "set color to $c" 
        }
        #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
        ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
        #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
        proto_show_morph_moved $etype $ex $ey $ez $exrot $eyrot $ezrot 3
        incr n
      }      
    }
  }  
}
proc ::neuro::show_nodes_from_list {subsetNodeIdList} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node

  set node_radius 1 
  set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  theId: $theId line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    set c [expr $etype % 32 ] 
    draw color $c
    puts "set color to $c" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    show_morph_moved $etype $ex $ey $ez $exrot $eyrot $ezrot 3
    incr n
  }
}

proc ::neuro::show_nodes_from_list_soma_only_color_lookup_rgb {subsetNodeIdList soma_radius} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
  variable node
  variable typeHash
  set colorList ""
  set sphereList ""
  set radiiusList ""
  # uniform radius in this proc, but a current spheretube bug (apparent) forcing use of radiusList
  #variable nodeIdList

  #set node_radius 1 
  #set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    #puts "list elem: $n  line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    lappend colorList [cortex_color_map $typeHash(popName,$etype)]
    lappend sphereList [list $ex $ey $ez]
    lappend radiusList $soma_radius
    ##show_morph_moved_soma_only $etype $ex $ey $ez $exrot $eyrot $ezrot 3
    incr n
  }
   #puts "#draw spheretube \"$sphereList\" colors \"$colorList\" radius $soma_radius  drawtubes 0" 
  draw spheretube "$sphereList" radii "$radiusList" drawtubes 0 colors "$colorList"
   #draw spheretube "$sphereList" radius $soma_radius  drawtubes 0 
}

proc ::neuro::proto_show_nodes_from_list_soma_only {subsetNodeIdList colorUsed givenScale givenRes} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node
  variable debugMode

  set node_radius 1 
  set node_scale 1
  set n 0
  switch $colorUsed {
    "type" {
        foreach theId $subsetNodeIdList {
          foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
          set c [expr $etype % 32 ] 
          draw color $c
          if {$debugMode} {
            puts "list elem: $n  line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
            puts "set color to $c" 
          }
          #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
          ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
          #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
          proto_show_morph_moved_soma_only $etype $ex $ey $ez $exrot $eyrot $ezrot $givenScale $givenRes
          incr n
        }
    }
    "default" {
        set c $colorUsed
        draw color $c
        foreach theId $subsetNodeIdList {
          foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
          if {$debugMode} {
            puts "list elem: $n  line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
            puts "set color to $c" 
          }
          #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
          ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
          #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
          proto_show_morph_moved_soma_only $etype $ex $ey $ez $exrot $eyrot $ezrot $givenScale $givenRes
          incr n
        }      
    }
  }
  
}

proc ::neuro::show_nodes_from_list_soma_only {subsetNodeIdList} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node

  set node_radius 1 
  set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    set c [expr $etype % 32 ] 
    draw color $c
    puts "set color to $c" 
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    ##draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    show_morph_moved_soma_only $etype $ex $ey $ez $exrot $eyrot $ezrot 3
    incr n
  }
}



proc ::neuro::query_num_types {} {
  variable typeList
  return [llength $typeList]
}
proc ::neuro::query_type_list {} {
  variable typeList
  return $typeList
}
proc ::neuro::query_rep_list {} {
  variable nrepList
  set ll ""
  foreach e $nrepList {
    lappend ll [lindex $e 0]
  }
  return $ll
}

proc ::neuro::query_num_nreps {} {
  variable nrepList
  return [llength $nrepList]
}

proc ::neuro::query_nreps_molecs {} {
  variable nrepList
  set ll ""
  foreach e $nrepList {
    #for internal diagnostic: nrepid, molecule
    lappend ll [list [lindex $e 0] [lindex $e 1]]
  }
  return $ll
}

proc ::neuro::query_nreps_full {} {
  variable nrepList
  set ll ""
  foreach e $nrepList {
    #for internal diagnostic: all nrep info 
    lappend ll $e
  }
  return $ll
}

proc ::neuro::query_rep_property_list {} {
  variable nrepList
  set ll ""
  foreach e $nrepList {

    foreach {nrepid shown molec style color material colorbytype selection stride num_neurons sphereScale sphereRes} $e {}
    #for internal diagnostic: all nrep info 
    lappend ll [list $nrepid $shown $style $color $material $colorbytype $selection $stride $num_neurons $sphereScale $sphereRes] 
  }
  return $ll
}


proc ::neuro::query_nreps_molecs {} {
  variable nrepList
  set ll ""
  foreach e $nrepList {
    lappend ll [lindex $e 0]
  }
  return $ll
}
proc ::neuro::show_nodes {} {
  #Now show the nodes
  #multiple node coordin`ates by node_scale so same scale as swc
 
  variable nodeIdList
  variable node

  set node_radius 1 
  set node_scale 1

  set n 0
  foreach theId $nodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "list elem: $n  line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    set c [expr $etype % 32 ] 
    draw color $c
    
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #XX whi is exrot and ezrot turned off?
    show_morph_moved $etype $ex $ey $ez 0 $eyrot 0 3
    incr n
  }
}

proc ::neuro::show_nodes_arrows_from_list {subsetNodeIdList} {
  #Now show the nodes
  #multiple node coordinates by node_scale so same scale as swc
 
  #variable nodeIdList
  variable node

  set node_radius 1 
  set node_scale 1
  set n 0
  foreach theId $subsetNodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    set c [expr $etype % 32 ] 
    draw color $c
    puts "n= $n  line: $ex $ey $ez $exrot $eyrot $ezrot $etype color: $c"
     
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    #draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #rotate a vector along x axis
    set m [transmult  [transaxis x $exrot rad] [transaxis y $eyrot rad] [transaxis z $ezrot rad]]
    set v [list 1 0 0 ]
    set vr [coordtrans $m $v]

    draw_arrow [list $ex $ey $ez] $vr 10 2 1 2 12
    #show_morph_moved $etype $ex $ey $ez $exrot $eyrot $ezrot 3
    incr n
  }
  display resetview
}
proc ::neuro::show_nodes_arrows {} {
  #Now show the nodes
  #multiple node coordin`ates by node_scale so same scale as swc
 
  variable nodeIdList
  variable node

  set node_radius 1 
  set node_scale 1

  foreach theId $nodeIdList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($theId) {}
    puts "line: $ex $ey $ez $exrot $eyrot $ezrot $etype"
    set c [expr $etype % 32 ] 
    draw color $c
    
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    #draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    #rotate a vector along x axis
    set m [transmult  [transaxis x $exrot rad] [transaxis y $eyrot rad] [transaxis z $ezrot rad]]
    set v [list 1 0 0 ]
    set vr [coordtrans $m $v]

    draw_arrow [list $ex $ey $ez] $vr 10 2 1 2 12
    #show_morph_moved $etype $ex $ey $ez $exrot $eyrot $ezrot 3
  }
  display resetview
}
proc ::neuro::read_store_nodes_local {filenamestart filenameend y_rot_only} {
  
  set xfilename "${filenamestart}x${filenameend}"
  set yfilename "${filenamestart}y${filenameend}"
  set zfilename "${filenamestart}z${filenameend}"
  set typefilename "${filenamestart}node_type${filenameend}"
  set idfilename "${filenamestart}node_id${filenameend}"
  set yaxisfilename "${filenamestart}rotation_angle_yaxis${filenameend}"
  if {$y_rot_only} {
    set xaxisfilename ""
    set zaxisfilename ""
   
  } else {
    set xaxisfilename "${filenamestart}rotation_angle_xaxis${filenameend}"
    set zaxisfilename "${filenamestart}rotation_angle_zaxis${filenameend}"
  }
  foreach vec {xv yv zv xrotv yrotv zrotv typev idv } fn {xfilename yfilename zfilename xaxisfilename yaxisfilename zaxisfilename typefilename idfilename} {
    set thefilename [set $fn]
    puts "vec= $vec thefilename= $thefilename"
    if {$thefilename != ""} {
      set thefile [open $thefilename r]
      # XXX change so works for something that is not last line in file
      while { [gets $thefile myline] >=0} {
        set $vec [split $myline]
      }
   }
  }

#  set fx [open $xfilename r]
#   
#  while { [gets $fx myline] >=0} {
#    set xv [split $myline]
#   }
#  close $fx
#  set fy [open $yfilename r]
#  while { [gets $fy myline] >=0} {
#   set yv [split $myline]
#  }
#  close $fy
#  set fz [open $zfilename r]
#  while { [gets $fz myline] >=0} {
#   set zv [split $myline]
#  }
#  close $fz
#  set ftype [open $typefilename r]
#  while { [gets $ftype myline] >=0} {
#   set typev [split $myline]
#  }
#  close $ftype
#
  set node_radius 1 
  set node_scale 1
  set nodes ""
  foreach ex $xv ey $yv ez $zv etype $typev {
    lappend nodes [list $ex $ey $ez $etype]
  }
  #Now show the nodes
   #multiple node coordinates by node_scale so same scale as swc
    
  foreach e $nodes {
    foreach {ex ey ez etype} $e {}
    puts "line: $ex $ey $ez $etype"
    set c [expr $etype % 32 ] 
    draw color $c
    
    #draw sphere [list [expr 10 * $ex]  [expr 10 * $ey] [expr 10 * $ez]] radius $node_radius resolution 12
    draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4 
    
  }
}


proc ::neuro::read_nodes {filenamestart filenameend} {
  set xfilename "${filenamestart}x${filenameend}"
  set yfilename "${filenamestart}y${filenameend}"
  set zfilename "${filenamestart}z${filenameend}"
  set typefilename "${filenamestart}node_type${filenameend}"
  set fx [open $xfilename r]
  # XXX change so works for something that is not last line in file
  while { [gets $fx myline] >=0} {
    set xv [split $myline]
   }
  close $fx
  set fy [open $yfilename r]
  while { [gets $fy myline] >=0} {
   set yv [split $myline]
  }
  close $fy
  set fz [open $zfilename r]
  while { [gets $fz myline] >=0} {
   set zv [split $myline]
  }
  close $fz
  set ftype [open $typefilename r]
  while { [gets $ftype myline] >=0} {
   set typev [split $myline]
  }
  close $ftype
  set node_radius 1
  foreach ex $xv ey $yv ez $zv etype $typev {
    puts "line: $ex $ey $ez $etype"
    set c [expr $etype % 32] 
    draw color $c
    #draw sphere [list [expr 1000 * $ex]  [expr 1000 * $ey] [expr ed_000 * $ez]] radius $node_radius resolution 12
    draw sphere [list [expr $ex]  [expr $ey] [expr $ez]] radius $node_radius resolution 4
  }
} 


proc ::neuro::draw_arrow {from dir length  arrowlength lineradius arrowradius resolution } {
    puts "dir= $dir"
    set norm  [vecnorm $dir ]
    set endline  [vecadd  $from [vecscale $norm  [expr $length - $arrowlength] ]]
    set endarrow  [vecadd  $endline [vecscale $norm $arrowlength ] ]
  
        #might need short or disk-like cylinder  
        #ensures arrowhead point is at actual "to"/length position              
    if {$length < $arrowlength} {
        set endline $from
    }


    draw cylinder $from  $endline  radius  $lineradius resolution $resolution filled yes

    draw cone $endline $endarrow radius $arrowradius resolution $resolution

    return

}

proc ::neuro::check_not_null {} {
 variable nodeIdList
 variable node
 set typeList ""
 set i 0
 set nn 0
  foreach e $nodeIdList {
  set theType [lindex $node($e) 6]
  if  {$theType > 200000000} {
    incr nn
    lappend typeList [list $nn $i $theType]
  }
  incr i
 }  
 #puts $typeList
 puts "i = $i, nn= $nn length typeList= [llength $typeList]"
 #set uList [lsort -integer -unique $typeList]
 #puts "uList= $uList"
 #puts "unique types: [llength $uList]"
}

proc ::neuro::check_unique_types {} {
 variable nodeIdList
 variable node
 set typeList ""
 foreach e $nodeIdList {
  lappend typeList [lindex $node($e) 6]
 }  
 set uList [lsort -integer -unique $typeList]
 puts "uList= $uList"
 puts "unique types: [llength $uList]"
}

proc ::neuro::stride_list_skip_special {stride theList} {
  variable node
  set outList ""
  set n 0
  foreach e $theList {
    #puts "node($e)= $node($e)"
    if {([expr $n % $stride] == 0) && ([lindex $node($e) 6] != 471819401) } {
      lappend outList $e
    }
    incr n
  }
  return $outList
}

proc ::neuro::stride_list {stride theList} {
  set outList ""
  set n 0
  foreach e $theList {
    if {[expr $n % $stride] == 0} {
      lappend outList $e
    }
    incr n
  }
  return $outList
}

proc ::neuro::within_soma_select_list {radius target_node_id theList} {
  #find node_ids within radius of target_node_id.  Only soma is compared to soma (single cental coordinate per neuron) 
  variable node
  
  foreach {tx ty tz txrot tyrot tzrot ttype} $node($target_node_id) {}
  set outList ""
  set radius_sq [expr $radius * $radius]
  foreach e $theList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($e) {}
    set rad_sq_calc [expr ($ex - $tx)* ($ex - $tx) + ($ey - $ty)* ($ey - $ty) + ($ez - $tz) *($ez - $tz) ]
    if {$rad_sq_calc < $radius_sq} {
     puts "e= $e  radius_sq= $radius_sq rad_sq_calc= $rad_sq_calc"
     lappend outList $e
    } 
  }
  return $outList
}

proc ::neuro::geom_select_list {comp_axis comp_op comp_val theList} {
  variable node
  set outList ""
  foreach e $theList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($e) {}
    switch $comp_axis {
      x {set compvar $ex}
      y {set compvar $ey}
      z {set compvar $ez}
      default {puts "geom_select_list ERROR: ** axis ** must be x, y, or z"
        return -1
      }
    }  
    switch $comp_op {  
      gt {if {$compvar >= $comp_val} {lappend outList $e}}
      lt {if {$compvar < $comp_val} {lappend outList $e}}
      default {puts "geom_select_list ERROR: ** comp ** must be gt or lt" 
        return -1
      }
    }
  }
  return $outList
}
 
proc ::neuro::geom_morph_select_list {comp_axis comp_op comp_val theList} {
  #select by geometry, including spheres in full morphology
  variable node
  variable morphoHash
  variable typeHash
  set outList ""
  foreach e $theList {
    foreach {ex ey ez exrot eyrot ezrot etype} $node($e) {}
    set pointList $morphoHash($etype)
    set rotPointList ""
    set type_zrot $typeHash(rot_zaxis,$etype)
    #note the corrective -type_zrot, not true for all data sets
    set m [transmult  [transoffset [list $ex $ey $ez]] [transaxis x $exrot rad ] [transaxis y $eyrot rad] [transaxis z $ezrot rad] [transaxis z [expr -1.0 * $type_zrot] rad]]
    foreach pe $pointList {
        set v [list [lindex $pe 2] [lindex $pe 3] [lindex $pe 4]]
        set vr [coordtrans $m $v]
        #puts "vr = $vr, v 0 = [lindex $vr 0]"

      switch $comp_axis {
        x {set compvar [lindex $vr 0]} 
        y {set compvar [lindex $vr 1]} 
        z {set compvar [lindex $vr 2]} 
        default { puts "geom_select_list ERROR: ** axis ** must be x, y, or z"
                  return -1
        }
      }  
      switch $comp_op {  
        # leave pointList foreach loop after successful comparison
        gt {if {$compvar >= $comp_val} {lappend outList $e; break}}
        lt {if {$compvar < $comp_val} {lappend outList $e; break}}
        default {puts "geom_select_list ERROR: ** comp ** must be gt or lt" 
          return -1
        }
      }
    }
  }
  return $outList
}
proc ::neuro::node_type_from_node_list {theList} {
  variable node
  set ll ""
  foreach e $theList {
    lappend ll [lindex $node($e) 6]
  }
  return $ll
}
  
     
proc ::neuro::v1_reset_view {} {
 display resetview
 scale by 0.025
 translate by 0 1.2 0
 display projection Orthographic
}

proc ::neuro::list_extract_if_morph {subsetList} {
  variable node
  variable typeHash
  set ll ""
  foreach n $subsetList {
    set t [lindex $node($n) 6]
    if {$t>110000000} {
      lappend ll $n
    }
  }
  return $ll
}
proc ::neuro::list_info {subsetList} {
  variable node
  variable typeHash
  foreach n $subsetList {
    set t [lindex $node($n) 6]
    if {$t>110000000} {
      puts "$n: type $t  pop: $typeHash(popName,$t) name:$typeHash(morphoName,$t)"
    }
  }
}

proc ::neuro::make_colmap_cortex {} {
  set ll [list AIv #FFFFE0 GU #FFFF99 AIp #FFE302 AId #FFEA17 VISC #FFFF14 VISam #32174d VISpm #c9a0dc VISa #645394 RSPagl #9f00ff RSPd #ee82ee RSPv #7f00ff ILA #0000CD ORBm #4682B4 FRP #00BFFF ACAv #191970 ORBvl #000080 ORBl #F0F8FF ACAd #87CEFA PL #1E90FF MOs #0000FF SSp-un #e23d28 SSp-tr #660000 SSp-ll #FFA07A SSp-n #CD5C5C SSp-ul #FF6347 SSp-m #DC143C SSp-bfd #FF4500 MOp #B22222 SSs #FF0000 PERI #c46210 AUDpo #ff8c00 AUDd #ed9121 ECT #ff7538 AUDv #ff8200 AUDp #ff9f00 TEa #ff7f00 VISli #00a693 VISal #006a4e VISrl #66ff00 VISpl #00cc99 VISpor #ace1af VISl #177245 VISp #00ff00]

  foreach {popname colorhex} $ll  {
    set s [string range $colorhex 1 6] 
    set r [format %.3f [expr 0x[string range $s 0 1]/255.0]]
    set g [format %.3f [expr 0x[string range $s 2 3]/255.0]]
    set b [format %.3f [expr 0x[string range $s 4 5]/255.0]]
    puts "$popname $r $g $b"
  }
}



proc ::neuro::cmd_load_model { directory} {
  #for first mockup, we completely fake this
 #in this mockup, only one model, so:
 ::neuro::initVars
 #read hardcoded file, v1 network
 ::neuro::proto_read_store_types_and_morphos $directory/v1_node_types.csv 2 4 6 $directory/morphologies 8
 
 ::neuro::read_store_nodes $directory/v1_longline_ .dat true

 #only one model allowed, so hardcode this 
 set new_model_id 0
 # create a default represenation
 set theStride 1
 set sel "all"
 if {[cmd_query "num_neurons"] > 10000} {set theStride 5}
 if {[cmd_query "num_neurons"] > 100000} {set theStride 50}
 if {[cmd_query "num_neurons"] > 1000000} {set theStride 500}
 cmd_create_rep soma "type" Opaque true $sel $theStride true
 # uses stride 20 and forces the v1 special skip -- needed for early canned demos
 # later, stride will be a part of proper boolean and nested-parenthesis  selections -- but if common, consider a default filter
 return $new_model_id
}



proc ::neuro::parse_selection_string {selString theList} {
  #use selection string to choose from theList
  set lselString [string tolower $selString]
  set e [split $lselString]
  foreach {e1 e2 e3 e4 e5} $e {}
  puts "parsing: e1= $e1  e2= $e2  e3= $e3"
  switch $e1 {
    all { set outputList $theList
    }
    stride { set outputList [stride_list $e2 $theList]}
    soma  { if {$e3 == "<"} {set e3 "lt"}
            if {$e3 == ">"} {set e3 "gt"}
            set outputList [geom_select_list $e2 $e3 $e4 $theList]
           # soma z > 100
    }
    morph { if {$e3 == "<"} {set e3 "lt"}
            if {$e3 == ">"} {set e3 "gt"}
            set outputList [geom_morph_select_list $e2 $e3 $e4 $theList]
            # morph x < 31.2  
    }
    within {set outputList [within_soma_select_list $e2 $e5 $theList]
            #XX will take any text as words e4 and e4, 
            #XX do check, intention is: within 10 of node 2323 
    } 
    default { set outputList -1}
    
  }
  return $outputList
}

proc ::neuro::cmd_create_rep {style color material colorbytype selection {stride 1} {v1_special_skip 0} {givenScale 3} {givenRes 5}} {
  # XX special stride parameter is temporary for testing - stride will be a part of proper selection language with boolean and nested-parenthesis  selections
  variable debugMode
  variable nrepList   
  variable nrepCount
  # number of created nreps. At initVars, set to 0.  Also is the index of the next nrep to be created, so first nrep created has index 0.
  variable nodeIdList
  if {$debugMode} {puts "attempt to create rep $nrepCount: $style $color $material $colorbytype >$selection< $stride $v1_special_skip"}
  # use nrep for "neuro represenation" so not confused with internal VMD reps.
  # Note that for this implementation, there is one nrep  per molecule.
  #
  set molec [mol new]
  set shown true
 
  # here, draw needed neurons 
  # make selection

  if {$v1_special_skip} {
     #XXX hack for showing v1 
     set displayableNodeIdList [stride_list_skip_special $stride $nodeIdList]
  } else {
    set displayableNodeIdList [stride_list $stride $nodeIdList ]
  }
  set myNodeIdList [parse_selection_string $selection $displayableNodeIdList]
  #puts "myNodeIdList is $myNodeIdList"
  #proto_show_nodes_from_list [stride_list 4000 $::skipBadNodeIdList]
  #do cases for styles
  set num_neurons [llength $myNodeIdList]
  set newNrepid $nrepCount
  lappend nrepList [list $newNrepid $shown $molec $style $color $material $colorbytype $selection $stride $num_neurons $givenScale $givenRes]
  incr nrepCount
 

  switch $style {
    soma {proto_show_nodes_from_list_soma_only $myNodeIdList $color $givenScale $givenRes}
    morphology {proto_show_nodes_from_list $myNodeIdList $color}
    default {showError "style $style not recognized"
        return -1
    } 
  }
  # XX still must add colors and representations
 
  # XX track limits and fit selection in view instead of hardcoded scaling
  display resetview; scale by 0.021; translate by 0 1 0; display projection Orthographic

  # call existiing procs 
    
  return $newNrepid
}


proc ::neuro::cmd_delete_rep {repid} {
    variable nrepList
    set listPos [lsearch -exact -index 0 $nrepList $repid]
    if  {$listPos >=0}  {
      #remove the molecule we are using to hold nrep $repid
      set theMol [lindex [lindex $nrepList $listPos] 2]
      puts "deleting nrep $repid = molec $theMol"
      mol delete $theMol
      #delete the item from the list
      set nrepList [lreplace $nrepList $listPos $listPos]
    } else {
      ::neuro::showError "Representation $repid does not exist"
      return 1
   }  
  return 0
}


proc ::neuro::showError {errorString} {
  puts "  Error (neuro_view): $errorString" 
}

proc ::neuro::cmd_show_rep {repid} {
  puts "starting cmd_show_rep..."
  variable nrepList
  set listPos [lsearch -exact -index 0 $nrepList $repid]
  puts "cmd_show_rep listPos= $listPos"
  if  {$listPos >=0}  {
    #remove the molecule we are using to hold nrep $repid
    foreach {nrepid shown molec style color material colorbytype selection stride num_neurons sphereScale sphereRes} [lindex $nrepList $listPos] {}
    puts "showing nrep $repid = molec $molec"
    mol on $molec
    #set the shown property to true 
    set shown true
    set nrepList [lreplace $nrepList $listPos $listPos [list $nrepid $shown $molec $style $color $material $colorbytype $selection $stride $num_neurons]]
    } else {
      ::neuro::showError "Representation $repid does not exist."
      return 1
   }
}

proc ::neuro::cmd_hide_rep {repid} {
  puts "starting cmd_hide_rep..."
  variable nrepList
  set listPos [lsearch -exact -index 0 $nrepList $repid]

  puts "cmd_hide_rep listPos= $listPos"
  if  {$listPos >=0}  {
    #remove the molecule we are using to hold nrep $repid
    foreach {nrepid shown molec style color material colorbytype selection stride num_neurons sphereScale sphereRes} [lindex $nrepList $listPos] {}
    puts "hiding: nrep $repid = molec $molec"
    mol off $molec
    #set the shown property to false
    set shown false
    set nrepList [lreplace $nrepList $listPos $listPos [list $nrepid $shown $molec $style $color $material $colorbytype $selection $stride $num_neurons $sphereScale $sphereRes]]
    } else {
      ::neuro::showError "Representation $repid does not exist"
      return 1
   }
}



proc ::neuro::cmd_query {property} {
  #list reps with details
  variable nodeIdList
  switch $property {
    num_neurons { return [llength $nodeIdList]}
    num_morphologies {}
    num_reps { return [query_num_nreps]} 
    num_types { return [query_num_types]} 
    rep_list { return [query_rep_list]}
    type_list { return [query_type_list]}
    rep_property_list { return [query_rep_property_list]}
    default {showError "Query $property is not recognized. num_neurons, num_morphologies, num_reps, rep_list, num_types, type_list, rep_property_list"; return -1}
   }
}
