package require Tk
package require tablelist

package provide neuronvnd 1.0

namespace eval ::NeuronVND:: {

    variable modellist 0
    variable modelselected ""
    variable repselected 0
    variable selRep ""
    variable styleRep ""
    variable materialRep ""
    variable colorRep ""
    variable proxyantialias ""
    variable proxydepthcueing ""
    variable proxyfps ""
    variable proxylight0 on 
    variable proxylight1 off 
    variable proxylight2 off 
    variable proxylight3 off 

    proc initialize {} {
        global env
        #########################
        variable listmodels
        set listmodels(-1) ""
        set listmodels(0,name) ""
        variable indexmodel 0

        # source neuro from barry
        #source /Projects/barryi/vmd/scripts/neuro_viz/neuro_read.tcl

    }
    initialize
}

source [file join $env(NEURONVNDDIR) neuro_read.tcl]

proc ::NeuronVND::resizeGUI {w} {
  # taken from fftk
  update idletasks
  regexp {([0-9]+)x[0-9]+[\+\-]+[0-9]+[\+\-]+[0-9]+} [wm geometry $w] all dimW
  set dimH [winfo reqheight $w]
  #set dimH [expr {$dimH + 10}]
  set dimW [winfo reqwidth $w]
  #set dimW [expr {$dimW + 5}]
  wm geometry $w [format "%ix%i" $dimW $dimH]
  update idletasks

}

proc ::NeuronVND::neuronRep { } {
    variable repselected
    variable selRep
    variable styleRep
    variable materialRep
    variable colorRep

    set w .neuron.fp.representations
    #wm title $w "Representations"
    #wm resizable $w 1 1
    #set width 288 ;# in pixels
    #set height 160 ;# in pixels
    #wm geometry $w ${width}x${height}+797+747   

    grid [frame $w.main] -row 0 -column 0 -sticky news

    grid [labelframe $w.main.modelsel -text "Selected Model" -labelanchor n] -row 0 -column 0 -sticky news -padx 2 -pady 2
    #grid columnconfigure $w.main.modelsel 0 -weight 1

    grid [ttk::combobox $w.main.modelsel.inp -width 37 -background white -values $::NeuronVND::modellist -state readonly -justify left -textvariable ::NeuronVND::modelselected] -row 0 -column 1 -sticky ew -padx 1

    bind $w.main.modelsel.inp <<ComboboxSelected>> {
        set text [%W get]
        %W selection clear
    }

    grid [frame $w.main.rep] -row 1 -column 0 -sticky news -padx 2 -pady 2
    grid [button $w.main.rep.add -text "Create Rep" -command {::NeuronVND::createRep}] -row 0 -column 0 -sticky news
    grid [button $w.main.rep.show -text "Show / Hide" -command {::NeuronVND::showHideRep}] -row 0 -column 1 -sticky news
    grid [button $w.main.rep.del -text "Delete Rep" -command {::NeuronVND::delRep}] -row 0 -column 2 -sticky e
    #grid columnconfigure $w.main.rep 2 -weight 1

    grid [frame $w.main.table] -row 2 -column 0 -sticky news -padx 4 -pady 2
    
    grid [tablelist::tablelist $w.main.table.tb -columns {
        0 "Style" 
        0 "Color"
        0 "Selection"
        } \
        -yscrollcommand [list $w.main.table.scr1 set] \
        -stretch all -background white -stretch all -height 6 -width 37]
    
    ##Scroll_BAr V
    grid [scrollbar $w.main.table.scr1 -orient vertical -command [list $w.main.table.tb yview]] -row 0 -column 1  -sticky ens

    $w.main.table.tb columnconfigure 0 -width 10
    $w.main.table.tb columnconfigure 2 -width 15
    #$w.main.table.tb columnconfigure 0 -width 0 -editable true -editwindow ttk::checkbutton

    bind $w.main.table.tb <<TablelistSelect>>  {
      set ::NeuronVND::repselected [%W curselection]  
      ::NeuronVND::updateRepMenu
    }

    grid [labelframe $w.main.sel -text "Selected Neurons" -labelanchor n ] -row 3 -column 0 -sticky news -padx 2 -pady 2
    grid [entry $w.main.sel.entry -textvariable ::NeuronVND::selRep -width 38] -row 0 -column 0 -sticky news -padx 1
    bind $w.main.sel.entry <Return> {
      ::NeuronVND::editRep sel
      return
    }
    

    grid [frame $w.main.def] -row 4 -column 0 -sticky news -padx 2 -pady 2
    grid [label $w.main.def.stylbl -text "Style"] -row 0 -column 0
    grid [ttk::combobox $w.main.def.stycb -width 10 -values {"soma" "morphology"} -textvariable ::NeuronVND::styleRep] -row 0 -column 1
    bind $w.main.def.stycb <<ComboboxSelected>> {
        set text [%W get]
        ::NeuronVND::editRep style
        %W selection clear
    }
    
    grid [label $w.main.def.matlbl -text "Material" -width 8 -anchor e] -row 0 -column 2
    set materiallist {"Opaque" "Transparent" "BrushedMetal" "Diffuse" "Ghost" "Glass1" "Glass2" "Glass3" "Glossy" "HardPlastic" "MetallicPastel" "Steel" \
        "Translucent" "Edgy" "EdgyShiny" "EdgyGlass" "Goodsell" "AOShiny" "AOChalky" "AOEdgy" "BlownGlass" "GlassBubble" "RTChrome"}
    grid [ttk::combobox $w.main.def.matcb -width 10 -values $materiallist -textvariable ::NeuronVND::materialRep] -row 0 -column 3
    bind $w.main.def.matcb <<ComboboxSelected>> {
        set text [%W get]
        ::NeuronVND::editRep material
        %W selection clear
    }


    grid [label $w.main.def.colorlbl -text "Color"] -row 1 -column 0
    grid [ttk::combobox $w.main.def.colorcb -width 10 -values {"name" "type" "morphology" "colorID"} -textvariable ::NeuronVND::colorRep] -row 1 -column 1
    
    grid [frame $w.main.arg] -row 5 -column 0 -sticky news -padx 2 -pady 2

    #grid [label $w.main.arg.lb1 -text "Spline detail"] -row 0 -column 0 -sticky news
    #grid [entry $w.main.arg.en1 -text "5" -width 5] -row 0 -column 1 -sticky news
    grid [label $w.main.arg.lb2 -text "Resolution"] -row 0 -column 0 -sticky news
    set resRep ""
    grid [spinbox $w.main.arg.en2 -width 3 -increment 1 -from 1 -to 10 -textvariable resRep -background white]  -row 0 -column 1 -padx 2 -sticky w

    # check neuro::nrepList and add reps to table
    if {[info exists ::neuro::nrepList]} {
        foreach r $::neuro::nrepList {
            set style [lindex $r 3]
            set color [lindex $r 4]
            set selection [lindex $r 7]
            set show [lindex $r 1]
            $w.main.table.tb insert end [list $style $color $selection]
            if {!$show} {
                $w.main.table.tb rowconfigure end -foreground red
                $w.main.table.tb rowconfigure end -selectforeground red
            }
        }
    }

    #NeuronVND::resizeGUI $w

}

proc ::NeuronVND::createPages { orientation } {
    variable listmodels
    set w .neuron
    if {[winfo exists .neuron.fp]} { destroy .neuron.fp }
    ttk::style configure new.TNotebook -tabposition $orientation
    ttk::style configure new.TNotebook.Tab -width 12
    ttk::style configure new.TNotebook.Tab -anchor center
    #font create customfont2 -size 100 -weight bold
    ttk::style configure New.TNotebook.Tab -font customfont2
    grid [ttk::notebook $w.fp -style new.TNotebook -width 420] -row 1 -column 0 -sticky nsew -pady 2 -padx 2
    grid columnconfigure $w.fp 0 -weight 1
    grid rowconfigure $w.fp 0 -weight 1

    frame $w.fp.systems
    frame $w.fp.representations
    frame $w.fp.navigation

    set fontarg "helvetica 20 bold"

    if {$orientation == "wn"} {
        set text1 "\nSystems\n"
        set text2 "\nGraphics\n"
        set text3 "\nNavigation\n"
        set width 350
        set height 300
    } else {
        set text1 "Systems"
        set text2 "Graphics"
        set text3 "Navigation"
        set width 268
        set height 325
    }

    $w.fp add $w.fp.systems -text $text1 -padding 2 -sticky news
    $w.fp add $w.fp.representations -text $text2 -padding 2 -sticky news
    $w.fp add $w.fp.navigation -text $text3 -padding 2 -sticky news

    grid [frame $w.fp.systems.main] -row 0 -column 0 -sticky news
    grid [tablelist::tablelist $w.fp.systems.main.tb -columns {
        0 "ID" 
        0 "T"
        0 "D"
        0 "Model"
        0 "Neurons"
        } \
        -yscrollcommand [list $w.fp.systems.main.scr1 set] \
        -stretch all -background white -stretch all -height 10 -width 40]  

    ##Scroll_BAr V
    grid [scrollbar $w.fp.systems.main.scr1 -orient vertical -command [list $w.fp.systems.main.tb yview]] -row 0 -column 1  -sticky ens

    #$w.main.tb insert end [list "0" "T" "D" "V1" [::neuro::cmd_query num_neurons] ""]

    #$w.main.tb insert end [list "0" "T" "D" "event30K" "30.000" "100"]
    #$w.main.tb insert end [list "1" "" "D" "test500K" "500.000" "0"]

    if {$listmodels(0,name) != ""} {
    .neuron.fp.systems.main.tb insert end [list "0" "T" "D" $listmodels(0,name) $listmodels(0,neurons)]
    }

    grid [frame $w.fp.navigation.main] -row 0 -column 0 -sticky news

    #grid [button $w.scaleframe.left -image left -command { }] -row 0 -column 0
    grid [entry $w.fp.navigation.main.entry -textvariable timeentry -width 5] -row 0 -column 0
    grid [scale $w.fp.navigation.main.scale -from 0 -to 100 -orien horizontal -length 220 -variable timeentry -sliderlength 10 -command {}] -row 0 -column 1 -sticky news -columnspan 3
    grid [label $w.fp.navigation.main.steplbl -text "Step" -width 5] -row 1 -column 0 -sticky news
    grid [entry $w.fp.navigation.main.stepentry -textvariable stepval -width 5] -row 1 -column 1 -sticky news
    grid [label $w.fp.navigation.main.speedlbl -text "Speed" -width 5] -row 1 -column 2 -sticky news
    grid [scale $w.fp.navigation.main.speed -from 1 -to 5 -orien horizontal -length 20 -label "" -variable speedvar -sliderlength 10 -command {}] -row 1 -column 3 -sticky news

    ::NeuronVND::neuronRep

    wm geometry $w ${width}x${height}+782+454

}

proc ::NeuronVND::neuronGui { } {

   variable timeentry
   variable proxyantialias
   variable proxydepthcueing
   variable proxyfps
   variable proxylight0 
   variable proxylight1 
   variable proxylight2 
   variable proxylight3 

   set w [toplevel ".neuron"]
   wm title $w "Visual Neuronal Dynamics"
   wm resizable $w 1 1
   set width 350 ;# in pixels
   set height 300 ;# in pixels 290x200+782+454
   wm geometry $w ${width}x${height}+782+454
   grid columnconfigure $w 0 -weight 1
   grid columnconfigure $w 1 -weight 0
   grid rowconfigure $w 0 -weight 0
   grid rowconfigure $w 1 -weight 1

   grid [frame $w.menubar -relief raised -bd 2] -row 0 -column 0 -sticky nswe -pady 2 -padx 2
   grid columnconfigure $w.menubar 4 -weight 1
   grid rowconfigure $w.menubar 0 -weight 1

   grid [menubutton $w.menubar.file -text "File" -width 5 -menu $w.menubar.file.menu] -row 0 -column 0 -sticky ew
   #grid [menubutton $w.menubar.system -text "System" -width 8 -menu $w.menubar.system.menu] -row 0 -column 1 -sticky ew
   grid [menubutton $w.menubar.display -text "Display" -width 8 -menu $w.menubar.display.menu] -row 0 -column 2 -sticky ew
   grid [menubutton $w.menubar.analysis -text "Analysis" -width 8 -menu $w.menubar.analysis.menu] -row 0 -column 3 -sticky ew
   grid [menubutton $w.menubar.help -text "Help" -width 5 -menu $w.menubar.help.menu] -row 0 -column 4 -sticky e
      
   # File
   menu $w.menubar.file.menu -tearoff no
   $w.menubar.file.menu add command -label "Open File" -command { ::NeuronVND::loadfiles }
   $w.menubar.file.menu add command -label "Render" -command {menu render off; menu render on}

   #$w.menubar.file.menu add command -label "Write Input File" -command { }

   # System
   #menu $w.menubar.system.menu -tearoff no
   #$w.menubar.system.menu add command -label "System Information" -command { ::NeuronVND::neuronInfo } -state disabled
   #$w.menubar.system.menu add command -label "Representations" -command { ::NeuronVND::neuronRep }

    # Display
   menu $w.menubar.display.menu -tearoff no
   menu $w.menubar.display.menu.orient -tearoff no -title "Menu"
   $w.menubar.display.menu add cascade -label "Menu" -menu $w.menubar.display.menu.orient
   $w.menubar.display.menu.orient add radiobutton -label "Horizontal" -variable orient -value "nw" -command { ::NeuronVND::createPages nw }
   $w.menubar.display.menu.orient add radiobutton -label "Vertical" -variable orient -value "wn" -command { ::NeuronVND::createPages wn }
   
   $w.menubar.display.menu add command -label "Reset View" -command { display resetview }
   $w.menubar.display.menu add separator
   $w.menubar.display.menu add radiobutton -label "Perspective" -variable perps -value on -command {display projection Perspective}
   $w.menubar.display.menu add radiobutton -label "Orthographic" -variable perps -value off -command {display projection Orthographic}
   set perps on
   $w.menubar.display.menu add separator   
   $w.menubar.display.menu add checkbutton -label "Antialiasing" -variable ::NeuronVND::proxyantialias -onvalue on -offvalue off -command { 
       switch $::NeuronVND::proxyantialias {
           "on"  { display antialias on }
           "off" { display antialias off }
       }
   }
   $w.menubar.display.menu add checkbutton -label "Depth Cueing" -variable ::NeuronVND::proxydepthcueing -onvalue on -offvalue off -command { 
       switch $::NeuronVND::proxydepthcueing {
           "on"  { display depthcue on }
           "off" { display depthcue off }
       }
   }
   $w.menubar.display.menu add checkbutton -label "FPS Indicator" -variable ::NeuronVND::proxyfps -onvalue on -offvalue off -command { 
       switch $::NeuronVND::proxyfps {
           "on"  { display fps on }
           "off" { display fps off }
       }
   }
   $w.menubar.display.menu add separator   
   $w.menubar.display.menu add checkbutton -label "Light 0" -variable ::NeuronVND::proxylight0 -onvalue on -offvalue off -command { 
       switch $::NeuronVND::proxylight0 {
           "on"  { light 0 on }
           "off" { light 0 off }
       }
   }
   $w.menubar.display.menu add checkbutton -label "Light 1" -variable ::NeuronVND::proxylight1 -onvalue on -offvalue off -command { 
       switch $::NeuronVND::proxylight1 {
           "on"  { light 1 on }
           "off" { light 1 off }
       }
   }
   $w.menubar.display.menu add checkbutton -label "Light 2" -variable ::NeuronVND::proxylight2 -onvalue on -offvalue off -command { 
       switch $::NeuronVND::proxylight2 {
           "on"  { light 2 on }
           "off" { light 2 off }
       }
   }
   $w.menubar.display.menu add checkbutton -label "Light 3" -variable ::NeuronVND::proxylight3 -onvalue on -offvalue off -command { 
       switch $::NeuronVND::proxylight3 {
           "on"  { light 3 on }
           "off" { light 3 off }
       }
   }      
   $w.menubar.display.menu add separator   
   menu $w.menubar.display.menu.axes -tearoff no -title "Axes"
   $w.menubar.display.menu add cascade -label "Axes" -menu $w.menubar.display.menu.axes
   $w.menubar.display.menu.axes add radiobutton -label "Off" -variable axes -value off -command { axes location Off }
   $w.menubar.display.menu.axes add radiobutton -label "Origin" -variable axes -value origin -command { axes location Origin }
   $w.menubar.display.menu.axes add radiobutton -label "Lower Left" -variable axes -value lowerleft -command { axes location LowerLeft }
   $w.menubar.display.menu.axes add radiobutton -label "Lower Right" -variable axes -value lowerright -command { axes location LowerRight }
   $w.menubar.display.menu.axes add radiobutton -label "Upper Left" -variable axes -value upperleft -command { axes location UpperLeft }
   $w.menubar.display.menu.axes add radiobutton -label "Upper Right" -variable axes -value upperright -command { axes location UpperRight }
   
   menu $w.menubar.display.menu.background -tearoff no -title "Background"
   $w.menubar.display.menu add cascade -label "Background" -menu $w.menubar.display.menu.background
   $w.menubar.display.menu.background add radiobutton -label "Solid Color" -variable bgsolid -value on -command { display backgroundgradient off }
   $w.menubar.display.menu.background add radiobutton -label "Gradient" -variable bgsolid -value off -command { display backgroundgradient on }
   $w.menubar.display.menu add separator
   menu $w.menubar.display.menu.rendermode -tearoff no -title "Render Mode"
   $w.menubar.display.menu add cascade -label "Render Mode" -menu $w.menubar.display.menu.rendermode
   $w.menubar.display.menu.rendermode add radiobutton -label "Normal" -variable render -value normal -command { display rendermode Normal }
   $w.menubar.display.menu.rendermode add radiobutton -label "GLSL" -variable render -value glsl -command { display rendermode GLSL }
   $w.menubar.display.menu.rendermode add radiobutton -label "Acrobat3D" -variable render -value a3D -command { display rendermode Acrobat3D }
   $w.menubar.display.menu add separator
   $w.menubar.display.menu add command -label "Display Settings" -command { menu display off; menu display on }

    # Analysis
   menu $w.menubar.analysis.menu -tearoff no
   $w.menubar.analysis.menu add command -label "Timeline Analysis" -command { neuronTimeline } -state disabled
   
   # Help
   menu $w.menubar.help.menu -tearoff no
   $w.menubar.help.menu add command -label "Website, Tutorial and FAQs" \
       -command "vmd_open_url https://www.ks.uiuc.edu/Research/vnd/"

    ::NeuronVND::createPages nw

}

::NeuronVND::neuronGui




proc ::NeuronVND::neuronInfo { } {

   set w [toplevel ".neuron.info"]
   wm title $w "System Information"
   wm resizable $w 1 1
   set width 290 ;# in pixels
   set height 100 ;# in pixels
   wm geometry $w ${width}x${height}

   grid [frame $w.main] -row 0 -column 0 -sticky news

   grid [ttk::frame $w.main.t1] -row 0 -column 0 -sticky nswe -padx 4 -columnspan 8

   grid columnconfigure $w.main.t1 0 -weight 1
   grid rowconfigure $w.main.t1 0 -weight 1


   #grid columnconfigure $w.main 0 -weight 1
   #grid rowconfigure $w.main 0 -weight 1

   #option add *Tablelist.activeStyle       frame
   
   set fro2 $w.main.t1

   option add *Tablelist.movableColumns    no
   option add *Tablelist.labelCommand      tablelist::sortByColumn

       tablelist::tablelist $fro2.tb -columns {\
           0 "Type" center
           0 "Number" center
           0 "Events" center
           0 "Notes" center
       }\
       -yscrollcommand [list $fro2.scr1 set] \
               -showseparators 0 -labelrelief groove  -labelbd 1 -selectforeground black\
               -foreground black -background white -width 45 -height 6 -state normal -selectmode extended -stretch all -stripebackgroun white -exportselection true\
               
   grid $fro2.tb -row 0 -column 0 -sticky news 
   
   ##Scroll_BAr V
   scrollbar $fro2.scr1 -orient vertical -command [list $fro2.tb  yview]
    grid $fro2.scr1 -row 0 -column 1  -sticky ens

    $fro2.tb insert end [list "101" "20.000" "12" "mayority"]
    $fro2.tb insert end [list "102" "7.000" "5" ""]
    $fro2.tb insert end [list "103" "3.000" "1" ""]

}

proc ::NeuronVND::loadfiles {} {
    variable listmodels
    variable indexmodel

    set neuronrep .neuron.fp.representations;#.neuron.rep.

    ####### For the future application 
    # read files
    set success 0
    # if succesful increase indexmodel
    if {$success} {}
    # populate main table required values
    set listmodels($indexmodel,id) 0
    set listmodels($indexmodel,name) ""
    set listmodels($indexmodel,neurons) ""
    ############################################
    
    # current shortcut
    set workdir [tk_chooseDirectory \
		  -initialdir "." -title "Choose model directory"]

    ::neuro::cmd_load_model $workdir

    set listmodels(0,name) "V1"
    set listmodels(0,neurons) [::neuro::cmd_query num_neurons]

    .neuron.fp.systems.main.tb insert end [list "0" "T" "D" $listmodels(0,name) $listmodels(0,neurons)]

    # check neuro::nrepList and add reps to table
    if {[info exists ::neuro::nrepList]} {
        foreach r $::neuro::nrepList {
            set style [lindex $r 3]
            set color [lindex $r 4]
            set selection [lindex $r 7]
            set show [lindex $r 1]
            $neuronrep.main.table.tb insert end [list $style $color $selection]
            if {!$show} {
                $neuronrep.main.table.tb rowconfigure end -foreground red
                $neuronrep.main.table.tb rowconfigure end -selectforeground red
            }
        }
    }

}

proc ::NeuronVND::createRep {} {
    variable repselected
    variable materialRep
    #instead of defining the rep, use the selected to get a copy.
    #set repselected [.neuron.fp.representations.table.tb curselection]
    if {$repselected == ""} {
        # no rep selected, create a default one
        set style soma 
        set color 11 
        set selection "stride 50"
    } else {
        # copy rep selected
        lassign [.neuron.fp.representations.main.table.tb get $repselected] style color selection
    }
    set material $materialRep 
    set colorbyte true 
    set repid [::neuro::cmd_create_rep $style $color $material $colorbyte $selection 50 true]

    .neuron.fp.representations.main.table.tb insert end [list $style $color $selection]

}

proc ::NeuronVND::delRep {} {
    variable repselected

    #set repselected [.neuron.fp.representations.table.tb curselection]
    set repid [lindex $::neuro::nrepList $repselected 0]
    ::neuro::cmd_delete_rep $repid
    .neuron.fp.representations.main.table.tb delete $repselected    
}

proc ::NeuronVND::showHideRep {} {
    variable repselected

    #set repselected [.neuron.fp.representations.table.tb curselection]
    set status [.neuron.fp.representations.main.table.tb rowcget $repselected -foreground]
    set repid [lindex $::neuro::nrepList $repselected 0]
    if {$status == "red"} {
        # rep was hidden, show it
        ::neuro::cmd_show_rep $repid
        # update foreground color
        .neuron.fp.representations.main.table.tb rowconfigure $repselected -foreground black
        .neuron.fp.representations.main.table.tb rowconfigure $repselected -selectforeground black
    } else {
        # rep was showing, hide it
        ::neuro::cmd_hide_rep $repid
        # update foreground color
        .neuron.fp.representations.main.table.tb rowconfigure $repselected -foreground red
        .neuron.fp.representations.main.table.tb rowconfigure $repselected -selectforeground red
    }
}

proc ::NeuronVND::updateRepMenu {} {
    variable repselected
    variable styleRep
    variable materialRep
    variable colorRep

    # get rep details from neuro_read
    set repdetails [lindex $::neuro::nrepList $repselected]

    # idea: when a rep is selected in the table, populate the selection, style and color entry/boxs
    set styleRep [lindex $repdetails 3]
    set colorRep [lindex $repdetails 4]
    set materialRep [lindex $repdetails 5]
    set selRep [lindex $repdetails 7]
    .neuron.fp.representations.main.sel.entry delete 0 end
    .neuron.fp.representations.main.sel.entry insert 0 $selRep

}

proc ::NeuronVND::editRep {case} {
    variable repselected
    variable styleRep
    variable materialRep
    variable colorRep
    variable selRep

    set t .neuron.fp.representations.main.table.tb

    # check the selected rep has a different style, get rep details from neuro_read
    set repdetails [lindex $::neuro::nrepList $repselected]

    switch $case {
        "style" {
            if {$styleRep != [lindex $repdetails 3]} {
                # update value in table, as a workaround to edit style
                $t insert $repselected [list $styleRep $colorRep $selRep]
                $t selection set $repselected
                $t delete [expr $repselected + 1]
                # create a copy rep with a different style
                ::NeuronVND::createRep
                # delete previous rep
                ::NeuronVND::delRep
            }
        }
        "sel" {
            if {$selRep != [lindex $repdetails 7]} {
                # update value in table, as a workaround to edit style
                $t insert $repselected [list $styleRep $colorRep $selRep]
                $t selection set $repselected
                $t delete [expr $repselected + 1]
                # create a copy rep with a different style
                ::NeuronVND::createRep
                # delete previous rep
                ::NeuronVND::delRep
            }
        }
        "color" {
            if {$colorRep != [lindex $repdetails 4]} {
                # update value in table, as a workaround to edit style
                $t insert $repselected [list $styleRep $colorRep $selRep]
                $t selection set $repselected
                $t delete [expr $repselected + 1]
                # create a copy rep with a different style
                ::NeuronVND::createRep
                # delete previous rep
                ::NeuronVND::delRep
            }
        }
        "material" {
            if {$materialRep != [lindex $repdetails 5]} {
                # update neuro::nrepList
                set ::neuro::nrepList [lreplace $::neuro::nrepList $repselected $repselected [lreplace [lindex $::neuro::nrepList $repselected] 5 5 $materialRep]]
                # changing material through draw command
                # needs to make mol top then call draw material xxxx
                mol top [lindex $repdetails 2]
                draw material $materialRep
            }
        }
    }
}

proc ::NeuronVND::exit {} {
    destroy .neuron
    #destroy .neuron.rep
    #namespace delete 
}
