package require Tk
package require tablelist 

package provide neuronvnd 1.0

namespace eval ::NeuronVND:: {

    variable modellist 0
    variable modelselected ""
    variable repselected 0
    variable selRep ""
    variable styleRep ""
    variable colorRep ""

    proc initialize {} {
        global env
        #########################
        variable listmodels
        set listmodels(-1) ""
        variable indexmodel 0

        # source neuro from barry
        #source /Projects/barryi/vmd/scripts/neuro_viz/neuro_read.tcl

    }
    initialize
}

source [file join $env(NEURONVNDDIR) neuro_read.tcl]

proc ::NeuronVND::resizeGUI {w} {
  # taken from fftk
  update idletasks
  regexp {([0-9]+)x[0-9]+[\+\-]+[0-9]+[\+\-]+[0-9]+} [wm geometry $w] all dimW
  set dimH [winfo reqheight $w]
  #set dimH [expr {$dimH + 10}]
  set dimW [winfo reqwidth $w]
  #set dimW [expr {$dimW + 5}]
  wm geometry $w [format "%ix%i" $dimW $dimH]
  update idletasks

}

proc ::NeuronVND::neuronGui { } {

   variable timeentry

   set w [toplevel ".neuron"]
   wm title $w "VMD for Neuroscience"
   wm resizable $w 1 1
   set width 290 ;# in pixels
   set height 200 ;# in pixels 290x200+782+454
   wm geometry $w ${width}x${height}+782+454
   grid columnconfigure $w 0 -weight 1
   grid columnconfigure $w 1 -weight 0
   grid rowconfigure $w 0 -weight 0
   grid rowconfigure $w 1 -weight 1

   grid [frame $w.menubar -relief raised -bd 2] -row 0 -column 0 -sticky nswe -pady 2 -padx 2
   grid columnconfigure $w.menubar 4 -weight 1
   grid rowconfigure $w.menubar 0 -weight 1

   grid [menubutton $w.menubar.file -text "File" -width 8 -menu $w.menubar.file.menu] -row 0 -column 0 -sticky ew
   grid [menubutton $w.menubar.system -text "System" -width 8 -menu $w.menubar.system.menu] -row 0 -column 1 -sticky ew
   grid [menubutton $w.menubar.analysis -text "Analysis" -width 8 -menu $w.menubar.analysis.menu] -row 0 -column 2 -sticky ew
   grid [menubutton $w.menubar.help -text "Help" -width 8 -menu $w.menubar.help.menu] -row 0 -column 3 -sticky e
      
   # File
   menu $w.menubar.file.menu -tearoff no
   $w.menubar.file.menu add command -label "Open File" -command { ::NeuronVND::loadfiles }
   #$w.menubar.file.menu add command -label "Write Input File" -command { }

   # System
   menu $w.menubar.system.menu -tearoff no
   $w.menubar.system.menu add command -label "System Information" -command { neuronInfo }
   $w.menubar.system.menu add command -label "Representations" -command { ::NeuronVND::neuronRep }

    # Analysis
   menu $w.menubar.analysis.menu -tearoff no
   $w.menubar.analysis.menu add command -label "Timeline Analysis" -command { neuronTimeline }
   
   # Help
   menu $w.menubar.help.menu -tearoff no
   $w.menubar.help.menu add command -label "Website, Tutorial and FAQs" \
       -command "vmd_open_url [string trimright [vmdinfo www] /]/plugins/qmtool"

    grid [frame $w.main] -row 1 -column 0 -sticky news

    grid [tablelist::tablelist $w.main.tb -columns {
        0 "ID" 
        0 "T"
        0 "D"
        0 "Model"
        0 "Neurons"
        0 "Time"
        } \
        -yscrollcommand [list $w.main.scr1 set] \
        -stretch all -background white -stretch all -height 6 -width 45]  
    
    ##Scroll_BAr V
    grid [scrollbar $w.main.scr1 -orient vertical -command [list $w.main.tb yview]] -row 0 -column 1  -sticky ens

    #$w.main.tb insert end [list "0" "T" "D" "V1" [::neuro::cmd_query num_neurons] ""]

    #$w.main.tb insert end [list "0" "T" "D" "event30K" "30.000" "100"]
    #$w.main.tb insert end [list "1" "" "D" "test500K" "500.000" "0"]

    grid [frame $w.scaleframe] -row 2 -column 0 -sticky news
    #grid columnconfigure $w.scaleframe 0 -weight 1
    #grid rowconfigure $w.scaleframe 0 -weight 1

    #grid [button $w.scaleframe.left -image left -command { }] -row 0 -column 0
    grid [entry $w.scaleframe.entry -textvariable timeentry -width 5] -row 0 -column 0
    grid [scale $w.scaleframe.scale -from 0 -to 100 -orien horizontal -length 220 -variable timeentry -sliderlength 10 -command {}] -row 0 -column 1 -sticky news -columnspan 3
    grid [label $w.scaleframe.steplbl -text "Step" -width 5] -row 1 -column 0 -sticky news
    grid [entry $w.scaleframe.stepentry -textvariable stepval -width 5] -row 1 -column 1 -sticky news
    grid [label $w.scaleframe.speedlbl -text "Speed" -width 5] -row 1 -column 2 -sticky news
    grid [scale $w.scaleframe.speed -from 1 -to 5 -orien horizontal -length 20 -label "" -variable speedvar -sliderlength 10 -command {}] -row 1 -column 3 -sticky news
    

}

::NeuronVND::neuronGui

proc ::NeuronVND::neuronInfo { } {

   set w [toplevel ".neuron.info"]
   wm title $w "System Information"
   wm resizable $w 1 1
   set width 290 ;# in pixels
   set height 100 ;# in pixels
   wm geometry $w ${width}x${height}

   grid [frame $w.main] -row 0 -column 0 -sticky news

   grid [ttk::frame $w.main.t1] -row 0 -column 0 -sticky nswe -padx 4 -columnspan 8

   grid columnconfigure $w.main.t1 0 -weight 1
   grid rowconfigure $w.main.t1 0 -weight 1


   #grid columnconfigure $w.main 0 -weight 1
   #grid rowconfigure $w.main 0 -weight 1

   #option add *Tablelist.activeStyle       frame
   
   set fro2 $w.main.t1

   option add *Tablelist.movableColumns    no
   option add *Tablelist.labelCommand      tablelist::sortByColumn

       tablelist::tablelist $fro2.tb -columns {\
           0 "Type" center
           0 "Number" center
           0 "Events" center
           0 "Notes" center
       }\
       -yscrollcommand [list $fro2.scr1 set] \
               -showseparators 0 -labelrelief groove  -labelbd 1 -selectforeground black\
               -foreground black -background white -width 45 -height 6 -state normal -selectmode extended -stretch all -stripebackgroun white -exportselection true\
               
   grid $fro2.tb -row 0 -column 0 -sticky news 
   
   ##Scroll_BAr V
   scrollbar $fro2.scr1 -orient vertical -command [list $fro2.tb  yview]
    grid $fro2.scr1 -row 0 -column 1  -sticky ens

    $fro2.tb insert end [list "101" "20.000" "12" "mayority"]
    $fro2.tb insert end [list "102" "7.000" "5" ""]
    $fro2.tb insert end [list "103" "3.000" "1" ""]

}

proc ::NeuronVND::neuronRep { } {
    variable repselected
    variable selRep
    variable styleRep
    variable colorRep

    set w [toplevel ".neuron.rep"]
    wm title $w "Representations"
    wm resizable $w 1 1
    set width 288 ;# in pixels
    set height 160 ;# in pixels
    wm geometry $w ${width}x${height}+797+747   

    grid [frame $w.main] -row 0 -column 0 -sticky news

    grid [labelframe $w.main.modelsel -text "Selected Model" -labelanchor n] -row 0 -column 0 -sticky news -padx 2 -pady 2
    #grid columnconfigure $w.main.modelsel 0 -weight 1

    grid [ttk::combobox $w.main.modelsel.inp -width 37 -background white -values $::NeuronVND::modellist -state readonly -justify left -textvariable ::NeuronVND::modelselected] -row 0 -column 1 -sticky ew -padx 1

    bind $w.main.modelsel.inp <<ComboboxSelected>> {
        set text [%W get]
        %W selection clear
    }

    grid [frame $w.main.rep] -row 1 -column 0 -sticky news -padx 2 -pady 2
    grid [button $w.main.rep.add -text "Create Rep" -command {::NeuronVND::createRep}] -row 0 -column 0 -sticky news
    grid [button $w.main.rep.show -text "Show / Hide" -command {::NeuronVND::showHideRep}] -row 0 -column 1 -sticky news
    grid [button $w.main.rep.del -text "Delete Rep" -command {::NeuronVND::delRep}] -row 0 -column 2 -sticky e
    #grid columnconfigure $w.main.rep 2 -weight 1

    grid [frame $w.main.table] -row 2 -column 0 -sticky news -padx 4 -pady 2
    
    grid [tablelist::tablelist $w.main.table.tb -columns {
        0 "Style" 
        0 "Color"
        0 "Selection"
        } \
        -yscrollcommand [list $w.main.table.scr1 set] \
        -stretch all -background white -stretch all -height 6 -width 37]
    
    ##Scroll_BAr V
    grid [scrollbar $w.main.table.scr1 -orient vertical -command [list $w.main.table.tb yview]] -row 0 -column 1  -sticky ens

    $w.main.table.tb columnconfigure 0 -width 10
    $w.main.table.tb columnconfigure 2 -width 15
    #$w.main.table.tb columnconfigure 0 -width 0 -editable true -editwindow ttk::checkbutton

    bind $w.main.table.tb <<TablelistSelect>>  {
      set ::NeuronVND::repselected [%W curselection]  
      ::NeuronVND::updateRepMenu
    }

    grid [labelframe $w.main.sel -text "Selected Neurons" -labelanchor n ] -row 3 -column 0 -sticky news -padx 2 -pady 2
    grid [entry $w.main.sel.entry -textvariable ::NeuronVND::selRep -width 38] -row 0 -column 0 -sticky news -padx 1
    bind $w.main.sel.entry <Return> {
      ::NeuronVND::editRep sel
      return
    }
    

    grid [frame $w.main.def] -row 4 -column 0 -sticky news -padx 2 -pady 2
    grid [label $w.main.def.stylbl -text "Style"] -row 0 -column 0
    grid [ttk::combobox $w.main.def.stycb -width 10 -values {"soma" "morphology" "lines" "spheres"} -textvariable ::NeuronVND::styleRep] -row 0 -column 1
    bind $w.main.def.stycb <<ComboboxSelected>> {
        set text [%W get]
        ::NeuronVND::editRep style
        %W selection clear
    }
    
    grid [label $w.main.def.colorlbl -text "Color" -width 8 -anchor e] -row 0 -column 2
    grid [ttk::combobox $w.main.def.colorcb -width 10 -values {"name" "type" "morphology" "colorID"} -textvariable ::NeuronVND::colorRep] -row 0 -column 3
    
    grid [frame $w.main.arg] -row 5 -column 0 -sticky news -padx 2 -pady 2
    grid [label $w.main.arg.lb1 -text "Spline detail"] -row 0 -column 0 -sticky news
    grid [entry $w.main.arg.en1 -text "5" -width 5] -row 0 -column 1 -sticky news
    grid [label $w.main.arg.lb2 -text "Resolution"] -row 0 -column 2 -sticky news
    grid [entry $w.main.arg.en2 -text "8" -width 5] -row 0 -column 3 -sticky news

    # check neuro::nrepList and add reps to table
    if {[info exists ::neuro::nrepList]} {
        foreach r $::neuro::nrepList {
            set style [lindex $r 3]
            set color [lindex $r 4]
            set selection [lindex $r 7]
            set show [lindex $r 1]
            .neuron.rep.main.table.tb insert end [list $style $color $selection]
            if {!$show} {
                .neuron.rep.main.table.tb rowconfigure end -foreground red
                .neuron.rep.main.table.tb rowconfigure end -selectforeground red
            }
        }
    }

    NeuronVND::resizeGUI $w

}

::NeuronVND::neuronRep

proc ::NeuronVND::loadfiles {} {
    variable listmodels
    variable indexmodel

    ####### For the future application 
    # read files
    set success 0
    # if succesful increase indexmodel
    if {$success} {}
    # populate main table required values
    set listmodels($indexmodel,id) 0
    set listmodels($indexmodel,name) ""
    set listmodels($indexmodel,neurons) ""
    ############################################
    
    # current shortcut
    set workdir [tk_chooseDirectory \
		  -initialdir "." -title "Choose model directory"]

    ::neuro::cmd_load_model $workdir

    .neuron.main.tb insert end [list "0" "T" "D" "V1" [::neuro::cmd_query num_neurons] ""]

    # check neuro::nrepList and add reps to table
    if {[info exists ::neuro::nrepList]} {
        foreach r $::neuro::nrepList {
            set style [lindex $r 3]
            set color [lindex $r 4]
            set selection [lindex $r 7]
            set show [lindex $r 1]
            .neuron.rep.main.table.tb insert end [list $style $color $selection]
            if {!$show} {
                .neuron.rep.main.table.tb rowconfigure end -foreground red
                .neuron.rep.main.table.tb rowconfigure end -selectforeground red
            }
        }
    }

}

proc ::NeuronVND::createRep {} {
    variable repselected
    #instead of defining the rep, use the selected to get a copy.
    #set repselected [.neuron.rep.main.table.tb curselection]
    if {$repselected == ""} {
        # no rep selected, create a default one
        set style soma 
        set color 11 
        set selection "stride 50"
    } else {
        # copy rep selected
        lassign [.neuron.rep.main.table.tb get $repselected] style color selection
    }
    set material Opaque 
    set colorbyte true 
    set repid [::neuro::cmd_create_rep $style $color $material $colorbyte $selection 50 true]

    .neuron.rep.main.table.tb insert end [list $style $color $selection]

}

proc ::NeuronVND::delRep {} {
    variable repselected

    #set repselected [.neuron.rep.main.table.tb curselection]
    set repid [lindex $::neuro::nrepList $repselected 0]
    ::neuro::cmd_delete_rep $repid
    .neuron.rep.main.table.tb delete $repselected    
}

proc ::NeuronVND::showHideRep {} {
    variable repselected

    #set repselected [.neuron.rep.main.table.tb curselection]
    set status [.neuron.rep.main.table.tb rowcget $repselected -foreground]
    set repid [lindex $::neuro::nrepList $repselected 0]
    if {$status == "red"} {
        # rep was hidden, show it
        ::neuro::cmd_show_rep $repid
        # update foreground color
        .neuron.rep.main.table.tb rowconfigure $repselected -foreground black
        .neuron.rep.main.table.tb rowconfigure $repselected -selectforeground black
    } else {
        # rep was showing, hide it
        ::neuro::cmd_hide_rep $repid
        # update foreground color
        .neuron.rep.main.table.tb rowconfigure $repselected -foreground red
        .neuron.rep.main.table.tb rowconfigure $repselected -selectforeground red
    }
}

proc ::NeuronVND::updateRepMenu {} {
    variable repselected
    variable styleRep
    variable colorRep

    # get rep details from neuro_read
    set repdetails [lindex $::neuro::nrepList $repselected]

    # idea: when a rep is selected in the table, populate the selection, style and color entry/boxs
    set styleRep [lindex $repdetails 3]
    set colorRep [lindex $repdetails 4]
    set selRep [lindex $repdetails 7]
    .neuron.rep.main.sel.entry delete 0 end
    .neuron.rep.main.sel.entry insert 0 $selRep

}

proc ::NeuronVND::editRep {case} {
    variable repselected
    variable styleRep
    variable colorRep
    variable selRep

    set t .neuron.rep.main.table.tb

    # check the selected rep has a different style, get rep details from neuro_read
    set repdetails [lindex $::neuro::nrepList $repselected]

    switch $case {
        "style" {
            if {$styleRep != [lindex $repdetails 3]} {
                # update value in table, as a workaround to edit style
                $t insert $repselected [list $styleRep $colorRep $selRep]
                $t selection set $repselected
                $t delete [expr $repselected + 1]
                # create a copy rep with a different style
                ::NeuronVND::createRep
                # delete previous rep
                ::NeuronVND::delRep
            }
        }
        "sel" {
            if {$selRep != [lindex $repdetails 7]} {
                # update value in table, as a workaround to edit style
                $t insert $repselected [list $styleRep $colorRep $selRep]
                $t selection set $repselected
                $t delete [expr $repselected + 1]
                # create a copy rep with a different style
                ::NeuronVND::createRep
                # delete previous rep
                ::NeuronVND::delRep
            }
        }
        "color" {
            if {$colorRep != [lindex $repdetails 4]} {
                # update value in table, as a workaround to edit style
                $t insert $repselected [list $styleRep $colorRep $selRep]
                $t selection set $repselected
                $t delete [expr $repselected + 1]
                # create a copy rep with a different style
                ::NeuronVND::createRep
                # delete previous rep
                ::NeuronVND::delRep
            }
        }
    }
}

proc ::NeuronVND::exit {} {
    destroy .neuron
    destroy .neuron.rep
    #namespace delete 
}
