/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2016 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: ToolFltkMenu.h,v $
 *      $Author: johns $        $Locker:  $             $State: Exp $
 *      $Revision: 1.15 $       $Date: 2016/11/28 03:05:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  generated by Fast Light User Interface Designer (fluid) version 1.0100
 ***************************************************************************/
#ifndef tool_h
#define tool_h

#include "VMDFltkMenu.h"
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Hold_Browser.H>
#include <FL/Fl_Tabs.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Value_Input.H>
#include <FL/Fl_Round_Button.H>

/// VMDFltkMenu subclass that implements a GUI for configuring Tool,  
/// Sensor, Button, Feedback, and VMDTracker objects.
class ToolFltkMenu : public VMDFltkMenu {
protected:
  int act_on_command(int, Command *);

private:
  void make_window();
  Fl_Choice *tooltypechooser;
  Fl_Browser *toolbrowser;
  Fl_Choice *positionchooser;
  Fl_Choice *buttonchooser;
  Fl_Choice *forcechooser;
  Fl_Value_Input *xoffsetinput;
  Fl_Value_Input *yoffsetinput;
  Fl_Value_Input *zoffsetinput;
  Fl_Value_Input *positionscalinginput;
  Fl_Value_Input *forceconstantinput;
  Fl_Value_Input *forcescalinginput;
  Fl_Round_Button *forceatombutton;
  Fl_Round_Button *forcerepbutton;
  Fl_Choice *repmoleculechooser;
  Fl_Choice *reprepchooser;
  Fl_Tabs *tooltabs;

public:
  ToolFltkMenu(VMDApp *);

  /// Put tracker, force, and button device names into choosers
  void reset_device_menus();

  /// Re-create list of of active tools
  void reset_tool_list();

  /// Create a new tool, using the current tool type from the tooltypechooser
  void create_tool();

  /// Delete the currently selected tool.
  void delete_tool();

  /// Change the currently selected tool to the currently selected type.
  /// Does nothing if no tool is selected.
  void select_tool_type();

  /// A tool has been selected in the toolchooser; update the values
  /// for the devices, offset, force, etc.
  void select_tool();

  /// A device of the given type has been chosen in the GUI
  void choose_tracker(const char *);
  void choose_feedback(const char *);
  void choose_buttons(const char *);

  /// set the tool offset based on current values
  void set_offset();
  
  /// set the spring constant for the tool based on the current value
  void set_springscale();
  
  /// set the force scale for the tool based on current values.
  void set_forcescale();

  /// set the position scaling for the tool based on the current value
  void set_positionscale();

  /// Set the rep, if any, assigned to the current tool.
  void set_toolrep();

  /// Make the tool rep reflect reality, based on currently existing molecules
  /// and reps and the currently selected tool, if any.
  void update_toolrep_choosers();

  /// Update the rep list to reflect the currently selected molecule
  void update_replist();
};
  
#endif
