/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2016 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

#ifndef ISOCONTOUR_H
#define ISOCONTOUR_H

#include "BaseMolecule.h"
#include "ResizeArray.h"

/// structure containing xy values for line vertices
typedef struct {
   float x;
   float y;
} XY;

/// structure defining a triangle generated by isocontour extraction code
typedef struct {
   XY p[2];     ///< vertices
} LINE;

/// set of 4 grid samples used for isocontour extraction
typedef struct {
   XY p[4];     ///< 4 vertices (corners of square)
   float val[4]; ///< 4 density values 
   int cubeindex;
} SQUARECELL;

/// Class implementing triangulated isocontour extraction routines
class IsoContour {
 public:
   int numtriangles;              ///< number of triangles in the facet list.
   ResizeArray<float>  v;         ///< vertices
   ResizeArray<int>    f;         ///< facets
   const VolumetricData * vol;    ///< volume data pointer
   float xax[3], yax[3], zax[3];  ///< axes/size of volume

 public:
   IsoContour(); ///< constructor

   /// calculate isocontour for a given isovalue and step size
   int compute(const VolumetricData *, float isovalue, int step); 

   void clear(); ///< free up memory

 /* private: */
 public:
   int DoCell(int x, int y, int z, float isovalue, int step);
   int Polygonise(const SQUARECELL grid, const float isolevel, LINE *lines);
   void VertexInterp(float isolevel, const SQUARECELL grid, int ind1, int ind2, XY *vert); 
};


#if defined(ISOCONTOUR_INTERNAL)

static int edgeTable[16]={
0x0  , 0x109, 0x203, 0x30a, 0x406, 0x50f, 0x605, 0x70c,
0x70c, 0x605, 0x50f, 0x406, 0x30a, 0x203, 0x109, 0x0   };

int lineTable[16][16] =
{{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};

#endif

#endif
