/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2016 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: FileChooserFltkMenu.h,v $
 *      $Author: johns $        $Locker:  $             $State: Exp $
 *      $Revision: 1.17 $       $Date: 2016/11/28 03:04:59 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   generated by Fast Light User Interface Designer (fluid) version 1.0100
 ***************************************************************************/

#ifndef newfilebrowser_h
#define newfilebrowser_h
#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Box.H>
#include "VMDFltkMenu.h"


/// VMDFltkMenu subclass providing a GUI for loading files into VMD
class FileChooserFltkMenu : public VMDFltkMenu {
public:
  FileChooserFltkMenu(VMDApp *);

  int selectmol(int molno);

private:    
  void make_window();
  void add_file(const char *);
  void load_file(const char *);
  void browse_files();

  Fl_Choice *molchooser;
  Fl_Input *filenameinput;
  Fl_Choice *filetypechooser;
  Fl_Button *loadbutton;
  Fl_Button *browsebutton;

  Fl_Group *timestepgroup;
  Fl_Button *allatoncebutton;
  Fl_Button *loadinbackgroundbutton;
  Fl_Input *firstinput;
  Fl_Input *lastinput;
  Fl_Input *strideinput;

  Fl_Browser *datasetbrowser;

  static void browse_cb(Fl_Widget *, void *);  
  static void filenameinput_cb(Fl_Widget *, void *);  
  static void filetype_cb(Fl_Widget *, void *);
  static void load_cb(Fl_Widget *, void *);

  /// rebuild the molecule chooser and selects the "selmol"-th 
  /// molecule (-1 = "new")
  void update_molchooser(int selmol=-1);
    
  void update_filetypes();
  void update_checkboxes();
  
  int has_structure;
  int has_bonds;
  int has_timesteps;
  int has_graphics;
  int has_volumetric;
    
protected:
  int act_on_command(int, Command *);
};
#endif
