/*
 * Copyright (C) 2007 by David J. Hardy.  All rights reserved.
 */

/**@file    moltypes/moltypes.h
 * @brief   Main header for all molecular modeling container classes.
 * @author  David J. Hardy
 * @date    Aug. 2007
 *
 * Container types:
 *
 *   Trajectory  - trajectory.h
 *   Topology    - topology.h
 *   ForcePrm    - forceprm.h
 *   ForceResult - forceresult.h
 *   SimParm     - simparm.h
 *   SimResult   - simresult.h
 *   SimIO       - simio.h
 */

#ifndef MOLTYPES_H
#define MOLTYPES_H

//#include "moltypes/basic.h"
//#include "moltypes/mathfunc.h"
#include "moltypes/forceprm.h"
#include "moltypes/topology.h"
#include "moltypes/exclude.h"
#include "moltypes/coord.h"
#include "moltypes/energy.h"
#include "moltypes/simprm.h"
//#include "moltypes/trajectory.h"
//#include "moltypes/forceresult.h"
//#include "moltypes/stepparm.h"
//#include "moltypes/stepresult.h"

#endif /* MOLTYPES_H */
