/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: vmdconsole.h,v $
 *      $Author: johns $        $Locker:  $             $State: Exp $
 *      $Revision: 1.2 $       $Date: 2007/01/12 20:08:38 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * vmd console redirector 
 * (c) 2006 Axel Kohlmeyer <akohlmey@cmm.chem.upenn.edu>
 * 
 ***************************************************************************/

/* common definitions for the vmdconsole plugin */
#ifndef _VMDCONSOLE_H
#define _VMDCONSOLE_H

#ifdef __cplusplus
extern "C" {
#endif

/* turn on text mode processing */
extern void vmdcon_use_text(void);

/* (de-)register a widget to be the console window */
extern int vmdcon_register(const char *w_path, const char *mark, void *interp);

/* append a string of up to 'length' characters to console message queue.
 * 'length' can be -1 to autodetect length with \0 terminated strings.
 * a 'length' of 0 means, do not add to message queue.  */
extern int vmdcon_append(const char *text, int length);

/* purge message queue into registered text widget.*/
extern int vmdcon_purge(void);

/* print to the current vmd console, printf style.*/
extern int vmdprintf(const char *format, ...);

/* insert text into an existing text widget */
extern int tcl_vmdcon_insert(void *interp, const char *w_path, const char *mark, const char *text);

#ifdef __cplusplus
}
#endif

#endif
