/* -*- c++ -*- */

%typemap(python,in) (int , char *[]) {
  /* Check if is a list */
  if (PyList_Check($input)) {
    int i;
    $1 = PyList_Size($input);
    $2 = (char **) malloc(($1+1)*sizeof(char *));
    for (i = 0; i < $1; i++) {
      PyObject *o = PyList_GetItem($input,i);
      if (PyString_Check(o))
        $2[i] = PyString_AsString(PyList_GetItem($input,i));
      else {
        PyErr_SetString(PyExc_TypeError,"list must contain strings");
        free($2);
        return NULL;
      }
    }
    $2[i] = 0;
  } else {
    PyErr_SetString(PyExc_TypeError,"not a list");
    return NULL;
  }
}

%typemap(freearg) (int argc, char **argv) {
  free((char *) $2);
}

// Python sequence -> int[2]
%typemap(python,in) int[2] {
  if (!PySequence_Check($input) || PySequence_Size($input) != 2) {
    PyErr_SetString(PyExc_TypeError, 
      "int[2] argument requires sequence of two elements");
    return NULL;
  }
  $1 = (int *)malloc(2*sizeof(int));
  PyObject *item0, *item1;
  item0 = PySequence_GetItem($input, 0);
  item1 = PySequence_GetItem($input, 1);
  if (!item0 || !item1) {
    PyErr_SetString(PyExc_ValueError, "Unable to access elements in sequence");
    return NULL;
  }
  $1[0] = PyInt_AsLong(PySequence_GetItem($input, 0));
  $1[1] = PyInt_AsLong(PySequence_GetItem($input, 1));
  if (PyErr_Occurred()) return NULL;
}
%typemap(python,freearg) int[2] {
  free($1);
}

// typemap for add_volumetric.
%typemap(python,in) (int xsize, int ysize, int zsize, float *datablock) {
  PyErr_SetString(PyExc_NotImplementedError, "Sorry, volumetric not implemented");
  return NULL;
}

// typemap for coordinates.  Try to be efficient...
%typemap(python,in) const float *coordinates {
  PyObject *coordobj = PySequence_Fast($input, "coordinates argment requires sequence input");
  if (!coordobj) return NULL;
  int size = PySequence_Fast_GET_SIZE(coordobj);
  if (!size || size % 3) {
    PyErr_SetString(PyExc_TypeError, "coordinates argment must contain a multiple of three elements");
    return NULL;
  }
  $1 = (float *)malloc(3*size*sizeof(float));
  for (int i=0; i<size; i++) {
    PyObject *item = PySequence_Fast_GET_ITEM(coordobj, i);
    // Dont use macro; otherwise ints wont be cast to floats.
    $1[i] = PyFloat_AsDouble(item);
    printf("got %f\n", $1[i]);
  }
  Py_DECREF(coordobj);
}
%typemap(python,freearg) const float *coordinates {
  free($1);
}

// This tells SWIG to treat an double * argument with name 'OutValue' as
// an output value.  We append the value to the current result which 
// is guaranteed to be a List object by SWIG.

%typemap(argout) int *out {
    PyObject *o, *o2, *o3;
    o = PyFloat_FromDouble(*$1);
    if ((!$result) || ($result == Py_None)) {
        $result = o;
    } else {
        if (!PyTuple_Check($result)) {
            PyObject *o2 = $result;
            $result = PyTuple_New(1);
            PyTuple_SetItem($result,0,o2);
        }
        o3 = PyTuple_New(1);
        PyTuple_SetItem(o3,0,o);
        o2 = $result;
        $result = PySequence_Concat(o2,o3);
        Py_DECREF(o2);
        Py_DECREF(o3);
    }
}
%typemap(ignore) int *out (int temp) {
  $1 = &temp;
}

%typemap(python, in) const FileSpec *spec {
  if (!PyDict_Check($input)) {
    PyErr_SetString(PyExc_ValueError, "FileSpec argument must be a dictionary.");
    return NULL;
  }
  PyObject *first = PyDict_GetItemString($input, (char *)"first");
  PyObject *last = PyDict_GetItemString($input, (char *)"last");
  PyObject *stride = PyDict_GetItemString($input, (char *)"step");
  PyObject *waitfor = PyDict_GetItemString($input, (char *)"waitfor");
  PyObject *volsets = PyDict_GetItemString($input, (char *)"volsets");

  $1 = new FileSpec;
  if (first) $1->first = PyInt_AsLong(first);
  if (last)  $1->last = PyInt_AsLong(last);
  if (stride) $1->stride = PyInt_AsLong(stride);
  if (waitfor) $1->waitfor = PyInt_AsLong(waitfor);
  if (volsets) {
    if (!PyList_Check(volsets)) {
      PyErr_SetString(PyExc_ValueError, "volsets component of FileSpec must be list");
      delete $1;
      return NULL;
    }
    $1->nvolsets = PyList_GET_SIZE(volsets);
    $1->setids = new int[$1->nvolsets];
    for (int i=0; i<$1->nvolsets; i++) {
      $1->setids[i] = PyInt_AsLong(PyList_GET_ITEM(volsets, i));
      if (PyErr_Occurred()) {
        delete $1;
        return NULL;
      }
    }
  }
}

%typemap(python,freearg) const FileSpec *spec {
  delete $1;
}



