/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: tcl_commands.C,v $
 *      $Author: johns $        $Locker:  $             $State: Exp $
 *      $Revision: 1.23 $       $Date: 2007/01/12 20:08:37 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Fundamental VMD Tcl text commands
 ***************************************************************************/

#include "tcl.h"
#include "TclCommands.h"
#include "tcl_commands.h"
#include "config.h"
#include <string.h>

class VMDApp;

#define SIMPLE_TCL_OPT(string,result)       \
if (!strcmp(argv[1], string)) {             \
  Tcl_AppendResult(interp, result, NULL);   \
  return TCL_OK;                            \
}

static int vmdinfo_tcl(ClientData, Tcl_Interp *interp,
                       int argc, const char *argv[])
{
  if (argc == 2) {
    SIMPLE_TCL_OPT("version", VMDVERSION);
    SIMPLE_TCL_OPT("versionmsg", VERSION_MSG);
    SIMPLE_TCL_OPT("authors", VMD_AUTHORS);
    SIMPLE_TCL_OPT("arch", VMD_ARCH);
    SIMPLE_TCL_OPT("options", VMD_OPTIONS);
    SIMPLE_TCL_OPT("www", VMD_HOMEPAGE);
    SIMPLE_TCL_OPT("wwwhelp", VMD_HELPPAGE);
  }
  Tcl_AppendResult(interp,
"vmdinfo: version | versionmsg | authors | arch | options | www | wwwhelp",
                   NULL);
  return TCL_ERROR;
}

int Vmd_Init(Tcl_Interp *interp) {
  VMDApp *app = (VMDApp *)Tcl_GetAssocData(interp, "VMDApp", NULL);
  Tcl_CreateCommand(interp,  "vmdinfo", vmdinfo_tcl,
                      (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "animate", text_cmd_animate,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "color", text_cmd_color,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "axes", text_cmd_axes,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "display", text_cmd_display,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "imd", text_cmd_imd,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "vmdcollab", text_cmd_collab,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "vmd_label", text_cmd_label,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "light", text_cmd_light,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "material", text_cmd_material,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "vmd_menu", text_cmd_menu,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);
  
  Tcl_CreateCommand(interp, "stage", text_cmd_stage,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "light", text_cmd_light,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "user", text_cmd_user,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "mol", text_cmd_mol,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "molecule", text_cmd_mol,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "mouse", text_cmd_mouse,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "plugin", text_cmd_plugin,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "render", text_cmd_render,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

#if defined(VMDTK) && !defined(_MSC_VER)
  Tcl_CreateCommand(interp, "tkrender", text_cmd_tkrender,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);
#endif

  Tcl_CreateCommand(interp, "rock", text_cmd_rock,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "rotate", text_cmd_rotate,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "rotmat", text_cmd_rotmat,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "vmd_scale", text_cmd_scale,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "translate", text_cmd_translate,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "sleep", text_cmd_sleep,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(interp, "tool", text_cmd_tool,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateObjCommand(interp,  "measure", obj_measure,
                    (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateObjCommand(interp,  "rawtimestep", cmd_rawtimestep,
                    (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateObjCommand(interp,  "gettimestep", cmd_gettimestep,
                    (ClientData) app, (Tcl_CmdDeleteProc *) NULL);

#ifdef VMDPYTHON
  Tcl_CreateCommand(interp, "gopython", text_cmd_gopython,
        (ClientData) app, (Tcl_CmdDeleteProc *) NULL);
#endif

#if defined(VMDTKCON)
  Tcl_CreateObjCommand(interp,"vmdcon",tcl_vmdcon,
        (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);
#endif
  
  Tcl_CreateObjCommand(interp,  "volmap", obj_volmap,
                    (ClientData) app, (Tcl_CmdDeleteProc *) NULL);
  
  return TCL_OK;
}

