/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: py_commands.h,v $
 *      $Author: johns $        $Locker:  $             $State: Exp $
 *      $Revision: 1.33 $       $Date: 2007/03/03 19:59:46 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Core VMD Python interface.
 ***************************************************************************/

#ifndef PY_COMMANDS_H
#define PY_COMMANDS_H

#if defined(__APPLE__)
// use the Apple-provided Python framework
#include "Python/Python.h"
#else
#include "Python.h"
#endif

class VMDApp;
extern VMDApp *get_vmdapp();

// turn a PyObject into an array of three floats, if possible
// The object must be a tuple of size 3
// return 1 on success, 0 on error
extern int py_array_from_obj(PyObject *obj, float *arr);

extern void initanimate();
extern void initatomselection();
extern void initatomsel();
extern void initaxes();
extern void initcolor();
extern void initdisplay();
extern void initgraphics();
extern void initimd();
extern void initlabel();
extern void initmaterial();
extern void initmolecule();
extern void initmolrep();
extern void initmouse();
extern void initrender();
extern void inittrans();
extern void initvmdmenu();

#ifdef VMDNUMPY
extern void initvmdnumpy();
#endif

// use this typedef so that we can define our Python methods as static 
// functions, then cast them to the proper type, rather than declaring the
// functions extern "C", which can lead to namespace collision. 

extern "C" {
  typedef PyObject *(*vmdPyMethod)(PyObject *, PyObject *);
}

#endif

