/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: macosxvmdstart.C,v $
 *      $Author: johns $        $Locker:  $             $State: Exp $
 *      $Revision: 1.13 $      $Date: 2007/01/12 20:08:37 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  MacOS X startup code
 ***************************************************************************/

// only compile this file if we're building on MacOS X
#if defined(ARCH_MACOSX) || defined(ARCH_MACOSXX86)

#include <Carbon/Carbon.h>    /* Carbon APIs for process management */
#include <stdlib.h>
#include <stdio.h>            
#include "utilities.h"        /* string/filename manipulation routines */

OSErr GetApplicationBundleFSSpec(FSSpecPtr theFSSpecPtr) {
   OSErr err;
   ProcessSerialNumber psn;
   err = GetCurrentProcess(&psn);
   if (err != noErr) return err;

   FSRef location;
   err = GetProcessBundleLocation(&psn, &location);
   if (err != noErr) return err;

   return FSGetCatalogInfo(&location, kFSCatInfoNone, 
     NULL, NULL, theFSSpecPtr, NULL);
}

OSErr GetApplicationPackageFSSpecFromBundle(FSSpecPtr theFSSpecPtr) {
  OSErr err = fnfErr;
  CFBundleRef myAppsBundle = CFBundleGetMainBundle();
  if (myAppsBundle == NULL) return err;
  CFURLRef myBundleURL = CFBundleCopyBundleURL(myAppsBundle);
  if (myBundleURL == NULL) return err;

  FSRef myBundleRef;
  Boolean ok = CFURLGetFSRef(myBundleURL, &myBundleRef);
  CFRelease(myBundleURL);
  if (!ok) return err;

  return FSGetCatalogInfo(&myBundleRef, kFSCatInfoNone,
    NULL, NULL, theFSSpecPtr, NULL);
}

static char * vmd_get_vmddir(void) {
  FSSpec spec;
  FSRef ref;
  UInt8 * path;
  OSErr rc;
  char *bundledir;
  char *vmddir;
  char *tmp;

  bundledir = (char *) malloc(2048 * sizeof(UInt8));
  memset(bundledir, 0, 2048 * sizeof(UInt8));

#if 0
  if (!(rc = GetApplicationPackageFSSpecFromBundle(&spec))) {
#else
  if (!(rc = GetApplicationBundleFSSpec(&spec))) {
#endif
    rc = FSpMakeFSRef(&spec, &ref);
    if (rc) printf("makefsref OSErr: %d\n", rc);
      
    rc = FSRefMakePath(&ref,(UInt8 *) bundledir, 2048);
    if (rc) printf("makepath OSErr: %d\n", rc);
  } else {
    printf("getappbundlepath OSErr: %d\n", rc);
  }

  if (rc) {
    free(bundledir);
    return NULL;
  } 

  // truncate bundle path to parent bundle directory
  if ((tmp = strrchr(bundledir, '/')) != NULL) {
    tmp[0] = '\0';
  }
  if ((tmp = strrchr(bundledir, '/')) != NULL) {
    tmp[0] = '\0';
  }

  // add "/vmd" to parent bundle directory
  vmddir = (char *) malloc(strlen(bundledir) + 1 + strlen("/vmd"));
  strcpy(vmddir, bundledir);
  strcat(vmddir, "/vmd");

  free(bundledir);

  return (char *) vmddir;
}


#if 1
int macosxvmdstart(int argc, char **argv) {
#else
int main(int argc, char **argv) {
#endif
  char tmp[8192];
  char * vmddir;
  int i;

  vmddir = vmd_get_vmddir();
  if (vmddir == NULL) {
    return -1; // fail and exit
  }

#if 0
  if (!getenv("MACOSXVMDSTARTUP")) {
    int startterminal=1; // be default, we start one...

    putenv("MACOSXVMDSTARTUP=1");
    // check for -dispdev text, in which case we don't start a terminal...
    for (i=0; i < argc; i++) {
      if (!strupcmp(argv[i], "-dispdev")) {
        if (argc > i+1) {
          if (!strupcmp(argv[i+1], "text")) {
            startterminal=0;
          }
        } 
      }
    }

    if (startterminal) {
      char cmdbuf[16384];
      sprintf(cmdbuf, "\"%s/vmd_MACOSX\"", vmddir);
      if (argc > 1) {
        for (i=1; i < argc; i++) {
          strcat(cmdbuf, " ");
          strcat(cmdbuf, argv[i]);
        }
      }
      strcat(cmdbuf, " &");

printf("Executing VMD startup command: %s\n", cmdbuf);
      exit(system(cmdbuf));
    }
  }
#endif

  if (!getenv("VMDDIR")) {
    strcpy(tmp, "VMDDIR=");
    strcat(tmp, vmddir);
    putenv(tmp);
  }

  if (!getenv("TCL_LIBRARY")) {
    strcpy(tmp, "TCL_LIBRARY=");
    strcat(tmp, vmddir);
    strcat(tmp, "/scripts/tcl");
    putenv(tmp);
  }

  if (!getenv("TK_LIBRARY")) {
    strcpy(tmp, "TK_LIBRARY=");
    strcat(tmp, vmddir);
    strcat(tmp, "/scripts/tk");
    putenv(tmp);
  }

  if (!getenv("PYTHONPATH")) {
    strcpy(tmp, "PYTHONPATH=");
    strcat(tmp, vmddir);
    strcat(tmp, "/scripts/python");
    putenv(tmp);
  } else {
    strcpy(tmp, getenv("PYTHONPATH"));
    strcat(tmp, ":");
    strcat(tmp, vmddir);
    strcat(tmp, "/scripts/python");
    putenv(tmp);
  }

  if (!getenv("STRIDE_BIN")) {
    strcpy(tmp, "STRIDE_BIN=");
    strcat(tmp, vmddir);
#if defined(ARCH_MACOSXX86)
    strcat(tmp, "/stride_MACOSXX86");
#else
    strcat(tmp, "/stride_MACOSX");
#endif
    putenv(tmp);
  }

  if (!getenv("SURF_BIN")) {
    strcpy(tmp, "SURF_BIN=");
    strcat(tmp, vmddir);
#if defined(ARCH_MACOSXX86)
    strcat(tmp, "/surf_MACOSXX86");
#else
    strcat(tmp, "/surf_MACOSX");
#endif
    putenv(tmp);
  }

  if (!getenv("TACHYON_BIN")) {
    strcpy(tmp, "TACHYON_BIN=");
    strcat(tmp, vmddir);
#if defined(ARCH_MACOSXX86)
    strcat(tmp, "/tachyon_MACOSXX86");
#else
    strcat(tmp, "/tachyon_MACOSX");
#endif
    putenv(tmp);
  }

  return 0;
}


#endif

