/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

#include <stdlib.h>
#include <tcl.h>
#include "config.h"
#include "VMDApp.h"
#include "Mouse.h"
#include "utilities.h"


// print usage message
static void mouse_usage(Tcl_Interp *interp) {
  Tcl_AppendResult(interp, "mouse usage:\n",
                   "mouse callback [on|off]\n",
                   "mouse rocking [on|off]\n",
                   "mouse mode <mode> <submode>\n",
                   "   modes: rotate, translate, scale, light, pick, user, userpoint\n",
                    NULL);
}


// The following use MOUSE_MODE
int text_cmd_mouse(ClientData cd, Tcl_Interp *interp, int argc,
                            const char *argv[]) {

  VMDApp *app = (VMDApp *)cd;

  if (argc == 2 && !strupncmp(argv[1], "stoprotation", CMDLEN)) {
    app->scene_stoprotation();
    return TCL_OK;
  } else if(argc < 3 || argc > 4) {
    // if here, something went wrong, so return an error message
    mouse_usage(interp);
    return TCL_ERROR;
  }

  // the modes are:
  //  ROTATION == 0, ... USER == 6 ; as defined in Mouse.h
  if(!strupncmp(argv[1], "mode", CMDLEN)) {
    int m1;
    // see if these are string values
    if (!strupncmp(argv[2], "rotate", CMDLEN)) {
      m1 = Mouse::ROTATION;  
    } else if (!strupncmp(argv[2], "translate", CMDLEN)) { 
      m1 = Mouse::TRANSLATION;  
    } else if (!strupncmp(argv[2], "scale", CMDLEN)){ 
      m1 = Mouse::SCALING;  
    } else if (!strupncmp(argv[2], "light", CMDLEN)){ 
      m1 = Mouse::LIGHT;  
    } else if (!strupncmp(argv[2], "pick", CMDLEN)) { 
      m1 = Mouse::PICKING;  
    } else if (!strupncmp(argv[2], "user", CMDLEN)) { 
      m1 = Mouse::USER; 
    } else if (!strupncmp(argv[2], "userpoint", CMDLEN)) {
      m1 = Mouse::USERPOINT;
    } else {
      // not a string so convert to a number
      // XXX need to check if atoi fails..
      m1 = atoi(argv[2]);
    }
    // get the mouse submode, if there is one
    int m2 = (argc > 3 ? atoi(argv[3]) : (-1));
    if (!app->mouse_set_mode(m1, m2)) {
      Tcl_AppendResult(interp, "Unable to set mouse mode to ",
          argv[2], argc > 3 ? argv[3] : NULL, NULL);

      // if here, something went wrong, so return an error message
      mouse_usage(interp);

      return TCL_ERROR;
    }
  } else if(!strupncmp(argv[1], "callback", CMDLEN)) {
    int on=-1;
    Tcl_GetBoolean(interp, argv[2], &on);
    if(on!=-1) {
      app->set_mouse_callbacks(on);
    }
  } else if (argc == 3 && !strupncmp(argv[1], "rocking", CMDLEN)) {
    int on = 0;
    if (Tcl_GetBoolean(interp, argv[2], &on) != TCL_OK) return TCL_ERROR;
    app->set_mouse_rocking(on);
  } else {
    // if here, something went wrong, so return an error message
    mouse_usage(interp);
    return TCL_ERROR;
  }
  
  // if here, everything worked out ok
  return TCL_OK;
}

