/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: VolMap.h,v $
 *      $Author: johns $        $Locker:  $             $State: Exp $
 *      $Revision: 1.6 $       $Date: 2007/01/12 20:08:35 $
 *
 **************************************************************************/

///////////////////  VolMap ////////////////

/// Volumetric data class for use by VolMapCreate, etc...
/// Temporary solution for storing volumetricData. This class' member
/// variables mirror those in VolumetricData, for possible merging 
/// later on...

/// NOTE: Most VolMap methods do not properly support non-orthogonal cells.
/// This is fine for its current usage, but be careful porting some methods
/// over to the VolumetricData class, as the latter needs to support 
/// slanted cells.

class VolumetricData;

class VolMap {
public:
  float origin[3];        /// origin of volume (x=0, y=0, z=0 corner)
  float xaxis[3];         /// direction and length for X axis (non-unit)
  float yaxis[3];         /// direction and length for Y axis (non-unit)
  float zaxis[3];         /// direction and length for Z axis (non-unit)
// do not change the following to doubles, as the *_from_coord methods
// will return wrong answers, (unless they are modified)
  float xdelta[3];        /// x axis of unit cell
  float ydelta[3];        /// y axis of unit cell
  float zdelta[3];        /// z axis of unit cell
  int xsize, ysize, zsize; /// number of samples along each axis
  int gridsize;
  float *data;             /// raw data, total of xsize*ysize*zsize voxels
  char  owns_data;
  float weight;            /// weight associated with map (used when combining)
  float temperature;       /// temperature for ligand pmf maps
      
  /// constructor
  VolMap();
  VolMap(const VolumetricData *voldata);
      
  /// destructor
  ~VolMap();
  
  // run this when delta and size are modified.
  void update_internal();
  
  void clone(const VolMap *volmap);
  
  
  /// Sets data name to an internal copy of the provided string
  void set_name(const char* name);
  
  // get a pointer to the internal name string 
  // (i.e., please make a copy if you intend to keep it)
  const char *get_name() const;

  int write_dx_file (const char *filename);
  
  /// clears the volmap with zeros (or value)
  void fill(float value=0.);

  inline int voxel_index(int gx, int gy, int gz) {
    return (gx + gy*xsize + gz*ysize*xsize);
  }
    
  /// return voxel at requested index, no safety checks
  inline float voxel_value(int gx, int gy, int gz) {
    return data[gx + gy*xsize + gz*ysize*xsize];
  }

  /// return voxel, after safely clamping index to valid range
  float voxel_value_safe(int x, int y, int z) const ;
  
  /// return interpolated value from 8 nearest neighbor voxels
  float voxel_value_interpolate(float xv, float yv, float zv) const ;
  int coord_to_index(float x, float y, float z);
  float voxel_value_from_coord(float xpos, float ypos, float zpos) const;
  float voxel_value_interpolate_from_coord(float xpos, float ypos, float zpos) const;

  void peel_by_negative_gradient();
          
  // El cheapo convolution. Needs to be more powerful and accept a 3x3 or bigger
  // matrix, but all I needed was a simple smooth to test out the feature...
  void smooth();
  
private:
  char *dataname;

};
