/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: VMDThreads.h,v $
 *      $Author: johns $        $Locker:  $             $State: Exp $
 *      $Revision: 1.14 $       $Date: 2007/01/12 20:08:34 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  code for spawning threads on various platforms.
 ***************************************************************************/

#ifndef VMD_THREADS_INC
#define VMD_THREADS_INC 1

/* define which thread calls to use */
#if defined(USEPOSIXTHREADS) && defined(USEUITHREADS)
#error You may only define USEPOSIXTHREADS or USEUITHREADS, but not both
#endif

/* POSIX Threads */
#if defined(HPUX) || defined(Irix) || defined(Linux) || defined(_CRAY) || defined(__osf__) || defined(AIX) || defined(_AIX) || defined(__APPLE__)
#if !defined(USEUITHREADS) && !defined(USEPOSIXTHREADS)
#define USEPOSIXTHREADS
#endif
#endif

/* Unix International Threads */
#if defined(__sun)
#if !defined(USEPOSIXTHREADS)
#define USEUITHREADS
#endif
#endif



#ifdef VMDTHREADS
#ifdef USEPOSIXTHREADS
#include <pthread.h>

typedef pthread_t        vmd_thread_t;
typedef pthread_mutex_t   vmd_mutex_t;

typedef struct vmd_barrier_struct {
  int padding1[8]; /* Padding bytes to avoid false sharing and cache aliasing */
  pthread_mutex_t lock;   /* Mutex lock for the structure */
  int n_clients;          /* Number of threads to wait for at barrier */
  int n_waiting;          /* Number of currently waiting threads */
  int phase;              /* Flag to separate waiters from fast workers */
  int sum;                /* Sum of arguments passed to barrier_wait */
  int result;             /* Answer to be returned by barrier_wait */
  pthread_cond_t wait_cv; /* Clients wait on condition variable to proceed */
  int padding2[8]; /* Padding bytes to avoid false sharing and cache aliasing */
} vmd_barrier_t;

#endif

#ifdef USEUITHREADS
#include <thread.h>

typedef thread_t  vmd_thread_t;
typedef mutex_t    vmd_mutex_t;

typedef struct vmd_barrier_struct {
  int padding1[8]; /* Padding bytes to avoid false sharing and cache aliasing */
  mutex_t lock;           /* Mutex lock for the structure */
  int n_clients;          /* Number of threads to wait for at barrier */
  int n_waiting;          /* Number of currently waiting threads */
  int phase;              /* Flag to separate waiters from fast workers */
  int sum;                /* Sum of arguments passed to barrier_wait */
  int result;             /* Answer to be returned by barrier_wait */
  cond_t wait_cv;         /* Clients wait on condition variable to proceed */
  int padding2[8]; /* Padding bytes to avoid false sharing and cache aliasing */
} vmd_barrier_t;

#endif



#ifdef _MSC_VER
#include <windows.h>
typedef HANDLE vmd_thread_t;
typedef HANDLE vmd_mutex_t;
typedef HANDLE vmd_barrier_t;
#endif
#endif



#ifndef VMDTHREADS
typedef int vmd_thread_t;
typedef int vmd_mutex_t;
typedef int vmd_barrier_t;
#endif



int vmd_thread_numprocessors(void);
int vmd_thread_setconcurrency(int);
int vmd_thread_create(vmd_thread_t *, void * routine(void *), void *);
int vmd_thread_join(vmd_thread_t, void **);
int vmd_mutex_init(vmd_mutex_t *);
int vmd_mutex_lock(vmd_mutex_t *);
int vmd_mutex_unlock(vmd_mutex_t *);
int vmd_mutex_destroy(vmd_mutex_t *);
int vmd_thread_barrier_init(vmd_barrier_t *, int n_clients);
void vmd_thread_barrier_destroy(vmd_barrier_t *barrier);
int vmd_thread_barrier(vmd_barrier_t *barrier, int increment);

#endif
