/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: VMDFltkMenu.h,v $
 *      $Author: johns $        $Locker:  $             $State: Exp $
 *      $Revision: 1.12 $       $Date: 2007/01/12 20:08:34 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Class to manage FLTK menus within VMD.
 ***************************************************************************/

#ifndef VMDFLTKMENU_H
#define VMDFLTKMENU_H

#include <FL/Fl_Window.H>
#include "VMDMenu.h"

#if (FL_MAJOR_VERSION >= 1) && (FL_MINOR_VERSION >= 1)
#define VMDFLTKTOOLTIP(obj, string)  (obj)->tooltip(string);
#else 
#define VMDFLTKTOOLTIP(obj, string)
#endif

class Fl_Choice;

/// VMDMenu and FL_Window subclass for managing all FLTK-based menus in VMD
class VMDFltkMenu : public VMDMenu, public Fl_Window {
private:
  char *_title;
  static void window_cb(Fl_Widget *, void *);

protected:
  virtual void do_on();
  virtual void do_off();

public:
  VMDFltkMenu(const char *menuname, const char *title, VMDApp *);
  ~VMDFltkMenu();

  virtual void move(int, int);
  virtual void where(int &, int &);
};

/// a convenience function for filling a molecule chooser
void fill_fltk_molchooser(Fl_Choice *, VMDApp *);

/// a convenience function for generating properly-escaped menu strings
char * escape_fltk_menustring(const char *);

#endif

