/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: SpaceballTracker.h,v $
 *	$Author: johns $	$Locker:  $		$State: Exp $
 *	$Revision: 1.10 $	$Date: 2007/01/12 20:08:32 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * This is Paul's new Tracker code -- pgrayson@ks.uiuc.edu
 *
 * A Tracker that gets its info from the Spaceball driver.
 *
 ***************************************************************************/
#ifndef SPACEBALLTRACKER_H
#define SPACEBALLTRACKER_H

#if defined(VMDSPACEBALL) && !defined(VMDSPACEWARE)

#include "P_Tracker.h"
#include "sball.h"

/// VMDTracker subclass that gets its info from the Spaceball driver
class SpaceballTracker : public VMDTracker {
private:
  SBallHandle sball;                 ///< handle from spaceball I/O library
  float transInc, rotInc, scaleInc;

protected:
  virtual int do_start(const SensorConfig *);
 
public:
  SpaceballTracker();
  ~SpaceballTracker();
  virtual const char *device_name() const { return "sballtracker"; } 
  virtual VMDTracker *clone() { return new SpaceballTracker; }

  virtual void update();
  inline virtual int alive() { return 1; }
};

#endif

#endif
