/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: SpaceballTracker.C,v $
 *	$Author: johns $	$Locker:  $		$State: Exp $
 *	$Revision: 1.9 $	$Date: 2007/03/15 18:01:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * This is Paul's new Tracker code -- pgrayson@ks.uiuc.edu
 *
 *
 ***************************************************************************/

#if defined(VMDSPACEBALL) && !defined(VMDSPACEWARE)

#include <stdlib.h> // for getenv(), abs() etc.
#include <string.h>
#include "SpaceballTracker.h"
#include "Matrix4.h"
#include "Inform.h"
#include "utilities.h"

SpaceballTracker::SpaceballTracker() {
  sball=NULL; // zero it out to begin with
}

int SpaceballTracker::do_start(const SensorConfig *config) {

  if (sball) return FALSE;
  if (!config->require_local()) return 0;
  if (!config->have_one_sensor()) return 0;

  char *myUSL = stringdup(config->getname());
  
  msgInfo << "Opening Spaceball on port: " << myUSL << sendmsg;
  sball = sball_open(myUSL);
  delete [] myUSL;

  if (sball == NULL) 
    msgErr << "Failed to open Spaceball port, Spaceball input disabled" 
           << sendmsg; 

  // set the default translation and rotation increments
  // these really need to be made user modifiable at runtime
  transInc = 1.0f / 6000.0f;
    rotInc = 1.0f /   50.0f;
  scaleInc = 1.0f / 6000.0f;

  // reset the position
  moveto(0,0,0);
  orient->identity();

  return TRUE;
}

SpaceballTracker::~SpaceballTracker(void) {
  if (sball != NULL)
    sball_close(sball);
}

void SpaceballTracker::update() {
  Matrix4 temp;

  if(!alive()) {
    moveto(0,0,0);
    orient->identity();
    return;
  }

  int tx, ty, tz, rx, ry, rz, buttons;

  if (!sball_getstatus(sball, &tx, &ty, &tz, &rx, &ry, &rz, &buttons))
    return;

  // Z-axis rotation/trans have to be negated in order to convert to the
  // VMD coordinate system
  temp.identity();
  temp.rot( ((float)rx)*rotInc, 'x' );
  temp.rot( ((float)ry)*rotInc, 'y' );
  temp.rot(-((float)rz)*rotInc, 'z' );
  temp.multmatrix(*orient);
  orient->loadmatrix(temp);
  pos[0] += tx * transInc;
  pos[1] += ty * transInc;
  pos[2] +=-tz * transInc;
}

#endif
