/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Spaceball.h,v $
 *	$Author: johns $	$Locker:  $		$State: Exp $
 *	$Revision: 1.15 $	$Date: 2007/01/12 20:08:32 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The Spaceball UI object, which maintains the current state of the 
 * spaceball.  This code uses John Stone's spaceball driver library.
 *
 ***************************************************************************/
#ifndef SPACEBALL_OBJ_H
#define SPACEBALL_OBJ_H

#if defined(VMDSPACEBALL) || defined(VMDSPACEWARE)

#include "UIObject.h"
#include "Command.h"
#include "NameList.h"

#if defined(VMDSPACEBALL) && !defined(VMDSPACEWARE)
#include "sball.h" // spaceball I/O library header
#endif

/// UIObject subclass for Spaceball-based motion control
class Spaceball : public UIObject {
public:
  /// enum for Spaceball movement modes
  enum MoveMode { ROTTRANS, MAXAXIS, SCALING };

private:
#if defined(VMDSPACEBALL) && !defined(VMDSPACEWARE)
  SBallHandle sball; ///< handle from spaceball I/O library
#endif

  MoveMode moveMode; ///< the current move mode
  float transInc;    ///< increment for translation
  float rotInc;      ///< increment for rotation
  float scaleInc;    ///< increment for scaling
  float scaling;     ///< scale factor
  int buttonDown;    ///< which buttons are down 

public:
  Spaceball(VMDApp *);      ///< constructor
  virtual ~Spaceball(void); ///< destructor
  
  //
  // virtual routines for UI init/display
  //
   
  /// reset the user interface (force update of all info displays)
  virtual void reset(void);
  
  /// update the display due to a command being executed.  Return whether
  /// any action was taken on this command.
  /// Arguments are the command type, command object, and the 
  /// success of the command (T or F).
  virtual int act_on_command(int, Command *); ///< command execute update
  
  /// check for and event, queue and return TRUE if one is found.  
  virtual int check_event(void);
};

#endif

#endif

