/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Residue.h,v $
 *	$Author: johns $	$Locker:  $		$State: Exp $
 *	$Revision: 1.30 $	$Date: 2007/01/12 20:08:31 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  This is based on the uniq_resid assigned in BaseMolecule
 * A residue knows the other residues to which it is connected.  It also
 * has a list of all the atoms contained by this residue
 *
 ***************************************************************************/
#ifndef RESIDUE_H
#define RESIDUE_H

#include "Atom.h" // to get enums from Atom
#include "ResizeArray.h"

#if 0
// maximum number of bonds between residues
#define MAXRESIDUEBONDS 4
#endif

// these are secondary structure definitions from Stride
#define SS_HELIX_ALPHA 0
#define SS_HELIX_3_10  1
#define SS_HELIX_PI    2
#define SS_BETA        3
#define SS_BRIDGE      4
#define SS_TURN        5
#define SS_COIL        6

/// Based on the uniq_resid assigned in BaseMolecule, a residue knows 
/// what other residues it is connected to, and maintains a list of
/// the atoms it contains
class Residue {
  public:
    int resid;                    ///< non-unique resid from the original file
    signed char residueType;      ///< residue type code
    signed char sstruct;          ///< secondary structure for this residue

#if defined(MAXRESIDUEBONDS)
    // XXX residue bonds are currently only used by the BaseMolecule 
    //     structure analysis routines.  For systems containing a lot of 
    //     water, we could save a significant amount of memory by storing this
    //     information only during use in the analysis routines.
    short bonds;                  ///< number of bonds to other residues
    int bondTo[MAXRESIDUEBONDS];  ///< list of bonds to other residues
#endif

    int fragment;                 ///< a fragment is a set of connect residues
                                  ///<  which are not connected to any other
                                  ///<  residues
    ResizeArray<int> atoms;       ///< list of atoms in this residue

    Residue(int realid, int newtype) : atoms(3) {
      resid = realid; // non-unique resid from file...
#if defined(MAXRESIDUEBONDS)
      bonds = 0;
#endif
      residueType = newtype;
      fragment = -1;
      sstruct = SS_COIL;
    }

    void add_atom(int atomindex) {
      atoms.append(atomindex);
    };

#if defined(MAXRESIDUEBONDS)    
    int add_bond(int idx, int bondto) {
      int j;
      int flg = FALSE;
      for (j=0; j<bonds; j++) { // check uniqueness
        if (bondTo[j] == bondto) { // already there
          flg = TRUE;
          break;  // ignore repeats;  I would have a return, but the
                  // compilier doesn't allow that in inline functions
        }
      }  // new bond

      if (!flg && idx != bondto) { 
        if (bonds >= MAXRESIDUEBONDS) return -1; // fail
        bondTo[bonds++] = bondto;
      }

      return 0; // success
    } // end of add_bond
#endif

};

#endif

