/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: PickModeList.C,v $
 *      $Author: johns $        $Locker:  $             $State: Exp $
 *      $Revision: 1.10 $       $Date: 2007/01/12 20:08:30 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  List of all pick modes.
 ***************************************************************************/

#include "PickModeList.h"
#include "PickModeAddBond.h"
#include "PickModeCenter.h"
#include "PickModeForce.h"
#include "PickModeMolLabel.h"
#include "PickModeMove.h"
#include "PickModeUser.h"

#include "VMDApp.h"

PickModeList::PickModeList(VMDApp *app) {
  pickmodelist.add_name("Query", new PickMode); 
  pickmodelist.add_name("Center", new PickModeCenter(app));

  pickmodelist.add_name("Atoms", new PickModeAtoms(app));
  pickmodelist.add_name("Bonds", new PickModeBonds(app));
  pickmodelist.add_name("Angles", new PickModeAngles(app));
  pickmodelist.add_name("Dihedrals", new PickModeDihedrals(app));

  pickmodelist.add_name("MoveAtom", new PickModeMoveAtom);
  pickmodelist.add_name("MoveResidue", new PickModeMoveResidue);
  pickmodelist.add_name("MoveFragment", new PickModeMoveFragment);
  pickmodelist.add_name("MoveMolecule", new PickModeMoveMolecule);
 
  pickmodelist.add_name("ForceAtom", new PickModeForceAtom); 
  pickmodelist.add_name("ForceResidue", new PickModeForceResidue); 
  pickmodelist.add_name("ForceFragment", new PickModeForceFragment); 

  pickmodelist.add_name("MoveRep", new PickModeMoveRep);

  pickmodelist.add_name("AddBond", new PickModeAddBond(app));
  pickmodelist.add_name("User", new PickModeUser(app));

  curpickmode = pickmodelist.data("Query");
}

PickModeList::~PickModeList() {
  for (int i=0; i<pickmodelist.num(); i++)
    delete pickmodelist.data(i);
}


